# install.packages("BioGeoBEARS")
library(optimx)         # You need to have some version of optimx available
# as it is a BioGeoBEARS dependency; however, if you
# don't want to use optimx, and use optim() (from R core) 
# you can set:
# BioGeoBEARS_run_object$use_optimx = FALSE
# ...everything should work either way -- NJM 2014-01-08
library(FD)       # for FD::maxent() (make sure this is up-to-date)
library(snow)     # (if you want to use multicore functionality; some systems/R versions prefer library(parallel), try either)
library(parallel)
library(BioGeoBEARS)

setwd("~/Dropbox/Andrew/DataSets&Manuscripts/Phylogenomics_of_Bothriechis/Analyses/V3/BioGeo/")

##############################################################################################
#####################  Processing of the Tree prior to working with it  ######################
##############################################################################################
Dated_Tree<-read.tree("FigTree_edited.tre")
Dated_Tree$edge.length<-Dated_Tree$edge.length*100
plot(Dated_Tree)
add.scale.bar()
nodelabels(Dated_Tree$Nnode)

extra_tips<-c("SI2043_Ccerastes","S1948_Ccerastes","S2093_Acontortrix","S2040_Pdunni",
              "SI1925_Pdunni","S1984_Anummifer","S1952_Cgodmani","SI1958_Cgodmani",
              "SI2048_Bhyoprorus","SI7400_Bfonsecai","SI7372_Bdiporus","S1951_Batrox",           
              "SI1957_Batrox","SI2055_Bbrazili","SI1967_Bbrazili","SI1956_Lmuta","S1969_Lmuta",
              "S2078_Mmelanurus","SI2065_Osmaragdinus","SI1923_Oundulatus","S2035_Oundulatus",
              "SI1931_Bnasicornis","SI2012_Bnasicornis","SI0786_Cmaculatus","SI2001_Cmaculatus",
              "SI12205_Oaeneus","SI12224_Bmulticinctus","SI8103_Pvindumi")
Bothri_dated<-drop.tip(Dated_Tree,extra_tips)
plot(Bothri_dated)
add.scale.bar()

extra_Bothri<-c("S17967_Baurifer","S17968_Bbicolor","S1968_Blateralis","S17981_Bthalassinus",
                "S1980_Bnubestris","S1992_Bsupraciliaris","S1959_Bschlegelii")
Bothri_dated<-drop.tip(Bothri_dated,extra_Bothri)
Bothri_dated$tip.label<-c("Baurifer","Browleyi","Bbicolor","Bguifarroi","Blateralis",
                          "Bmarchi","Bthalassinus","Bnigroviridis","Bnubestris",
                          "Bsupraciliaris","Bschlegelii")
##############################################################################################


##################################################################################################################################################
##################################################################################################################################################
######################################################                                             ###############################################
######################################################   Testing Models with other Region Coding   ###############################################
######################################################    And differentaial dispersal              ###############################################
######################################################                                             ###############################################
##################################################################################################################################################
##################################################################################################################################################

plot(Bothri_dated)
axisPhylo()
write.tree(Bothri_dated,file = "~/Dropbox/Andrew/DataSets&Manuscripts/Phylogenomics_of_Bothriechis/Analyses/V3/BioGeo/Bothri_dated.newick")

Bothri_trfn=c("~/Dropbox/Andrew/DataSets&Manuscripts/Phylogenomics_of_Bothriechis/Analyses/V3/BioGeo/Bothri_dated.newick")
tr = read.tree(Bothri_trfn)
tr
plot(tr)
title("Bothriechis (2018)")
axisPhylo() # plots timescale
Bothri_geofn=c("~/Dropbox/Andrew/DataSets&Manuscripts/Phylogenomics_of_Bothriechis/Analyses/V3/BioGeo/Bothri_region5.data")
moref(Bothri_geofn)
Bothri_tipranges = getranges_from_LagrangePHYLIP(lgdata_fn=Bothri_geofn)
Bothri_tipranges
max_range_size = 4
disperal_multipliers=c("~/Dropbox/Andrew/DataSets&Manuscripts/Phylogenomics_of_Bothriechis/Analyses/V3/BioGeo/Bothri_dispersal_4states.matrix")
disperal_multipliers

## Use the below command to check the total number of stats to make sure it isn't going to overwhelm the program
numstates_from_numareas(numareas=4, maxareas=4, include_null_range=TRUE)

BioGeoBEARS_run_object = define_BioGeoBEARS_run()
# Give BioGeoBEARS the location of the geography text file
BioGeoBEARS_run_object$geogfn = Bothri_geofn
# Give BioGeoBEARS the location of the phylogeny Newick file
BioGeoBEARS_run_object$trfn = Bothri_trfn

BioGeoBEARS_run_object$max_range_size = max_range_size

BioGeoBEARS_run_object$min_branchlength = 0.000001    # Min to treat tip as a direct ancestor (no speciation event)
BioGeoBEARS_run_object$include_null_range = TRUE 

BioGeoBEARS_run_object$dispersal_multipliers_fn = disperal_multipliers

BioGeoBEARS_run_object$on_NaN_error = -1e50   # returns very low lnL if parameters produce NaN error (underflow check)
BioGeoBEARS_run_object$speedup=FALSE          # shorcuts to speed ML search; use FALSE if worried (e.g. >3 params)
BioGeoBEARS_run_object$use_optimx = 'GenSA'
BioGeoBEARS_run_object$calc_ancprobs=TRUE

BioGeoBEARS_run_object$num_cores_to_use=1
BioGeoBEARS_run_object$force_sparse=FALSE

BioGeoBEARS_run_object = readfiles_BioGeoBEARS_run(BioGeoBEARS_run_object)

BioGeoBEARS_run_object$return_condlikes_table = TRUE
BioGeoBEARS_run_object$calc_TTL_loglike_from_condlikes_table = TRUE
BioGeoBEARS_run_object$calc_ancprobs = TRUE

# Look at the BioGeoBEARS_run_object; it's just a list of settings etc.
BioGeoBEARS_run_object

# This contains the model object
BioGeoBEARS_run_object$BioGeoBEARS_model_object

# This table contains the parameters of the model
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table

# Run this to check inputs. Read the error messages if you get them!
check_BioGeoBEARS_run(BioGeoBEARS_run_object)

# For a slow analysis, run once, then set runslow=FALSE to just
# load the saved result.
runslow = TRUE
resfn = "Bothri_DEC_M0_unconstrained_v1.Rdata"
if (runslow)
{
  res = bears_optim_run(BioGeoBEARS_run_object)
  res
  
  save(res, file=resfn)
  resDEC = res
} else {
  # Loads to "res"
  load(resfn)
  resDEC = res
}


#######################################################
# Plot ancestral states - DEC
#######################################################
analysis_titletxt ="BioGeoBEARS DEC on Bothriechis M0_unconstrained"

# Setup
results_object = resDEC
scriptdir = np(system.file("extdata/a_scripts", package="BioGeoBEARS"))

# States
res2 = plot_BioGeoBEARS_results(results_object, analysis_titletxt, addl_params=list("j"), 
                                plotwhat="text", label.offset=0.45, tipcex=0.7, statecex=0.7, 
                                splitcex=0.6, titlecex=0.8, plotsplits=TRUE, 
                                cornercoords_loc=scriptdir, include_null_range=TRUE, tr=tr, 
                                tipranges=Bothri_tipranges)

# Pie chart
plot_BioGeoBEARS_results(results_object, analysis_titletxt, addl_params=list("j"), 
                         plotwhat="pie", label.offset=0.45, tipcex=0.7, statecex=0.7, 
                         splitcex=0.6, titlecex=0.8, plotsplits=FALSE, 
                         cornercoords_loc=scriptdir, include_null_range=TRUE, tr=tr, 
                         tipranges=Bothri_tipranges,  plotlegend = TRUE)


#######################################################
# Run DIVALIKE
#######################################################
BioGeoBEARS_run_object = define_BioGeoBEARS_run()
BioGeoBEARS_run_object$trfn = Bothri_trfn
BioGeoBEARS_run_object$geogfn = Bothri_geofn
BioGeoBEARS_run_object$max_range_size = max_range_size
BioGeoBEARS_run_object$dispersal_multipliers_fn = disperal_multipliers
BioGeoBEARS_run_object$min_branchlength = 0.000001    # Min to treat tip as a direct ancestor (no speciation event)
BioGeoBEARS_run_object$include_null_range = TRUE 

BioGeoBEARS_run_object$on_NaN_error = -1e50    # returns very low lnL if parameters produce NaN error (underflow check)
BioGeoBEARS_run_object$speedup = FALSE          # shorcuts to speed ML search; use FALSE if worried (e.g. >3 params)
BioGeoBEARS_run_object$use_optimx = 'GenSA'    # if FALSE, use optim() instead of optimx()
BioGeoBEARS_run_object$num_cores_to_use = 1
BioGeoBEARS_run_object$force_sparse = FALSE    # force_sparse=TRUE causes pathology & isn't much faster at this scale

BioGeoBEARS_run_object$calc_ancprobs=TRUE    # get ancestral states from optim run

# This function loads the dispersal multiplier matrix etc. from the text files into the model object. Required for these to work!
# (It also runs some checks on these inputs for certain errors.)
BioGeoBEARS_run_object = readfiles_BioGeoBEARS_run(BioGeoBEARS_run_object)

# Good default settings to get ancestral states
BioGeoBEARS_run_object$return_condlikes_table = TRUE
BioGeoBEARS_run_object$calc_TTL_loglike_from_condlikes_table = TRUE
BioGeoBEARS_run_object$calc_ancprobs = TRUE

# Set up DIVALIKE model
# Remove subset-sympatry
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["s","type"] = "fixed"
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["s","init"] = 0.0
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["s","est"] = 0.0

BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["ysv","type"] = "2-j"
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["ys","type"] = "ysv*1/2"
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["y","type"] = "ysv*1/2"
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["v","type"] = "ysv*1/2"

# Allow classic, widespread vicariance; all events equiprobable
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["mx01v","type"] = "fixed"
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["mx01v","init"] = 0.5
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["mx01v","est"] = 0.5

check_BioGeoBEARS_run(BioGeoBEARS_run_object)

runslow = TRUE
resfn = "Bothriechis_DIVALIKE_M0_unconstrained_v1.Rdata"
if (runslow)
{
  res = bears_optim_run(BioGeoBEARS_run_object)
  res
  
  save(res, file=resfn)
  resDIVALIKE = res
} else {
  # Loads to "res"
  load(resfn)
  resDIVALIKE = res
}


#######################################################
# Plot ancestral states - DIVALIKE
#######################################################
analysis_titletxt ="BioGeoBEARS DIVALIKE on Bothriechis M0_unconstrained"

# Setup
results_object = resDIVALIKE
scriptdir = np(system.file("extdata/a_scripts", package="BioGeoBEARS"))

# States
res2 = plot_BioGeoBEARS_results(results_object, analysis_titletxt, addl_params=list("j"), 
                                plotwhat="text", label.offset=0.45, tipcex=0.7, statecex=0.7, 
                                splitcex=0.6, titlecex=0.8, plotsplits=FALSE, 
                                cornercoords_loc=scriptdir, include_null_range=TRUE, 
                                tr=tr, tipranges=Bothri_tipranges)

# Pie chart
plot_BioGeoBEARS_results(results_object, analysis_titletxt, addl_params=list("j"), 
                         plotwhat="pie", label.offset=0.45, tipcex=0.7, statecex=0.7, 
                         splitcex=0.6, titlecex=0.8, plotsplits=FALSE, 
                         cornercoords_loc=scriptdir, include_null_range=TRUE, tr=tr, 
                         tipranges=Bothri_tipranges,plotlegend = TRUE)


#######################################################
# BAYAREALIKE AND BAYAREALIKE+J ANALYSIS
#######################################################

# NOTE: As with DIVA, the BioGeoBEARS BayArea-like model is
# not identical with the full Bayesian model implemented
# in the "BayArea" program of Landis et al. (2013).
#
# Instead, this is a simplified likelihood interpretation
# of the model.  Basically, in BayArea and BioGeoBEARS-BAYAREALIKE,
# "d" and "e" work like they do in the DEC model of Lagrange
# (and BioGeoBEARS), and then BayArea's cladogenesis assumption
# (which is that nothing in particular happens at cladogenesis) is
# replicated by BioGeoBEARS.
#
# This leaves out 3 important things that are in BayArea:
# 1. Distance dependence (you can add this with a distances
#    matrix + the "x" parameter in BioGeoBEARS, however)
# 2. A correction for disallowing "e" events that drive
#    a species extinct (a null geographic range)
# 3. The neat Bayesian sampling of histories, which allows
#    analyses on large numbers of areas.
#
# The main purpose of having a "BAYAREALIKE" model is
# to test the importance of the cladogenesis model on
# particular datasets. Does it help or hurt the data
# likelihood if there is no special cladogenesis process?
#
# I thus now call the model "BAYAREALIKE", and you should also. ;-)
#

#######################################################
# Run BAYAREALIKE
#######################################################
BioGeoBEARS_run_object = define_BioGeoBEARS_run()
BioGeoBEARS_run_object$trfn = Bothri_trfn
BioGeoBEARS_run_object$geogfn = Bothri_geofn
BioGeoBEARS_run_object$max_range_size = max_range_size
BioGeoBEARS_run_object$dispersal_multipliers_fn = disperal_multipliers
BioGeoBEARS_run_object$min_branchlength = 0.000001    # Min to treat tip as a direct ancestor (no speciation event)
BioGeoBEARS_run_object$include_null_range = TRUE 

BioGeoBEARS_run_object$on_NaN_error = -1e50    # returns very low lnL if parameters produce NaN error (underflow check)
BioGeoBEARS_run_object$speedup = FALSE          # shorcuts to speed ML search; use FALSE if worried (e.g. >3 params)
BioGeoBEARS_run_object$use_optimx = 'GenSA'    # if FALSE, use optim() instead of optimx()
BioGeoBEARS_run_object$num_cores_to_use = 1
BioGeoBEARS_run_object$force_sparse = FALSE 

BioGeoBEARS_run_object$calc_ancprobs=TRUE    # get ancestral states from optim run

# This function loads the dispersal multiplier matrix etc. from the text files into the model object. Required for these to work!
# (It also runs some checks on these inputs for certain errors.)
BioGeoBEARS_run_object = readfiles_BioGeoBEARS_run(BioGeoBEARS_run_object)

# Good default settings to get ancestral states
BioGeoBEARS_run_object$return_condlikes_table = TRUE
BioGeoBEARS_run_object$calc_TTL_loglike_from_condlikes_table = TRUE
BioGeoBEARS_run_object$calc_ancprobs = TRUE

# Set up BAYAREALIKE model
# No subset sympatry
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["s","type"] = "fixed"
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["s","init"] = 0.0
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["s","est"] = 0.0

# No vicariance
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["v","type"] = "fixed"
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["v","init"] = 0.0
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["v","est"] = 0.0

# Adjust linkage between parameters
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["ysv","type"] = "1-j"
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["ys","type"] = "ysv*1/1"
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["y","type"] = "1-j"

# Only sympatric/range-copying (y) events allowed, and with
# exact copying (both descendants always the same size as the ancestor)
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["mx01y","type"] = "fixed"
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["mx01y","init"] = 0.9999
BioGeoBEARS_run_object$BioGeoBEARS_model_object@params_table["mx01y","est"] = 0.9999

# Check the inputs
check_BioGeoBEARS_run(BioGeoBEARS_run_object)

runslow = TRUE
resfn = "Bothriechis_BAYAREALIKE_M0_unconstrained_v1.Rdata"
if (runslow)
{
  res = bears_optim_run(BioGeoBEARS_run_object)
  res
  
  save(res, file=resfn)
  resBAYAREALIKE = res
} else {
  # Loads to "res"
  load(resfn)
  resBAYAREALIKE = res
}


#######################################################
# Plot ancestral states - BAYAREALIKE
#######################################################
analysis_titletxt ="BioGeoBEARS BAYAREALIKE on Bothriechis M0_unconstrained"

# Setup
results_object = resBAYAREALIKE

# States
res2 = plot_BioGeoBEARS_results(results_object, analysis_titletxt, addl_params=list("j"), 
                                plotwhat="text", label.offset=0.45, tipcex=0.7, statecex=0.7, 
                                splitcex=0.6, titlecex=0.8, plotsplits=FALSE, 
                                cornercoords_loc=scriptdir, include_null_range=TRUE, tr=tr, 
                                tipranges=Bothri_tipranges, plotlegend = TRUE)

# Pie chart
plot_BioGeoBEARS_results(results_object, analysis_titletxt, addl_params=list("j"), 
                         plotwhat="pie", label.offset=0.45, tipcex=0.7, statecex=0.7, 
                         splitcex=0.6, titlecex=0.8, plotsplits=FALSE, 
                         cornercoords_loc=scriptdir, include_null_range=TRUE, tr=tr, 
                         tipranges=Bothri_tipranges, plotlegend = TRUE)


#########################################################################
#########################################################################
#########################################################################
#########################################################################
#
# CALCULATE SUMMARY STATISTICS TO COMPARE
# DEC, DIVALIKE, BAYAREALIKE
#
#########################################################################
#########################################################################
#########################################################################
#########################################################################

#########################################################################
#########################################################################
# REQUIRED READING:
#
# Practical advice / notes / basic principles on statistical model
#    comparison in general, and in BioGeoBEARS:
# http://phylo.wikidot.com/advice-on-statistical-model-comparison-in-biogeobears
#########################################################################
#########################################################################

# Set up empty tables to hold the statistical results
restable = NULL

#######################################################
# Statistics -- DEC
#######################################################
# We have to extract the log-likelihood differently, depending on the
# version of optim/optimx
LnL = get_LnL_from_BioGeoBEARS_results_object(resDEC)

numparams = 2
stats_DEC = calc_AIC_column(LnL, numparams)
AIC_DEC = calc_AIC_vals(LnL, numparams)
stats_DEC

# DEC, null model for Likelihood Ratio Test (LRT)
res = extract_params_from_BioGeoBEARS_results_object(results_object=resDEC, returnwhat="table", addl_params=c("j"), paramsstr_digits=4)
# DEC+J, alternative model for Likelihood Ratio Test (LRT)
#res1 = extract_params_from_BioGeoBEARS_results_object(results_object=resDECj, returnwhat="table", addl_params=c("j"), paramsstr_digits=4)

# The null hypothesis for a Likelihood Ratio Test (LRT) is that two models
# confer the same likelihood on the data. See: Brian O'Meara's webpage:
# http://www.brianomeara.info/tutorials/aic
# ...for an intro to LRT, AIC, and AICc

tmp<-cbind(res,stats_DEC)

rbind(tmp)

restable = rbind(restable, tmp)

#######################################################
# Statistics -- DIVALIKE
#######################################################
# We have to extract the log-likelihood differently, depending on the
# version of optim/optimx
LnL= get_LnL_from_BioGeoBEARS_results_object(resDIVALIKE)

numparams = 2
stats_DIVA = calc_AIC_column(LnL, numparams)
AIC_DIVA = calc_AIC_vals(LnL, numparams)
stats_DIVA

# DIVALIKE, null model for Likelihood Ratio Test (LRT)
res = extract_params_from_BioGeoBEARS_results_object(results_object=resDIVALIKE, returnwhat="table", addl_params=c("j"), paramsstr_digits=4)

tmp<-cbind(res,stats_DIVA)

rbind(tmp)

restable = rbind(restable, tmp)

#######################################################
# Statistics -- BAYAREALIKE
#######################################################
# We have to extract the log-likelihood differently, depending on the
# version of optim/optimx
LnL = get_LnL_from_BioGeoBEARS_results_object(resBAYAREALIKE)

numparams = 2
stats_BAYAREA = calc_AIC_column(LnL, numparams)
AIC_BAYAREA = calc_AIC_vals(LnL, numparams)
stats_BAYAREA

# BAYAREALIKE, null model for Likelihood Ratio Test (LRT)
res = extract_params_from_BioGeoBEARS_results_object(results_object=resBAYAREALIKE, returnwhat="table", addl_params=c("j"), paramsstr_digits=4)

tmp<-cbind(res,stats_BAYAREA)

rbind(tmp)

restable = rbind(restable, tmp)
#########################################################################
AICs<-c(AIC_DEC,AIC_DIVA,AIC_BAYAREA)
DEC_weight<-getAIC_weight_for_model1(AIC_DEC,AICs)
DIVA_weight<-getAIC_weight_for_model1(AIC_DIVA,AICs)
BAYAREA_weight<-getAIC_weight_for_model1(AIC_BAYAREA,AICs)
AIC_weights<-c(DEC_weight,DIVA_weight,BAYAREA_weight)

#########################################################################
# RESULTS: DEC, DIVALIKE, BAYAREALIKE
#########################################################################

restable<-cbind(restable,AIC_weights)
row.names(restable) = c("DEC", "DIVALIKE", "BAYAREALIKE")

# Look at the results!!
restable
#teststable

#######################################################
# Save the results tables for later -- check for e.g.
# convergence issues
#######################################################

# Loads to "restable"
save(restable, file="restable_v1.Rdata")
load(file="restable_v1.Rdata")

#######################################################
# The p-value of the LRT (Likelihood Ratio Test) tells you whether or not you can reject the
# null hypothesis that DEC and DEC+J confer equal likelihoods on the data
#
# AIC and AICc model weights are also shown, giving a sense of the relative probability of the two models.
#
# (One could easily do model weights between all 6 models, but this is not done here; s
#  see Brian O'Meara's AIC webpage: http://www.brianomeara.info/tutorials/aic )
#######################################################






library(readxl)
library(raster)
library(dismo)
library(rgdal)
library(landsat)
library(adehabitat)
library(rgeos)
library(ggmap)
library(rworldmap)
#install.packages("maptools", lib="/Library/Frameworks/R.framework/Versions/3.4/Resources/library")
#install.packages("mapdata", lib="/Library/Frameworks/R.framework/Versions/3.4/Resources/library")
library(maptools)
library(mapdata)
data("wrld_simpl")
data("worldHires")
library(data.table)


All_Bothriechis_localities <- read_excel("Dropbox/Andrew/DataSets&Manuscripts/Phylogenomics_of_Bothriechis/Analyses/Butterfly_Analyses/Taxonset2_46terminals/Biogeography_Testing/All_Bothriechis_localities.xlsx")
schlegelii<-subset(All_Bothriechis_localities,All_Bothriechis_localities$Name=="schlegelii")
bicolor<-subset(All_Bothriechis_localities,All_Bothriechis_localities$Name=="bicolor")
aurifer<-subset(All_Bothriechis_localities,All_Bothriechis_localities$Name=="aurifer")
rowleyi<-subset(All_Bothriechis_localities,All_Bothriechis_localities$Name=="rowleyi")


my_colors<-palette(c("black","red","green3","blue","cyan","magenta","yellow","gray","orange","white","pink"))
names(my_colors)<-c("schlegelii","supraciliaris","nigroviridis","nubestris","marchi","lateralis","guifarroi",
                         "thalassinus","aurifer","bicolor","rowleyi")

map('worldHires', xlim=c(-100,-70),ylim=c(3,22),
    border=0, ann=FALSE,axes=FALSE, box=TRUE,mar=c(0,0,0,0))
points(schlegelii$Long,schlegelii$Lat,col="black",bg="black", pch=21,cex=1,add=T)
points(bicolor$Long,bicolor$Lat,col="black",bg="green", pch=21,cex=1,add=T)
points(aurifer$Long,aurifer$Lat,col="black",bg="blue", pch=21,cex=1,add=T)
points(rowleyi$Long,rowleyi$Lat,col="black",bg="pink", pch=21,cex=1,add=T)




