#Load packages
library(lme4)
library(lmerTest)
library(plotrix)

#Load table
bgh=read.csv('BlueGreenHybridSIFF.csv',header=T)

#Load variables
species=bgh$Species
SL=bgh$SL
SI=bgh$SI
e=bgh$EvasiveAvg
a=bgh$AttachedAvg

# Size correct the performance traits
e.lm=lm(e~SL+species)
e.sizecor=e-e.lm$coefficients[2]*(SL-mean(SL))

a.lm=lm(a~SL+species)
a.sizecor=a-a.lm$coefficients[2]*(SL-mean(SL))

# plot performance traits

par(mfrow=c(1,2))
plot(species,a.sizecor,xaxt="n",col=c("Darkblue","Orange","Forestgreen"),
range=0,ylab="Force exerted on simulated attached prey(N)")
axis(1,1:3,c("Bluegill","Hybrid","Green sunfish"))
plot(species,e.sizecor,xaxt="n",col=c("Darkblue","Orange","Forestgreen"),
range=0,ylab="Max. escape force of simulated captured evasive prey(N)")
axis(1,1:3,c("Bluegill","Hybrid","Green sunfish"))

#randomization test for attached performance, hybrid to best specialist(bluegill)

ab.sampled = seq(1, 10000)

for (i in 1:10000) {
ab.sample=sample(a.sizecor)
ab.sampled[i] = abs(mean(ab.sample[species=='H'])-mean(ab.sample[species=='B']))
}


# attached performance, hybrid to worst specialist
aw.sampled = seq(1, 10000)

for (i in 1:10000) {
aw.sample=sample(a.sizecor)
aw.sampled[i] = abs(mean(aw.sample[species=='H'])-mean(aw.sample[species=='XG']))
}

par(mfrow=c(1,2))
hist(ab.sampled)
abline(v=abs(mean(a.sizecor[species=='H'])-mean(a.sizecor[species=='B'])))

hist(aw.sampled)
abline(v=abs(mean(a.sizecor[species=='H'])-mean(a.sizecor[species=='XG'])))



#randomization test for evasive performance, hybrid to best specialist(bluegill)

eb.sampled = seq(1, 10000)

for (i in 1:10000) {
eb.sample=sample(e.sizecor)
eb.sampled[i] = abs(mean(eb.sample[species=='H'])-mean(eb.sample[species=='XG']))
}


# attached performance, hybrid to worst specialist
ew.sampled = seq(1, 10000)

for (i in 1:10000) {
ew.sample=sample(e.sizecor)
ew.sampled[i] = abs(mean(ew.sample[species=='H'])-mean(ew.sample[species=='B']))
}

par(mfrow=c(1,2))
plot(density(eb.sampled))
abline(v=abs(mean(e.sizecor[species=='H'])-mean(e.sizecor[species=='XG'])))

plot(density(ew.sampled))
abline(v=abs(mean(e.sizecor[species=='H'])-mean(e.sizecor[species=='B'])))




