#Load packages
library(lme4)
library(lmerTest)
library(vegan)

#Load table
cent.t=read.csv('BlueGreenHybridKinematics.csv',header=T)

#independent variables
indiv=cent.t$Indiv
species=cent.t$Species
SL=cent.t$SL

#excursions
maxgape=cent.t$gape
maxhyoid=cent.t$max_hyoid
strikedist=cent.t$strike_dist
maxJP=cent.t$max_JP
headelev=cent.t$head_elev
jawrot=cent.t$jaw_rot

ram=cent.t$Ram

#timings
TTPG=cent.t$TTPG
TTPH=cent.t$TTPH
TTPC=cent.t$TTPC
TTPJP=cent.t$TTPJP
TTPHA=cent.t$TTPHA
TTPLJR=cent.t$TTPLJR



#size correct each value, taking into account species differences
maxgape.lmer<-lmer(maxgape~SL+species+(1|indiv))
maxgape.mmres=maxgape-maxgape.lmer@pp$delb[1]-SL*maxgape.lmer@pp$delb[2]

strikedist.lmer<-lmer(strikedist~SL+species+(1|indiv))
strikedist.mmres=strikedist-strikedist.lmer@pp$delb[1]-(SL-mean(SL))*strikedist.lmer@pp$delb[2]

maxJP.lmer<-lmer(maxJP~SL+species+(1|indiv))
maxJP.mmres=maxJP-maxJP.lmer@pp$delb[1]-(SL-mean(SL))*maxJP.lmer@pp$delb[2]

headelev.lmer<-lmer(headelev~SL+species+(1|indiv))
headelev.mmres=headelev-headelev.lmer@pp$delb[1]-(SL-mean(SL))*headelev.lmer@pp$delb[2]

maxhyoid.lmer<-lmer(maxhyoid~SL+species+(1|indiv))
maxhyoid.mmres=maxhyoid-maxhyoid.lmer@pp$delb[1]-(SL-mean(SL))*maxhyoid.lmer@pp$delb[2]

jawrot.lmer<-lmer(jawrot~SL+species+(1|indiv))
jawrot.mmres=jawrot-jawrot.lmer@pp$delb[1]-(SL-mean(SL))*jawrot.lmer@pp$delb[2]


TTPG.lmer<-lmer(TTPG~SL+species+(1|indiv))
TTPG.mmres=TTPG-TTPG.lmer@pp$delb[1]-(SL-mean(SL))*TTPG.lmer@pp$delb[2]

TTPC.lmer<-lmer(TTPC~SL+species+(1|indiv))
TTPC.mmres=TTPC-TTPC.lmer@pp$delb[1]-(SL-mean(SL))*TTPC.lmer@pp$delb[2]

TTPJP.lmer<-lmer(TTPJP~SL+species+(1|indiv))
TTPJP.mmres=TTPJP-TTPJP.lmer@pp$delb[1]-(SL-mean(SL))*TTPJP.lmer@pp$delb[2]

TTPHA.lmer<-lmer(TTPHA~SL+species+(1|indiv))
TTPHA.mmres=TTPHA-TTPHA.lmer@pp$delb[1]-(SL-mean(SL))*TTPHA.lmer@pp$delb[2]

TTPH.lmer<-lmer(TTPH~SL+species+(1|indiv))
TTPH.mmres=TTPH-TTPH.lmer@pp$delb[1]-(SL-mean(SL))*TTPH.lmer@pp$delb[2]

TTPLJR.lmer<-lmer(TTPLJR~SL+species+(1|indiv))
TTPLJR.mmres=TTPLJR-TTPLJR.lmer@pp$delb[1]-(SL-mean(SL))*TTPLJR.lmer@pp$delb[2]


#combine variables
kine.ex=cbind(maxgape.mmres,strikedist.mmres,maxJP.mmres,headelev.mmres,jawrot.mmres)
kine.ttp=cbind(TTPG.mmres,TTPC.mmres,TTPJP.mmres,TTPHA.mmres,TTPLJR.mmres)
kine.all=cbind(kine.ttp,kine.ex)

#run PCA on covariance matrix
ex.pca=prcomp(kine.ex)
ttp.pca=prcomp(kine.ttp)

#check which PC axes explain more variation than expected by chance
screeplot(ex.pca, bstick=T)
screeplot(ttp.pca,bstick=T)

#extract first PC axis from each analysis and plot
ex.pc1=ex.pca$x[,1]
ttp.pc1=ttp.pca$x[,1]
plot(ex.pc1,ttp.pc1,col=c("Darkblue","Forestgreen","Orange")[species],pch=16)

#mixed-model analysis comparing the three species
summary(lmer(ttp.pc1~species+(1|indiv)))
summary(lmer(ex.pc1~species+(1|indiv)))

