setwd("/Users/Christen/Dropbox/DEE lab/Christen/CW_TK/20E")

#load the two genotypes you wish to compare in the plots
load("w1118.RData")
load("w1118_20E.RData")


require(segmented)
require(reshape)
require(lattice)
require(epicalc)

#w1118

attach(w1118)
datam<-w1118[c("age", "ttp")]
datam<-na.omit(datam)
plot(datam, xlab="Age Starved (h AL3E)", ylab="Time to Pupariation (h AL3E)",xlim=c(0,44), ylim=c(0,168),axes=FALSE, col="black")
axis(side=1, at=c(0,6,12,18,24,30,36,42))
axis(side=2, at=c(0,24,48,72,96,120,144,168))


datam<-as.matrix(datam)
theta=0.5*pi/180
R <- matrix(c(cos(theta), -sin(theta), sin(theta), cos(theta)), nrow=2)
datamr<-datam%*%R

datamrd<-as.data.frame(datamr)
names(datamrd)<-c("age","ttp")
glm<-glm(ttp~age, data=datamrd)
davies.test(glm, seg.Z=~age, k=1)

# the value of psi can change depending on the dataset, look at the spread of the points to approximate where psi might be
seg<-segmented(glm,seg.Z=~age,psi=list(age=10))
summary(seg)

bpage<-seg$psi[,2]
bpagevalue<-bpage
slope<-seg$coefficients[2]
intercept<-seg$coefficients[1]
bpttp<-intercept+slope*bpage
conf<-confint(seg)
low<-conf$age[,2]
high<-conf$age[,3]
bpsunconverted <- matrix(c(bpage, low, high, bpttp, bpttp, bpttp), ncol=2, nrow=3)
Rback <- matrix(c(cos(-theta), -sin(-theta), sin(-theta), cos(-theta)), nrow=2)
CS<-bpsunconverted%*%Rback
CS<-as.data.frame(CS)
TGP<-CS$V2[1]
#TGP
TGP
 
CA<-CS$V1[1]
#CS as age
CA
CS 
#breakpoint age genotype 1
points(CS[1,1],CS[1,2], pch=19,lwd=4)
lines(c(CS[2,1],CS[3,1]), c(CS[1,2],CS[1,2]), lwd=3)
lines(c(CS[1,1],CS[1,1]), c(CS[2,2],CS[3,2]), lwd=3)
 
#plot lines of breakpoint 
# nrow and segRotate will change with the dataset, check the number of rows and change nrow and the x value of
# segRotate the number of the last row
seg2=broken.line(seg, link=FALSE)
seg2.matrix=matrix(c(age,seg2),nrow=107, ncol=2)
Rback <- matrix(c(cos(-theta), -sin(-theta), sin(-theta), cos(-theta)), nrow=2)
segRotate<-seg2.matrix%*%Rback
lines(c(segRotate[1,1],CS[1,1]),c(segRotate[1,2],CS[1,2]), lwd=2)
lines(c(CS[1,1],segRotate[107,1]),c(CS[1,2],segRotate[107,2]),lwd=2)
 
#compute CW
data<-w1118
growth<-w1118growth


growth<-subset(growth, age<25)

datam<-data[c("age", "ttp")]
datam<-na.omit(datam)
plot(datam)
datam<-as.matrix(datam)

theta=0.5*pi/180
R <- matrix(c(cos(theta), -sin(theta), sin(theta), cos(theta)), nrow=2)

datamr<-datam%*%R

plot(datamr)

datamrd<-as.data.frame(datamr)
names(datamrd)<-c("age","ttp")
glm<-glm(ttp~age, data=datamrd)
davies.test(glm, seg.Z=~age, k=1)
seg<-segmented(glm,seg.Z=~age,psi=list(age=10))
summary(seg)
plot(seg, add=T)
bpage<-seg$psi[,2]
bpagevalue<-bpage
slope<-seg$coefficients[2]
intercept<-seg$coefficients[1]
bpttp<-intercept+slope*bpage


conf<-confint(seg)
low<-conf$age[,2]
high<-conf$age[,3]


bpsunconverted <- matrix(c(bpage, low, high, bpttp, bpttp, bpttp), ncol=2, nrow=3)
Rback <- matrix(c(cos(-theta), -sin(-theta), sin(-theta), cos(-theta)), nrow=2)
CS<-bpsunconverted%*%Rback
CS<-as.data.frame(CS)
TGP<-CS$V2[1]
#TGP
TGP
CA<-CS$V1[1]
#CS as age
CA

#CS as weight
lm<-lm(mass~age, data=growth)
int<-lm$coefficients[1]
slp<-lm$coefficients[2]
CS<-int+slp*CA
#CS as larval weight
CS

#bootstrap


bootCS<-NA
bootTGP<-NA
bootCA<-NA

theta=0.5*pi/180
R <- matrix(c(cos(theta), -sin(theta), sin(theta), cos(theta)), nrow=2)
for (i in 1:1000)
{
  detachAllData()
  bootdataall<-data[sample(nrow(data),nrow(data), replace=T),]
  bootdata<-bootdataall[c("age", "ttp")]
  bootdatam<-na.omit(bootdata)
  bootdatam<-as.matrix(bootdatam)
  bootdatamr<-bootdatam%*%R
  bootdatamrd<-as.data.frame(bootdatamr)
  glm<-glm(V2~V1, data=bootdatamrd)
  seg<-segmented(glm,seg.Z=~V1,psi=list(V1=bpagevalue))
  bpage<-seg$psi[,2]
  slope<-seg$coefficients[2]
  intercept<-seg$coefficients[1]
  bpttp<-intercept+slope*bpage
  bpsunconverted <- matrix(c(bpage ,bpttp), ncol=2, nrow=1)
  Rback <- matrix(c(cos(-theta), -sin(-theta), sin(-theta), cos(-theta)), nrow=2)
  CAandTGP<-bpsunconverted%*%Rback
  CA<-CAandTGP[,1]
  bootCA<-rbind(bootCA,CA)
  TGP<-CAandTGP[,2]
  bootTGP<-rbind(bootTGP,TGP)
  bootgrowth<-growth[sample(nrow(growth),nrow(growth), replace=T),]
  lm<-lm(mass~age, data=bootgrowth)
  int<-lm$coefficients[1]
  slp<-lm$coefficients[2]
  CS<-int+slp*CA
  #CS as larval weight
  bootCS<-rbind(bootCS,CS)
}
  bootCA<-na.omit(bootCA)
  bootCS<-na.omit(bootCS)
  bootTGP<-na.omit(bootTGP)
  
  mean(bootCA)
  quantile(bootCA, probs=c(.025,.975))

  mean(bootCS)
  quantile(bootCS, probs=c(.025,.975))
  
  mean(bootTGP)
  quantile(bootTGP, probs=c(.025,.975)) 
 
detach(w1118)

#w1118 + 20E
attach(w1118_20E)
datam<-w1118_20E[c("age", "ttp")]
datam<-na.omit(datam)
datam<-as.matrix(datam)
points(datam,pch=2, col="dark grey")

theta=0.5*pi/180
R <- matrix(c(cos(theta), -sin(theta), sin(theta), cos(theta)), nrow=2)
datamr<-datam%*%R

datamrd<-as.data.frame(datamr)
names(datamrd)<-c("age","ttp")
glm<-glm(ttp~age, data=datamrd)
davies.test(glm, seg.Z=~age, k=1)

# the value of psi can change depending on the dataset, look at the spread of the points to approximate where psi might be
seg<-segmented(glm,seg.Z=~age,psi=list(age=10))
summary(seg)

bpage<-seg$psi[,2]
bpagevalue<-bpage
slope<-seg$coefficients[2]
intercept<-seg$coefficients[1]
bpttp<-intercept+slope*bpage
conf<-confint(seg)
low<-conf$age[,2]
high<-conf$age[,3]
bpsunconverted <- matrix(c(bpage, low, high, bpttp, bpttp, bpttp), ncol=2, nrow=3)
Rback <- matrix(c(cos(-theta), -sin(-theta), sin(-theta), cos(-theta)), nrow=2)
CS<-bpsunconverted%*%Rback
CS<-as.data.frame(CS)
TGP<-CS$V2[1]
#TGP
TGP
 
CA<-CS$V1[1]
#CS as age
CA
CS
#breakpoint age genotype 2
points(CS[1,1],CS[1,2], pch=19,lwd=4, col="dark grey")
lines(c(CS[2,1],CS[3,1]), c(CS[1,2],CS[1,2]), lwd=3, col="dark grey")
lines(c(CS[1,1],CS[1,1]), c(CS[2,2],CS[3,2]), lwd=3, col="dark grey")
 
#plot lines of breakpoint 
# nrow and segRotate will change with the dataset, check the number of rows and change nrow and the x value of
# segRotate the number of the last row
seg2=broken.line(seg, link=FALSE)
seg2.matrix=matrix(c(age,seg2),nrow=138, ncol=2)
Rback <- matrix(c(cos(-theta), -sin(-theta), sin(-theta), cos(-theta)), nrow=2)
segRotate<-seg2.matrix%*%Rback
lines(c(segRotate[1,1],CS[1,1]),c(segRotate[1,2],CS[1,2]), lwd=2, col="dark grey")
lines(c(CS[1,1],segRotate[138,1]),c(CS[1,2],segRotate[138,2]),lwd=2, col="dark grey")

detach(w1118_20E)


