setwd("/Users/Christen/Dropbox/DEE lab/Christen/CW_TK/20E")

#load the two genotypes you wish to compare in the plots
load("P0206.RData")
load("P0206_20E.RData")


require(segmented)
require(reshape)
require(lattice)
require(epicalc)

#P0206

attach(P0206)
datam<-P0206[c("age", "ttp")]
datam<-na.omit(datam)
plot(datam, xlab="Age Starved (h AL3E)", ylab="Time to Pupariation (h AL3E)", pch=22, xlim=c(0,44), ylim=c(0,168),axes=FALSE, col="black")
axis(side=1, at=c(0,6,12,18,24,30,36,42))
axis(side=2, at=c(0,24,48,72,96,120,144,168))


datam<-as.matrix(datam)
theta=0.5*pi/180
R <- matrix(c(cos(theta), -sin(theta), sin(theta), cos(theta)), nrow=2)
datamr<-datam%*%R

datamrd<-as.data.frame(datamr)
names(datamrd)<-c("age","ttp")
glm<-glm(ttp~age, data=datamrd)
davies.test(glm, seg.Z=~age, k=1)

# the value of psi can change depending on the dataset, look at the spread of the points to approximate where psi might be
seg<-segmented(glm,seg.Z=~age,psi=list(age=10))
summary(seg)

bpage<-seg$psi[,2]
bpagevalue<-bpage
slope<-seg$coefficients[2]
intercept<-seg$coefficients[1]
bpttp<-intercept+slope*bpage
conf<-confint(seg)
low<-conf$age[,2]
high<-conf$age[,3]
bpsunconverted <- matrix(c(bpage, low, high, bpttp, bpttp, bpttp), ncol=2, nrow=3)
Rback <- matrix(c(cos(-theta), -sin(-theta), sin(-theta), cos(-theta)), nrow=2)
CS<-bpsunconverted%*%Rback
CS<-as.data.frame(CS)
TGP<-CS$V2[1]
#TGP
TGP
 
CA<-CS$V1[1]
#CS as age
CA
CS 
#breakpoint age genotype 1
points(CS[1,1],CS[1,2], pch=19,lwd=4)
lines(c(CS[2,1],CS[3,1]), c(CS[1,2],CS[1,2]), lwd=3)
lines(c(CS[1,1],CS[1,1]), c(CS[2,2],CS[3,2]), lwd=3)
 
#plot lines of breakpoint 
# nrow and segRotate will change with the dataset, check the number of rows and change nrow and the x value of
# segRotate the number of the last row
seg2=broken.line(seg, link=FALSE)
seg2.matrix=matrix(c(age,seg2),nrow=119, ncol=2)
Rback <- matrix(c(cos(-theta), -sin(-theta), sin(-theta), cos(-theta)), nrow=2)
segRotate<-seg2.matrix%*%Rback
lines(c(segRotate[1,1],CS[1,1]),c(segRotate[1,2],CS[1,2]), lwd=2)
lines(c(CS[1,1],segRotate[119,1]),c(CS[1,2],segRotate[119,2]),lwd=2)
 
detach(P0206)

#P0206 + 20E
attach(P0206_20E)
datam<-P0206_20E[c("age", "ttp")]
datam<-na.omit(datam)
datam<-as.matrix(datam)
points(datam,pch=2, col="dark grey")

theta=0.5*pi/180
R <- matrix(c(cos(theta), -sin(theta), sin(theta), cos(theta)), nrow=2)
datamr<-datam%*%R

datamrd<-as.data.frame(datamr)
names(datamrd)<-c("age","ttp")
glm<-glm(ttp~age, data=datamrd)
davies.test(glm, seg.Z=~age, k=1)

# the value of psi can change depending on the dataset, look at the spread of the points to approximate where psi might be
seg<-segmented(glm,seg.Z=~age,psi=list(age=10))
summary(seg)

bpage<-seg$psi[,2]
bpagevalue<-bpage
slope<-seg$coefficients[2]
intercept<-seg$coefficients[1]
bpttp<-intercept+slope*bpage
conf<-confint(seg)
low<-conf$age[,2]
high<-conf$age[,3]
bpsunconverted <- matrix(c(bpage, low, high, bpttp, bpttp, bpttp), ncol=2, nrow=3)
Rback <- matrix(c(cos(-theta), -sin(-theta), sin(-theta), cos(-theta)), nrow=2)
CS<-bpsunconverted%*%Rback
CS<-as.data.frame(CS)
TGP<-CS$V2[1]
#TGP
TGP
 
CA<-CS$V1[1]
#CS as age
CA
CS
#breakpoint age genotype 2
points(CS[1,1],CS[1,2], pch=19,lwd=4, col="dark grey")
lines(c(CS[2,1],CS[3,1]), c(CS[1,2],CS[1,2]), lwd=3, col="dark grey")
lines(c(CS[1,1],CS[1,1]), c(CS[2,2],CS[3,2]), lwd=3, col="dark grey")
 
#plot lines of breakpoint 
# nrow and segRotate will change with the dataset, check the number of rows and change nrow and the x value of
# segRotate the number of the last row
seg2=broken.line(seg, link=FALSE)
seg2.matrix=matrix(c(age,seg2),nrow=155, ncol=2)
Rback <- matrix(c(cos(-theta), -sin(-theta), sin(-theta), cos(-theta)), nrow=2)
segRotate<-seg2.matrix%*%Rback
lines(c(segRotate[1,1],CS[1,1]),c(segRotate[1,2],CS[1,2]), lwd=2, col="dark grey")
lines(c(CS[1,1],segRotate[155,1]),c(CS[1,2],segRotate[155,2]),lwd=2, col="dark grey")

detach(P0206_20E)


