//***************************************************
//
//	SOAHTchemistry.ipf
//	Author: Ziyue Li (UC Davis)
//	Revision Number: 1.00
//	Revision Date: Sep 24, 2018
//	Revision Notes:
//
//

/////////////////////////////////////////////////////////////////
menu  "HT Oxidation"
	Submenu "Create Rate Constants Wave"
		//Simple = rate constants for all the three generations are assumed identical
		"Low RH-Simple", CreatekkWave_3G_basic() 
		"High RH-Simple", CreatekkWave_3G_basicH2O()
		//Complex = different rate constants are assumed for each generation
		"Low RH-Complex", CreatekkWave_3G_adv()
		"High RH-Complex", CreatekkWave_3G_advH2O()
       end
       Submenu "Profiles at one OH conc"
       	//To use the following, rate contant wave must be creased first, simple and complex both work
       	//RO is not considered explicitly in the following two functions
       	"Low RH", OHexposure38s_3G_dry()
       	"High RH", OHexposure38s_3G_H2O()
       	//RO is considered explicitly; however particle growth due to water uptake is not considered 
       	//"Low RH with RO",OHexposure38s_3G_dry_RO()
       end
       Submenu "Profiles at various OH conc"
       	//The following functions treat RO radicals implicitly and use same rate constants for three generations
       	"Low RH", FullOHRange_lowRH()
       	"High RH", FullOHRange_highRH()
       end
end

//////////////////////////////////////////////////////////////////////////////////////////
//This function pops up a selection menu to set values for Dorg, uptake_OH, prob, kkRO2 and bratio
//This function assumes that uptake_HO2=uptake_OH and that frag prob, kkRO2 and bratio for all generations are the same
Function CreatekkWave_3G_basic()
	make/o/d/n=(100) kkWave
	make/o/t/n=(100) kkWave_names
	kkWave=nan
	kkWave_names=""
	
	variable Dorg=1e-18
	variable uptake_OH=0.105
	variable prob=0.31
	variable kk=1e-15
	variable bratio=0.75
	variable kd=1e5
	variable kk_1=1e-15  
	prompt Dorg, "Diffusivity in m2/s"
	prompt uptake_OH, "Uptake coef of OH and HO2"
	prompt prob, "Fragmentation probability (fraction)"
	prompt kk, "Rate constant for RO2+RO2"
	prompt bratio, "Braching ratio ROOH_1+OH->RO2_1"
	//prompt kd, "Decomposition rate of RO"
	//prompt kk_1, "Rate constant for RO+RH"
	DoPrompt "Set following values",Dorg,uptake_OH,prob,kk,bratio//,kd,kk_1
	
	variable Dfrag=1.4*Dorg
	variable OH_gas=0.6e11
	variable HO2_gas=0.6e11
	variable OH_gs=0.6e11
	variable HO2_gs=0.6e11
	variable flowtime=38.00
	variable totaltimesteps=101
	variable timestep=flowtime/(totaltimesteps-1)
	variable smallest_timestep=0.0001
	variable stepnum
	if(smallest_timestep<=0)
		print "smallest_timestep can't be zero or negative"
		abort
	else
		stepnum=ceil(timestep/smallest_timestep)
		smallest_timestep=timestep/stepnum
	endif
	variable Dp=125  //nm
	variable SL_depth=0.76  //nm; surface layer depth is fixed no matter how particle shrinks unless particle radius is smaller than SL detph
	variable totallayers=50   //#
	variable layerdepth=(0.5*Dp-SL_depth)/totallayers
	variable density=1.3   //g/cm3
	variable MWorg=175  //g/mol
	variable NA=6.022e23  //mlc/mol
	variable Corg_initial=density*NA/MWorg  //mlc/cm3-particle
	variable Corg_mlc_initial=Corg_initial*pi/6*(Dp*1e-7)^3  //total mlc in one particle
	
	kkWave[0]=Dorg  //m2/s
	kkWave[1]=Dfrag  //m2/s
	kkWave[2]=OH_gas  //mlc/cm3-air
	kkWave[3]=HO2_gas  //mlc/cm3-air
	kkWave[4]=OH_gs  //mlc/cm3-air  gas concentration near the surface
	kkWave[5]=HO2_gs  //mlc/cm3-air  gas concentration near the surface
	kkWave[6]=uptake_OH
	kkWave[7]=uptake_OH
	kkWave[8]=flowtime  //s
	kkWave[9]=totaltimesteps  
	kkWave[10]=timestep  //s
	kkWave[11]=stepnum
	kkWave[12]=smallest_timestep  //s
	kkWave[13]=Dp  //nm  initial diameter
	kkWave[14]=SL_depth  //nm
	kkWave[15]=totallayers  //besides surface layer
	kkWave[16]=layerdepth  //nm   initial layerdepth
	kkWave[17]=density  //g/cm3-particle
	kkWave[18]=MWorg  //g/mol
	kkWave[19]=Corg_initial  //mlc/cm3-particle
	kkWave[20]=Corg_mlc_initial  //mlc
	kkWave[21]=prob  //fragmentation probability for RO2_1+RO2_1
	kkWave[22]=prob  //fragmentation probability for RO2_1+RO2_2 and RO2_2+RO2_2
	kkWave[23]=prob  //fragmentation probability for RO2_1+RO2_3, RO2_2+RO2_3 and RO2_3+RO2_3
	kkWave[24]=kk  //cm3/mlc/s,  RO2_1+RO2_1
	kkWave[25]=kk  //RO2_1+RO2_2
	kkWave[26]=kk  //RO2_2+RO2_2  
	kkWave[27]=kk  //RO2_1+RO2_3, RO2_2+RO2_3 and RO2_3+RO2_3
	kkWave[28]=bRatio  //braching ratio of ROOH_1+OH-> bratio*RO2_1+ (1-bratio)* RO2_2
	kkWave[29]=bRatio  //braching ratio of ROOH_2+OH-> bratio*RO2_2+ (1-bratio)* RO2_3
	kkWave[30]=kd  //RO_1->2*Frag
	kkWAve[31]=kd  //RO_2->2*Frag
	kkWave[32]=kd  //RO_3->2*Frag
	kkWave[33]=kk_1 //RO_1+RH->ROH1+RO2_1
	kkWave[34]=kk_1 //RO_1+ROH1->ROH1+RO2_2
	kkWave[35]=kk_1  //RO_1+ROH2->ROH1+RO2_3
	kkWave[36]=kk_1  //RO_1+ROH3->ROH1+RO2_3
	kkWave[37]=kk_1 //RO_2+RH->ROH2+RO2_1
	kkWave[38]=kk_1 //RO_2+ROH1->ROH2+RO2_2
	kkWave[39]=kk_1 //RO_2+ROH2->ROH2+RO2_3
	kkWave[40]=kk_1  //RO_2+ROH3->ROH2+RO2_3
	kkWave[41]=kk_1  //RO_3+RH->ROH3+RO2_1
	kkWave[42]=kk_1  //RO_3+ROH1->ROH3+RO2_2
	kkWave[43]=kk_1  //RO_3+ROH2->ROH3+RO2_3
	kkWave[44]=kk_1  //RO_3+ROH3->ROH3+RO2_3
	kkWave[45]=kk_1  //RO_1+ROOH1->ROH1+RO2_2
	kkWave[46]=kk_1  //RO_1+ROOH2->ROH1+RO2_3
	kkWave[47]=kk_1  //RO_1+ROOH3->ROH1+RO2_3
	kkWave[48]=kk_1  //RO_2+ROOH1->ROH2+RO2_2
	kkWave[49]=kk_1  //RO_2+ROOH2->ROH2+RO2_3
	kkWave[50]=kk_1  //RO_2+ROOH3->ROH2+RO2_3
	kkWave[51]=kk_1  //RO_3+ROOH1->ROH3+RO2_2
	kkWAve[52]=kk_1  //RO_3+ROOH2->ROH3+RO2_3
	kkWave[53]=kk_1  //RO_3+ROOH3->ROH3+RO2_3
	
	
	kkWave_names[0]="Dorg,m2/s"
	kkWave_names[1]="Dfrag,m2/s"
	kkWave_names[2]="concentration of OH,mlc/cm3-air"
	kkWave_names[3]="concentration of HO2,mlc/cm3-air"
	kkWave_names[4]="concentration of OH near the surface, mlc/cm3-air"
	kkWave_names[5]="concentration of HO2 near the surface, mlc/cm3-air"
	kkWave_names[6]="uptake coefficient of OH"
	kkWave_names[7]="uptake coefficient of HO2"
	kkWave_names[8]="flow time, s"
	kkWave_names[9]="# of big time steps"  
	kkWave_names[10]="big time step, s"
	kkWave_names[11]="# of small time steps in each big time step"
	kkWave_names[12]="smallest time step, s"
	kkWave_names[13]="initial particle diameter, nm"
	kkWave_names[14]="depth of surface layer, nm"
	kkWave_names[15]="# of layers besides surface layer"
	kkWave_names[16]="initial thickness of each layer, nm"
	kkWave_names[17]="particle density, g/cm3-particle"
	kkWave_names[18]="average molecular weight, g/mol"
	kkWave_names[19]="initial molecular density, mlc/cm3-particle"
	kkWave_names[20]="initial total molecules, mlc"
	kkWave_names[21]="fragmentation probability for RO2_1+RO2_1"
	kkWave_names[22]="fragmentation probability for RO2_1+RO2_2 and RO2_2+RO2_2"
	kkWave_names[23]="fragmentation probability for RO2_1+RO2_3, RO2_2+RO2_3 and RO2_3+RO2_3"
	kkWave_names[24]="rate constant for RO2_1+RO2_1, cm3/mlc/s"
	kkWave_names[25]="rate constant for RO2_1+RO2_2"
	kkWave_names[26]="rate constant for RO2_2+RO2_2"
	kkWave_names[27]="rate constant for RO2_1+RO2_3, RO2_2+RO2_3 and RO2_3+RO2_3"
	kkWave_names[28]="braching ratio of ROOH_1+OH->RO2_1"
	kkWave_names[29]="braching ratio of ROOH_2+OH->RO2_2"
	kkWave_names[30]="decomposition rate for RO_1->2*Frag"
	kkWAve_names[31]="decomposition rate for RO_2->2*Frag"
	kkWave_names[32]="decomposition rate for RO_3->2*Frag"
	kkWave_names[33]="rate constant for RO_1+RH->ROH1+RO2_1"
	kkWave_names[34]="rate constant for RO_1+ROH1->ROH1+RO2_2"
	kkWave_names[35]="rate constant for RO_1+ROH2->ROH1+RO2_3"
	kkWave_names[36]="rate constant for RO_1+ROH3->ROH1+RO2_3"
	kkWave_names[37]="rate constant for RO_2+RH->ROH2+RO2_1"
	kkWave_names[38]="rate constant for RO_2+ROH1->ROH2+RO2_2"
	kkWave_names[39]="rate constant for RO_2+ROH2->ROH2+RO2_3"
	kkWave_names[40]="rate constant for RO_2+ROH3->ROH2+RO2_3"
	kkWave_names[41]="rate constant for RO_3+RH->ROH3+RO2_1"
	kkWave_names[42]="rate constant for RO_3+ROH1->ROH3+RO2_2"
	kkWave_names[43]="rate constant for RO_3+ROH2->ROH3+RO2_3"
	kkWave_names[44]="rate constant for RO_3+ROH3->ROH3+RO2_3"
	kkWave_names[45]="rate constant for RO_1+ROOH1->ROH1+RO2_2"
	kkWave_names[46]="rate constant for RO_1+ROOH2->ROH1+RO2_3"
	kkWave_names[47]="rate constant for RO_1+ROOH3->ROH1+RO2_3"
	kkWave_names[48]="rate constant for RO_2+ROOH1->ROH2+RO2_2"
	kkWave_names[49]="rate constant for RO_2+ROOH2->ROH2+RO2_3"
	kkWave_names[50]="rate constant for RO_2+ROOH3->ROH2+RO2_3"
	kkWave_names[51]="rate constant for RO_3+ROOH1->ROH3+RO2_2"
	kkWAve_names[52]="rate constant for RO_3+ROOH2->ROH3+RO2_3"
	kkWave_names[53]="rate constant for RO_3+ROOH3->ROH3+RO2_3"
	
	Note/k kkwave "This wave stores the rate constants etc., please refer to text wave 'kkwave_names' for what each column is"
	Note/k kkwave_names "This text wave stores the item names of 'kkwave' "


End

//////////////////////////////////////////////////////////////////////////////////////////
//This function pops up a selection menu to set values for Dorg, uptake_OH, prob, kkRO2 and bratio
//This function assumes that uptake_HO2=uptake_OH and that frag prob, kkRO2 and bratio for all generations are the same
//The water in the particle is considered as one of the compositions; Water fraction is considered by setting growth factor >1
Function CreatekkWave_3G_basicH2O()
	make/o/d/n=(100) kkWave
	make/o/t/n=(100) kkWave_names
	kkWave=nan
	kkWave_names=""
	
	variable Dorg=1e-16
	variable uptake_OH=0.50
	variable prob=0.31
	variable kk=1e-15
	variable bratio=0.75
	variable kd=1e5
	variable kk_1=1e-15  
	variable gf = 1.1 //(growth factor of aP SOA at high RH)
	prompt Dorg, "Diffusivity in m2/s"
	prompt uptake_OH, "Uptake coef of OH and HO2"
	prompt prob, "Fragmentation probability (fraction)"
	prompt kk, "Rate constant for RO2+RO2"
	prompt bratio, "Braching ratio ROOH_1+OH->RO2_1"
	//prompt kd, "Decomposition rate of RO"
	//prompt kk_1, "Rate constant for RO+RH"
	prompt gf, "Growth factor of SOA at RH = 90%"
	DoPrompt "Set following values",Dorg,uptake_OH,prob,kk,bratio,gf//,kd,kk_1
	
	variable Dfrag=1.4*Dorg
	variable OH_gas=1.7e11
	variable HO2_gas=1.7e11
	variable OH_gs=1.7e11
	variable HO2_gs=1.7e11
	variable flowtime=38.00
	variable totaltimesteps=101
	variable timestep=flowtime/(totaltimesteps-1)
	variable smallest_timestep=0.0001
	variable stepnum
	if(smallest_timestep<=0)
		print "smallest_timestep can't be zero or negative"
		abort
	else
		stepnum=ceil(timestep/smallest_timestep)
		smallest_timestep=timestep/stepnum
	endif
	variable Dp=125  //initial diameter(before water uptake) in nm
	Dp = Dp*gf //diameter of particle after water uptake
	variable SL_depth=0.76  //nm; surface layer depth is fixed no matter how particle shrinks unless particle radius is smaller than SL detph
	variable totallayers=50   //#
	variable layerdepth=(0.5*Dp-SL_depth)/totallayers
	variable MWorg=175  //g/mol
	variable NA=6.022e23  //mlc/mol
	variable f_water_v=(gf^3-1)/(gf^3) //volume fraction of water in the particle
	variable density_org=1.3  //g/cm3
	variable density=density_org*(1-f_water_v)+1.0*f_water_v   //g/cm3
	variable Corg=density_org*NA/MWorg  //mlc/cm3-particle  molecular density of organics before water uptake
	variable Cwater=1.0*NA/18.02  //mlc/cm3-particle
	variable Corg_initial=Corg*(1-f_water_v)  //mlc/cm3-particle   molecular density of organics after water uptake
	variable Cwater_initial=Cwater*f_water_v
	variable Corg_mlc_initial=Corg_initial*pi/6*(Dp*1e-7)^3  //total mlc in one particle
	variable Cwater_mlc_initial=Cwater_initial*pi/6*(Dp*1e-7)^3  //total mlc in one particle
	
	kkWave[0]=Dorg  //m2/s
	kkWave[1]=Dfrag  //m2/s
	kkWave[2]=OH_gas  //mlc/cm3-air
	kkWave[3]=HO2_gas  //mlc/cm3-air
	kkWave[4]=OH_gs  //mlc/cm3-air  gas concentration near the surface
	kkWave[5]=HO2_gs  //mlc/cm3-air  gas concentration near the surface
	kkWave[6]=uptake_OH
	kkWave[7]=uptake_OH
	kkWave[8]=flowtime  //s
	kkWave[9]=totaltimesteps  
	kkWave[10]=timestep  //s
	kkWave[11]=stepnum
	kkWave[12]=smallest_timestep  //s
	kkWave[13]=Dp  //nm  initial diameter
	kkWave[14]=SL_depth  //nm
	kkWave[15]=totallayers  //besides surface layer
	kkWave[16]=layerdepth  //nm   initial layerdepth
	kkWave[17]=density  //g/cm3-particle
	kkWave[18]=MWorg  //g/mol
	kkWave[19]=Corg_initial  //mlc/cm3-particle
	kkWave[20]=Corg_mlc_initial  //mlc
	kkWave[21]=prob  //fragmentation probability for RO2_1+RO2_1
	kkWave[22]=prob  //fragmentation probability for RO2_1+RO2_2 and RO2_2+RO2_2
	kkWave[23]=prob  //fragmentation probability for RO2_1+RO2_3, RO2_2+RO2_3 and RO2_3+RO2_3
	kkWave[24]=kk  //cm3/mlc/s,  RO2_1+RO2_1
	kkWave[25]=kk  //RO2_1+RO2_2
	kkWave[26]=kk  //RO2_2+RO2_2  
	kkWave[27]=kk  //RO2_1+RO2_3, RO2_2+RO2_3 and RO2_3+RO2_3
	kkWave[28]=bRatio  //braching ratio of ROOH_1+OH-> bratio*RO2_1+ (1-bratio)* RO2_2
	kkWave[29]=bRatio  //braching ratio of ROOH_2+OH-> bratio*RO2_2+ (1-bratio)* RO2_3
	kkWave[30]=kd  //RO_1->2*Frag
	kkWAve[31]=kd  //RO_2->2*Frag
	kkWave[32]=kd  //RO_3->2*Frag
	kkWave[33]=kk_1 //RO_1+RH->ROH1+RO2_1
	kkWave[34]=kk_1 //RO_1+ROH1->ROH1+RO2_2
	kkWave[35]=kk_1  //RO_1+ROH2->ROH1+RO2_3
	kkWave[36]=kk_1  //RO_1+ROH3->ROH1+RO2_3
	kkWave[37]=kk_1 //RO_2+RH->ROH2+RO2_1
	kkWave[38]=kk_1 //RO_2+ROH1->ROH2+RO2_2
	kkWave[39]=kk_1 //RO_2+ROH2->ROH2+RO2_3
	kkWave[40]=kk_1  //RO_2+ROH3->ROH2+RO2_3
	kkWave[41]=kk_1  //RO_3+RH->ROH3+RO2_1
	kkWave[42]=kk_1  //RO_3+ROH1->ROH3+RO2_2
	kkWave[43]=kk_1  //RO_3+ROH2->ROH3+RO2_3
	kkWave[44]=kk_1  //RO_3+ROH3->ROH3+RO2_3
	kkWave[45]=kk_1  //RO_1+ROOH1->ROH1+RO2_2
	kkWave[46]=kk_1  //RO_1+ROOH2->ROH1+RO2_3
	kkWave[47]=kk_1  //RO_1+ROOH3->ROH1+RO2_3
	kkWave[48]=kk_1  //RO_2+ROOH1->ROH2+RO2_2
	kkWave[49]=kk_1  //RO_2+ROOH2->ROH2+RO2_3
	kkWave[50]=kk_1  //RO_2+ROOH3->ROH2+RO2_3
	kkWave[51]=kk_1  //RO_3+ROOH1->ROH3+RO2_2
	kkWAve[52]=kk_1  //RO_3+ROOH2->ROH3+RO2_3
	kkWave[53]=kk_1  //RO_3+ROOH3->ROH3+RO2_3
	kkWave[54]=f_water_v  //volume fraction of water
	kkWave[55]=Cwater_initial  //molecular density of water in the particle
	kkWave[56]=Cwater_mlc_initial  //initial totale molecule number of water in the particle
	kkWave[57]=gf  //growth factor at 90% RH
	
		
	kkWave_names[0]="Dorg,m2/s"
	kkWave_names[1]="Dfrag,m2/s"
	kkWave_names[2]="concentration of OH,mlc/cm3-air"
	kkWave_names[3]="concentration of HO2,mlc/cm3-air"
	kkWave_names[4]="concentration of OH near the surface, mlc/cm3-air"
	kkWave_names[5]="concentration of HO2 near the surface, mlc/cm3-air"
	kkWave_names[6]="uptake coefficient of OH"
	kkWave_names[7]="uptake coefficient of HO2"
	kkWave_names[8]="flow time, s"
	kkWave_names[9]="# of big time steps"  
	kkWave_names[10]="big time step, s"
	kkWave_names[11]="# of small time steps in each big time step"
	kkWave_names[12]="smallest time step, s"
	kkWave_names[13]="initial particle diameter, nm"
	kkWave_names[14]="depth of surface layer, nm"
	kkWave_names[15]="# of layers besides surface layer"
	kkWave_names[16]="initial thickness of each layer, nm"
	kkWave_names[17]="particle density, g/cm3-particle"
	kkWave_names[18]="average molecular weight, g/mol"
	kkWave_names[19]="initial molecular density, mlc/cm3-particle"
	kkWave_names[20]="initial total molecules, mlc"
	kkWave_names[21]="fragmentation probability for RO2_1+RO2_1"
	kkWave_names[22]="fragmentation probability for RO2_1+RO2_2 and RO2_2+RO2_2"
	kkWave_names[23]="fragmentation probability for RO2_1+RO2_3, RO2_2+RO2_3 and RO2_3+RO2_3"
	kkWave_names[24]="rate constant for RO2_1+RO2_1, cm3/mlc/s"
	kkWave_names[25]="rate constant for RO2_1+RO2_2"
	kkWave_names[26]="rate constant for RO2_2+RO2_2"
	kkWave_names[27]="rate constant for RO2_1+RO2_3, RO2_2+RO2_3 and RO2_3+RO2_3"
	kkWave_names[28]="braching ratio of ROOH_1+OH->RO2_1"
	kkWave_names[29]="braching ratio of ROOH_2+OH->RO2_2"
	kkWave_names[30]="decomposition rate for RO_1->2*Frag"
	kkWAve_names[31]="decomposition rate for RO_2->2*Frag"
	kkWave_names[32]="decomposition rate for RO_3->2*Frag"
	kkWave_names[33]="rate constant for RO_1+RH->ROH1+RO2_1"
	kkWave_names[34]="rate constant for RO_1+ROH1->ROH1+RO2_2"
	kkWave_names[35]="rate constant for RO_1+ROH2->ROH1+RO2_3"
	kkWave_names[36]="rate constant for RO_1+ROH3->ROH1+RO2_3"
	kkWave_names[37]="rate constant for RO_2+RH->ROH2+RO2_1"
	kkWave_names[38]="rate constant for RO_2+ROH1->ROH2+RO2_2"
	kkWave_names[39]="rate constant for RO_2+ROH2->ROH2+RO2_3"
	kkWave_names[40]="rate constant for RO_2+ROH3->ROH2+RO2_3"
	kkWave_names[41]="rate constant for RO_3+RH->ROH3+RO2_1"
	kkWave_names[42]="rate constant for RO_3+ROH1->ROH3+RO2_2"
	kkWave_names[43]="rate constant for RO_3+ROH2->ROH3+RO2_3"
	kkWave_names[44]="rate constant for RO_3+ROH3->ROH3+RO2_3"
	kkWave_names[45]="rate constant for RO_1+ROOH1->ROH1+RO2_2"
	kkWave_names[46]="rate constant for RO_1+ROOH2->ROH1+RO2_3"
	kkWave_names[47]="rate constant for RO_1+ROOH3->ROH1+RO2_3"
	kkWave_names[48]="rate constant for RO_2+ROOH1->ROH2+RO2_2"
	kkWave_names[49]="rate constant for RO_2+ROOH2->ROH2+RO2_3"
	kkWave_names[50]="rate constant for RO_2+ROOH3->ROH2+RO2_3"
	kkWave_names[51]="rate constant for RO_3+ROOH1->ROH3+RO2_2"
	kkWAve_names[52]="rate constant for RO_3+ROOH2->ROH3+RO2_3"
	kkWave_names[53]="rate constant for RO_3+ROOH3->ROH3+RO2_3"
	kkWave_names[54]="Volume fraction of water"
	kkWave_names[55]="Molecular density of water in the particle"
	kkWave_names[56]="Initial totale molecule number of water in the particle"
	kkWave_names[57]="Growth factor at 90% RH"

	Note/k kkwave "This wave stores the rate constants etc., please refer to text wave 'kkwave_names' for what each column is"
	Note/k kkwave_names "This text wave stores the item names of 'kkwave' "


End


/////////////////////////////////////////////////////////////////////////////////////////////////////////
//This function pops up a selection menu to set values for Dorg, uptake_OH, prob, kkRO2 and bratio differently for every generation
Function CreatekkWave_3G_adv()
	make/o/d/n=(100) kkWave
	make/o/t/n=(100) kkWave_names
	kkWave=nan
	kkWave_names=""
	
	variable Dorg=1e-18
	variable uptake_OH=0.15
	variable uptake_HO2=0.10
	variable prob1=0.5
	variable prob2=0.7
	variable prob3=0.9
	variable kk2=1e-17
	variable kk6=1e-16
	variable kk11=1e-15
	variable bratio1=0.75
	variable bratio2=0.75
	variable kd1=1e4  //s-1
	variable kd2=1e5  //s-1
	variable kd3=1e6  //s-1
	variable kk_1=1e-15
	variable kk_2=1e-15
	variable kk_3=1e-15
	
	prompt Dorg, "Diffusivity in m2/s"
	prompt uptake_OH, "Uptake coef of OH"
	prompt uptake_HO2, "Uptake coef of HO2"
	prompt kk2, "Rate constant for RO2+RO2 for G1"
	prompt kk6, "Rate constant for RO2+RO2 for G2"
	prompt kk11, "Rate constant for RO2+RO2 for G3"
	prompt kk_1, "Rate constant for RO+RH for G1"
	prompt kk_2, "Rate constant for RO+RH for G2"
	prompt kk_3, "Rate constant for RO+RH for G3"
	DoPrompt "Set following values",Dorg,uptake_OH,uptake_HO2,kk2,kk6,kk11,kk_1,kk_2,kk_3
	variable kk7=kk6
	
	prompt prob1, "Fragmentation probability for G1"
	prompt prob2, "Fragmentation probability for G2"
	prompt prob3, "Fragmentation probability for G3"
	prompt kd1, "Decomposition rate of RO for G1"
	prompt kd2, "Decomposition rate of RO for G2"
	prompt kd3, "Decomposition rate of RO for G3"
	prompt bratio1, "Braching ratio ROOH_1+OH->RO2_1"
	prompt bratio2, "Braching ratio ROOH_2+OH->RO2_2"
	DoPrompt "Set following values",prob1,prob2,prob3,kd1,kd2,kd3,bratio1,bratio2
	
	variable Dfrag=1.4*Dorg
	variable OH_gas=1e11
	variable HO2_gas=1e11
	variable OH_gs=1e11
	variable HO2_gs=1e11
	variable flowtime=38
	variable totaltimesteps=101
	variable timestep=flowtime/(totaltimesteps-1)
	variable smallest_timestep=0.00001
	variable stepnum
	if(smallest_timestep<=0)
		print "smallest_timestep can't be zero or negative"
		abort
	else
		stepnum=ceil(timestep/smallest_timestep)
		smallest_timestep=timestep/stepnum
	endif
	variable Dp=125  //nm
	variable SL_depth=0.4  //nm; surface layer depth is fixed no matter how particle shrinks unless particle radius is smaller than SL detph
	variable totallayers=50   //#
	variable layerdepth=(0.5*Dp-SL_depth)/totallayers
	variable density=1.3   //g/cm3
	variable MWorg=170  //g/mol
	variable NA=6.022e23  //mlc/mol
	variable Corg_initial=density*NA/MWorg  //mlc/cm3-particle
	variable Corg_mlc_initial=Corg_initial*pi/6*(Dp*1e-7)^3  //total mlc in one particle
	
	kkWave[0]=Dorg  //m2/s
	kkWave[1]=Dfrag  //m2/s
	kkWave[2]=OH_gas  //mlc/cm3-air
	kkWave[3]=HO2_gas  //mlc/cm3-air
	kkWave[4]=OH_gs  //mlc/cm3-air  gas concentration near the surface
	kkWave[5]=HO2_gs  //mlc/cm3-air  gas concentration near the surface
	kkWave[6]=uptake_OH
	kkWave[7]=uptake_HO2
	kkWave[8]=flowtime  //s
	kkWave[9]=totaltimesteps  
	kkWave[10]=timestep  //s
	kkWave[11]=stepnum
	kkWave[12]=smallest_timestep  //s
	kkWave[13]=Dp  //nm  initial diameter
	kkWave[14]=SL_depth  //nm
	kkWave[15]=totallayers  //besides surface layer
	kkWave[16]=layerdepth  //nm   initial layerdepth
	kkWave[17]=density  //g/cm3-particle
	kkWave[18]=MWorg  //g/mol
	kkWave[19]=Corg_initial  //mlc/cm3-particle
	kkWave[20]=Corg_mlc_initial  //mlc
	kkWave[21]=prob1  //fragmentation probability for RO2_1+RO2_1
	kkWave[22]=prob2 //fragmentation probability for RO2_1+RO2_2 and RO2_2+RO2_2
	kkWave[23]=prob3  //fragmentation probability for RO2_1+RO2_3, RO2_2+RO2_3 and RO2_3+RO2_3
	kkWave[24]=kk2  //cm3/mlc/s,  RO2_1+RO2_1
	kkWave[25]=kk6  //RO2_1+RO2_2
	kkWave[26]=kk7  //RO2_2+RO2_2  
	kkWave[27]=kk11  //RO2_1+RO2_3, RO2_2+RO2_3 and RO2_3+RO2_3
	kkWave[28]=bRatio1  //braching ratio of ROOH_1+OH->RO2_1
	kkWave[29]=bRatio2  //braching ratio of ROOH_2+OH->RO2_2
	kkWave[30]=kd1  //RO_1->2*Frag
	kkWAve[31]=kd2  //RO_2->2*Frag
	kkWave[32]=kd3  //RO_3->2*Frag
	kkWave[33]=kk_1 //RO_1+RH->ROH1+RO2_1
	kkWave[34]=kk_1 //RO_1+ROH1->ROH1+RO2_2
	kkWave[35]=kk_1  //RO_1+ROH2->ROH1+RO2_3
	kkWave[36]=kk_1  //RO_1+ROH3->ROH1+RO2_3
	kkWave[37]=kk_2 //RO_2+RH->ROH2+RO2_1
	kkWave[38]=kk_2 //RO_2+ROH1->ROH2+RO2_2
	kkWave[39]=kk_2 //RO_2+ROH2->ROH2+RO2_3
	kkWave[40]=kk_2  //RO_2+ROH3->ROH2+RO2_3
	kkWave[41]=kk_3  //RO_3+RH->ROH3+RO2_1
	kkWave[42]=kk_3  //RO_3+ROH1->ROH3+RO2_2
	kkWave[43]=kk_3  //RO_3+ROH2->ROH3+RO2_3
	kkWave[44]=kk_3  //RO_3+ROH3->ROH3+RO2_3
	kkWave[45]=kk_1  //RO_1+ROOH1->ROH1+RO2_2
	kkWave[46]=kk_1  //RO_1+ROOH2->ROH1+RO2_3
	kkWave[47]=kk_1  //RO_1+ROOH3->ROH1+RO2_3
	kkWave[48]=kk_2  //RO_2+ROOH1->ROH2+RO2_2
	kkWave[49]=kk_2  //RO_2+ROOH2->ROH2+RO2_3
	kkWave[50]=kk_2  //RO_2+ROOH3->ROH2+RO2_3
	kkWave[51]=kk_3  //RO_3+ROOH1->ROH3+RO2_2
	kkWAve[52]=kk_3  //RO_3+ROOH2->ROH3+RO2_3
	kkWave[53]=kk_3  //RO_3+ROOH3->ROH3+RO2_3

	kkWave_names[0]="Dorg,m2/s"
	kkWave_names[1]="Dfrag,m2/s"
	kkWave_names[2]="concentration of OH,mlc/cm3-air"
	kkWave_names[3]="concentration of HO2,mlc/cm3-air"
	kkWave_names[4]="concentration of OH near the surface, mlc/cm3-air"
	kkWave_names[5]="concentration of HO2 near the surface, mlc/cm3-air"
	kkWave_names[6]="uptake coefficient of OH"
	kkWave_names[7]="uptake coefficient of HO2"
	kkWave_names[8]="flow time, s"
	kkWave_names[9]="# of big time steps"  
	kkWave_names[10]="big time step, s"
	kkWave_names[11]="# of small time steps in each big time step"
	kkWave_names[12]="smallest time step, s"
	kkWave_names[13]="initial particle diameter, nm"
	kkWave_names[14]="depth of surface layer, nm"
	kkWave_names[15]="# of layers besides surface layer"
	kkWave_names[16]="initial thickness of each layer, nm"
	kkWave_names[17]="particle density, g/cm3-particle"
	kkWave_names[18]="average molecular weight, g/mol"
	kkWave_names[19]="initial molecular density, mlc/cm3-particle"
	kkWave_names[20]="initial total molecules, mlc"
	kkWave_names[21]="fragmentation probability for RO2_1+RO2_1"
	kkWave_names[22]="fragmentation probability for RO2_1+RO2_2 and RO2_2+RO2_2"
	kkWave_names[23]="fragmentation probability for RO2_1+RO2_3, RO2_2+RO2_3 and RO2_3+RO2_3"
	kkWave_names[24]="rate constant for RO2_1+RO2_1, cm3/mlc/s"
	kkWave_names[25]="rate constant for RO2_1+RO2_2"
	kkWave_names[26]="rate constant for RO2_2+RO2_2"
	kkWave_names[27]="rate constant for RO2_1+RO2_3, RO2_2+RO2_3 and RO2_3+RO2_3"
	kkWave_names[28]="braching ratio of ROOH_1+OH->RO2_1"
	kkWave_names[29]="braching ratio of ROOH_2+OH->RO2_2"
	kkWave_names[30]="decomposition rate for RO_1->2*Frag"
	kkWAve_names[31]="decomposition rate for RO_2->2*Frag"
	kkWave_names[32]="decomposition rate for RO_3->2*Frag"
	kkWave_names[33]="rate constant for RO_1+RH->ROH1+RO2_1"
	kkWave_names[34]="rate constant for RO_1+ROH1->ROH1+RO2_2"
	kkWave_names[35]="rate constant for RO_1+ROH2->ROH1+RO2_3"
	kkWave_names[36]="rate constant for RO_1+ROH3->ROH1+RO2_3"
	kkWave_names[37]="rate constant for RO_2+RH->ROH2+RO2_1"
	kkWave_names[38]="rate constant for RO_2+ROH1->ROH2+RO2_2"
	kkWave_names[39]="rate constant for RO_2+ROH2->ROH2+RO2_3"
	kkWave_names[40]="rate constant for RO_2+ROH3->ROH2+RO2_3"
	kkWave_names[41]="rate constant for RO_3+RH->ROH3+RO2_1"
	kkWave_names[42]="rate constant for RO_3+ROH1->ROH3+RO2_2"
	kkWave_names[43]="rate constant for RO_3+ROH2->ROH3+RO2_3"
	kkWave_names[44]="rate constant for RO_3+ROH3->ROH3+RO2_3"
	kkWave_names[45]="rate constant for RO_1+ROOH1->ROH1+RO2_2"
	kkWave_names[46]="rate constant for RO_1+ROOH2->ROH1+RO2_3"
	kkWave_names[47]="rate constant for RO_1+ROOH3->ROH1+RO2_3"
	kkWave_names[48]="rate constant for RO_2+ROOH1->ROH2+RO2_2"
	kkWave_names[49]="rate constant for RO_2+ROOH2->ROH2+RO2_3"
	kkWave_names[50]="rate constant for RO_2+ROOH3->ROH2+RO2_3"
	kkWave_names[51]="rate constant for RO_3+ROOH1->ROH3+RO2_2"
	kkWAve_names[52]="rate constant for RO_3+ROOH2->ROH3+RO2_3"
	kkWave_names[53]="rate constant for RO_3+ROOH3->ROH3+RO2_3"
	
	Note/k kkwave "This wave stores the rate constants etc., please refer to text wave 'kkwave_names' for what each column is"
	Note/k kkwave_names "This text wave stores the item names of 'kkwave' "


End

/////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////
//This function pops up a selection menu to set values for Dorg, uptake_OH, prob, kkRO2 and bratio differently for every generation
//Water content is considered by setting growth factor >1
Function CreatekkWave_3G_advH2O()
	make/o/d/n=(100) kkWave
	make/o/t/n=(100) kkWave_names
	kkWave=nan
	kkWave_names=""
	
	variable Dorg=1e-16
	variable uptake_OH=0.50
	variable uptake_HO2=0.40
	variable prob1=0.5
	variable prob2=0.7
	variable prob3=0.9
	variable kk2=1e-17
	variable kk6=1e-16
	variable kk11=1e-15
	variable bratio1=0.75
	variable bratio2=0.75
	variable kd1=1e4  //s-1
	variable kd2=1e5  //s-1
	variable kd3=1e6  //s-1
	variable kk_1=1e-15
	variable kk_2=1e-15
	variable kk_3=1e-15
	variable gf = 1.1 //(growth factor of aP SOA at high RH)
	
	
	prompt Dorg, "Diffusivity in m2/s"
	prompt gf, "Growth factor of SOA at RH = 90%"
	prompt uptake_OH, "Uptake coef of OH"
	prompt uptake_HO2, "Uptake coef of HO2"
	prompt kk2, "Rate constant for RO2+RO2 for G1"
	prompt kk6, "Rate constant for RO2+RO2 for G2"
	prompt kk11, "Rate constant for RO2+RO2 for G3"
	prompt kk_1, "Rate constant for RO+RH for G1"
	prompt kk_2, "Rate constant for RO+RH for G2"
	prompt kk_3, "Rate constant for RO+RH for G3"
	DoPrompt "Set following values",Dorg,gf,uptake_OH,uptake_HO2,kk2,kk6,kk11,kk_1,kk_2,kk_3
	variable kk7=kk6
	
	prompt prob1, "Fragmentation probability for G1"
	prompt prob2, "Fragmentation probability for G2"
	prompt prob3, "Fragmentation probability for G3"
	prompt kd1, "Decomposition rate of RO for G1"
	prompt kd2, "Decomposition rate of RO for G2"
	prompt kd3, "Decomposition rate of RO for G3"
	prompt bratio1, "Braching ratio ROOH_1+OH->RO2_1"
	prompt bratio2, "Braching ratio ROOH_2+OH->RO2_2"
	DoPrompt "Set following values",prob1,prob2,prob3,kd1,kd2,kd3,bratio1,bratio2
	
	variable Dfrag=1.4*Dorg
	variable OH_gas=1e11
	variable HO2_gas=1e11
	variable OH_gs=1e11
	variable HO2_gs=1e11
	variable flowtime=38
	variable totaltimesteps=101
	variable timestep=flowtime/(totaltimesteps-1)
	variable smallest_timestep=0.00001
	variable stepnum
	if(smallest_timestep<=0)
		print "smallest_timestep can't be zero or negative"
		abort
	else
		stepnum=ceil(timestep/smallest_timestep)
		smallest_timestep=timestep/stepnum
	endif
	variable Dp=125  //initial diameter(before water uptake) in nm
	Dp = Dp*gf //diameter of particle after water uptake
	variable SL_depth=0.76  //nm; surface layer depth is fixed no matter how particle shrinks unless particle radius is smaller than SL detph
	variable totallayers=50   //#
	variable layerdepth=(0.5*Dp-SL_depth)/totallayers
	variable MWorg=175  //g/mol
	variable NA=6.022e23  //mlc/mol
	variable f_water_v=(gf^3-1)/(gf^3) //volume fraction of water in the particle
	variable density_org=1.3  //g/cm3
	variable density=density_org*(1-f_water_v)+1.0*f_water_v   //g/cm3
	variable Corg=density_org*NA/MWorg  //mlc/cm3-particle  molecular density of organics before water uptake
	variable Cwater=1.0*NA/18.02  //mlc/cm3-particle
	variable Corg_initial=Corg*(1-f_water_v)  //mlc/cm3-particle   molecular density of organics after water uptake
	variable Cwater_initial=Cwater*f_water_v
	variable Corg_mlc_initial=Corg_initial*pi/6*(Dp*1e-7)^3  //total mlc in one particle
	variable Cwater_mlc_initial=Cwater_initial*pi/6*(Dp*1e-7)^3  //total mlc in one particle
	
	kkWave[0]=Dorg  //m2/s
	kkWave[1]=Dfrag  //m2/s
	kkWave[2]=OH_gas  //mlc/cm3-air
	kkWave[3]=HO2_gas  //mlc/cm3-air
	kkWave[4]=OH_gs  //mlc/cm3-air  gas concentration near the surface
	kkWave[5]=HO2_gs  //mlc/cm3-air  gas concentration near the surface
	kkWave[6]=uptake_OH
	kkWave[7]=uptake_HO2
	kkWave[8]=flowtime  //s
	kkWave[9]=totaltimesteps  
	kkWave[10]=timestep  //s
	kkWave[11]=stepnum
	kkWave[12]=smallest_timestep  //s
	kkWave[13]=Dp  //nm  initial diameter
	kkWave[14]=SL_depth  //nm
	kkWave[15]=totallayers  //besides surface layer
	kkWave[16]=layerdepth  //nm   initial layerdepth
	kkWave[17]=density  //g/cm3-particle
	kkWave[18]=MWorg  //g/mol
	kkWave[19]=Corg_initial  //mlc/cm3-particle
	kkWave[20]=Corg_mlc_initial  //mlc
	kkWave[21]=prob1  //fragmentation probability for RO2_1+RO2_1
	kkWave[22]=prob2 //fragmentation probability for RO2_1+RO2_2 and RO2_2+RO2_2
	kkWave[23]=prob3  //fragmentation probability for RO2_1+RO2_3, RO2_2+RO2_3 and RO2_3+RO2_3
	kkWave[24]=kk2  //cm3/mlc/s,  RO2_1+RO2_1
	kkWave[25]=kk6  //RO2_1+RO2_2
	kkWave[26]=kk7  //RO2_2+RO2_2  
	kkWave[27]=kk11  //RO2_1+RO2_3, RO2_2+RO2_3 and RO2_3+RO2_3
	kkWave[28]=bRatio1  //braching ratio of ROOH_1+OH->RO2_1
	kkWave[29]=bRatio2  //braching ratio of ROOH_2+OH->RO2_2
	kkWave[30]=kd1  //RO_1->2*Frag
	kkWAve[31]=kd2  //RO_2->2*Frag
	kkWave[32]=kd3  //RO_3->2*Frag
	kkWave[33]=kk_1 //RO_1+RH->ROH1+RO2_1
	kkWave[34]=kk_1 //RO_1+ROH1->ROH1+RO2_2
	kkWave[35]=kk_1  //RO_1+ROH2->ROH1+RO2_3
	kkWave[36]=kk_1  //RO_1+ROH3->ROH1+RO2_3
	kkWave[37]=kk_2 //RO_2+RH->ROH2+RO2_1
	kkWave[38]=kk_2 //RO_2+ROH1->ROH2+RO2_2
	kkWave[39]=kk_2 //RO_2+ROH2->ROH2+RO2_3
	kkWave[40]=kk_2  //RO_2+ROH3->ROH2+RO2_3
	kkWave[41]=kk_3  //RO_3+RH->ROH3+RO2_1
	kkWave[42]=kk_3  //RO_3+ROH1->ROH3+RO2_2
	kkWave[43]=kk_3  //RO_3+ROH2->ROH3+RO2_3
	kkWave[44]=kk_3  //RO_3+ROH3->ROH3+RO2_3
	kkWave[45]=kk_1  //RO_1+ROOH1->ROH1+RO2_2
	kkWave[46]=kk_1  //RO_1+ROOH2->ROH1+RO2_3
	kkWave[47]=kk_1  //RO_1+ROOH3->ROH1+RO2_3
	kkWave[48]=kk_2  //RO_2+ROOH1->ROH2+RO2_2
	kkWave[49]=kk_2  //RO_2+ROOH2->ROH2+RO2_3
	kkWave[50]=kk_2  //RO_2+ROOH3->ROH2+RO2_3
	kkWave[51]=kk_3  //RO_3+ROOH1->ROH3+RO2_2
	kkWAve[52]=kk_3  //RO_3+ROOH2->ROH3+RO2_3
	kkWave[53]=kk_3  //RO_3+ROOH3->ROH3+RO2_3
	kkWave[54]=f_water_v  //volume fraction of water
	kkWave[55]=Cwater_initial  //molecular density of water in the particle
	kkWave[56]=Cwater_mlc_initial  //initial totale molecule number of water in the particle
	kkWave[57]=gf  //growth factor at 90% RH

	kkWave_names[0]="Dorg,m2/s"
	kkWave_names[1]="Dfrag,m2/s"
	kkWave_names[2]="concentration of OH,mlc/cm3-air"
	kkWave_names[3]="concentration of HO2,mlc/cm3-air"
	kkWave_names[4]="concentration of OH near the surface, mlc/cm3-air"
	kkWave_names[5]="concentration of HO2 near the surface, mlc/cm3-air"
	kkWave_names[6]="uptake coefficient of OH"
	kkWave_names[7]="uptake coefficient of HO2"
	kkWave_names[8]="flow time, s"
	kkWave_names[9]="# of big time steps"  
	kkWave_names[10]="big time step, s"
	kkWave_names[11]="# of small time steps in each big time step"
	kkWave_names[12]="smallest time step, s"
	kkWave_names[13]="initial particle diameter, nm"
	kkWave_names[14]="depth of surface layer, nm"
	kkWave_names[15]="# of layers besides surface layer"
	kkWave_names[16]="initial thickness of each layer, nm"
	kkWave_names[17]="particle density, g/cm3-particle"
	kkWave_names[18]="average molecular weight, g/mol"
	kkWave_names[19]="initial molecular density, mlc/cm3-particle"
	kkWave_names[20]="initial total molecules, mlc"
	kkWave_names[21]="fragmentation probability for RO2_1+RO2_1"
	kkWave_names[22]="fragmentation probability for RO2_1+RO2_2 and RO2_2+RO2_2"
	kkWave_names[23]="fragmentation probability for RO2_1+RO2_3, RO2_2+RO2_3 and RO2_3+RO2_3"
	kkWave_names[24]="rate constant for RO2_1+RO2_1, cm3/mlc/s"
	kkWave_names[25]="rate constant for RO2_1+RO2_2"
	kkWave_names[26]="rate constant for RO2_2+RO2_2"
	kkWave_names[27]="rate constant for RO2_1+RO2_3, RO2_2+RO2_3 and RO2_3+RO2_3"
	kkWave_names[28]="braching ratio of ROOH_1+OH->RO2_1"
	kkWave_names[29]="braching ratio of ROOH_2+OH->RO2_2"
	kkWave_names[30]="decomposition rate for RO_1->2*Frag"
	kkWAve_names[31]="decomposition rate for RO_2->2*Frag"
	kkWave_names[32]="decomposition rate for RO_3->2*Frag"
	kkWave_names[33]="rate constant for RO_1+RH->ROH1+RO2_1"
	kkWave_names[34]="rate constant for RO_1+ROH1->ROH1+RO2_2"
	kkWave_names[35]="rate constant for RO_1+ROH2->ROH1+RO2_3"
	kkWave_names[36]="rate constant for RO_1+ROH3->ROH1+RO2_3"
	kkWave_names[37]="rate constant for RO_2+RH->ROH2+RO2_1"
	kkWave_names[38]="rate constant for RO_2+ROH1->ROH2+RO2_2"
	kkWave_names[39]="rate constant for RO_2+ROH2->ROH2+RO2_3"
	kkWave_names[40]="rate constant for RO_2+ROH3->ROH2+RO2_3"
	kkWave_names[41]="rate constant for RO_3+RH->ROH3+RO2_1"
	kkWave_names[42]="rate constant for RO_3+ROH1->ROH3+RO2_2"
	kkWave_names[43]="rate constant for RO_3+ROH2->ROH3+RO2_3"
	kkWave_names[44]="rate constant for RO_3+ROH3->ROH3+RO2_3"
	kkWave_names[45]="rate constant for RO_1+ROOH1->ROH1+RO2_2"
	kkWave_names[46]="rate constant for RO_1+ROOH2->ROH1+RO2_3"
	kkWave_names[47]="rate constant for RO_1+ROOH3->ROH1+RO2_3"
	kkWave_names[48]="rate constant for RO_2+ROOH1->ROH2+RO2_2"
	kkWave_names[49]="rate constant for RO_2+ROOH2->ROH2+RO2_3"
	kkWave_names[50]="rate constant for RO_2+ROOH3->ROH2+RO2_3"
	kkWave_names[51]="rate constant for RO_3+ROOH1->ROH3+RO2_2"
	kkWAve_names[52]="rate constant for RO_3+ROOH2->ROH3+RO2_3"
	kkWave_names[53]="rate constant for RO_3+ROOH3->ROH3+RO2_3"
	kkWave_names[54]="Volume fraction of water"
	kkWave_names[55]="Molecular density of water in the particle"
	kkWave_names[56]="Initial totale molecule number of water in the particle"
	kkWave_names[57]="Growth factor at 90% RH"
	
	Note/k kkwave "This wave stores the rate constants etc., please refer to text wave 'kkwave_names' for what each column is"
	Note/k kkwave_names "This text wave stores the item names of 'kkwave' "


End

////////////////////////////////////////////////////////////////////////////////////////////////////////
//This function treats ROOH(hydropeoxides) and other functionalized species (lumped as ROH) differently
//RO is considered explicitly in this function with inclusion of RO->(decomposes to)2Frag and RO+RH reactions
//This function has high requirement towards smallest_timestep
Function OHexposure38s_3G_dry_RO()

	wave kkWave
	if (waveexists(kkwave)==0)
		print "Please create rate constant wave 'kkwave' first"
		abort
	endif
	
	variable Dorg=kkWave[0]
	variable Dfrag=kkWave[1]
	variable OH_gas=kkWave[2]
	variable HO2_gas=kkWave[3]
	variable uptake_OH=kkWave[6]
	variable uptake_HO2=kkWave[7]
	variable flowtime=kkWave[8]	
	variable totaltimesteps=kkWave[9]
	variable timestep=kkWave[10]
	variable stepnum=kkWave[11]
	variable smallest_timestep=kkWave[12]
	variable Dp=kkWave[13]
	variable SL_depth=kkWave[14]
	variable totallayers=kkWave[15]
	variable layerdepth=kkWave[16]
	variable Corg_initial=kkWave[19]
	variable Corg_mlc_initial=kkWave[20]
	variable prob1=kkWave[21]
	variable prob2=kkWave[22]
	variable prob3=kkWave[23]
	variable k2=kkWave[24]
	variable k6=kkWave[25]
	variable k7=kkWave[26]
	variable k11=kkWave[27]
	variable bratio1=kkWave[28]
	variable bratio2=kkWave[29]
	variable kd1=kkWave[30]
	variable kd2=kkWave[31]
	variable kd3=kkWave[32]
	variable kk_1=kkWave[33]
	variable kk_2=kkWave[37]
	variable kk_3=kkWave[41]
	
	variable Kn_OH=6*0.21485e-4/609/Dp/1e-9   //dimensionless
	variable Kn_HO2=6*0.25e-4/437/Dp/1e-9   //dimensionless
	variable Fuchs_OH=(0.75+0.28*Kn_OH)/(Kn_OH*(1+Kn_OH))  //Maybe not Fuchs... From Shiraiwa et al. ACP 2010
	variable Fuchs_HO2=(0.75+0.28*Kn_HO2)/(Kn_HO2*(1+Kn_HO2)) 
	variable Crtf_OH=1/(1+uptake_OH*Fuchs_OH)  //Correction factor of the near surface concentration to the far away concentration
	variable Crtf_HO2=1/(1+uptake_HO2*Fuchs_HO2)
	variable OH_initial=OH_gas*Crtf_OH
	variable HO2_initial=HO2_gas*Crtf_HO2
	
	variable OH_gs=OH_initial  //mlc/cm3-air
	variable HO2_gs=HO2_initial //mlc/cm3-air
	
	//stores concentration and mlc number in each layer at each big time step
	make/o/d/n=(totaltimesteps,totallayers+1) C_RH,C_ROOH1,C_ROOH2,C_ROOH3,C_ROH1,C_ROH2,C_ROH3,C_Frag,C_RO2_1,C_RO2_2,C_RO2_3,C_RO_1,C_RO_2,C_RO_3
	make/o/d/n=(totaltimesteps,totallayers+1) mlc_RH,mlc_ROOH1,mlc_ROOH2,mlc_ROOH3,mlc_ROH1,mlc_ROH2,mlc_ROH3,mlc_RO2_1,mlc_RO2_2,mlc_RO2_3,mlc_Frag,mlc_RO_1,mlc_RO_2,mlc_RO_3   //surface layer index is 0
	C_RH=0  
	C_ROOH1=0
	C_ROOH2=0
	C_ROOH3=0
	C_ROH1=0
	C_ROH2=0
	C_ROH3=0
	C_Frag=0
	C_RO2_1=0
	C_RO2_2=0
	C_RO2_3=0
	C_RO_1=0
	C_RO_2=0
	C_RO_3=0
	mlc_RH=0  
	mlc_ROOH1=0
	mlc_ROOH2=0
	mlc_ROOH3=0
	mlc_ROH1=0
	mlc_ROH2=0
	mlc_ROH3=0
	mlc_RO2_1=0
	mlc_RO2_2=0
	mlc_RO2_3=0
	mlc_Frag=0
	mlc_RO_1=0
	mlc_RO_2=0
	mlc_RO_3=0
	
	//stores concentration or mlc number of each layer for past and current time steps only
	make/o/d/n=(2,totallayers+1)/Free temp_RH,temp_ROOH1,temp_ROOH2,temp_ROOH3,temp_ROH1,temp_ROH2,temp_ROH3,temp_Frag,temp_RO2_1,temp_RO2_2,temp_RO2_3,temp_RO_1,temp_RO_2,temp_RO_3
	temp_RH=kkWave[19]  //mlc/cm3-particle   don't use Corg_mlc_initial for all the layers because it is different
	temp_ROOH1=0
	temp_ROOH2=0
	temp_ROOH3=0  
	temp_ROH1=0
	temp_ROH2=0
	temp_ROH3=0
	temp_Frag=0
	temp_RO2_1=0
	temp_RO2_2=0
	temp_RO2_3=0
	temp_RO_1=0
	temp_RO_2=0
	temp_RO_3=0
	
	//stores change of mlc num in each layer for current time step
	make/o/d/n=(totallayers+1)/Free temp_dRH,temp_dROOH1,temp_dROOH2,temp_dROOH3,temp_dROH1,temp_dROH2,temp_dROH3,temp_dFragment,temp_dRO2_1,temp_dRO2_2,temp_dRO2_3,temp_dRO_1,temp_dRO_2,temp_dRO_3
	temp_dRH=0
	temp_dROOH1=0
	temp_dROOH2=0
	temp_dROOH3=0
	temp_dROH1=0
	temp_dROH2=0
	temp_dROH3=0
	temp_dFragment=0
	temp_dRO2_1=0
	temp_dRO2_2=0
	temp_dRO2_3=0
	temp_dRO_1=0
	temp_dRO_2=0
	temp_dRO_3=0
	//stores rate of change of each species at the start at every big time step
	make/o/d/n=(totaltimesteps,totallayers+1)/Free dRH,dROOH1,dROOH2,dROOH3,dROH1,dROH2,dROH3,dRO2_1,dRO2_2,dRO2_3,dFragment,dRO_1,dRO_2,dRO_3
	dRH=0
	dROOH1=0
	dROOH2=0
	dROOH3=0
	dROH1=0
	dROH2=0
	dROH3=0
	dRO2_1=0
	dRO2_2=0
	dRO2_3=0
	dFragment=0
	dRO_1=0
	dRO_2=0
	dRO_3=0
	make/o/d/n=(totaltimesteps) SL_dRO2HO2,SL_dRO2RO2,Bulkavg_dRO2RO2,SL_dRO2P,SL_dRO2Dif
	SL_dro2ho2=0
	SL_dro2ro2=0
	Bulkavg_dro2ro2=0
	SL_dRO2P=0
	SL_dRO2Dif=0
	make/o/d/n=(totaltimesteps) SL_dFragP,SL_dFragDif
	SL_dfragP=0
	SL_dFragDif=0
	
	//stores volume, outer surface area of each layer for current time step and volume for previous time step
	make/o/d/n=(totallayers+1)/Free layer_V,layer_outer_SA,layer_V_pre
	calculateLayerVolume(Dp,totallayers,SL_depth,layer_V)   //returns in unit cm3
	calculateLayerVolume(Dp,totallayers,SL_depth,layer_V_pre)   //returns in unit cm3
	calculateLayerouterSA(Dp,totallayers,SL_depth,layer_outer_SA)     //returns in unit cm2
	
	//stores change of mlc number that happens over redistribution of particle due to evaporation for current time step
	//layer 0 is the mlc added to a layer while layer1 is mlc removed from a layer
	make/o/d/n=(totaltimesteps,totallayers+1,2)/Free RH_redis,ROOH1_redis,ROOH2_redis,ROOH3_redis,ROH1_redis,ROH2_redis,ROH3_redis,RO2_1_redis,RO2_2_redis,RO2_3_redis,Frag_redis,RO_1_redis,RO_2_redis,RO_3_redis   //mlc
	RH_redis=0
	ROOH1_redis=0
	ROOH2_redis=0
	ROOH3_redis=0
	ROH1_redis=0
	ROH2_redis=0
	ROH3_redis=0
	RO2_1_redis=0
	RO2_2_redis=0
	RO2_3_redis=0
	frag_redis=0
	RO_1_redis=0
	RO_2_redis=0
	RO_2_redis=0
	
	//stores mlc added and removed for each layer at current time step only 
	make/o/d/n=(2,totallayers+1)/Free temp_RH_redis,temp_ROOH1_redis,temp_ROOH2_redis,temp_ROOH3_redis,temp_ROH1_redis,temp_ROH2_redis,temp_ROH3_redis,temp_RO2_1_redis,temp_RO2_2_redis,temp_RO2_3_redis,temp_Frag_redis,temp_RO_1_redis,temp_RO_2_redis,temp_RO_3_redis
	temp_RH_redis=0
	temp_ROOH1_redis=0
	temp_ROOH2_redis=0
	temp_ROOH3_redis=0
	temp_ROH1_redis=0
	temp_ROH2_redis=0
	temp_ROH3_redis=0
	temp_RO2_1_redis=0
	temp_RO2_2_redis=0
	temp_RO2_3_redis=0
	temp_Frag_redis=0
	temp_RO_1_redis=0
	temp_RO_2_redis=0
	temp_RO_3_redis=0
	
	//stores volume and outer surface area for each big time step for every layer
	make/o/d/n=(totaltimesteps,totallayers+1)/Free layer_V_t,layer_outerSA_t
	layer_V_t=0
	layer_outerSA_t=0
	
	//stores detailed mlc number change due to diffusion, chemical production and chemical loss in every layer at each big time step
	make/o/d/n=(totaltimesteps,totallayers+1,2)/Free dFrag_detail   //mlc
	dFrag_detail=0
	make/o/d/n=(totaltimesteps,totallayers+1,3)/Free dRH_detail
	make/o/d/n=(totaltimesteps,totallayers+1,4)/Free dROOH1_detail,dROOH2_detail,dROOH3_detail
	make/o/d/n=(totaltimesteps,totallayers+1,5)/Free dROH1_detail,dROH2_detail,dROH3_detail   //mlc
	dRH_detail=0
	dROOH1_detail=0
	dROOH2_detail=0
	dROOH3_detail=0
	dROH1_detail=0
	dROH2_detail=0
	dROH3_detail=0
	make/o/d/n=(totaltimesteps,totallayers+1,5)/Free dRO2_1_detail,dRO2_2_detail,dRO2_3_detail
	make/o/d/n=(totaltimesteps,totallayers+1,4)/Free dRO_1_detail,dRO_2_detail,dRO_3_detail     //mlc
	dRO2_1_detail=0
	dRO2_2_detail=0
	dRO2_3_detail=0
	dRO_1_detail=0
	dRO_2_detail=0
	dRO_3_detail=0
	
	make/o/d/n=(totaltimesteps)/Free SL_Frag
	SL_frag=0
	
	//stores VFR etc 
	make/o/d/n=(totaltimesteps) VFR_38s,timewave,NewDp,ratio_HO2_RO2,Evaporation
	VFR_38s=1
	timewave=x*flowtime/(kkwave[9]-1)
	NewDp[0]=Dp
	ratio_HO2_RO2=0
	Evaporation=0
	make/o/d/n=2/Free temp_Dp,temp_VFR
	temp_Dp=Dp
	temp_VFR=1
	
	//stores bulk averaged conc of each species at each big timestep
	make/o/d/n=(totaltimesteps,13) FinalConc  // Stores averaged concentration of each species in the order of RH, RO_1-3,ROOH1-3, ROH1-3, RO2_1-3
	make/o/d/n=(totallayers+1)/Free temp_sum_mlc
	variable initialV=Dp^3*pi/6*1e-21  //cm3  
	
	//stores the surface layer concentration and bulk averaged concentration of RO2
	make/o/d/n=(totaltimesteps) SL_RO2, Bulkavg_RO2   //mlc/cm3
	SL_ro2=0
	bulkavg_RO2=0
	
	variable f_RH,f_ROOH1,f_ROOH2,f_ROOH3,f_ROH1,f_ROH2,f_ROH3,f_RO2_1,f_RO2_2,f_RO2_3,f_RO_1,f_RO_2,f_RO_3
	f_RH=1
	f_ROOH1=0
	f_ROOH2=0
	f_ROOH3=0
	f_ROH1=0
	f_ROH2=0
	f_ROH3=0
	f_RO2_1=0
	f_RO2_2=0
	f_RO2_3=0
	f_RO_1=0
	f_RO_2=0
	f_RO_3=0
	//stores fraction of every species in the surface layer at each big time step
	make/o/d/n=(totaltimesteps,14) Fraction_Matrix
	fraction_matrix[][0]=1    //fraction of RH
	fraction_matrix[][1]=0    //fraction of ROOH1
	fraction_matrix[][2]=0    //fraction of ROOH2
	fraction_matrix[][3]=0    //fraction of ROOH3
	fraction_matrix[][4]=0    //fraction of ROH1
	fraction_matrix[][5]=0    //fraction of ROH2
	fraction_matrix[][6]=0    //fraction of ROH3
	fraction_matrix[][7]=0    //fraction of RO2_1
	fraction_matrix[][8]=0    //fraction of RO2_2
	fraction_matrix[][9]=0    //fraction of RO2_3
	fraction_matrix[][10]=0	//fraction of RO_1
	fraction_matrix[][11]=0	//fraction of RO_2
	fraction_matrix[][12]=0	//fraction of RO_3
	fraction_matrix[][13]=0  //fraction of Frag?
	
	variable i_time,i_layer,j_time
	variable layer_r,SL_sum
	variable temp_dRO2sum, temp_ratio
	make/o/d/n=(totallayers+1)/Free volume_removed,volume_added
	temp_ratio=0
	temp_dRO2sum=0
	volume_removed=0
	volume_added=0
	
	variable temp_sum_ro2,temp_sum_layerV
	temp_sum_ro2=0
	temp_sum_layerV=0
	
	for(i_time=0;i_time<totaltimesteps;i_time+=1)
		NewDp[i_time]=temp_Dp[0]   //nm
		VFR_38s[i_time]=temp_VFR[0]
		ratio_HO2_RO2[i_time]=temp_ratio
			fraction_matrix[i_time][0]=f_RH    //fraction of RH
			fraction_matrix[i_time][1]=f_ROOH1    //fraction of ROOH1
			fraction_matrix[i_time][2]=f_ROOH2    //fraction of ROOH2
			fraction_matrix[i_time][3]=f_ROOH3    //fraction of ROOH3
			fraction_matrix[i_time][4]=f_ROH1   //fraction of ROH1
			fraction_matrix[i_time][5]=f_ROH2    //fraction of ROH2
			fraction_matrix[i_time][6]=f_ROH3    //fraction of ROH3
			fraction_matrix[i_time][7]=f_RO2_1    //fraction of RO2_1
			fraction_matrix[i_time][8]=f_RO2_2    //fraction of RO2_2
			fraction_matrix[i_time][9]=f_RO2_3    //fraction of RO2_3
			fraction_matrix[i_time][10]=f_RO_1
			fraction_matrix[i_time][11]=f_RO_2
			fraction_matrix[i_time][12]=f_RO_3
			fraction_matrix[i_time][13]=0  //fraction of Frag?
		SL_RO2[i_time]=temp_RO2_1[1][0]+temp_RO2_2[1][0]+temp_RO2_3[1][0]
		//calculate the bulk averaged RO2  concentration
		temp_sum_ro2=0
		temp_sum_layerv=0
		for(i_layer=1;i_layer<=totallayers;i_layer+=1)
			temp_sum_RO2+=(temp_RO2_1[1][i_layer]+temp_RO2_2[1][i_layer]+temp_RO2_3[1][i_layer])*layer_V[i_layer]   //mlc
			temp_sum_layerV+=layer_V[i_layer]   //cm3
		endfor
		Bulkavg_RO2[i_time]=temp_sum_RO2/temp_sum_layerV
		//Record down concentrations etc at each big time step
		for(i_layer=0;i_layer<=totallayers;i_layer+=1)
			C_RH[i_time][i_layer]=temp_RH[1][i_layer]
			C_Frag[i_time][i_layer]=temp_Frag[1][i_layer]
			C_ROOH1[i_time][i_layer]=temp_ROOH1[1][i_layer]
			C_ROOH2[i_time][i_layer]=temp_ROOH2[1][i_layer]
			C_ROOH3[i_time][i_layer]=temp_ROOH3[1][i_layer]
			C_ROH1[i_time][i_layer]=temp_ROH1[1][i_layer]
			C_ROH2[i_time][i_layer]=temp_ROH2[1][i_layer]
			C_ROH3[i_time][i_layer]=temp_ROH3[1][i_layer]
			C_RO2_1[i_time][i_layer]=temp_RO2_1[1][i_layer]
			C_RO2_2[i_time][i_layer]=temp_RO2_2[1][i_layer]
			C_RO2_3[i_time][i_layer]=temp_RO2_3[1][i_layer]
			C_RO_1[i_time][i_layer]=temp_RO_1[1][i_layer]
			C_RO_2[i_time][i_layer]=temp_RO_2[1][i_layer]
			C_RO_3[i_time][i_layer]=temp_RO_3[1][i_layer]
			mlc_RH[i_time][i_layer]=temp_RH[1][i_layer]*layer_V[i_layer]
			mlc_Frag[i_time][i_layer]=temp_Frag[1][i_layer]*layer_V[i_layer]
			mlc_ROOH1[i_time][i_layer]=temp_ROOH1[1][i_layer]*layer_V[i_layer]
			mlc_ROOH2[i_time][i_layer]=temp_ROOH2[1][i_layer]*layer_V[i_layer]
			mlc_ROOH3[i_time][i_layer]=temp_ROOH3[1][i_layer]*layer_V[i_layer]
			mlc_ROH1[i_time][i_layer]=temp_ROH1[1][i_layer]*layer_V[i_layer]
			mlc_ROH2[i_time][i_layer]=temp_ROH2[1][i_layer]*layer_V[i_layer]
			mlc_ROH3[i_time][i_layer]=temp_ROH3[1][i_layer]*layer_V[i_layer]
			mlc_RO2_1[i_time][i_layer]=temp_RO2_1[1][i_layer]*layer_V[i_layer]
			mlc_RO2_2[i_time][i_layer]=temp_RO2_2[1][i_layer]*layer_V[i_layer]
			mlc_RO2_3[i_time][i_layer]=temp_RO2_3[1][i_layer]*layer_V[i_layer]
			mlc_RO_1[i_time][i_layer]=temp_RO_1[1][i_layer]*layer_V[i_layer]
			mlc_RO_2[i_time][i_layer]=temp_RO_2[1][i_layer]*layer_V[i_layer]
			mlc_RO_3[i_time][i_layer]=temp_RO_3[1][i_layer]*layer_V[i_layer]
			layer_v_t[i_time][i_layer]=layer_v[i_layer]
			layer_outerSA_t[i_time][i_layer]=layer_outer_SA[i_layer]
			RH_redis[i_time][i_layer][0]=temp_RH_redis[0][i_layer]
			ROOH1_redis[i_time][i_layer][0]=temp_ROOH1_redis[0][i_layer]
			ROOH2_redis[i_time][i_layer][0]=temp_ROOH2_redis[0][i_layer]
			ROOH3_redis[i_time][i_layer][0]=temp_ROOH3_redis[0][i_layer]
			ROH1_redis[i_time][i_layer][0]=temp_ROH1_redis[0][i_layer]
			ROH2_redis[i_time][i_layer][0]=temp_ROH2_redis[0][i_layer]
			ROH3_redis[i_time][i_layer][0]=temp_ROH3_redis[0][i_layer]
			RO2_1_redis[i_time][i_layer][0]=temp_RO2_1_redis[0][i_layer]
			RO2_2_redis[i_time][i_layer][0]=temp_RO2_2_redis[0][i_layer]
			RO2_3_redis[i_time][i_layer][0]=temp_RO2_3_redis[0][i_layer]
			RO_1_redis[i_time][i_layer][0]=temp_RO_1_redis[0][i_layer]
			RO_2_redis[i_time][i_layer][0]=temp_RO_2_redis[0][i_layer]
			RO_3_redis[i_time][i_layer][0]=temp_RO_3_redis[0][i_layer]
			Frag_redis[i_time][i_layer][0]=temp_Frag_redis[0][i_layer]
			RH_redis[i_time][i_layer][1]=temp_RH_redis[1][i_layer]
			ROOH1_redis[i_time][i_layer][1]=temp_ROOH1_redis[1][i_layer]
			ROOH2_redis[i_time][i_layer][1]=temp_ROOH2_redis[1][i_layer]
			ROOH3_redis[i_time][i_layer][1]=temp_ROOH3_redis[1][i_layer]
			ROH1_redis[i_time][i_layer][1]=temp_ROH1_redis[1][i_layer]
			ROH2_redis[i_time][i_layer][1]=temp_ROH2_redis[1][i_layer]
			ROH3_redis[i_time][i_layer][1]=temp_ROH3_redis[1][i_layer]
			RO2_1_redis[i_time][i_layer][1]=temp_RO2_1_redis[1][i_layer]
			RO2_2_redis[i_time][i_layer][1]=temp_RO2_2_redis[1][i_layer]
			RO2_3_redis[i_time][i_layer][1]=temp_RO2_3_redis[1][i_layer]
			RO_1_redis[i_time][i_layer][1]=temp_RO_1_redis[1][i_layer]
			RO_2_redis[i_time][i_layer][1]=temp_RO_2_redis[1][i_layer]
			RO_3_redis[i_time][i_layer][1]=temp_RO_3_redis[1][i_layer]
			Frag_redis[i_time][i_layer][1]=temp_Frag_redis[1][i_layer]
		endfor
		
		for(j_time=1;j_time<=stepnum;j_time+=1)
			//Calculate new layer depth based on diameter change
			layerdepth=(0.5*temp_Dp[0]-SL_depth)/totallayers   //nm
			if(layerdepth<0.4)
				//print "Decay too fast"
				//abort
			endif
			CalculateLayerVolume(temp_Dp[0],totallayers,SL_depth,layer_V)   //cm3
			CalculateLayerouterSA(temp_Dp[0],totallayers,SL_depth,layer_outer_SA)  //cm2
			//Calculate new OH and HO2 concentration near surface
			Kn_OH=6*0.21485e-4/609/1e-9/temp_Dp[0]   //dimensionless
			Fuchs_OH=(0.75+0.28*Kn_OH)/(Kn_OH*(1+Kn_OH))  //Maybe not Fuchs... From Shiraiwa et al. ACP 2010
			Crtf_OH=1/(1+uptake_OH*Fuchs_OH)  //Correction factor of the near surface concentration to the far away concentration
			OH_gs=OH_gas*Crtf_OH  //mlc/cm3-air
			Kn_HO2=6*0.25e-4/437/1e-9/temp_Dp[0]   //dimensionless
			Fuchs_HO2=(0.75+0.28*Kn_HO2)/(Kn_HO2*(1+Kn_HO2))  //Maybe not Fuchs... From Shiraiwa et al. ACP 2010
			Crtf_HO2=1/(1+uptake_HO2*Fuchs_HO2)  //Correction factor of the near surface concentration to the far away concentration
			HO2_gs=HO2_gas*Crtf_HO2 //mlc/cm3-air
			
			for(i_layer=0;i_layer<=totallayers;i_layer+=1)
				temp_RH[0][i_layer]=temp_RH[1][i_layer]//mlc/cm3
				temp_ROOH1[0][i_layer]=temp_ROOH1[1][i_layer]
				temp_ROOH2[0][i_layer]=temp_ROOH2[1][i_layer]
				temp_ROOH3[0][i_layer]=temp_ROOH3[1][i_layer]
				temp_ROH1[0][i_layer]=temp_ROH1[1][i_layer]
				temp_ROH2[0][i_layer]=temp_ROH2[1][i_layer]
				temp_ROH3[0][i_layer]=temp_ROH3[1][i_layer]
				temp_RO2_1[0][i_layer]=temp_RO2_1[1][i_layer]
				temp_RO2_2[0][i_layer]=temp_RO2_2[1][i_layer]
				temp_RO2_3[0][i_layer]=temp_RO2_3[1][i_layer]
				temp_RO_1[0][i_layer]=temp_RO_1[1][i_layer]
				temp_RO_2[0][i_layer]=temp_RO_2[1][i_layer]
				temp_RO_3[0][i_layer]=temp_RO_3[1][i_layer]
				temp_Frag[0][i_layer]=temp_Frag[1][i_layer]
			endfor
			temp_dRO2sum=0
			SL_sum=temp_RH[0][0]+temp_ROOH1[0][0]+temp_ROOH2[0][0]+temp_ROOH3[0][0]+temp_ROH1[0][0]+temp_ROH2[0][0]+temp_ROH3[0][0]+temp_RO2_1[0][0]+temp_RO2_2[0][0]+temp_RO2_3[0][0]+temp_RO_1[0][0]+temp_RO_2[0][0]+temp_RO_3[0][0]+0.5*temp_frag[0][0]
			if(SL_sum!=0)
				f_RH=temp_RH[0][0]/SL_sum
				f_ROOH1=temp_ROOH1[0][0]/SL_sum
				f_ROOH2=temp_ROOH2[0][0]/SL_sum
				f_ROOH3=temp_ROOH3[0][0]/SL_sum
				f_ROH1=temp_ROH1[0][0]/SL_sum
				f_ROH2=temp_ROH2[0][0]/SL_sum
				f_ROH3=temp_ROH3[0][0]/SL_sum
				f_RO2_1=temp_RO2_1[0][0]/SL_sum
				f_RO2_2=temp_RO2_2[0][0]/SL_sum
				f_RO2_3=temp_RO2_3[0][0]/SL_sum
				f_RO_1=temp_RO_1[0][0]/SL_sum
				f_RO_2=temp_RO_1[0][0]/SL_sum
				f_RO_3=temp_RO_1[0][0]/SL_sum
			else
				f_RH=0
				f_ROOH1=0
				f_ROOH2=0
				f_ROOH3=0
				f_ROH1=0
				f_ROH2=0
				f_ROH3=0
				f_RO2_1=0
				f_RO2_2=0
				f_RO2_3=0
				f_RO_1=0
				f_RO_2=0
				f_RO_3=0
			endif
			//print sl_sum,f_rh
			//This loop calculates change of concentration in term of mlc for every species in every layer at a specific time step
			for(i_layer=0;i_layer<=totallayers;i_layer+=1)
				//calculate production and loss rate in term of mlc/s for each layer
				if(i_layer==0)
					dRH_detail[i_time][0][0]=-8*Dorg*temp_RH[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_RH[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))  //mlc/s, 1e4*1e7=1e11 conversion from m2/nm to cm
					dRH_detail[i_time][0][1]=-uptake_OH*f_RH*6e4*OH_gs*layer_outer_SA[0]/4    //mlc/s
					dRH_detail[i_time][0][2]=(-kk_1*temp_RH[0][0]*temp_RO_1[0][0]-kk_2*temp_RH[0][0]*temp_RO_2[0][0]-kk_3*temp_RH[0][0]*temp_RO_3[0][0])*layer_V[0]
					dFrag_detail[i_time][0][0]=-8*DFrag*temp_Frag[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*DFrag*temp_Frag[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dFrag_detail[i_time][0][1]=2*(kd1*temp_RO_1[0][0]+kd2*temp_RO_2[0][0]+kd3*temp_RO_3[0][0])*layer_V[0]
					dRO_1_detail[i_time][0][0]=-8*Dorg*temp_RO_1[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_RO_1[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dRO_1_detail[i_time][0][1]=k2*2*Prob1*temp_RO2_1[0][0]^2*layer_V[0]
					dRO_1_detail[i_time][0][2]=-kd1*temp_RO_1[0][0]*layer_V[0]
					dRO_1_detail[i_time][0][3]=-kk_1*temp_RO_1[0][0]*temp_RH[0][0]-kk_1*temp_RO_1[0][0]*temp_ROH1[0][0]-kk_1*temp_RO_1[0][0]*temp_ROH2[0][0]-kk_1*temp_RO_1[0][0]*temp_ROH3[0][0]
					dRO_1_detail[i_time][0][3]=dRO_1_detail[i_time][0][3]-kk_1*temp_RO_1[0][0]*temp_ROOH1[0][0]-kk_1*temp_RO_1[0][0]*temp_ROOH2[0][0]-kk_1*temp_RO_1[0][0]*temp_ROOH3[0][0]
					dRO_1_detail[i_time][0][3]*=layer_V[0]
					dRO_2_detail[i_time][0][0]=-8*Dorg*temp_RO_2[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_RO_2[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dRO_2_detail[i_time][0][1]=k7*2*Prob2*temp_RO2_2[0][0]^2*layer_V[0]+k6*2*Prob2*temp_RO2_1[0][0]*temp_RO2_2[0][0]*layer_V[0]//factor of 4 is because 2 RO2 react leads to 2 RO and if fragments, lead to 4 fragments
					dRO_2_detail[i_time][0][2]=-kd2*temp_RO_2[0][0]*layer_V[0]
					dRO_2_detail[i_time][0][3]=-kk_2*temp_RO_2[0][0]*temp_RH[0][0]-kk_2*temp_RO_2[0][0]*temp_ROH1[0][0]-kk_2*temp_RO_2[0][0]*temp_ROH2[0][0]-kk_2*temp_RO_2[0][0]*temp_ROH3[0][0]
					dRO_2_detail[i_time][0][3]=dRO_2_detail[i_time][0][3]-kk_2*temp_RO_2[0][0]*temp_ROOH1[0][0]-kk_2*temp_RO_2[0][0]*temp_ROOH2[0][0]-kk_2*temp_RO_2[0][0]*temp_ROOH3[0][0]
					dRO_2_detail[i_time][0][3]*=layer_V[0]
					dRO_3_detail[i_time][0][0]=-8*Dorg*temp_RO_3[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_RO_3[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dRO_3_detail[i_time][0][1]=k11*2*Prob3*temp_RO2_1[0][0]*temp_RO2_3[0][0]*layer_V[0]+k11*2*Prob3*temp_RO2_3[0][0]^2*layer_V[0]+k11*2*Prob3*temp_RO2_2[0][0]*temp_RO2_3[0][0]*layer_V[0]
					dRO_3_detail[i_time][0][2]=-kd3*temp_RO_3[0][0]*layer_V[0]
					dRO_3_detail[i_time][0][3]=-kk_3*temp_RO_3[0][0]*temp_RH[0][0]-kk_3*temp_RO_3[0][0]*temp_ROH1[0][0]-kk_3*temp_RO_3[0][0]*temp_ROH2[0][0]-kk_3*temp_RO_3[0][0]*temp_ROH3[0][0]
					dRO_3_detail[i_time][0][3]=dRO_3_detail[i_time][0][3]-kk_3*temp_RO_3[0][0]*temp_ROOH1[0][0]-kk_3*temp_RO_3[0][0]*temp_ROOH2[0][0]-kk_3*temp_RO_3[0][0]*temp_ROOH3[0][0]
					dRO_3_detail[i_time][0][3]*=layer_V[0]
					dROOH1_detail[i_time][0][0]=-8*Dorg*temp_ROOH1[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_ROOH1[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dROOH1_detail[i_time][0][1]=uptake_HO2*f_RO2_1*4.4e4*HO2_gs*layer_outer_SA[0]/4
					dROOH1_detail[i_time][0][2]=-uptake_OH*f_ROOH1*6e4*OH_gs*layer_outer_SA[0]/4
					dROOH1_detail[i_time][0][3]=(-kk_1*temp_RO_1[0][0]*temp_ROOH1[0][0]-kk_2*temp_RO_2[0][0]*temp_ROOH1[0][0]-kk_3*temp_RO_3[0][0]*temp_ROOH1[0][0])*layer_v[0]
					dROOH2_detail[i_time][0][0]=-8*Dorg*temp_ROOH2[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_ROOH2[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dROOH2_detail[i_time][0][1]=uptake_HO2*f_RO2_2*4.4e4*HO2_gs*layer_outer_SA[0]/4
					dROOH2_detail[i_time][0][2]=-uptake_OH*f_ROOH2*6e4*OH_gs*layer_outer_SA[0]/4
					dROOH2_detail[i_time][0][3]=(-kk_1*temp_RO_1[0][0]*temp_ROOH2[0][0]-kk_2*temp_RO_2[0][0]*temp_ROOH2[0][0]-kk_3*temp_RO_3[0][0]*temp_ROOH2[0][0])*layer_v[0]
					dROOH3_detail[i_time][0][0]=-8*Dorg*temp_ROOH3[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_ROOH3[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dROOH3_detail[i_time][0][1]=uptake_HO2*f_RO2_3*4.4e4*HO2_gs*layer_outer_SA[0]/4
					dROOH3_detail[i_time][0][2]=-uptake_OH*f_ROOH3*6e4*OH_gs*layer_outer_SA[0]/4
					dROOH3_detail[i_time][0][3]=(-kk_1*temp_RO_1[0][0]*temp_ROOH3[0][0]-kk_2*temp_RO_2[0][0]*temp_ROOH3[0][0]-kk_3*temp_RO_3[0][0]*temp_ROOH3[0][0])*layer_v[0]
					dROH1_detail[i_time][0][0]=-8*Dorg*temp_ROH1[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_ROH1[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dROH1_detail[i_time][0][1]=k2*2*(1-Prob1)*temp_RO2_1[0][0]^2*layer_V[0]
					dROH1_detail[i_time][0][2]=kk_1*temp_RO_1[0][0]*(temp_RH[0][0]+temp_ROH1[0][0]+temp_ROH2[0][0]+temp_ROH3[0][0]+temp_ROOH1[0][0]+temp_ROOH2[0][0]+temp_ROOH3[0][0])*layer_V[0]
					dROH1_detail[i_time][0][3]=-uptake_OH*f_ROH1*6e4*OH_gs*layer_outer_SA[0]/4
					dROH1_detail[i_time][0][4]=(-kk_1*temp_RO_1[0][0]*temp_ROH1[0][0]-kk_2*temp_RO_2[0][0]*temp_ROH1[0][0]-kk_3*temp_RO_3[0][0]*temp_ROH1[0][0])*layer_v[0]
					dROH2_detail[i_time][0][0]=-8*Dorg*temp_ROH2[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_ROH2[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dROH2_detail[i_time][0][1]=k7*2*(1-Prob2)*temp_RO2_2[0][0]^2*layer_V[0]+k6*2*(1-Prob2)*temp_RO2_2[0][0]*temp_RO2_1[0][0]*layer_V[0]
					dROH2_detail[i_time][0][2]=kk_2*temp_RO_2[0][0]*(temp_RH[0][0]+temp_ROH1[0][0]+temp_ROH2[0][0]+temp_ROH3[0][0]+temp_ROOH1[0][0]+temp_ROOH2[0][0]+temp_ROOH3[0][0])*layer_V[0]
					dROH2_detail[i_time][0][3]=-uptake_OH*f_ROH2*6e4*OH_gs*layer_outer_SA[0]/4
					dROH2_detail[i_time][0][4]=(-kk_1*temp_RO_1[0][0]*temp_ROH2[0][0]-kk_2*temp_RO_2[0][0]*temp_ROH2[0][0]-kk_3*temp_RO_3[0][0]*temp_ROH2[0][0])*layer_v[0]
					dROH3_detail[i_time][0][0]=-8*Dorg*temp_ROH3[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_ROH3[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dROH3_detail[i_time][0][1]=k11*2*(1-Prob3)*temp_RO2_3[0][0]^2*layer_V[0]+k11*2*(1-Prob3)*temp_RO2_1[0][0]*temp_RO2_3[0][0]*layer_V[0]+k11*2*(1-Prob3)*temp_RO2_2[0][0]*temp_RO2_3[0][0]*layer_V[0]
					dROH3_detail[i_time][0][2]=kk_3*temp_RO_3[0][0]*(temp_RH[0][0]+temp_ROH1[0][0]+temp_ROH2[0][0]+temp_ROH3[0][0]+temp_ROOH1[0][0]+temp_ROOH2[0][0]+temp_ROOH3[0][0])*layer_V[0]	
					dROH3_detail[i_time][0][3]=-uptake_OH*f_ROH3*6e4*OH_gs*layer_outer_SA[0]/4
					dROH3_detail[i_time][0][4]=(-kk_1*temp_RO_1[0][0]*temp_ROH3[0][0]-kk_2*temp_RO_2[0][0]*temp_ROH3[0][0]-kk_3*temp_RO_3[0][0]*temp_ROH3[0][0])*layer_v[0]
					dRO2_1_detail[i_time][0][0]=-8*Dorg*temp_RO2_1[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_RO2_1[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dRO2_1_detail[i_time][0][1]=(uptake_OH*f_RH*6e4*OH_gs/4+uptake_OH*f_ROOH1*6e4*OH_gs*bratio1/4)*layer_outer_SA[0]
					dRO2_1_detail[i_time][0][2]=(kk_1*temp_RH[0][0]*temp_RO_1[0][0]+kk_2*temp_RH[0][0]*temp_RO_2[0][0]+kk_3*temp_RH[0][0]*temp_RO_3[0][0])*layer_V[0]
					dRO2_1_detail[i_time][0][3]=-uptake_HO2*f_RO2_1*4.4e4*HO2_gs*layer_outer_SA[0]/4
					dRO2_1_detail[i_time][0][4]=-k2*2*temp_RO2_1[0][0]^2*layer_V[0]-k6*temp_RO2_1[0][0]*temp_RO2_2[0][0]*layer_V[0]-k11*temp_RO2_1[0][0]*temp_RO2_3[0][0]*layer_V[0]
					dRO2_2_detail[i_time][0][0]=-8*Dorg*temp_RO2_2[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_RO2_2[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dRO2_2_detail[i_time][0][1]=(uptake_OH*f_ROOH1*6e4*OH_gs*(1-bratio1)/4+uptake_OH*f_ROOH2*6e4*OH_gs*bratio2/4+uptake_OH*f_ROH1*6e4*OH_gs/4)*layer_outer_SA[0]
					dRO2_2_detail[i_time][0][2]=(kk_1*temp_RO_1[0][0]*temp_ROH1[0][0]+kk_2*temp_RO_2[0][0]*temp_ROH1[0][0]+kk_3*temp_RO_3[0][0]*temp_ROH1[0][0])*layer_V[0]
					dRO2_2_detail[i_time][0][2]+=(kk_1*temp_RO_1[0][0]*temp_ROOH1[0][0]+kk_2*temp_RO_2[0][0]*temp_ROOH1[0][0]+kk_3*temp_RO_3[0][0]*temp_ROOH1[0][0])*layer_V[0]
					dRO2_2_detail[i_time][0][3]=-uptake_HO2*f_RO2_2*4.4e4*HO2_gs*layer_outer_SA[0]/4
					dRO2_2_detail[i_time][0][4]=-k7*2*temp_RO2_2[0][0]^2*layer_V[0]-k6*temp_RO2_1[0][0]*temp_RO2_2[0][0]*layer_V[0]-k11*temp_RO2_2[0][0]*temp_RO2_3[0][0]*layer_V[0]
					dRO2_3_detail[i_time][0][0]=-8*Dorg*temp_RO2_3[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_RO2_3[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dRO2_3_detail[i_time][0][1]=(uptake_OH*f_ROOH2*6e4*OH_gs*(1-bratio2)/4+uptake_OH*f_ROOH3*6e4*OH_gs/4+uptake_OH*f_ROH2*6e4*OH_gs/4+uptake_OH*f_ROH3*6e4*OH_gs/4)*layer_outer_SA[0]
					dRO2_3_detail[i_time][0][2]=(kk_1*temp_RO_1[0][0]*temp_ROH2[0][0]+kk_1*temp_RO_1[0][0]*temp_ROH3[0][0])*layer_v[0]
					dRO2_3_detail[i_time][0][2]+=(kk_2*temp_RO_2[0][0]*temp_ROH2[0][0]+kk_2*temp_RO_2[0][0]*temp_ROH3[0][0])*layer_v[0]
					dRO2_3_detail[i_time][0][2]+=(kk_3*temp_RO_3[0][0]*temp_ROH2[0][0]+kk_3*temp_RO_3[0][0]*temp_ROH3[0][0])*layer_v[0]
					dRO2_3_detail[i_time][0][2]+=(kk_1*temp_RO_1[0][0]*temp_ROOH2[0][0]+kk_1*temp_RO_1[0][0]*temp_ROOH3[0][0])*layer_v[0]
					dRO2_3_detail[i_time][0][2]+=(kk_2*temp_RO_2[0][0]*temp_ROOH2[0][0]+kk_2*temp_RO_2[0][0]*temp_ROOH3[0][0])*layer_v[0]
					dRO2_3_detail[i_time][0][2]+=(kk_3*temp_RO_3[0][0]*temp_ROOH2[0][0]+kk_3*temp_RO_3[0][0]*temp_ROOH3[0][0])*layer_v[0]
					dRO2_3_detail[i_time][0][3]=-uptake_HO2*f_RO2_3*4.4e4*HO2_gs*layer_outer_SA[0]/4
					dRO2_3_detail[i_time][0][4]=-k11*2*temp_RO2_3[0][0]^2*layer_V[0]-k11*temp_RO2_1[0][0]*temp_RO2_3[0][0]*layer_V[0]-k11*temp_RO2_2[0][0]*temp_RO2_3[0][0]*layer_V[0]
				
				elseif(i_layer==1)  //the first layer near surface
					dRH_detail[i_time][i_layer][0]=8*Dorg*temp_RH[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_RH[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_RH[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RH[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRH_detail[i_time][i_layer][1]=0
					dRH_detail[i_time][i_layer][2]=(-kk_1*temp_RH[0][i_layer]*temp_RO_1[0][i_layer]-kk_2*temp_RH[0][i_layer]*temp_RO_2[0][i_layer]-kk_3*temp_RH[0][i_layer]*temp_RO_3[0][i_layer])*layer_V[i_layer]			
					dFrag_detail[i_time][i_layer][0]=8*Dfrag*temp_Frag[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dfrag*temp_Frag[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dfrag*temp_Frag[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dfrag*temp_Frag[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dFrag_detail[i_time][i_layer][1]=2*(kd1*temp_RO_1[0][i_layer]+kd2*temp_RO_2[0][i_layer]+kd3*temp_RO_3[0][i_layer])*layer_V[i_layer]
					dRO_1_detail[i_time][i_layer][0]=8*Dorg*temp_RO_1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_RO_1[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_RO_1[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RO_1[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRO_1_detail[i_time][i_layer][1]=k2*2*Prob1*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]
					dRO_1_detail[i_time][i_layer][2]=-kd1*temp_RO_1[0][i_layer]*layer_V[i_layer]
					dRO_1_detail[i_time][i_layer][3]=-kk_1*temp_RO_1[0][i_layer]*temp_RH[0][i_layer]-kk_1*temp_RO_1[0][i_layer]*temp_ROH1[0][i_layer]-kk_1*temp_RO_1[0][i_layer]*temp_ROH2[0][i_layer]-kk_1*temp_RO_1[0][i_layer]*temp_ROH3[0][i_layer]
					dRO_1_detail[i_time][i_layer][3]=dRO_1_detail[i_time][i_layer][3]-kk_1*temp_RO_1[0][i_layer]*temp_ROOH1[0][i_layer]-kk_1*temp_RO_1[0][i_layer]*temp_ROOH2[0][i_layer]-kk_1*temp_RO_1[0][i_layer]*temp_ROOH3[0][i_layer]
					dRO_1_detail[i_time][i_layer][3]*=layer_V[i_layer]
					dRO_2_detail[i_time][i_layer][0]=8*Dorg*temp_RO_2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_RO_2[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_RO_2[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RO_2[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth				
					dRO_2_detail[i_time][i_layer][1]=k7*2*Prob2*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]+k6*2*Prob2*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]//factor of 4 is because 2 RO2 react leads to 2 RO and if fragments, lead to 4 fragments
					dRO_2_detail[i_time][i_layer][2]=-kd2*temp_RO_2[0][i_layer]*layer_V[i_layer]
					dRO_2_detail[i_time][i_layer][3]=-kk_2*temp_RO_2[0][i_layer]*temp_RH[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROH1[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROH2[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROH3[0][i_layer]
					dRO_2_detail[i_time][i_layer][3]=dRO_2_detail[i_time][i_layer][3]-kk_2*temp_RO_2[0][i_layer]*temp_ROOH1[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROOH2[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROOH3[0][i_layer]
					dRO_2_detail[i_time][i_layer][3]*=layer_V[i_layer]
					dRO_3_detail[i_time][i_layer][0]=8*Dorg*temp_RO_3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_RO_3[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_RO_3[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RO_3[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth				
					dRO_3_detail[i_time][i_layer][1]=k11*2*Prob3*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]+k11*2*Prob3*temp_RO2_3[0][i_layer]^2*layer_V[i_layer]+k11*2*Prob3*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dRO_3_detail[i_time][i_layer][2]=-kd3*temp_RO_3[0][i_layer]*layer_V[i_layer]
					dRO_3_detail[i_time][i_layer][3]=-kk_3*temp_RO_3[0][i_layer]*temp_RH[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROH1[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROH2[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROH3[0][i_layer]
					dRO_3_detail[i_time][i_layer][3]=dRO_3_detail[i_time][i_layer][3]-kk_3*temp_RO_3[0][i_layer]*temp_ROOH1[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROOH2[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROOH3[0][i_layer]
					dRO_3_detail[i_time][i_layer][3]*=layer_V[i_layer]
					dROOH1_detail[i_time][i_layer][0]=8*Dorg*temp_ROOH1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_ROOH1[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_ROOH1[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROOH1[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROOH1_detail[i_time][i_layer][1]=0
					dROOH1_detail[i_time][i_layer][2]=0
					dROOH1_detail[i_time][i_layer][3]=(-kk_1*temp_RO_1[0][i_layer]*temp_ROOH1[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROOH1[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROOH1[0][i_layer])*layer_v[i_layer]
					dROOH2_detail[i_time][i_layer][0]=8*Dorg*temp_ROOH2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_ROOH2[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_ROOH2[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROOH2[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROOH2_detail[i_time][i_layer][1]=0
					dROOH2_detail[i_time][i_layer][2]=0
					dROOH2_detail[i_time][i_layer][3]=(-kk_1*temp_RO_1[0][i_layer]*temp_ROOH2[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROOH2[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROOH2[0][i_layer])*layer_v[i_layer]
					dROOH3_detail[i_time][i_layer][0]=8*Dorg*temp_ROOH3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_ROOH3[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_ROOH3[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROOH3[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROOH3_detail[i_time][i_layer][1]=0
					dROOH3_detail[i_time][i_layer][2]=0
					dROOH3_detail[i_time][i_layer][3]=(-kk_1*temp_RO_1[0][i_layer]*temp_ROOH3[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROOH3[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROOH3[0][i_layer])*layer_v[i_layer]					
					dROH1_detail[i_time][i_layer][0]=8*Dorg*temp_ROH1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_ROH1[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_ROH1[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROH1[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROH1_detail[i_time][i_layer][1]=k2*2*(1-Prob1)*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]
					dROH1_detail[i_time][i_layer][2]=kk_1*temp_RO_1[0][i_layer]*(temp_RH[0][i_layer]+temp_ROH1[0][i_layer]+temp_ROH2[0][i_layer]+temp_ROH3[0][i_layer]+temp_ROOH1[0][i_layer]+temp_ROOH2[0][i_layer]+temp_ROOH3[0][i_layer])*layer_V[i_layer]
					dROH1_detail[i_time][i_layer][3]=0
					dROH1_detail[i_time][i_layer][4]=(-kk_1*temp_RO_1[0][i_layer]*temp_ROH1[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROH1[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROH1[0][i_layer])*layer_v[i_layer]
					dROH2_detail[i_time][i_layer][0]=8*Dorg*temp_ROH2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_ROH2[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_ROH2[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROH2[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROH2_detail[i_time][i_layer][1]=k7*2*(1-Prob2)*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]+k6*2*(1-Prob2)*temp_RO2_2[0][i_layer]*temp_RO2_1[0][i_layer]*layer_V[i_layer]
					dROH2_detail[i_time][i_layer][2]=kk_2*temp_RO_2[0][i_layer]*(temp_RH[0][i_layer]+temp_ROH1[0][i_layer]+temp_ROH2[0][i_layer]+temp_ROH3[0][i_layer]+temp_ROOH1[0][i_layer]+temp_ROOH2[0][i_layer]+temp_ROOH3[0][i_layer])*layer_V[i_layer]
					dROH2_detail[i_time][i_layer][3]=0
					dROH2_detail[i_time][i_layer][4]=(-kk_1*temp_RO_1[0][i_layer]*temp_ROH2[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROH2[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROH2[0][i_layer])*layer_v[i_layer]
					dROH3_detail[i_time][i_layer][0]=8*Dorg*temp_ROH3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_ROH3[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_ROH3[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROH3[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROH3_detail[i_time][i_layer][1]=k11*2*(1-Prob3)*temp_RO2_3[0][i_layer]^2*layer_V[i_layer]+k11*2*(1-Prob3)*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]+k11*2*(1-Prob3)*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dROH3_detail[i_time][i_layer][2]=kk_3*temp_RO_3[0][i_layer]*(temp_RH[0][i_layer]+temp_ROH1[0][i_layer]+temp_ROH2[0][i_layer]+temp_ROH3[0][i_layer]+temp_ROOH1[0][i_layer]+temp_ROOH2[0][i_layer]+temp_ROOH3[0][i_layer])*layer_V[i_layer]	
					dROH3_detail[i_time][i_layer][3]=0
					dROH3_detail[i_time][i_layer][4]=(-kk_1*temp_RO_1[0][i_layer]*temp_ROH3[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROH3[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROH3[0][i_layer])*layer_v[i_layer]
					dRO2_1_detail[i_time][i_layer][0]=8*Dorg*temp_RO2_1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_RO2_1[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_RO2_1[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RO2_1[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRO2_1_detail[i_time][i_layer][1]=0
					dRO2_1_detail[i_time][i_layer][2]=(kk_1*temp_RH[0][i_layer]*temp_RO_1[0][i_layer]+kk_2*temp_RH[0][i_layer]*temp_RO_2[0][i_layer]+kk_3*temp_RH[0][i_layer]*temp_RO_3[0][i_layer])*layer_V[i_layer]
					dRO2_1_detail[i_time][i_layer][3]=0
					dRO2_1_detail[i_time][i_layer][4]=-k2*2*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]-k6*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dRO2_2_detail[i_time][i_layer][0]=8*Dorg*temp_RO2_2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_RO2_2[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_RO2_2[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RO2_2[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRO2_2_detail[i_time][i_layer][1]=0
					dRO2_2_detail[i_time][i_layer][2]=(kk_1*temp_RO_1[0][i_layer]*temp_ROH1[0][i_layer]+kk_2*temp_RO_2[0][i_layer]*temp_ROH1[0][i_layer]+kk_3*temp_RO_3[0][i_layer]*temp_ROH1[0][i_layer])*layer_V[i_layer]
					dRO2_2_detail[i_time][i_layer][2]+=(kk_1*temp_RO_1[0][i_layer]*temp_ROOH1[0][i_layer]+kk_2*temp_RO_2[0][i_layer]*temp_ROOH1[0][i_layer]+kk_3*temp_RO_3[0][i_layer]*temp_ROOH1[0][i_layer])*layer_V[i_layer]
					dRO2_2_detail[i_time][i_layer][3]=0
					dRO2_2_detail[i_time][i_layer][4]=-k7*2*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]-k6*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dRO2_3_detail[i_time][i_layer][0]=8*Dorg*temp_RO2_3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_RO2_3[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_RO2_3[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RO2_3[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRO2_3_detail[i_time][i_layer][1]=0
					dRO2_3_detail[i_time][i_layer][2]=(kk_1*temp_RO_1[0][i_layer]*temp_ROH2[0][i_layer]+kk_1*temp_RO_1[0][i_layer]*temp_ROH3[0][i_layer])*layer_v[i_layer]
					dRO2_3_detail[i_time][i_layer][2]+=(kk_2*temp_RO_2[0][i_layer]*temp_ROH2[0][i_layer]+kk_2*temp_RO_2[0][i_layer]*temp_ROH3[0][i_layer])*layer_v[i_layer]
					dRO2_3_detail[i_time][i_layer][2]+=(kk_3*temp_RO_3[0][i_layer]*temp_ROH2[0][i_layer]+kk_3*temp_RO_3[0][i_layer]*temp_ROH3[0][i_layer])*layer_v[i_layer]
					dRO2_3_detail[i_time][i_layer][2]+=(kk_1*temp_RO_1[0][i_layer]*temp_ROOH2[0][i_layer]+kk_1*temp_RO_1[0][i_layer]*temp_ROOH3[0][i_layer])*layer_v[i_layer]
					dRO2_3_detail[i_time][i_layer][2]+=(kk_2*temp_RO_2[0][i_layer]*temp_ROOH2[0][i_layer]+kk_2*temp_RO_2[0][i_layer]*temp_ROOH3[0][i_layer])*layer_v[i_layer]
					dRO2_3_detail[i_time][i_layer][2]+=(kk_3*temp_RO_3[0][i_layer]*temp_ROOH2[0][i_layer]+kk_3*temp_RO_3[0][i_layer]*temp_ROOH3[0][i_layer])*layer_v[i_layer]
					dRO2_3_detail[i_time][i_layer][3]=0
					dRO2_3_detail[i_time][i_layer][4]=-k11*2*temp_RO2_3[0][i_layer]^2*layer_V[i_layer]-k11*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]					
				elseif(i_layer==totallayers)   //center bulk of the particle
					dRH_detail[i_time][i_layer][0]=-4*Dorg*temp_RH[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RH[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dRH_detail[i_time][i_layer][1]=0   //no loss from RH+OH
					dRH_detail[i_time][i_layer][2]=(-kk_1*temp_RH[0][i_layer]*temp_RO_1[0][i_layer]-kk_2*temp_RH[0][i_layer]*temp_RO_2[0][i_layer]-kk_3*temp_RH[0][i_layer]*temp_RO_3[0][i_layer])*layer_V[i_layer]			
					dFrag_detail[i_time][i_layer][0]=-4*Dfrag*temp_Frag[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dfrag*temp_Frag[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dFrag_detail[i_time][i_layer][1]=2*(kd1*temp_RO_1[0][i_layer]+kd2*temp_RO_2[0][i_layer]+kd3*temp_RO_3[0][i_layer])*layer_V[i_layer]
					dRO_1_detail[i_time][i_layer][0]=-4*Dorg*temp_RO_1[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RO_1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dRO_1_detail[i_time][i_layer][1]=k2*2*Prob1*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]
					dRO_1_detail[i_time][i_layer][2]=-kd1*temp_RO_1[0][i_layer]*layer_V[i_layer]
					dRO_1_detail[i_time][i_layer][3]=-kk_1*temp_RO_1[0][i_layer]*temp_RH[0][i_layer]-kk_1*temp_RO_1[0][i_layer]*temp_ROH1[0][i_layer]-kk_1*temp_RO_1[0][i_layer]*temp_ROH2[0][i_layer]-kk_1*temp_RO_1[0][i_layer]*temp_ROH3[0][i_layer]
					dRO_1_detail[i_time][i_layer][3]=dRO_1_detail[i_time][i_layer][3]-kk_1*temp_RO_1[0][i_layer]*temp_ROOH1[0][i_layer]-kk_1*temp_RO_1[0][i_layer]*temp_ROOH2[0][i_layer]-kk_1*temp_RO_1[0][i_layer]*temp_ROOH3[0][i_layer]
					dRO_1_detail[i_time][i_layer][3]*=layer_V[i_layer]
					dRO_2_detail[i_time][i_layer][0]=-4*Dorg*temp_RO_2[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RO_2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dRO_2_detail[i_time][i_layer][1]=k7*2*Prob2*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]+k6*2*Prob2*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]//factor of 4 is because 2 RO2 react leads to 2 RO and if fragments, lead to 4 fragments
					dRO_2_detail[i_time][i_layer][2]=-kd2*temp_RO_2[0][i_layer]*layer_V[i_layer]
					dRO_2_detail[i_time][i_layer][3]=-kk_2*temp_RO_2[0][i_layer]*temp_RH[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROH1[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROH2[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROH3[0][i_layer]
					dRO_2_detail[i_time][i_layer][3]=dRO_2_detail[i_time][i_layer][3]-kk_2*temp_RO_2[0][i_layer]*temp_ROOH1[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROOH2[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROOH3[0][i_layer]
					dRO_2_detail[i_time][i_layer][3]*=layer_V[i_layer]
					dRO_3_detail[i_time][i_layer][0]=-4*Dorg*temp_RO_3[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RO_3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dRO_3_detail[i_time][i_layer][1]=k11*2*Prob3*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]+k11*2*Prob3*temp_RO2_3[0][i_layer]^2*layer_V[i_layer]+k11*2*Prob3*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dRO_3_detail[i_time][i_layer][2]=-kd3*temp_RO_3[0][i_layer]*layer_V[i_layer]
					dRO_3_detail[i_time][i_layer][3]=-kk_3*temp_RO_3[0][i_layer]*temp_RH[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROH1[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROH2[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROH3[0][i_layer]
					dRO_3_detail[i_time][i_layer][3]=dRO_3_detail[i_time][i_layer][3]-kk_3*temp_RO_3[0][i_layer]*temp_ROOH1[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROOH2[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROOH3[0][i_layer]
					dRO_3_detail[i_time][i_layer][3]*=layer_V[i_layer]
					dROOH1_detail[i_time][i_layer][0]=-4*Dorg*temp_ROOH1[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROOH1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dROOH1_detail[i_time][i_layer][1]=0    //no production from RO2+HO2 which happens only at surface
					dROOH1_detail[i_time][i_layer][2]=0    //no loss due to ROOH+OH
					dROOH1_detail[i_time][i_layer][3]=(-kk_1*temp_RO_1[0][i_layer]*temp_ROOH1[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROOH1[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROOH1[0][i_layer])*layer_v[i_layer]
					dROOH2_detail[i_time][i_layer][0]=-4*Dorg*temp_ROOH2[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROOH2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dROOH2_detail[i_time][i_layer][1]=0    //no production from RO2+HO2 which happens only at surface
					dROOH2_detail[i_time][i_layer][2]=0    //no loss due to ROOH+OH
					dROOH2_detail[i_time][i_layer][3]=(-kk_1*temp_RO_1[0][i_layer]*temp_ROOH2[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROOH2[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROOH2[0][i_layer])*layer_v[i_layer]
					dROOH3_detail[i_time][i_layer][0]=-4*Dorg*temp_ROOH3[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROOH3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dROOH3_detail[i_time][i_layer][1]=0    //no production from RO2+HO2 which happens only at surface
					dROOH3_detail[i_time][i_layer][2]=0    //no loss due to ROOH+OH
					dROOH3_detail[i_time][i_layer][3]=(-kk_1*temp_RO_1[0][i_layer]*temp_ROOH3[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROOH3[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROOH3[0][i_layer])*layer_v[i_layer]					
					dROH1_detail[i_time][i_layer][0]=-4*Dorg*temp_ROH1[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROH1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dROH1_detail[i_time][i_layer][1]=k2*2*(1-Prob1)*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]
					dROH1_detail[i_time][i_layer][2]=kk_1*temp_RO_1[0][i_layer]*(temp_RH[0][i_layer]+temp_ROH1[0][i_layer]+temp_ROH2[0][i_layer]+temp_ROH3[0][i_layer]+temp_ROOH1[0][i_layer]+temp_ROOH2[0][i_layer]+temp_ROOH3[0][i_layer])*layer_V[i_layer]
					dROH1_detail[i_time][i_layer][3]=0
					dROH1_detail[i_time][i_layer][4]=(-kk_1*temp_RO_1[0][i_layer]*temp_ROH1[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROH1[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROH1[0][i_layer])*layer_v[i_layer]
					dROH2_detail[i_time][i_layer][0]=-4*Dorg*temp_ROH2[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROH2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dROH2_detail[i_time][i_layer][1]=k7*2*(1-Prob2)*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]+k6*2*(1-Prob2)*temp_RO2_2[0][i_layer]*temp_RO2_1[0][i_layer]*layer_V[i_layer]
					dROH2_detail[i_time][i_layer][2]=kk_2*temp_RO_2[0][i_layer]*(temp_RH[0][i_layer]+temp_ROH1[0][i_layer]+temp_ROH2[0][i_layer]+temp_ROH3[0][i_layer]+temp_ROOH1[0][i_layer]+temp_ROOH2[0][i_layer]+temp_ROOH3[0][i_layer])*layer_V[i_layer]
					dROH2_detail[i_time][i_layer][3]=0
					dROH2_detail[i_time][i_layer][4]=(-kk_1*temp_RO_1[0][i_layer]*temp_ROH2[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROH2[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROH2[0][i_layer])*layer_v[i_layer]
					dROH3_detail[i_time][i_layer][0]=-4*Dorg*temp_ROH3[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROH3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dROH3_detail[i_time][i_layer][1]=k11*2*(1-Prob3)*temp_RO2_3[0][i_layer]^2*layer_V[i_layer]+k11*2*(1-Prob3)*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]+k11*2*(1-Prob3)*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dROH3_detail[i_time][i_layer][2]=kk_3*temp_RO_3[0][i_layer]*(temp_RH[0][i_layer]+temp_ROH1[0][i_layer]+temp_ROH2[0][i_layer]+temp_ROH3[0][i_layer]+temp_ROOH1[0][i_layer]+temp_ROOH2[0][i_layer]+temp_ROOH3[0][i_layer])*layer_V[i_layer]	
					dROH3_detail[i_time][i_layer][3]=0
					dROH3_detail[i_time][i_layer][4]=(-kk_1*temp_RO_1[0][i_layer]*temp_ROH3[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROH3[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROH3[0][i_layer])*layer_v[i_layer]
					dRO2_1_detail[i_time][i_layer][0]=-4*Dorg*temp_RO2_1[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RO2_1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dRO2_1_detail[i_time][i_layer][1]=0    // no production from org+OH
					dRO2_1_detail[i_time][i_layer][2]=(kk_1*temp_RH[0][i_layer]*temp_RO_1[0][i_layer]+kk_2*temp_RH[0][i_layer]*temp_RO_2[0][i_layer]+kk_3*temp_RH[0][i_layer]*temp_RO_3[0][i_layer])*layer_V[i_layer]
					dRO2_1_detail[i_time][i_layer][3]=0	//no loss due to RO2+HO2
					dRO2_1_detail[i_time][i_layer][4]=-k2*2*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]-k6*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dRO2_2_detail[i_time][i_layer][0]=-4*Dorg*temp_RO2_2[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RO2_2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dRO2_2_detail[i_time][i_layer][1]=0    // no production from org+OH
					dRO2_2_detail[i_time][i_layer][2]=(kk_1*temp_RO_1[0][i_layer]*temp_ROH1[0][i_layer]+kk_2*temp_RO_2[0][i_layer]*temp_ROH1[0][i_layer]+kk_3*temp_RO_3[0][i_layer]*temp_ROH1[0][i_layer])*layer_V[i_layer]
					dRO2_2_detail[i_time][i_layer][2]+=(kk_1*temp_RO_1[0][i_layer]*temp_ROOH1[0][i_layer]+kk_2*temp_RO_2[0][i_layer]*temp_ROOH1[0][i_layer]+kk_3*temp_RO_3[0][i_layer]*temp_ROOH1[0][i_layer])*layer_V[i_layer]
					dRO2_2_detail[i_time][i_layer][3]=0	//no loss due to RO2+HO2
					dRO2_2_detail[i_time][i_layer][4]=-k7*2*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]-k6*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dRO2_3_detail[i_time][i_layer][0]=-4*Dorg*temp_RO2_3[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RO2_3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dRO2_3_detail[i_time][i_layer][1]=0    // no production from org+OH
					dRO2_3_detail[i_time][i_layer][2]=(kk_1*temp_RO_1[0][i_layer]*temp_ROH2[0][i_layer]+kk_1*temp_RO_1[0][i_layer]*temp_ROH3[0][i_layer])*layer_v[i_layer]
					dRO2_3_detail[i_time][i_layer][2]+=(kk_2*temp_RO_2[0][i_layer]*temp_ROH2[0][i_layer]+kk_2*temp_RO_2[0][i_layer]*temp_ROH3[0][i_layer])*layer_v[i_layer]
					dRO2_3_detail[i_time][i_layer][2]+=(kk_3*temp_RO_3[0][i_layer]*temp_ROH2[0][i_layer]+kk_3*temp_RO_3[0][i_layer]*temp_ROH3[0][i_layer])*layer_v[i_layer]
					dRO2_3_detail[i_time][i_layer][2]+=(kk_1*temp_RO_1[0][i_layer]*temp_ROOH2[0][i_layer]+kk_1*temp_RO_1[0][i_layer]*temp_ROOH3[0][i_layer])*layer_v[i_layer]
					dRO2_3_detail[i_time][i_layer][2]+=(kk_2*temp_RO_2[0][i_layer]*temp_ROOH2[0][i_layer]+kk_2*temp_RO_2[0][i_layer]*temp_ROOH3[0][i_layer])*layer_v[i_layer]
					dRO2_3_detail[i_time][i_layer][2]+=(kk_3*temp_RO_3[0][i_layer]*temp_ROOH2[0][i_layer]+kk_3*temp_RO_3[0][i_layer]*temp_ROOH3[0][i_layer])*layer_v[i_layer]
					dRO2_3_detail[i_time][i_layer][3]=0	//no loss due to RO2+HO2
					dRO2_3_detail[i_time][i_layer][4]=-k11*2*temp_RO2_3[0][i_layer]^2*layer_V[i_layer]-k11*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]			
				else  //layers that are not surface nor center
					dRH_detail[i_time][i_layer][0]=-4*Dorg*temp_RH[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RH[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_RH[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RH[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRH_detail[i_time][i_layer][1]=0
					dRH_detail[i_time][i_layer][2]=(-kk_1*temp_RH[0][i_layer]*temp_RO_1[0][i_layer]-kk_2*temp_RH[0][i_layer]*temp_RO_2[0][i_layer]-kk_3*temp_RH[0][i_layer]*temp_RO_3[0][i_layer])*layer_V[i_layer]			
					dFrag_detail[i_time][i_layer][0]=-4*Dfrag*temp_Frag[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dfrag*temp_Frag[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dfrag*temp_Frag[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dfrag*temp_Frag[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dFrag_detail[i_time][i_layer][1]=2*(kd1*temp_RO_1[0][i_layer]+kd2*temp_RO_2[0][i_layer]+kd3*temp_RO_3[0][i_layer])*layer_V[i_layer]
					dRO_1_detail[i_time][i_layer][0]=-4*Dorg*temp_RO_1[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RO_1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_RO_1[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RO_1[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRO_1_detail[i_time][i_layer][1]=k2*2*Prob1*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]
					dRO_1_detail[i_time][i_layer][2]=-kd1*temp_RO_1[0][i_layer]*layer_V[i_layer]
					dRO_1_detail[i_time][i_layer][3]=-kk_1*temp_RO_1[0][i_layer]*temp_RH[0][i_layer]-kk_1*temp_RO_1[0][i_layer]*temp_ROH1[0][i_layer]-kk_1*temp_RO_1[0][i_layer]*temp_ROH2[0][i_layer]-kk_1*temp_RO_1[0][i_layer]*temp_ROH3[0][i_layer]
					dRO_1_detail[i_time][i_layer][3]=dRO_1_detail[i_time][i_layer][3]-kk_1*temp_RO_1[0][i_layer]*temp_ROOH1[0][i_layer]-kk_1*temp_RO_1[0][i_layer]*temp_ROOH2[0][i_layer]-kk_1*temp_RO_1[0][i_layer]*temp_ROOH3[0][i_layer]
					dRO_1_detail[i_time][i_layer][3]*=layer_V[i_layer]
					dRO_2_detail[i_time][i_layer][0]=-4*Dorg*temp_RO_2[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RO_2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_RO_2[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RO_2[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRO_2_detail[i_time][i_layer][1]=k7*2*Prob2*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]+k6*2*Prob2*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]//factor of 4 is because 2 RO2 react leads to 2 RO and if fragments, lead to 4 fragments
					dRO_2_detail[i_time][i_layer][2]=-kd2*temp_RO_2[0][i_layer]*layer_V[i_layer]
					dRO_2_detail[i_time][i_layer][3]=-kk_2*temp_RO_2[0][i_layer]*temp_RH[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROH1[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROH2[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROH3[0][i_layer]
					dRO_2_detail[i_time][i_layer][3]=dRO_2_detail[i_time][i_layer][3]-kk_2*temp_RO_2[0][i_layer]*temp_ROOH1[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROOH2[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROOH3[0][i_layer]
					dRO_2_detail[i_time][i_layer][3]*=layer_V[i_layer]
					dRO_3_detail[i_time][i_layer][0]=-4*Dorg*temp_RO_3[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RO_3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_RO_3[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RO_3[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRO_3_detail[i_time][i_layer][1]=k11*2*Prob3*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]+k11*2*Prob3*temp_RO2_3[0][i_layer]^2*layer_V[i_layer]+k11*2*Prob3*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dRO_3_detail[i_time][i_layer][2]=-kd3*temp_RO_3[0][i_layer]*layer_V[i_layer]
					dRO_3_detail[i_time][i_layer][3]=-kk_3*temp_RO_3[0][i_layer]*temp_RH[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROH1[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROH2[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROH3[0][i_layer]
					dRO_3_detail[i_time][i_layer][3]=dRO_3_detail[i_time][i_layer][3]-kk_3*temp_RO_3[0][i_layer]*temp_ROOH1[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROOH2[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROOH3[0][i_layer]
					dRO_3_detail[i_time][i_layer][3]*=layer_V[i_layer]
					dROOH1_detail[i_time][i_layer][0]=-4*Dorg*temp_ROOH1[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROOH1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_ROOH1[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROOH1[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROOH1_detail[i_time][i_layer][1]=0
					dROOH1_detail[i_time][i_layer][2]=0
					dROOH1_detail[i_time][i_layer][3]=(-kk_1*temp_RO_1[0][i_layer]*temp_ROOH1[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROOH1[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROOH1[0][i_layer])*layer_v[i_layer]
					dROOH2_detail[i_time][i_layer][0]=-4*Dorg*temp_ROOH2[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROOH2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_ROOH2[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROOH2[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROOH2_detail[i_time][i_layer][1]=0
					dROOH2_detail[i_time][i_layer][2]=0
					dROOH2_detail[i_time][i_layer][3]=(-kk_1*temp_RO_1[0][i_layer]*temp_ROOH2[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROOH2[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROOH2[0][i_layer])*layer_v[i_layer]
					dROOH3_detail[i_time][i_layer][0]=-4*Dorg*temp_ROOH3[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROOH3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_ROOH3[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROOH3[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROOH3_detail[i_time][i_layer][1]=0
					dROOH3_detail[i_time][i_layer][2]=0
					dROOH3_detail[i_time][i_layer][3]=(-kk_1*temp_RO_1[0][i_layer]*temp_ROOH3[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROOH3[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROOH3[0][i_layer])*layer_v[i_layer]					
					dROH1_detail[i_time][i_layer][0]=-4*Dorg*temp_ROH1[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROH1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_ROH1[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROH1[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROH1_detail[i_time][i_layer][1]=k2*2*(1-Prob1)*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]
					dROH1_detail[i_time][i_layer][2]=kk_1*temp_RO_1[0][i_layer]*(temp_RH[0][i_layer]+temp_ROH1[0][i_layer]+temp_ROH2[0][i_layer]+temp_ROH3[0][i_layer]+temp_ROOH1[0][i_layer]+temp_ROOH2[0][i_layer]+temp_ROOH3[0][i_layer])*layer_V[i_layer]
					dROH1_detail[i_time][i_layer][3]=0
					dROH1_detail[i_time][i_layer][4]=(-kk_1*temp_RO_1[0][i_layer]*temp_ROH1[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROH1[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROH1[0][i_layer])*layer_v[i_layer]
					dROH2_detail[i_time][i_layer][0]=-4*Dorg*temp_ROH2[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROH2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_ROH2[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROH2[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROH2_detail[i_time][i_layer][1]=k7*2*(1-Prob2)*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]+k6*2*(1-Prob2)*temp_RO2_2[0][i_layer]*temp_RO2_1[0][i_layer]*layer_V[i_layer]
					dROH2_detail[i_time][i_layer][2]=kk_2*temp_RO_2[0][i_layer]*(temp_RH[0][i_layer]+temp_ROH1[0][i_layer]+temp_ROH2[0][i_layer]+temp_ROH3[0][i_layer]+temp_ROOH1[0][i_layer]+temp_ROOH2[0][i_layer]+temp_ROOH3[0][i_layer])*layer_V[i_layer]
					dROH2_detail[i_time][i_layer][3]=0
					dROH2_detail[i_time][i_layer][4]=(-kk_1*temp_RO_1[0][i_layer]*temp_ROH2[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROH2[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROH2[0][i_layer])*layer_v[i_layer]
					dROH3_detail[i_time][i_layer][0]=-4*Dorg*temp_ROH3[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROH3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_ROH3[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROH3[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROH3_detail[i_time][i_layer][1]=k11*2*(1-Prob3)*temp_RO2_3[0][i_layer]^2*layer_V[i_layer]+k11*2*(1-Prob3)*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]+k11*2*(1-Prob3)*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dROH3_detail[i_time][i_layer][2]=kk_3*temp_RO_3[0][i_layer]*(temp_RH[0][i_layer]+temp_ROH1[0][i_layer]+temp_ROH2[0][i_layer]+temp_ROH3[0][i_layer]+temp_ROOH1[0][i_layer]+temp_ROOH2[0][i_layer]+temp_ROOH3[0][i_layer])*layer_V[i_layer]	
					dROH3_detail[i_time][i_layer][3]=0
					dROH3_detail[i_time][i_layer][4]=(-kk_1*temp_RO_1[0][i_layer]*temp_ROH3[0][i_layer]-kk_2*temp_RO_2[0][i_layer]*temp_ROH3[0][i_layer]-kk_3*temp_RO_3[0][i_layer]*temp_ROH3[0][i_layer])*layer_v[i_layer]
					dRO2_1_detail[i_time][i_layer][0]=-4*Dorg*temp_RO2_1[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RO2_1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_RO2_1[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RO2_1[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRO2_1_detail[i_time][i_layer][1]=0
					dRO2_1_detail[i_time][i_layer][2]=(kk_1*temp_RH[0][i_layer]*temp_RO_1[0][i_layer]+kk_2*temp_RH[0][i_layer]*temp_RO_2[0][i_layer]+kk_3*temp_RH[0][i_layer]*temp_RO_3[0][i_layer])*layer_V[i_layer]
					dRO2_1_detail[i_time][i_layer][3]=0
					dRO2_1_detail[i_time][i_layer][4]=-k2*2*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]-k6*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dRO2_2_detail[i_time][i_layer][0]=-4*Dorg*temp_RO2_2[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RO2_2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_RO2_2[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RO2_2[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRO2_2_detail[i_time][i_layer][1]=0
					dRO2_2_detail[i_time][i_layer][2]=(kk_1*temp_RO_1[0][i_layer]*temp_ROH1[0][i_layer]+kk_2*temp_RO_2[0][i_layer]*temp_ROH1[0][i_layer]+kk_3*temp_RO_3[0][i_layer]*temp_ROH1[0][i_layer])*layer_V[i_layer]
					dRO2_2_detail[i_time][i_layer][2]+=(kk_1*temp_RO_1[0][i_layer]*temp_ROOH1[0][i_layer]+kk_2*temp_RO_2[0][i_layer]*temp_ROOH1[0][i_layer]+kk_3*temp_RO_3[0][i_layer]*temp_ROOH1[0][i_layer])*layer_V[i_layer]
					dRO2_2_detail[i_time][i_layer][3]=0
					dRO2_2_detail[i_time][i_layer][4]=-k7*2*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]-k6*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dRO2_3_detail[i_time][i_layer][0]=-4*Dorg*temp_RO2_3[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RO2_3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_RO2_3[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RO2_3[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRO2_3_detail[i_time][i_layer][1]=0
					dRO2_3_detail[i_time][i_layer][2]=(kk_1*temp_RO_1[0][i_layer]*temp_ROH2[0][i_layer]+kk_1*temp_RO_1[0][i_layer]*temp_ROH3[0][i_layer])*layer_v[i_layer]
					dRO2_3_detail[i_time][i_layer][2]+=(kk_2*temp_RO_2[0][i_layer]*temp_ROH2[0][i_layer]+kk_2*temp_RO_2[0][i_layer]*temp_ROH3[0][i_layer])*layer_v[i_layer]
					dRO2_3_detail[i_time][i_layer][2]+=(kk_3*temp_RO_3[0][i_layer]*temp_ROH2[0][i_layer]+kk_3*temp_RO_3[0][i_layer]*temp_ROH3[0][i_layer])*layer_v[i_layer]
					dRO2_3_detail[i_time][i_layer][2]+=(kk_1*temp_RO_1[0][i_layer]*temp_ROOH2[0][i_layer]+kk_1*temp_RO_1[0][i_layer]*temp_ROOH3[0][i_layer])*layer_v[i_layer]
					dRO2_3_detail[i_time][i_layer][2]+=(kk_2*temp_RO_2[0][i_layer]*temp_ROOH2[0][i_layer]+kk_2*temp_RO_2[0][i_layer]*temp_ROOH3[0][i_layer])*layer_v[i_layer]
					dRO2_3_detail[i_time][i_layer][2]+=(kk_3*temp_RO_3[0][i_layer]*temp_ROOH2[0][i_layer]+kk_3*temp_RO_3[0][i_layer]*temp_ROOH3[0][i_layer])*layer_v[i_layer]
					dRO2_3_detail[i_time][i_layer][3]=0
					dRO2_3_detail[i_time][i_layer][4]=-k11*2*temp_RO2_3[0][i_layer]^2*layer_V[i_layer]-k11*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]	
				endif
					dRH_detail[i_time][i_layer][0]*=smallest_timestep   //mlc
					dRH_detail[i_time][i_layer][1]*=smallest_timestep
					dRH_detail[i_time][i_layer][2]*=smallest_timestep
					dFrag_detail[i_time][i_layer][0]*=smallest_timestep
					dFrag_detail[i_time][i_layer][1]*=smallest_timestep
					dRO_1_detail[i_time][i_layer][0]*=smallest_timestep
					dRO_1_detail[i_time][i_layer][1]*=smallest_timestep
					dRO_1_detail[i_time][i_layer][2]*=smallest_timestep
					dRO_1_detail[i_time][i_layer][3]*=smallest_timestep
					dRO_2_detail[i_time][i_layer][0]*=smallest_timestep
					dRO_2_detail[i_time][i_layer][1]*=smallest_timestep
					dRO_2_detail[i_time][i_layer][2]*=smallest_timestep
					dRO_2_detail[i_time][i_layer][3]*=smallest_timestep
					dRO_3_detail[i_time][i_layer][0]*=smallest_timestep
					dRO_3_detail[i_time][i_layer][1]*=smallest_timestep
					dRO_3_detail[i_time][i_layer][2]*=smallest_timestep
					dRO_3_detail[i_time][i_layer][3]*=smallest_timestep
					dROOH1_detail[i_time][i_layer][0]*=smallest_timestep
					dROOH1_detail[i_time][i_layer][1]*=smallest_timestep
					dROOH1_detail[i_time][i_layer][2]*=smallest_timestep
					dROOH1_detail[i_time][i_layer][3]*=smallest_timestep
					dROOH2_detail[i_time][i_layer][0]*=smallest_timestep
					dROOH2_detail[i_time][i_layer][1]*=smallest_timestep
					dROOH2_detail[i_time][i_layer][2]*=smallest_timestep
					dROOH2_detail[i_time][i_layer][3]*=smallest_timestep
					dROOH3_detail[i_time][i_layer][0]*=smallest_timestep
					dROOH3_detail[i_time][i_layer][1]*=smallest_timestep
					dROOH3_detail[i_time][i_layer][2]*=smallest_timestep
					dROOH3_detail[i_time][i_layer][3]*=smallest_timestep
					dROH1_detail[i_time][i_layer][0]*=smallest_timestep
					dROH1_detail[i_time][i_layer][1]*=smallest_timestep
					dROH1_detail[i_time][i_layer][2]*=smallest_timestep
					dROH1_detail[i_time][i_layer][3]*=smallest_timestep
					dROH1_detail[i_time][i_layer][4]*=smallest_timestep
					dROH2_detail[i_time][i_layer][0]*=smallest_timestep
					dROH2_detail[i_time][i_layer][1]*=smallest_timestep
					dROH2_detail[i_time][i_layer][2]*=smallest_timestep
					dROH2_detail[i_time][i_layer][3]*=smallest_timestep
					dROH2_detail[i_time][i_layer][4]*=smallest_timestep
					dROH3_detail[i_time][i_layer][0]*=smallest_timestep
					dROH3_detail[i_time][i_layer][1]*=smallest_timestep
					dROH3_detail[i_time][i_layer][2]*=smallest_timestep
					dROH3_detail[i_time][i_layer][3]*=smallest_timestep
					dROH3_detail[i_time][i_layer][4]*=smallest_timestep
					dRO2_1_detail[i_time][i_layer][0]*=smallest_timestep
					dRO2_1_detail[i_time][i_layer][1]*=smallest_timestep
					dRO2_1_detail[i_time][i_layer][2]*=smallest_timestep
					dRO2_1_detail[i_time][i_layer][3]*=smallest_timestep
					dRO2_1_detail[i_time][i_layer][4]*=smallest_timestep
					dRO2_2_detail[i_time][i_layer][0]*=smallest_timestep
					dRO2_2_detail[i_time][i_layer][1]*=smallest_timestep
					dRO2_2_detail[i_time][i_layer][2]*=smallest_timestep
					dRO2_2_detail[i_time][i_layer][3]*=smallest_timestep
					dRO2_2_detail[i_time][i_layer][4]*=smallest_timestep
					dRO2_3_detail[i_time][i_layer][0]*=smallest_timestep
					dRO2_3_detail[i_time][i_layer][1]*=smallest_timestep
					dRO2_3_detail[i_time][i_layer][2]*=smallest_timestep
					dRO2_3_detail[i_time][i_layer][3]*=smallest_timestep
					dRO2_3_detail[i_time][i_layer][4]*=smallest_timestep
					
				temp_dRH[i_layer]=dRH_detail[i_time][i_layer][0]+dRH_detail[i_time][i_layer][1]+dRH_detail[i_time][i_layer][2]   //mlc
				temp_dFragment[i_layer]=dFrag_detail[i_time][i_layer][0]+dFrag_detail[i_time][i_layer][1]
				temp_dRO_1[i_layer]=dRO_1_detail[i_time][i_layer][0]+dRO_1_detail[i_time][i_layer][1]+dRO_1_detail[i_time][i_layer][2]+dRO_1_detail[i_time][i_layer][3]
				temp_dRO_2[i_layer]=dRO_2_detail[i_time][i_layer][0]+dRO_2_detail[i_time][i_layer][1]+dRO_2_detail[i_time][i_layer][2]+dRO_2_detail[i_time][i_layer][3]
				temp_dRO_3[i_layer]=dRO_3_detail[i_time][i_layer][0]+dRO_3_detail[i_time][i_layer][1]+dRO_3_detail[i_time][i_layer][2]+dRO_3_detail[i_time][i_layer][3]
				temp_dROOH1[i_layer]=dROOH1_detail[i_time][i_layer][0]+dROOH1_detail[i_time][i_layer][1]+dROOH1_detail[i_time][i_layer][2]+dROOH1_detail[i_time][i_layer][3]
				temp_dROOH2[i_layer]=dROOH2_detail[i_time][i_layer][0]+dROOH2_detail[i_time][i_layer][1]+dROOH2_detail[i_time][i_layer][2]+dROOH2_detail[i_time][i_layer][3]
				temp_dROOH3[i_layer]=dROOH3_detail[i_time][i_layer][0]+dROOH3_detail[i_time][i_layer][1]+dROOH3_detail[i_time][i_layer][2]+dROOH3_detail[i_time][i_layer][3]
				temp_dROH1[i_layer]=dROH1_detail[i_time][i_layer][0]+dROH1_detail[i_time][i_layer][1]+dROH1_detail[i_time][i_layer][2]+dROH1_detail[i_time][i_layer][3]+dROH1_detail[i_time][i_layer][4]
				temp_dROH2[i_layer]=dROH2_detail[i_time][i_layer][0]+dROH2_detail[i_time][i_layer][1]+dROH2_detail[i_time][i_layer][2]+dROH2_detail[i_time][i_layer][3]+dROH2_detail[i_time][i_layer][4]
				temp_dROH3[i_layer]=dROH3_detail[i_time][i_layer][0]+dROH3_detail[i_time][i_layer][1]+dROH3_detail[i_time][i_layer][2]+dROH3_detail[i_time][i_layer][3]+dROH3_detail[i_time][i_layer][4]
				temp_dRO2_1[i_layer]=dRO2_1_detail[i_time][i_layer][0]+dRO2_1_detail[i_time][i_layer][1]+dRO2_1_detail[i_time][i_layer][2]+dRO2_1_detail[i_time][i_layer][3]+dRO2_1_detail[i_time][i_layer][4]
				temp_dRO2_2[i_layer]=dRO2_2_detail[i_time][i_layer][0]+dRO2_2_detail[i_time][i_layer][1]+dRO2_2_detail[i_time][i_layer][2]+dRO2_2_detail[i_time][i_layer][3]+dRO2_2_detail[i_time][i_layer][4]
				temp_dRO2_3[i_layer]=dRO2_3_detail[i_time][i_layer][0]+dRO2_3_detail[i_time][i_layer][1]+dRO2_3_detail[i_time][i_layer][2]+dRO2_3_detail[i_time][i_layer][3]+dRO2_3_detail[i_time][i_layer][4]
				
				temp_RH[1][i_layer]=temp_RH[0][i_layer]*layer_V[i_layer]+temp_dRH[i_layer]  //mlc
				temp_RO_1[1][i_layer]=temp_RO_1[0][i_layer]*layer_V[i_layer]+temp_dRO_1[i_layer]  //mlc
				temp_RO_2[1][i_layer]=temp_RO_2[0][i_layer]*layer_V[i_layer]+temp_dRO_2[i_layer]  //mlc
				temp_RO_3[1][i_layer]=temp_RO_3[0][i_layer]*layer_V[i_layer]+temp_dRO_3[i_layer]  //mlc
				temp_ROOH1[1][i_layer]=temp_ROOH1[0][i_layer]*layer_V[i_layer]+temp_dROOH1[i_layer]  //mlc
				temp_ROOH2[1][i_layer]=temp_ROOH2[0][i_layer]*layer_V[i_layer]+temp_dROOH2[i_layer]  //mlc
				temp_ROOH3[1][i_layer]=temp_ROOH3[0][i_layer]*layer_V[i_layer]+temp_dROOH3[i_layer]  //mlc
				temp_ROH1[1][i_layer]=temp_ROH1[0][i_layer]*layer_V[i_layer]+temp_dROH1[i_layer]  //mlc
				temp_ROH2[1][i_layer]=temp_ROH2[0][i_layer]*layer_V[i_layer]+temp_dROH2[i_layer]  //mlc
				temp_ROH3[1][i_layer]=temp_ROH3[0][i_layer]*layer_V[i_layer]+temp_dROH3[i_layer]  //mlc
				temp_RO2_1[1][i_layer]=temp_RO2_1[0][i_layer]*layer_V[i_layer]+temp_dRO2_1[i_layer]  //mlc
				temp_RO2_2[1][i_layer]=temp_RO2_2[0][i_layer]*layer_V[i_layer]+temp_dRO2_2[i_layer]  //mlc
				temp_RO2_3[1][i_layer]=temp_RO2_3[0][i_layer]*layer_V[i_layer]+temp_dRO2_3[i_layer]  //mlc
				temp_Frag[1][i_layer]=temp_Frag[0][i_layer]*layer_V[i_layer]+temp_dFragment[i_layer]  //mlc
				temp_dRO2sum+=dRO2_1_detail[i_time][i_layer][4]+dRO2_2_detail[i_time][i_layer][4]+dRO2_3_detail[i_time][i_layer][4]  //mlc
				if(temp_RH[1][i_layer]<0||temp_RO_1[1][i_layer]<0||temp_RO_2[1][i_layer]<0||temp_RO_3[1][i_layer]<0||temp_RO2_1[1][i_layer]<0||temp_RO2_2[1][i_layer]<0||temp_RO2_3[1][i_layer]<0||temp_ROOH1[1][i_layer]<0||temp_ROOH2[1][i_layer]<0||temp_ROOH3[1][i_layer]<0||temp_ROH1[1][i_layer]<0||temp_ROH2[1][i_layer]<0||temp_ROH3[1][i_layer]<0||temp_Frag[1][i_layer]<0)
					print "Report negative values at"
					print num2str(i_time*timestep+j_time*smallest_timestep)+" s"
					print "layer "+num2str(i_layer)
					abort
				endif
								
			endfor
			//stores information of change rate
			if(j_time==1)
				for(i_layer=0;i_layer<=totallayers;i_layer+=1)
					dRH[i_time][i_layer]=temp_dRH[i_layer]/smallest_timestep/layer_v[i_layer]      //mlc/cm3/s
					dRO_1[i_time][i_layer]=temp_dRO_1[i_layer]/smallest_timestep/layer_v[i_layer] 
					dRO_2[i_time][i_layer]=temp_dRO_2[i_layer]/smallest_timestep/layer_v[i_layer] 
					dRO_3[i_time][i_layer]=temp_dRO_3[i_layer]/smallest_timestep/layer_v[i_layer] 
					dROOH1[i_time][i_layer]=temp_dROOH1[i_layer]/smallest_timestep/layer_v[i_layer] 
					dROOH2[i_time][i_layer]=temp_dROOH2[i_layer]/smallest_timestep/layer_v[i_layer] 
					dROOH3[i_time][i_layer]=temp_dROOH3[i_layer]/smallest_timestep/layer_v[i_layer] 
					dROH1[i_time][i_layer]=temp_dROH1[i_layer]/smallest_timestep/layer_v[i_layer]
					dROH2[i_time][i_layer]=temp_dROH2[i_layer]/smallest_timestep/layer_v[i_layer]
					dROH3[i_time][i_layer]=temp_dROH3[i_layer]/smallest_timestep/layer_v[i_layer] 
					dRO2_1[i_time][i_layer]=temp_dRO2_1[i_layer]/smallest_timestep/layer_v[i_layer] 
					dRO2_2[i_time][i_layer]=temp_dRO2_2[i_layer]/smallest_timestep/layer_v[i_layer] 
					dRO2_3[i_time][i_layer]=temp_dRO2_3[i_layer]/smallest_timestep/layer_v[i_layer] 
					dFragment[i_time][i_layer]=temp_dfragment[i_layer]/smallest_timestep/layer_v[i_layer] 
				endfor
				SL_dRO2HO2[i_time]=(dRO2_1_detail[i_time][0][3]+dRO2_2_detail[i_time][0][3]+dRO2_3_detail[i_time][0][3])/smallest_timestep/layer_V[0]   //mlc/cm3/s
				SL_dRO2RO2[i_time]=(dRO2_1_detail[i_time][0][4]+dRO2_2_detail[i_time][0][4]+dRO2_3_detail[i_time][0][4])/smallest_timestep/layer_V[0]
				SL_dRO2P[i_time]=(dRO2_1_detail[i_time][0][1]+dRO2_2_detail[i_time][0][1]+dRO2_3_detail[i_time][0][1]+dRO2_1_detail[i_time][0][2]+dRO2_2_detail[i_time][0][2]+dRO2_3_detail[i_time][0][2])/smallest_timestep/layer_V[0]
				SL_dRO2Dif[i_time]=(dRO2_1_detail[i_time][0][0]+dRO2_2_detail[i_time][0][0]+dRO2_3_detail[i_time][0][0])/smallest_timestep/layer_v[0]
				temp_sum_ro2=0
				temp_sum_layerv=0
				for(i_layer=1;i_layer<=totallayers;i_layer+=1)
					temp_sum_ro2+=dRO2_1_detail[i_time][i_layer][4]+dRO2_2_detail[i_time][i_layer][4]+dRO2_3_detail[i_time][i_layer][4]   //mlc
					temp_sum_layerv+=layer_V[i_layer]   //cm3
				endfor
				Bulkavg_dRO2RO2[i_time]=temp_sum_ro2/temp_sum_layerv/smallest_timestep   //mlc/cm3/s
				SL_frag[i_time]=0.5*temp_frag[1][0]
				SL_dFragP[i_time]=dFrag_detail[i_time][0][1]/smallest_timestep/layer_v[0]
				SL_dFragDif[i_time]=dFrag_detail[i_time][0][0]/smallest_timestep/layer_v[0]
				if(i_time<totaltimesteps-1)
					Evaporation[i_time+1]=Evaporation[i_time]
				endif
			endif
			//This is where evaporation happens
			temp_VFR[1]=temp_VFR[0]-0.5*temp_Frag[1][0]/Corg_mlc_initial   //2 fragments=1 RO2
			temp_Dp[1]=Dp*(temp_VFR[1])^(1/3)
			volume_removed[0]=pi*(temp_Dp[0]^3-temp_Dp[1]^3)*1e-21/6   //cm3
			if(i_time<totaltimesteps-1)
				Evaporation[i_time+1]+=0.5*temp_Frag[1][0]  //mlc
			endif
			temp_Frag[1][0]=0
			calculateLayerVolume(temp_Dp[0],totallayers,SL_depth,layer_V_pre)   //returns in unit cm3
			CalculateLayerVolume(temp_Dp[1],totallayers,SL_depth,layer_V)  //cm2
			temp_ratio=(dRO2_1_detail[i_time][0][3]+dRO2_2_detail[i_time][0][3]+dRO2_3_detail[i_time][0][3])/temp_dRO2sum
			
			//Redistribute mlc in the particle based on new diameter
			for(i_layer=0;i_layer<=totallayers;i_layer+=1)
				if(i_layer==0)
					volume_added[i_layer]=layer_V[i_layer]-layer_V_pre[i_layer]+volume_removed[i_layer]
					temp_RH_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RH[1][i_layer+1]   //mlc
					temp_RO_1_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RO_1[1][i_layer+1]
					temp_RO_2_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RO_2[1][i_layer+1]
					temp_RO_3_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RO_3[1][i_layer+1]
					temp_ROOH1_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROOH1[1][i_layer+1]
					temp_ROOH2_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROOH2[1][i_layer+1]
					temp_ROOH3_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROOH3[1][i_layer+1]
					temp_ROH1_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROH1[1][i_layer+1]
					temp_ROH2_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROH2[1][i_layer+1]
					temp_ROH3_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROH3[1][i_layer+1]
					temp_RO2_1_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RO2_1[1][i_layer+1]
					temp_RO2_2_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RO2_2[1][i_layer+1]
					temp_RO2_3_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RO2_3[1][i_layer+1]
					temp_Frag_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_Frag[1][i_layer+1]
					
					temp_RH[1][i_layer]=(temp_RH[1][i_layer]+temp_RH_redis[0][i_layer])/layer_V[i_layer]   //mlc/cm3
					temp_RO_1[1][i_layer]=(temp_RO_1[1][i_layer]+temp_RO_1_redis[0][i_layer])/layer_V[i_layer]   //mlc/cm3
					temp_RO_2[1][i_layer]=(temp_RO_2[1][i_layer]+temp_RO_2_redis[0][i_layer])/layer_V[i_layer]
					temp_RO_3[1][i_layer]=(temp_RO_3[1][i_layer]+temp_RO_3_redis[0][i_layer])/layer_V[i_layer]
					temp_ROOH1[1][i_layer]=(temp_ROOH1[1][i_layer]+temp_ROOH1_redis[0][i_layer])/layer_V[i_layer]  //mlc/cm3
					temp_ROOH2[1][i_layer]=(temp_ROOH2[1][i_layer]+temp_ROOH2_redis[0][i_layer])/layer_V[i_layer]
					temp_ROOH3[1][i_layer]=(temp_ROOH3[1][i_layer]+temp_ROOH3_redis[0][i_layer])/layer_V[i_layer]
					temp_ROH1[1][i_layer]=(temp_ROH1[1][i_layer]+temp_ROH1_redis[0][i_layer])/layer_V[i_layer]   //mlc/cm3
					temp_ROH2[1][i_layer]=(temp_ROH2[1][i_layer]+temp_ROH2_redis[0][i_layer])/layer_V[i_layer] 
					temp_ROH3[1][i_layer]=(temp_ROH3[1][i_layer]+temp_ROH3_redis[0][i_layer])/layer_V[i_layer] 
					temp_RO2_1[1][i_layer]=(temp_RO2_1[1][i_layer]+temp_RO2_1_redis[0][i_layer])/layer_V[i_layer]   //mlc/cm3
					temp_RO2_2[1][i_layer]=(temp_RO2_2[1][i_layer]+temp_RO2_2_redis[0][i_layer])/layer_V[i_layer]
					temp_RO2_3[1][i_layer]=(temp_RO2_3[1][i_layer]+temp_RO2_3_redis[0][i_layer])/layer_V[i_layer]
					temp_Frag[1][i_layer]=(temp_Frag[1][i_layer]+temp_Frag_redis[0][i_layer])/layer_V[i_layer]   //mlc/cm3
				elseif(i_layer==totallayers)
					volume_removed[i_layer]=volume_added[i_layer-1]
					volume_added[i_layer]=layer_V[i_layer]-layer_V_pre[i_layer]+volume_removed[i_layer]
					temp_RH_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RH[1][i_layer]
					temp_RO_1_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RO_1[1][i_layer]
					temp_RO_2_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RO_2[1][i_layer]
					temp_RO_3_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RO_3[1][i_layer]
					temp_ROOH1_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROOH1[1][i_layer]
					temp_ROOH2_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROOH2[1][i_layer]
					temp_ROOH3_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROOH3[1][i_layer]
					temp_ROH1_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROH1[1][i_layer]
					temp_ROH2_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROH2[1][i_layer]
					temp_ROH3_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROH3[1][i_layer]
					temp_RO2_1_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RO2_1[1][i_layer]
					temp_RO2_2_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RO2_2[1][i_layer]
					temp_RO2_3_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RO2_3[1][i_layer]
					temp_Frag_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_Frag[1][i_layer]
					
					temp_RH[1][i_layer]=(temp_RH[1][i_layer]-temp_RH_redis[1][i_layer])/layer_V[i_layer]   //mlc/cm3
					temp_RO_1[1][i_layer]=(temp_RO_1[1][i_layer]-temp_RO_1_redis[1][i_layer])/layer_V[i_layer]   //mlc/cm3
					temp_RO_2[1][i_layer]=(temp_RO_2[1][i_layer]-temp_RO_2_redis[1][i_layer])/layer_V[i_layer]
					temp_RO_3[1][i_layer]=(temp_RO_3[1][i_layer]-temp_RO_3_redis[1][i_layer])/layer_V[i_layer]
					temp_ROOH1[1][i_layer]=(temp_ROOH1[1][i_layer]-temp_ROOH1_redis[1][i_layer])/layer_V[i_layer]  //mlc/cm3
					temp_ROOH2[1][i_layer]=(temp_ROOH2[1][i_layer]-temp_ROOH2_redis[1][i_layer])/layer_V[i_layer]
					temp_ROOH3[1][i_layer]=(temp_ROOH3[1][i_layer]-temp_ROOH3_redis[1][i_layer])/layer_V[i_layer]
					temp_ROH1[1][i_layer]=(temp_ROH1[1][i_layer]-temp_ROH1_redis[1][i_layer])/layer_V[i_layer]   //mlc/cm3
					temp_ROH2[1][i_layer]=(temp_ROH2[1][i_layer]-temp_ROH2_redis[1][i_layer])/layer_V[i_layer]
					temp_ROH3[1][i_layer]=(temp_ROH3[1][i_layer]-temp_ROH3_redis[1][i_layer])/layer_V[i_layer]
					temp_RO2_1[1][i_layer]=(temp_RO2_1[1][i_layer]-temp_RO2_1_redis[1][i_layer])/layer_V[i_layer]   //mlc/cm3
					temp_RO2_2[1][i_layer]=(temp_RO2_2[1][i_layer]-temp_RO2_2_redis[1][i_layer])/layer_V[i_layer]
					temp_RO2_3[1][i_layer]=(temp_RO2_3[1][i_layer]-temp_RO2_3_redis[1][i_layer])/layer_V[i_layer]
					temp_Frag[1][i_layer]=(temp_Frag[1][i_layer]-temp_Frag_redis[1][i_layer])/layer_V[i_layer]   //mlc/cm3
				else
					volume_removed[i_layer]=volume_added[i_layer-1]
					volume_added[i_layer]=layer_V[i_layer]-layer_V_pre[i_layer]+volume_removed[i_layer]
					temp_RH_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RH[1][i_layer+1]
					temp_RO_1_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RO_1[1][i_layer+1]
					temp_RO_2_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RO_2[1][i_layer+1]
					temp_RO_3_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RO_3[1][i_layer+1]
					temp_ROOH1_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROOH1[1][i_layer+1]
					temp_ROOH2_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROOH2[1][i_layer+1]
					temp_ROOH3_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROOH3[1][i_layer+1]
					temp_ROH1_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROH1[1][i_layer+1]
					temp_ROH2_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROH2[1][i_layer+1]
					temp_ROH3_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROH3[1][i_layer+1]
					temp_RO2_1_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RO2_1[1][i_layer+1]
					temp_RO2_2_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RO2_2[1][i_layer+1]
					temp_RO2_3_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RO2_3[1][i_layer+1]
					temp_Frag_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_Frag[1][i_layer+1]
					temp_RH_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RH[1][i_layer]
					temp_RO_1_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RO_1[1][i_layer]
					temp_RO_2_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RO_2[1][i_layer]
					temp_RO_3_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RO_3[1][i_layer]
					temp_ROOH1_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROOH1[1][i_layer]
					temp_ROOH2_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROOH2[1][i_layer]
					temp_ROOH3_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROOH3[1][i_layer]
					temp_ROH1_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROH1[1][i_layer]
					temp_ROH2_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROH2[1][i_layer]
					temp_ROH3_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROH3[1][i_layer]
					temp_RO2_1_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RO2_1[1][i_layer]
					temp_RO2_2_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RO2_2[1][i_layer]
					temp_RO2_3_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RO2_3[1][i_layer]
					temp_Frag_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_Frag[1][i_layer]
					
					temp_RH[1][i_layer]=(temp_RH[1][i_layer]+temp_RH_redis[0][i_layer]-temp_RH_redis[1][i_layer])/layer_V[i_layer] 
					temp_RO_1[1][i_layer]=(temp_RO_1[1][i_layer]+temp_RO_1_redis[0][i_layer]-temp_RO_1_redis[1][i_layer])/layer_V[i_layer]
					temp_RO_2[1][i_layer]=(temp_RO_2[1][i_layer]+temp_RO_2_redis[0][i_layer]-temp_RO_2_redis[1][i_layer])/layer_V[i_layer]
					temp_RO_3[1][i_layer]=(temp_RO_3[1][i_layer]+temp_RO_3_redis[0][i_layer]-temp_RO_3_redis[1][i_layer])/layer_V[i_layer] 
					temp_ROOH1[1][i_layer]=(temp_ROOH1[1][i_layer]+temp_ROOH1_redis[0][i_layer]-temp_ROOH1_redis[1][i_layer])/layer_V[i_layer]
					temp_ROOH2[1][i_layer]=(temp_ROOH2[1][i_layer]+temp_ROOH2_redis[0][i_layer]-temp_ROOH2_redis[1][i_layer])/layer_V[i_layer]
					temp_ROOH3[1][i_layer]=(temp_ROOH3[1][i_layer]+temp_ROOH3_redis[0][i_layer]-temp_ROOH3_redis[1][i_layer])/layer_V[i_layer] 
					temp_ROH1[1][i_layer]=(temp_ROH1[1][i_layer]+temp_ROH1_redis[0][i_layer]-temp_ROH1_redis[1][i_layer])/layer_V[i_layer]
					temp_ROH2[1][i_layer]=(temp_ROH2[1][i_layer]+temp_ROH2_redis[0][i_layer]-temp_ROH2_redis[1][i_layer])/layer_V[i_layer]
					temp_ROH3[1][i_layer]=(temp_ROH3[1][i_layer]+temp_ROH3_redis[0][i_layer]-temp_ROH3_redis[1][i_layer])/layer_V[i_layer] 
					temp_RO2_1[1][i_layer]=(temp_RO2_1[1][i_layer]+temp_RO2_1_redis[0][i_layer]-temp_RO2_1_redis[1][i_layer])/layer_V[i_layer]
					temp_RO2_2[1][i_layer]=(temp_RO2_2[1][i_layer]+temp_RO2_2_redis[0][i_layer]-temp_RO2_2_redis[1][i_layer])/layer_V[i_layer]
					temp_RO2_3[1][i_layer]=(temp_RO2_3[1][i_layer]+temp_RO2_3_redis[0][i_layer]-temp_RO2_3_redis[1][i_layer])/layer_V[i_layer] 
					temp_Frag[1][i_layer]=(temp_Frag[1][i_layer]+temp_Frag_redis[0][i_layer]-temp_Frag_redis[1][i_layer])/layer_V[i_layer] 
				endif
			endfor
			temp_Dp[0]=temp_Dp[1]
			temp_VFR[0]=temp_VFR[1]
		endfor
	endfor
	
	for(i_time=0;i_time<totaltimesteps;i_time+=1)
	temp_sum_mlc=mlc_RH[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][0]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_ROOH1[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][1]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_ROOH2[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][2]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_ROOH3[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][3]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_ROH1[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][4]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_ROH2[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][5]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_ROH3[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][6]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_RO2_1[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][7]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_RO2_2[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][8]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_RO2_3[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][9]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_RO_1[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][10]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_RO_2[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][11]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_RO_3[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][12]=V_sum/(VFR_38s[i_time]*initialV)
	endfor
	
	make/o/d/n=(totaltimesteps,totallayers+1) Sum_RH,Sum_mlc_RH
	sum_RH=C_RH+C_RO_1+C_RO_2+C_RO_3+C_ROOH1+C_ROOH2+C_ROOH3+C_ROH1+C_ROH2+C_ROH3+C_RO2_1+C_RO2_2+C_RO2_3+0.5*c_frag
	sum_mlc_RH=mlc_RH+mlc_RO_1+mlc_RO_2+mlc_RO_3+mlc_ROOH1+mlc_ROOH2+mlc_ROOH3+mlc_ROH1+mlc_ROH2+mlc_ROH3+mlc_RO2_1+mlc_RO2_2+mlc_RO2_3+0.5*mlc_frag
	
End


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// This function calculates the R^2 for spectrum of oxidized particles vs. spectrum of non-oxidized particles
// "finalconc" is a 2D wave containing the concentration/mole fraction of all the species at various OH exposure. Each row is a different OH exposure and each column is a different species
Function R2foroxidizedvsnon(finalconc)

	wave Finalconc
	variable nrow=dimsize(finalconc,0)
	variable nspecies=dimsize(finalconc,1)
	
	make/o/d/n=(nrow) R2_oxi_non
	variable i, V_r2
	make/o/d/n=(nspecies)/Free Oxiwave 
	make/o/d/n=(nspecies)/Free Nonwave
	Nonwave=finalconc[0][p]
	R2_oxi_non[0]=1
	for(i=1;i<nrow;i+=1)
		Oxiwave=finalconc[i][p]
		CurveFit/Q/NTHR=0/TBOX=784 line  Oxiwave /X=Nonwave /D
			R2_oxi_non[i]=V_r2		
	endfor 
End

////////////////////////////////////////////////////////////////////////////////////////////////////////
//This function treats ROOH(hydropeoxides) and other functionalized species (lumped as ROH) differently
Function OHexposure38s_3G_dry()

	wave kkWave
	if (waveexists(kkwave)==0)
		print "Please create rate constant wave 'kkwave' first"
		abort
	endif
	variable Dorg=kkWave[0]
	variable Dfrag=kkWave[1]
	variable OH_gas=kkWave[2]
	variable HO2_gas=kkWave[3]
	variable uptake_OH=kkWave[6]
	variable uptake_HO2=kkWave[7]
	variable flowtime=kkWave[8]	
	variable totaltimesteps=kkWave[9]
	variable timestep=kkWave[10]
	variable stepnum=kkWave[11]
	variable smallest_timestep=kkWave[12]
	variable Dp=kkWave[13]
	variable SL_depth=kkWave[14]
	variable totallayers=kkWave[15]
	variable layerdepth=kkWave[16]
	variable Corg_initial=kkWave[19]
	variable Corg_mlc_initial=kkWave[20]
	variable prob1=kkWave[21]
	variable prob2=kkWave[22]
	variable prob3=kkWave[23]
	variable k2=kkWave[24]
	variable k6=kkWave[25]
	variable k7=kkWave[26]
	variable k11=kkWave[27]
	variable bratio1=kkWave[28]
	variable bratio2=kkWave[29]
	
	variable Kn_OH=6*0.21485e-4/609/Dp/1e-9   //dimensionless
	variable Kn_HO2=6*0.25e-4/437/Dp/1e-9   //dimensionless
	variable Fuchs_OH=(0.75+0.28*Kn_OH)/(Kn_OH*(1+Kn_OH))  //Maybe not Fuchs... From Shiraiwa et al. ACP 2010
	variable Fuchs_HO2=(0.75+0.28*Kn_HO2)/(Kn_HO2*(1+Kn_HO2)) 
	variable Crtf_OH=1/(1+uptake_OH*Fuchs_OH)  //Correction factor of the near surface concentration to the far away concentration
	variable Crtf_HO2=1/(1+uptake_HO2*Fuchs_HO2)
	variable OH_initial=OH_gas*Crtf_OH
	variable HO2_initial=HO2_gas*Crtf_HO2
	
	variable OH_gs=OH_initial  //mlc/cm3-air
	variable HO2_gs=HO2_initial //mlc/cm3-air
	
	//stores concentration and mlc number in each layer at each big time step
	make/o/d/n=(totaltimesteps,totallayers+1) C_RH,C_ROOH1,C_ROOH2,C_ROOH3,C_ROH1,C_ROH2,C_ROH3,C_Frag,C_RO2_1,C_RO2_2,C_RO2_3
	make/o/d/n=(totaltimesteps,totallayers+1) mlc_RH,mlc_ROOH1,mlc_ROOH2,mlc_ROOH3,mlc_ROH1,mlc_ROH2,mlc_ROH3,mlc_RO2_1,mlc_RO2_2,mlc_RO2_3,mlc_Frag   //surface layer index is 0
	C_RH=0  
	C_ROOH1=0
	C_ROOH2=0
	C_ROOH3=0
	C_ROH1=0
	C_ROH2=0
	C_ROH3=0
	C_Frag=0
	C_RO2_1=0
	C_RO2_2=0
	C_RO2_3=0
	mlc_RH=0  
	mlc_ROOH1=0
	mlc_ROOH2=0
	mlc_ROOH3=0
	mlc_ROH1=0
	mlc_ROH2=0
	mlc_ROH3=0
	mlc_RO2_1=0
	mlc_RO2_2=0
	mlc_RO2_3=0
	mlc_Frag=0
	
	//stores concentration or mlc number of each layer for past and current time steps only
	make/o/d/n=(2,totallayers+1)/Free temp_RH,temp_ROOH1,temp_ROOH2,temp_ROOH3,temp_ROH1,temp_ROH2,temp_ROH3,temp_Frag,temp_RO2_1,temp_RO2_2,temp_RO2_3
	temp_RH=kkWave[19]  //mlc/cm3-particle   don't use Corg_mlc_initial for all the layers because it is different
	temp_ROOH1=0
	temp_ROOH2=0
	temp_ROOH3=0  
	temp_ROH1=0
	temp_ROH2=0
	temp_ROH3=0
	temp_Frag=0
	temp_RO2_1=0
	temp_RO2_2=0
	temp_RO2_3=0
	
	//stores change of mlc num in each layer for current time step
	make/o/d/n=(totallayers+1)/Free temp_dRH,temp_dROOH1,temp_dROOH2,temp_dROOH3,temp_dROH1,temp_dROH2,temp_dROH3,temp_dFragment,temp_dRO2_1,temp_dRO2_2,temp_dRO2_3
	temp_dRH=0
	temp_dROOH1=0
	temp_dROOH2=0
	temp_dROOH3=0
	temp_dROH1=0
	temp_dROH2=0
	temp_dROH3=0
	temp_dFragment=0
	temp_dRO2_1=0
	temp_dRO2_2=0
	temp_dRO2_3=0
	//stores rate of change of each species at the start at every big time step
	make/o/d/n=(totaltimesteps,totallayers+1)/Free dRH,dROOH1,dROOH2,dROOH3,dROH1,dROH2,dROH3,dRO2_1,dRO2_2,dRO2_3,dFragment
	dRH=0
	dROOH1=0
	dROOH2=0
	dROOH3=0
	dROH1=0
	dROH2=0
	dROH3=0
	dRO2_1=0
	dRO2_2=0
	dRO2_3=0
	dFragment=0
	make/o/d/n=(totaltimesteps)/Free SL_dRO2HO2,SL_dRO2RO2,Bulkavg_dRO2RO2,SL_dRO2P,SL_dRO2Dif
	SL_dro2ho2=0
	SL_dro2ro2=0
	Bulkavg_dro2ro2=0
	SL_dRO2P=0
	SL_dRO2Dif=0
	make/o/d/n=(totaltimesteps)/Free SL_dFragP,SL_dFragDif
	SL_dfragP=0
	SL_dFragDif=0
	
	//stores volume, outer surface area of each layer for current time step and volume for previous time step
	make/o/d/n=(totallayers+1)/Free layer_V,layer_outer_SA,layer_V_pre
	calculateLayerVolume(Dp,totallayers,SL_depth,layer_V)   //returns in unit cm3
	calculateLayerVolume(Dp,totallayers,SL_depth,layer_V_pre)   //returns in unit cm3
	calculateLayerouterSA(Dp,totallayers,SL_depth,layer_outer_SA)     //returns in unit cm2
	
	//stores change of mlc number that happens over redistribution of particle due to evaporation for current time step
	//layer 0 is the mlc added to a layer while layer1 is mlc removed from a layer
	make/o/d/n=(totaltimesteps,totallayers+1,2)/Free RH_redis,ROOH1_redis,ROOH2_redis,ROOH3_redis,ROH1_redis,ROH2_redis,ROH3_redis,RO2_1_redis,RO2_2_redis,RO2_3_redis,Frag_redis   //mlc
	RH_redis=0
	ROOH1_redis=0
	ROOH2_redis=0
	ROOH3_redis=0
	ROH1_redis=0
	ROH2_redis=0
	ROH3_redis=0
	RO2_1_redis=0
	RO2_2_redis=0
	RO2_3_redis=0
	frag_redis=0
	
	//stores mlc added and removed for each layer at current time step only 
	make/o/d/n=(2,totallayers+1)/Free temp_RH_redis,temp_ROOH1_redis,temp_ROOH2_redis,temp_ROOH3_redis,temp_ROH1_redis,temp_ROH2_redis,temp_ROH3_redis,temp_RO2_1_redis,temp_RO2_2_redis,temp_RO2_3_redis,temp_Frag_redis
	temp_RH_redis=0
	temp_ROOH1_redis=0
	temp_ROOH2_redis=0
	temp_ROOH3_redis=0
	temp_ROH1_redis=0
	temp_ROH2_redis=0
	temp_ROH3_redis=0
	temp_RO2_1_redis=0
	temp_RO2_2_redis=0
	temp_RO2_3_redis=0
	temp_Frag_redis=0
	
	//stores volume and outer surface area for each big time step for every layer
	make/o/d/n=(totaltimesteps,totallayers+1)/Free layer_V_t,layer_outerSA_t
	layer_V_t=0
	layer_outerSA_t=0
	
	//stores detailed mlc number change due to diffusion, chemical production and chemical loss in every layer at each big time step
	make/o/d/n=(totaltimesteps,totallayers+1,2)/Free dRH_detail,dFrag_detail   //mlc
	dRH_detail=0
	dFrag_detail=0
	make/o/d/n=(totaltimesteps,totallayers+1,3)/Free dROOH1_detail,dROOH2_detail,dROOH3_detail,dROH1_detail,dROH2_detail,dROH3_detail   //mlc
	dROOH1_detail=0
	dROOH2_detail=0
	dROOH3_detail=0
	dROH1_detail=0
	dROH2_detail=0
	dROH3_detail=0
	make/o/d/n=(totaltimesteps,totallayers+1,4)/Free dRO2_1_detail,dRO2_2_detail,dRO2_3_detail     //mlc
	dRO2_1_detail=0
	dRO2_2_detail=0
	dRO2_3_detail=0
	
	make/o/d/n=(totaltimesteps)/Free SL_Frag
	SL_frag=0
	
	//stores VFR etc 
	make/o/d/n=(totaltimesteps) VFR_38s,timewave,NewDp,ratio_HO2_RO2,Evaporation,OHexposure_38s
	VFR_38s=1
	timewave=x*flowtime/(kkwave[9]-1)
	OHexposure_38s=timewave*OH_gas
	NewDp[0]=Dp
	ratio_HO2_RO2=0
	Evaporation=0
	make/o/d/n=2/Free temp_Dp,temp_VFR
	temp_Dp=Dp
	temp_VFR=1
	
	//stores bulk averaged conc of each species at each big timestep
	make/o/d/n=(totaltimesteps,11) FinalConc  // Stores averaged concentration of each species in the order of RH, ROOH1-3, ROH1-3, RO2_1-3,Frag
	make/o/d/n=(totallayers+1)/Free temp_sum_mlc
	variable initialV=Dp^3*pi/6*1e-21  //cm3  
	
	//stores the surface layer concentration and bulk averaged concentration of RO2
	make/o/d/n=(totaltimesteps) SL_RO2, Bulkavg_RO2   //mlc/cm3
	SL_ro2=0
	bulkavg_RO2=0
	
	variable f_RH,f_ROOH1,f_ROOH2,f_ROOH3,f_ROH1,f_ROH2,f_ROH3,f_RO2_1,f_RO2_2,f_RO2_3
	f_RH=1
	f_ROOH1=0
	f_ROOH2=0
	f_ROOH3=0
	f_ROH1=0
	f_ROH2=0
	f_ROH3=0
	f_RO2_1=0
	f_RO2_2=0
	f_RO2_3=0
	//stores fraction of every species in the surface layer at each big time step
	make/o/d/n=(totaltimesteps,11)/Free Fraction_Matrix
	fraction_matrix[][0]=1    //fraction of RH
	fraction_matrix[][1]=0    //fraction of ROOH1
	fraction_matrix[][2]=0    //fraction of ROOH2
	fraction_matrix[][3]=0    //fraction of ROOH3
	fraction_matrix[][4]=0    //fraction of ROH1
	fraction_matrix[][5]=0    //fraction of ROH2
	fraction_matrix[][6]=0    //fraction of ROH3
	fraction_matrix[][7]=0    //fraction of RO2_1
	fraction_matrix[][8]=0    //fraction of RO2_2
	fraction_matrix[][9]=0    //fraction of RO2_3
	fraction_matrix[][10]=0  //fraction of Frag?
	
	variable i_time,i_layer,j_time
	variable layer_r,SL_sum
	variable temp_dRO2sum, temp_ratio
	make/o/d/n=(totallayers+1)/Free volume_removed,volume_added
	temp_ratio=0
	temp_dRO2sum=0
	volume_removed=0
	volume_added=0
	
	variable temp_sum_ro2,temp_sum_layerV
	temp_sum_ro2=0
	temp_sum_layerV=0
	
	for(i_time=0;i_time<totaltimesteps;i_time+=1)
		NewDp[i_time]=temp_Dp[0]   //nm
		VFR_38s[i_time]=temp_VFR[0]
		ratio_HO2_RO2[i_time]=temp_ratio
			fraction_matrix[i_time][0]=f_RH    //fraction of RH
			fraction_matrix[i_time][1]=f_ROOH1    //fraction of ROOH1
			fraction_matrix[i_time][2]=f_ROOH2    //fraction of ROOH2
			fraction_matrix[i_time][3]=f_ROOH3    //fraction of ROOH3
			fraction_matrix[i_time][4]=f_ROH1   //fraction of ROH1
			fraction_matrix[i_time][5]=f_ROH2    //fraction of ROH2
			fraction_matrix[i_time][6]=f_ROH3    //fraction of ROH3
			fraction_matrix[i_time][7]=f_RO2_1    //fraction of RO2_1
			fraction_matrix[i_time][8]=f_RO2_2    //fraction of RO2_2
			fraction_matrix[i_time][9]=f_RO2_3    //fraction of RO2_3
			fraction_matrix[i_time][10]=0  //fraction of Frag?
		SL_RO2[i_time]=temp_RO2_1[1][0]+temp_RO2_2[1][0]+temp_RO2_3[1][0]
		//calculate the bulk averaged RO2  concentration
		temp_sum_ro2=0
		temp_sum_layerv=0
		for(i_layer=1;i_layer<=totallayers;i_layer+=1)
			temp_sum_RO2+=(temp_RO2_1[1][i_layer]+temp_RO2_2[1][i_layer]+temp_RO2_3[1][i_layer])*layer_V[i_layer]   //mlc
			temp_sum_layerV+=layer_V[i_layer]   //cm3
		endfor
		Bulkavg_RO2[i_time]=temp_sum_RO2/temp_sum_layerV
		//Record down concentrations etc at each big time step
		for(i_layer=0;i_layer<=totallayers;i_layer+=1)
			C_RH[i_time][i_layer]=temp_RH[1][i_layer]
			C_Frag[i_time][i_layer]=temp_Frag[1][i_layer]
			C_ROOH1[i_time][i_layer]=temp_ROOH1[1][i_layer]
			C_ROOH2[i_time][i_layer]=temp_ROOH2[1][i_layer]
			C_ROOH3[i_time][i_layer]=temp_ROOH3[1][i_layer]
			C_ROH1[i_time][i_layer]=temp_ROH1[1][i_layer]
			C_ROH2[i_time][i_layer]=temp_ROH2[1][i_layer]
			C_ROH3[i_time][i_layer]=temp_ROH3[1][i_layer]
			C_RO2_1[i_time][i_layer]=temp_RO2_1[1][i_layer]
			C_RO2_2[i_time][i_layer]=temp_RO2_2[1][i_layer]
			C_RO2_3[i_time][i_layer]=temp_RO2_3[1][i_layer]
			mlc_RH[i_time][i_layer]=temp_RH[1][i_layer]*layer_V[i_layer]
			mlc_Frag[i_time][i_layer]=temp_Frag[1][i_layer]*layer_V[i_layer]
			mlc_ROOH1[i_time][i_layer]=temp_ROOH1[1][i_layer]*layer_V[i_layer]
			mlc_ROOH2[i_time][i_layer]=temp_ROOH2[1][i_layer]*layer_V[i_layer]
			mlc_ROOH3[i_time][i_layer]=temp_ROOH3[1][i_layer]*layer_V[i_layer]
			mlc_ROH1[i_time][i_layer]=temp_ROH1[1][i_layer]*layer_V[i_layer]
			mlc_ROH2[i_time][i_layer]=temp_ROH2[1][i_layer]*layer_V[i_layer]
			mlc_ROH3[i_time][i_layer]=temp_ROH3[1][i_layer]*layer_V[i_layer]
			mlc_RO2_1[i_time][i_layer]=temp_RO2_1[1][i_layer]*layer_V[i_layer]
			mlc_RO2_2[i_time][i_layer]=temp_RO2_2[1][i_layer]*layer_V[i_layer]
			mlc_RO2_3[i_time][i_layer]=temp_RO2_3[1][i_layer]*layer_V[i_layer]
			layer_v_t[i_time][i_layer]=layer_v[i_layer]
			layer_outerSA_t[i_time][i_layer]=layer_outer_SA[i_layer]
			RH_redis[i_time][i_layer][0]=temp_RH_redis[0][i_layer]
			ROOH1_redis[i_time][i_layer][0]=temp_ROOH1_redis[0][i_layer]
			ROOH2_redis[i_time][i_layer][0]=temp_ROOH2_redis[0][i_layer]
			ROOH3_redis[i_time][i_layer][0]=temp_ROOH3_redis[0][i_layer]
			ROH1_redis[i_time][i_layer][0]=temp_ROH1_redis[0][i_layer]
			ROH2_redis[i_time][i_layer][0]=temp_ROH2_redis[0][i_layer]
			ROH3_redis[i_time][i_layer][0]=temp_ROH3_redis[0][i_layer]
			RO2_1_redis[i_time][i_layer][0]=temp_RO2_1_redis[0][i_layer]
			RO2_2_redis[i_time][i_layer][0]=temp_RO2_2_redis[0][i_layer]
			RO2_3_redis[i_time][i_layer][0]=temp_RO2_3_redis[0][i_layer]
			Frag_redis[i_time][i_layer][0]=temp_Frag_redis[0][i_layer]
			RH_redis[i_time][i_layer][1]=temp_RH_redis[1][i_layer]
			ROOH1_redis[i_time][i_layer][1]=temp_ROOH1_redis[1][i_layer]
			ROOH2_redis[i_time][i_layer][1]=temp_ROOH2_redis[1][i_layer]
			ROOH3_redis[i_time][i_layer][1]=temp_ROOH3_redis[1][i_layer]
			ROH1_redis[i_time][i_layer][1]=temp_ROH1_redis[1][i_layer]
			ROH2_redis[i_time][i_layer][1]=temp_ROH2_redis[1][i_layer]
			ROH3_redis[i_time][i_layer][1]=temp_ROH3_redis[1][i_layer]
			RO2_1_redis[i_time][i_layer][1]=temp_RO2_1_redis[1][i_layer]
			RO2_2_redis[i_time][i_layer][1]=temp_RO2_2_redis[1][i_layer]
			RO2_3_redis[i_time][i_layer][1]=temp_RO2_3_redis[1][i_layer]
			Frag_redis[i_time][i_layer][1]=temp_Frag_redis[1][i_layer]
		endfor
		
		for(j_time=1;j_time<=stepnum;j_time+=1)
			//Calculate new layer depth based on diameter change
			layerdepth=(0.5*temp_Dp[0]-SL_depth)/totallayers   //nm
			if(layerdepth<0.4)
				//print "Decay too fast"
				//abort
			endif
			CalculateLayerVolume(temp_Dp[0],totallayers,SL_depth,layer_V)   //cm3
			CalculateLayerouterSA(temp_Dp[0],totallayers,SL_depth,layer_outer_SA)  //cm2
			//Calculate new OH and HO2 concentration near surface
			Kn_OH=6*0.21485e-4/609/1e-9/temp_Dp[0]   //dimensionless
			Fuchs_OH=(0.75+0.28*Kn_OH)/(Kn_OH*(1+Kn_OH))  //Maybe not Fuchs... From Shiraiwa et al. ACP 2010
			Crtf_OH=1/(1+uptake_OH*Fuchs_OH)  //Correction factor of the near surface concentration to the far away concentration
			OH_gs=OH_gas*Crtf_OH  //mlc/cm3-air
			Kn_HO2=6*0.25e-4/437/1e-9/temp_Dp[0]   //dimensionless
			Fuchs_HO2=(0.75+0.28*Kn_HO2)/(Kn_HO2*(1+Kn_HO2))  //Maybe not Fuchs... From Shiraiwa et al. ACP 2010
			Crtf_HO2=1/(1+uptake_HO2*Fuchs_HO2)  //Correction factor of the near surface concentration to the far away concentration
			HO2_gs=HO2_gas*Crtf_HO2 //mlc/cm3-air
			
			for(i_layer=0;i_layer<=totallayers;i_layer+=1)
				temp_RH[0][i_layer]=temp_RH[1][i_layer]//mlc/cm3
				temp_ROOH1[0][i_layer]=temp_ROOH1[1][i_layer]
				temp_ROOH2[0][i_layer]=temp_ROOH2[1][i_layer]
				temp_ROOH3[0][i_layer]=temp_ROOH3[1][i_layer]
				temp_ROH1[0][i_layer]=temp_ROH1[1][i_layer]
				temp_ROH2[0][i_layer]=temp_ROH2[1][i_layer]
				temp_ROH3[0][i_layer]=temp_ROH3[1][i_layer]
				temp_RO2_1[0][i_layer]=temp_RO2_1[1][i_layer]
				temp_RO2_2[0][i_layer]=temp_RO2_2[1][i_layer]
				temp_RO2_3[0][i_layer]=temp_RO2_3[1][i_layer]
				temp_Frag[0][i_layer]=temp_Frag[1][i_layer]
			endfor
			temp_dRO2sum=0
			SL_sum=temp_RH[0][0]+temp_ROOH1[0][0]+temp_ROOH2[0][0]+temp_ROOH3[0][0]+temp_ROH1[0][0]+temp_ROH2[0][0]+temp_ROH3[0][0]+temp_RO2_1[0][0]+temp_RO2_2[0][0]++temp_RO2_3[0][0]+0.5*temp_frag[0][0]
			if(SL_sum!=0)
				f_RH=temp_RH[0][0]/SL_sum
				f_ROOH1=temp_ROOH1[0][0]/SL_sum
				f_ROOH2=temp_ROOH2[0][0]/SL_sum
				f_ROOH3=temp_ROOH3[0][0]/SL_sum
				f_ROH1=temp_ROH1[0][0]/SL_sum
				f_ROH2=temp_ROH2[0][0]/SL_sum
				f_ROH3=temp_ROH3[0][0]/SL_sum
				f_RO2_1=temp_RO2_1[0][0]/SL_sum
				f_RO2_2=temp_RO2_2[0][0]/SL_sum
				f_RO2_3=temp_RO2_3[0][0]/SL_sum
			else
				f_RH=0
				f_ROOH1=0
				f_ROOH2=0
				f_ROOH3=0
				f_ROH1=0
				f_ROH2=0
				f_ROH3=0
				f_RO2_1=0
				f_RO2_2=0
				f_RO2_3=0
			endif
			//print sl_sum,f_rh
			//This loop calculates change of concentration in term of mlc for every species in every layer at a specific time step
			for(i_layer=0;i_layer<=totallayers;i_layer+=1)
				//calculate production and loss rate in term of mlc/s for each layer
				if(i_layer==0)
					dRH_detail[i_time][0][0]=-8*Dorg*temp_RH[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_RH[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))  //mlc/s, 1e4*1e7=1e11 conversion from m2/nm to cm
					dRH_detail[i_time][0][1]=-uptake_OH*f_RH*6e4*OH_gs*layer_outer_SA[0]/4    //mlc/s
					dFrag_detail[i_time][0][0]=-8*DFrag*temp_Frag[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*DFrag*temp_Frag[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dFrag_detail[i_time][0][1]=k2*4*Prob1*temp_RO2_1[0][0]^2*layer_V[0]+k7*4*Prob2*temp_RO2_2[0][0]^2*layer_V[0]+k11*4*Prob3*temp_RO2_3[0][0]^2*layer_V[0] //factor of 4 is because 2 RO2 react leads to 2 RO and if fragments, lead to 4 fragments
					dFrag_detail[i_time][0][1]+=k6*4*Prob2*temp_RO2_1[0][0]*temp_RO2_2[0][0]*layer_V[0]+k11*4*Prob3*temp_RO2_1[0][0]*temp_RO2_3[0][0]*layer_V[0]+k11*4*Prob3*temp_RO2_2[0][0]*temp_RO2_3[0][0]*layer_V[0]
					dROOH1_detail[i_time][0][0]=-8*Dorg*temp_ROOH1[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_ROOH1[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dROOH1_detail[i_time][0][1]=uptake_HO2*f_RO2_1*4.4e4*HO2_gs*layer_outer_SA[0]/4
					dROOH1_detail[i_time][0][2]=-uptake_OH*f_ROOH1*6e4*OH_gs*layer_outer_SA[0]/4
					dROOH2_detail[i_time][0][0]=-8*Dorg*temp_ROOH2[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_ROOH2[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dROOH2_detail[i_time][0][1]=uptake_HO2*f_RO2_2*4.4e4*HO2_gs*layer_outer_SA[0]/4
					dROOH2_detail[i_time][0][2]=-uptake_OH*f_ROOH2*6e4*OH_gs*layer_outer_SA[0]/4
					dROOH3_detail[i_time][0][0]=-8*Dorg*temp_ROOH3[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_ROOH3[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dROOH3_detail[i_time][0][1]=uptake_HO2*f_RO2_3*4.4e4*HO2_gs*layer_outer_SA[0]/4
					dROOH3_detail[i_time][0][2]=-uptake_OH*f_ROOH3*6e4*OH_gs*layer_outer_SA[0]/4
					dROH1_detail[i_time][0][0]=-8*Dorg*temp_ROH1[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_ROH1[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dROH1_detail[i_time][0][1]=k2*2*(1-Prob1)*temp_RO2_1[0][0]^2*layer_V[0]
					dROH1_detail[i_time][0][2]=-uptake_OH*f_ROH1*6e4*OH_gs*layer_outer_SA[0]/4
					dROH2_detail[i_time][0][0]=-8*Dorg*temp_ROH2[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_ROH2[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dROH2_detail[i_time][0][1]=k7*2*(1-Prob2)*temp_RO2_2[0][0]^2*layer_V[0]+k6*2*(1-Prob2)*temp_RO2_2[0][0]*temp_RO2_1[0][0]*layer_V[0]
					dROH2_detail[i_time][0][2]=-uptake_OH*f_ROH2*6e4*OH_gs*layer_outer_SA[0]/4
					dROH3_detail[i_time][0][0]=-8*Dorg*temp_ROH3[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_ROH3[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dROH3_detail[i_time][0][1]=k11*2*(1-Prob3)*temp_RO2_3[0][0]^2*layer_V[0]+k11*2*(1-Prob3)*temp_RO2_1[0][0]*temp_RO2_3[0][0]*layer_V[0]+k11*2*(1-Prob3)*temp_RO2_2[0][0]*temp_RO2_3[0][0]*layer_V[0]
					dROH3_detail[i_time][0][2]=-uptake_OH*f_ROH3*6e4*OH_gs*layer_outer_SA[0]/4
					dRO2_1_detail[i_time][0][0]=-8*Dorg*temp_RO2_1[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_RO2_1[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dRO2_1_detail[i_time][0][1]=(uptake_OH*f_RH*6e4*OH_gs/4+uptake_OH*f_ROOH1*6e4*OH_gs*bratio1/4)*layer_outer_SA[0]
					dRO2_1_detail[i_time][0][2]=-uptake_HO2*f_RO2_1*4.4e4*HO2_gs*layer_outer_SA[0]/4
					dRO2_1_detail[i_time][0][3]=-k2*2*temp_RO2_1[0][0]^2*layer_V[0]-k6*temp_RO2_1[0][0]*temp_RO2_2[0][0]*layer_V[0]-k11*temp_RO2_1[0][0]*temp_RO2_3[0][0]*layer_V[0]
					dRO2_2_detail[i_time][0][0]=-8*Dorg*temp_RO2_2[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_RO2_2[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dRO2_2_detail[i_time][0][1]=(uptake_OH*f_ROOH1*6e4*OH_gs*(1-bratio1)/4+uptake_OH*f_ROOH2*6e4*OH_gs*bratio2/4+uptake_OH*f_ROH1*6e4*OH_gs/4)*layer_outer_SA[0]
					dRO2_2_detail[i_time][0][2]=-uptake_HO2*f_RO2_2*4.4e4*HO2_gs*layer_outer_SA[0]/4
					dRO2_2_detail[i_time][0][3]=-k7*2*temp_RO2_2[0][0]^2*layer_V[0]-k6*temp_RO2_1[0][0]*temp_RO2_2[0][0]*layer_V[0]-k11*temp_RO2_2[0][0]*temp_RO2_3[0][0]*layer_V[0]
					dRO2_3_detail[i_time][0][0]=-8*Dorg*temp_RO2_3[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_RO2_3[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dRO2_3_detail[i_time][0][1]=(uptake_OH*f_ROOH2*6e4*OH_gs*(1-bratio2)/4+uptake_OH*f_ROOH3*6e4*OH_gs/4+uptake_OH*f_ROH2*6e4*OH_gs/4+uptake_OH*f_ROH3*6e4*OH_gs/4)*layer_outer_SA[0]
					dRO2_3_detail[i_time][0][2]=-uptake_HO2*f_RO2_3*4.4e4*HO2_gs*layer_outer_SA[0]/4
					dRO2_3_detail[i_time][0][3]=-k11*2*temp_RO2_3[0][0]^2*layer_V[0]-k11*temp_RO2_1[0][0]*temp_RO2_3[0][0]*layer_V[0]-k11*temp_RO2_2[0][0]*temp_RO2_3[0][0]*layer_V[0]
				
				elseif(i_layer==1)  //the first layer near surface
					dRH_detail[i_time][i_layer][0]=8*Dorg*temp_RH[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_RH[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_RH[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RH[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRH_detail[i_time][i_layer][1]=0
					dFrag_detail[i_time][i_layer][0]=8*Dfrag*temp_Frag[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dfrag*temp_Frag[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dfrag*temp_Frag[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dfrag*temp_Frag[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dFrag_detail[i_time][i_layer][1]=k2*4*Prob1*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]+k7*4*Prob2*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]+k11*4*Prob3*temp_RO2_3[0][i_layer]^2*layer_V[i_layer] //factor of 4 is because 2 RO2 react leads to 2 RO and if fragments, lead to 4 fragments
					dFrag_detail[i_time][i_layer][1]+=k6*4*Prob2*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]+k11*4*Prob3*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]+k11*4*Prob3*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dROOH1_detail[i_time][i_layer][0]=8*Dorg*temp_ROOH1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_ROOH1[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_ROOH1[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROOH1[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROOH1_detail[i_time][i_layer][1]=0
					dROOH1_detail[i_time][i_layer][2]=0
					dROOH2_detail[i_time][i_layer][0]=8*Dorg*temp_ROOH2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_ROOH2[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_ROOH2[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROOH2[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROOH2_detail[i_time][i_layer][1]=0
					dROOH2_detail[i_time][i_layer][2]=0
					dROOH3_detail[i_time][i_layer][0]=8*Dorg*temp_ROOH3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_ROOH3[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_ROOH3[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROOH3[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROOH3_detail[i_time][i_layer][1]=0
					dROOH3_detail[i_time][i_layer][2]=0
					dROH1_detail[i_time][i_layer][0]=8*Dorg*temp_ROH1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_ROH1[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_ROH1[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROH1[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROH1_detail[i_time][i_layer][1]=k2*2*(1-Prob1)*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]
					dROH1_detail[i_time][i_layer][2]=0
					dROH2_detail[i_time][i_layer][0]=8*Dorg*temp_ROH2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_ROH2[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_ROH2[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROH2[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROH2_detail[i_time][i_layer][1]=k7*2*(1-Prob2)*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]+k6*2*(1-Prob2)*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]
					dROH2_detail[i_time][i_layer][2]=0
					dROH3_detail[i_time][i_layer][0]=8*Dorg*temp_ROH3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_ROH3[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_ROH3[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROH3[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROH3_detail[i_time][i_layer][1]=k11*2*(1-Prob3)*temp_RO2_3[0][i_layer]^2*layer_V[i_layer]+k11*2*(1-Prob3)*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]+k11*2*(1-Prob3)*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dROH3_detail[i_time][i_layer][2]=0
					dRO2_1_detail[i_time][i_layer][0]=8*Dorg*temp_RO2_1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_RO2_1[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_RO2_1[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RO2_1[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRO2_1_detail[i_time][i_layer][1]=0
					dRO2_1_detail[i_time][i_layer][2]=0
					dRO2_1_detail[i_time][i_layer][3]=-k2*2*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]-k6*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dRO2_2_detail[i_time][i_layer][0]=8*Dorg*temp_RO2_2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_RO2_2[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_RO2_2[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RO2_2[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRO2_2_detail[i_time][i_layer][1]=0
					dRO2_2_detail[i_time][i_layer][2]=0
					dRO2_2_detail[i_time][i_layer][3]=-k7*2*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]-k6*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dRO2_3_detail[i_time][i_layer][0]=8*Dorg*temp_RO2_3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_RO2_3[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_RO2_3[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RO2_3[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRO2_3_detail[i_time][i_layer][1]=0
					dRO2_3_detail[i_time][i_layer][2]=0
					dRO2_3_detail[i_time][i_layer][3]=-k11*2*temp_RO2_3[0][i_layer]^2*layer_V[i_layer]-k11*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]					
				elseif(i_layer==totallayers)   //center bulk of the particle
					dRH_detail[i_time][i_layer][0]=-4*Dorg*temp_RH[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RH[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dRH_detail[i_time][i_layer][1]=0   //no loss from RH+OH
					dFrag_detail[i_time][i_layer][0]=-4*Dfrag*temp_Frag[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dfrag*temp_Frag[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dFrag_detail[i_time][i_layer][1]=k2*4*Prob1*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]+k7*4*Prob2*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]+k11*4*Prob3*temp_RO2_3[0][i_layer]^2*layer_V[i_layer] //factor of 4 is because 2 RO2 react leads to 2 RO and if fragments, lead to 4 fragments
					dFrag_detail[i_time][i_layer][1]+=k6*4*Prob2*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]+k11*4*Prob3*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]+k11*4*Prob3*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dROOH1_detail[i_time][i_layer][0]=-4*Dorg*temp_ROOH1[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROOH1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dROOH1_detail[i_time][i_layer][1]=0    //no production from RO2+HO2 which happens only at surface
					dROOH1_detail[i_time][i_layer][2]=0    //no loss due to ROOH+OH
					dROOH2_detail[i_time][i_layer][0]=-4*Dorg*temp_ROOH2[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROOH2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dROOH2_detail[i_time][i_layer][1]=0    //no production from RO2+HO2 which happens only at surface
					dROOH2_detail[i_time][i_layer][2]=0    //no loss due to ROOH+OH
					dROOH3_detail[i_time][i_layer][0]=-4*Dorg*temp_ROOH3[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROOH3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dROOH3_detail[i_time][i_layer][1]=0    //no production from RO2+HO2 which happens only at surface
					dROOH3_detail[i_time][i_layer][2]=0    //no loss due to ROOH+OH
					dROH1_detail[i_time][i_layer][0]=-4*Dorg*temp_ROH1[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROH1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dROH1_detail[i_time][i_layer][1]=k2*2*(1-Prob1)*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]
					dROH1_detail[i_time][i_layer][2]=0    //no loss due to ROH+OH
					dROH2_detail[i_time][i_layer][0]=-4*Dorg*temp_ROH2[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROH2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dROH2_detail[i_time][i_layer][1]=k7*2*(1-Prob2)*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]+k6*2*(1-Prob2)*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]
					dROH2_detail[i_time][i_layer][2]=0 
					dROH3_detail[i_time][i_layer][0]=-4*Dorg*temp_ROH3[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROH3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dROH3_detail[i_time][i_layer][1]=k11*2*(1-Prob3)*temp_RO2_3[0][i_layer]^2*layer_V[i_layer]+k11*2*(1-Prob3)*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]+k11*2*(1-Prob3)*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dROH3_detail[i_time][i_layer][2]=0 
					dRO2_1_detail[i_time][i_layer][0]=-4*Dorg*temp_RO2_1[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RO2_1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dRO2_1_detail[i_time][i_layer][1]=0    // no production from org+OH
					dRO2_1_detail[i_time][i_layer][2]=0	//no loss due to RO2+HO2
					dRO2_1_detail[i_time][i_layer][3]=-k2*2*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]-k6*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dRO2_2_detail[i_time][i_layer][0]=-4*Dorg*temp_RO2_2[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RO2_2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dRO2_2_detail[i_time][i_layer][1]=0    // no production from org+OH
					dRO2_2_detail[i_time][i_layer][2]=0	//no loss due to RO2+HO2
					dRO2_2_detail[i_time][i_layer][3]=-k7*2*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]-k6*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dRO2_3_detail[i_time][i_layer][0]=-4*Dorg*temp_RO2_3[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RO2_3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dRO2_3_detail[i_time][i_layer][1]=0    // no production from org+OH
					dRO2_3_detail[i_time][i_layer][2]=0	//no loss due to RO2+HO2
					dRO2_3_detail[i_time][i_layer][3]=-k11*2*temp_RO2_3[0][i_layer]^2*layer_V[i_layer]-k11*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]			
				else  //layers that are not surface nor center
					dRH_detail[i_time][i_layer][0]=-4*Dorg*temp_RH[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RH[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_RH[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RH[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRH_detail[i_time][i_layer][1]=0
					dFrag_detail[i_time][i_layer][0]=-4*Dfrag*temp_Frag[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dfrag*temp_Frag[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dfrag*temp_Frag[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dfrag*temp_Frag[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dFrag_detail[i_time][i_layer][1]=k2*4*Prob1*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]+k7*4*Prob2*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]+k11*4*Prob3*temp_RO2_3[0][i_layer]^2*layer_V[i_layer] //factor of 4 is because 2 RO2 react leads to 2 RO and if fragments, lead to 4 fragments
					dFrag_detail[i_time][i_layer][1]+=k6*4*Prob2*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]+k11*4*Prob3*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]+k11*4*Prob3*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dROOH1_detail[i_time][i_layer][0]=-4*Dorg*temp_ROOH1[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROOH1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_ROOH1[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROOH1[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROOH1_detail[i_time][i_layer][1]=0
					dROOH1_detail[i_time][i_layer][2]=0
					dROOH2_detail[i_time][i_layer][0]=-4*Dorg*temp_ROOH2[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROOH2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_ROOH2[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROOH2[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROOH2_detail[i_time][i_layer][1]=0
					dROOH2_detail[i_time][i_layer][2]=0
					dROOH3_detail[i_time][i_layer][0]=-4*Dorg*temp_ROOH3[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROOH3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_ROOH3[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROOH3[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROOH3_detail[i_time][i_layer][1]=0
					dROOH3_detail[i_time][i_layer][2]=0
					dROH1_detail[i_time][i_layer][0]=-4*Dorg*temp_ROH1[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROH1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_ROH1[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROH1[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROH1_detail[i_time][i_layer][1]=k2*2*(1-Prob1)*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]
					dROH1_detail[i_time][i_layer][2]=0
					dROH2_detail[i_time][i_layer][0]=-4*Dorg*temp_ROH2[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROH2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_ROH2[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROH2[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROH2_detail[i_time][i_layer][1]=k7*2*(1-Prob2)*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]+k6*2*(1-Prob2)*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]
					dROH2_detail[i_time][i_layer][2]=0
					dROH3_detail[i_time][i_layer][0]=-4*Dorg*temp_ROH3[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROH3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_ROH3[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROH3[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROH3_detail[i_time][i_layer][1]=k11*2*(1-Prob3)*temp_RO2_3[0][i_layer]^2*layer_V[i_layer]+k11*2*(1-Prob3)*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]+k11*2*(1-Prob3)*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dROH3_detail[i_time][i_layer][2]=0
					dRO2_1_detail[i_time][i_layer][0]=-4*Dorg*temp_RO2_1[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RO2_1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_RO2_1[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RO2_1[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRO2_1_detail[i_time][i_layer][1]=0
					dRO2_1_detail[i_time][i_layer][2]=0
					dRO2_1_detail[i_time][i_layer][3]=-k2*2*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]-k6*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dRO2_2_detail[i_time][i_layer][0]=-4*Dorg*temp_RO2_2[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RO2_2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_RO2_2[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RO2_2[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRO2_2_detail[i_time][i_layer][1]=0
					dRO2_2_detail[i_time][i_layer][2]=0
					dRO2_2_detail[i_time][i_layer][3]=-k7*2*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]-k6*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dRO2_3_detail[i_time][i_layer][0]=-4*Dorg*temp_RO2_3[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RO2_3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_RO2_3[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RO2_3[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRO2_3_detail[i_time][i_layer][1]=0
					dRO2_3_detail[i_time][i_layer][2]=0
					dRO2_3_detail[i_time][i_layer][3]=-k11*2*temp_RO2_3[0][i_layer]^2*layer_V[i_layer]-k11*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]	
				endif
					dRH_detail[i_time][i_layer][0]*=smallest_timestep   //mlc
					dRH_detail[i_time][i_layer][1]*=smallest_timestep
					dFrag_detail[i_time][i_layer][0]*=smallest_timestep
					dFrag_detail[i_time][i_layer][1]*=smallest_timestep
					dROOH1_detail[i_time][i_layer][0]*=smallest_timestep
					dROOH1_detail[i_time][i_layer][1]*=smallest_timestep
					dROOH1_detail[i_time][i_layer][2]*=smallest_timestep
					dROOH2_detail[i_time][i_layer][0]*=smallest_timestep
					dROOH2_detail[i_time][i_layer][1]*=smallest_timestep
					dROOH2_detail[i_time][i_layer][2]*=smallest_timestep
					dROOH3_detail[i_time][i_layer][0]*=smallest_timestep
					dROOH3_detail[i_time][i_layer][1]*=smallest_timestep
					dROOH3_detail[i_time][i_layer][2]*=smallest_timestep
					dROH1_detail[i_time][i_layer][0]*=smallest_timestep
					dROH1_detail[i_time][i_layer][1]*=smallest_timestep
					dROH1_detail[i_time][i_layer][2]*=smallest_timestep
					dROH2_detail[i_time][i_layer][0]*=smallest_timestep
					dROH2_detail[i_time][i_layer][1]*=smallest_timestep
					dROH2_detail[i_time][i_layer][2]*=smallest_timestep
					dROH3_detail[i_time][i_layer][0]*=smallest_timestep
					dROH3_detail[i_time][i_layer][1]*=smallest_timestep
					dROH3_detail[i_time][i_layer][2]*=smallest_timestep
					dRO2_1_detail[i_time][i_layer][0]*=smallest_timestep
					dRO2_1_detail[i_time][i_layer][1]*=smallest_timestep
					dRO2_1_detail[i_time][i_layer][2]*=smallest_timestep
					dRO2_1_detail[i_time][i_layer][3]*=smallest_timestep
					dRO2_2_detail[i_time][i_layer][0]*=smallest_timestep
					dRO2_2_detail[i_time][i_layer][1]*=smallest_timestep
					dRO2_2_detail[i_time][i_layer][2]*=smallest_timestep
					dRO2_2_detail[i_time][i_layer][3]*=smallest_timestep
					dRO2_3_detail[i_time][i_layer][0]*=smallest_timestep
					dRO2_3_detail[i_time][i_layer][1]*=smallest_timestep
					dRO2_3_detail[i_time][i_layer][2]*=smallest_timestep
					dRO2_3_detail[i_time][i_layer][3]*=smallest_timestep
					
				temp_dRH[i_layer]=dRH_detail[i_time][i_layer][0]+dRH_detail[i_time][i_layer][1]   //mlc
				temp_dFragment[i_layer]=dFrag_detail[i_time][i_layer][0]+dFrag_detail[i_time][i_layer][1]
				temp_dROOH1[i_layer]=dROOH1_detail[i_time][i_layer][0]+dROOH1_detail[i_time][i_layer][1]+dROOH1_detail[i_time][i_layer][2]
				temp_dROOH2[i_layer]=dROOH2_detail[i_time][i_layer][0]+dROOH2_detail[i_time][i_layer][1]+dROOH2_detail[i_time][i_layer][2]
				temp_dROOH3[i_layer]=dROOH3_detail[i_time][i_layer][0]+dROOH3_detail[i_time][i_layer][1]+dROOH3_detail[i_time][i_layer][2]
				temp_dROH1[i_layer]=dROH1_detail[i_time][i_layer][0]+dROH1_detail[i_time][i_layer][1]+dROH1_detail[i_time][i_layer][2]
				temp_dROH2[i_layer]=dROH2_detail[i_time][i_layer][0]+dROH2_detail[i_time][i_layer][1]+dROH2_detail[i_time][i_layer][2]
				temp_dROH3[i_layer]=dROH3_detail[i_time][i_layer][0]+dROH3_detail[i_time][i_layer][1]+dROH3_detail[i_time][i_layer][2]
				temp_dRO2_1[i_layer]=dRO2_1_detail[i_time][i_layer][0]+dRO2_1_detail[i_time][i_layer][1]+dRO2_1_detail[i_time][i_layer][2]+dRO2_1_detail[i_time][i_layer][3]
				temp_dRO2_2[i_layer]=dRO2_2_detail[i_time][i_layer][0]+dRO2_2_detail[i_time][i_layer][1]+dRO2_2_detail[i_time][i_layer][2]+dRO2_2_detail[i_time][i_layer][3]
				temp_dRO2_3[i_layer]=dRO2_3_detail[i_time][i_layer][0]+dRO2_3_detail[i_time][i_layer][1]+dRO2_3_detail[i_time][i_layer][2]+dRO2_3_detail[i_time][i_layer][3]
				
				temp_RH[1][i_layer]=temp_RH[0][i_layer]*layer_V[i_layer]+temp_dRH[i_layer]  //mlc
				temp_ROOH1[1][i_layer]=temp_ROOH1[0][i_layer]*layer_V[i_layer]+temp_dROOH1[i_layer]  //mlc
				temp_ROOH2[1][i_layer]=temp_ROOH2[0][i_layer]*layer_V[i_layer]+temp_dROOH2[i_layer]  //mlc
				temp_ROOH3[1][i_layer]=temp_ROOH3[0][i_layer]*layer_V[i_layer]+temp_dROOH3[i_layer]  //mlc
				temp_ROH1[1][i_layer]=temp_ROH1[0][i_layer]*layer_V[i_layer]+temp_dROH1[i_layer]  //mlc
				temp_ROH2[1][i_layer]=temp_ROH2[0][i_layer]*layer_V[i_layer]+temp_dROH2[i_layer]  //mlc
				temp_ROH3[1][i_layer]=temp_ROH3[0][i_layer]*layer_V[i_layer]+temp_dROH3[i_layer]  //mlc
				temp_RO2_1[1][i_layer]=temp_RO2_1[0][i_layer]*layer_V[i_layer]+temp_dRO2_1[i_layer]  //mlc
				temp_RO2_2[1][i_layer]=temp_RO2_2[0][i_layer]*layer_V[i_layer]+temp_dRO2_2[i_layer]  //mlc
				temp_RO2_3[1][i_layer]=temp_RO2_3[0][i_layer]*layer_V[i_layer]+temp_dRO2_3[i_layer]  //mlc
				temp_Frag[1][i_layer]=temp_Frag[0][i_layer]*layer_V[i_layer]+temp_dFragment[i_layer]  //mlc
				temp_dRO2sum+=dRO2_1_detail[i_time][i_layer][3]+dRO2_2_detail[i_time][i_layer][3]+dRO2_3_detail[i_time][i_layer][3]  //mlc
				if(temp_RH[1][i_layer]<0||temp_RO2_1[1][i_layer]<0||temp_RO2_2[1][i_layer]<0||temp_RO2_3[1][i_layer]<0||temp_ROOH1[1][i_layer]<0||temp_ROOH2[1][i_layer]<0||temp_ROOH3[1][i_layer]<0||temp_ROH1[1][i_layer]<0||temp_ROH2[1][i_layer]<0||temp_ROH3[1][i_layer]<0||temp_Frag[1][i_layer]<0)
					print "Report negative values at"
					print num2str(i_time*timestep+j_time*smallest_timestep)+" s"
					print "layer "+num2str(i_layer)
					abort
				endif
								
			endfor
			//stores information of change rate
			if(j_time==1)
				for(i_layer=0;i_layer<=totallayers;i_layer+=1)
					dRH[i_time][i_layer]=temp_dRH[i_layer]/smallest_timestep/layer_v[i_layer]      //mlc/cm3/s
					dROOH1[i_time][i_layer]=temp_dROOH1[i_layer]/smallest_timestep/layer_v[i_layer] 
					dROOH2[i_time][i_layer]=temp_dROOH2[i_layer]/smallest_timestep/layer_v[i_layer] 
					dROOH3[i_time][i_layer]=temp_dROOH3[i_layer]/smallest_timestep/layer_v[i_layer] 
					dROH1[i_time][i_layer]=temp_dROH1[i_layer]/smallest_timestep/layer_v[i_layer]
					dROH2[i_time][i_layer]=temp_dROH2[i_layer]/smallest_timestep/layer_v[i_layer]
					dROH3[i_time][i_layer]=temp_dROH3[i_layer]/smallest_timestep/layer_v[i_layer] 
					dRO2_1[i_time][i_layer]=temp_dRO2_1[i_layer]/smallest_timestep/layer_v[i_layer] 
					dRO2_2[i_time][i_layer]=temp_dRO2_2[i_layer]/smallest_timestep/layer_v[i_layer] 
					dRO2_3[i_time][i_layer]=temp_dRO2_3[i_layer]/smallest_timestep/layer_v[i_layer] 
					dFragment[i_time][i_layer]=temp_dfragment[i_layer]/smallest_timestep/layer_v[i_layer] 
				endfor
				SL_dRO2HO2[i_time]=(dRO2_1_detail[i_time][0][2]+dRO2_2_detail[i_time][0][2]+dRO2_3_detail[i_time][0][2])/smallest_timestep/layer_V[0]   //mlc/cm3/s
				SL_dRO2RO2[i_time]=(dRO2_1_detail[i_time][0][3]+dRO2_2_detail[i_time][0][3]+dRO2_3_detail[i_time][0][3])/smallest_timestep/layer_V[0]
				SL_dRO2P[i_time]=(dRO2_1_detail[i_time][0][1]+dRO2_2_detail[i_time][0][1]+dRO2_3_detail[i_time][0][1])/smallest_timestep/layer_V[0]
				SL_dRO2Dif[i_time]=(dRO2_1_detail[i_time][0][0]+dRO2_2_detail[i_time][0][0]+dRO2_3_detail[i_time][0][0])/smallest_timestep/layer_v[0]
				temp_sum_ro2=0
				temp_sum_layerv=0
				for(i_layer=1;i_layer<=totallayers;i_layer+=1)
					temp_sum_ro2+=dRO2_1_detail[i_time][i_layer][3]+dRO2_2_detail[i_time][i_layer][3]+dRO2_3_detail[i_time][i_layer][3]   //mlc
					temp_sum_layerv+=layer_V[i_layer]   //cm3
				endfor
				Bulkavg_dRO2RO2[i_time]=temp_sum_ro2/temp_sum_layerv/smallest_timestep   //mlc/cm3/s
				SL_frag[i_time]=0.5*temp_frag[1][0]
				SL_dFragP[i_time]=dFrag_detail[i_time][0][1]/smallest_timestep/layer_v[0]
				SL_dFragDif[i_time]=dFrag_detail[i_time][0][0]/smallest_timestep/layer_v[0]
				if(i_time<totaltimesteps-1)
					Evaporation[i_time+1]=Evaporation[i_time]
				endif
			endif
			//This is where evaporation happens
			temp_VFR[1]=temp_VFR[0]-0.5*temp_Frag[1][0]/Corg_mlc_initial   //2 fragments=1 RO2
			temp_Dp[1]=Dp*(temp_VFR[1])^(1/3)
			volume_removed[0]=pi*(temp_Dp[0]^3-temp_Dp[1]^3)*1e-21/6   //cm3
			if(i_time<totaltimesteps-1)
				Evaporation[i_time+1]+=0.5*temp_Frag[1][0]  //mlc
			endif
			temp_Frag[1][0]=0
			calculateLayerVolume(temp_Dp[0],totallayers,SL_depth,layer_V_pre)   //returns in unit cm3
			CalculateLayerVolume(temp_Dp[1],totallayers,SL_depth,layer_V)  //cm2
			temp_ratio=(dRO2_1_detail[i_time][0][2]+dRO2_2_detail[i_time][0][2]+dRO2_3_detail[i_time][0][2])/temp_dRO2sum
			
			//Redistribute mlc in the particle based on new diameter
			for(i_layer=0;i_layer<=totallayers;i_layer+=1)
				if(i_layer==0)
					volume_added[i_layer]=layer_V[i_layer]-layer_V_pre[i_layer]+volume_removed[i_layer]
					temp_RH_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RH[1][i_layer+1]   //mlc
					temp_ROOH1_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROOH1[1][i_layer+1]
					temp_ROOH2_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROOH2[1][i_layer+1]
					temp_ROOH3_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROOH3[1][i_layer+1]
					temp_ROH1_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROH1[1][i_layer+1]
					temp_ROH2_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROH2[1][i_layer+1]
					temp_ROH3_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROH3[1][i_layer+1]
					temp_RO2_1_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RO2_1[1][i_layer+1]
					temp_RO2_2_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RO2_2[1][i_layer+1]
					temp_RO2_3_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RO2_3[1][i_layer+1]
					temp_Frag_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_Frag[1][i_layer+1]
					
					temp_RH[1][i_layer]=(temp_RH[1][i_layer]+temp_RH_redis[0][i_layer])/layer_V[i_layer]   //mlc/cm3
					temp_ROOH1[1][i_layer]=(temp_ROOH1[1][i_layer]+temp_ROOH1_redis[0][i_layer])/layer_V[i_layer]  //mlc/cm3
					temp_ROOH2[1][i_layer]=(temp_ROOH2[1][i_layer]+temp_ROOH2_redis[0][i_layer])/layer_V[i_layer]
					temp_ROOH3[1][i_layer]=(temp_ROOH3[1][i_layer]+temp_ROOH3_redis[0][i_layer])/layer_V[i_layer]
					temp_ROH1[1][i_layer]=(temp_ROH1[1][i_layer]+temp_ROH1_redis[0][i_layer])/layer_V[i_layer]   //mlc/cm3
					temp_ROH2[1][i_layer]=(temp_ROH2[1][i_layer]+temp_ROH2_redis[0][i_layer])/layer_V[i_layer] 
					temp_ROH3[1][i_layer]=(temp_ROH3[1][i_layer]+temp_ROH3_redis[0][i_layer])/layer_V[i_layer] 
					temp_RO2_1[1][i_layer]=(temp_RO2_1[1][i_layer]+temp_RO2_1_redis[0][i_layer])/layer_V[i_layer]   //mlc/cm3
					temp_RO2_2[1][i_layer]=(temp_RO2_2[1][i_layer]+temp_RO2_2_redis[0][i_layer])/layer_V[i_layer]
					temp_RO2_3[1][i_layer]=(temp_RO2_3[1][i_layer]+temp_RO2_3_redis[0][i_layer])/layer_V[i_layer]
					temp_Frag[1][i_layer]=(temp_Frag[1][i_layer]+temp_Frag_redis[0][i_layer])/layer_V[i_layer]   //mlc/cm3
				elseif(i_layer==totallayers)
					volume_removed[i_layer]=volume_added[i_layer-1]
					volume_added[i_layer]=layer_V[i_layer]-layer_V_pre[i_layer]+volume_removed[i_layer]
					temp_RH_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RH[1][i_layer]
					temp_ROOH1_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROOH1[1][i_layer]
					temp_ROOH2_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROOH2[1][i_layer]
					temp_ROOH3_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROOH3[1][i_layer]
					temp_ROH1_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROH1[1][i_layer]
					temp_ROH2_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROH2[1][i_layer]
					temp_ROH3_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROH3[1][i_layer]
					temp_RO2_1_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RO2_1[1][i_layer]
					temp_RO2_2_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RO2_2[1][i_layer]
					temp_RO2_3_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RO2_3[1][i_layer]
					temp_Frag_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_Frag[1][i_layer]
					
					temp_RH[1][i_layer]=(temp_RH[1][i_layer]-temp_RH_redis[1][i_layer])/layer_V[i_layer]   //mlc/cm3
					temp_ROOH1[1][i_layer]=(temp_ROOH1[1][i_layer]-temp_ROOH1_redis[1][i_layer])/layer_V[i_layer]  //mlc/cm3
					temp_ROOH2[1][i_layer]=(temp_ROOH2[1][i_layer]-temp_ROOH2_redis[1][i_layer])/layer_V[i_layer]
					temp_ROOH3[1][i_layer]=(temp_ROOH3[1][i_layer]-temp_ROOH3_redis[1][i_layer])/layer_V[i_layer]
					temp_ROH1[1][i_layer]=(temp_ROH1[1][i_layer]-temp_ROH1_redis[1][i_layer])/layer_V[i_layer]   //mlc/cm3
					temp_ROH2[1][i_layer]=(temp_ROH2[1][i_layer]-temp_ROH2_redis[1][i_layer])/layer_V[i_layer]
					temp_ROH3[1][i_layer]=(temp_ROH3[1][i_layer]-temp_ROH3_redis[1][i_layer])/layer_V[i_layer]
					temp_RO2_1[1][i_layer]=(temp_RO2_1[1][i_layer]-temp_RO2_1_redis[1][i_layer])/layer_V[i_layer]   //mlc/cm3
					temp_RO2_2[1][i_layer]=(temp_RO2_2[1][i_layer]-temp_RO2_2_redis[1][i_layer])/layer_V[i_layer]
					temp_RO2_3[1][i_layer]=(temp_RO2_3[1][i_layer]-temp_RO2_3_redis[1][i_layer])/layer_V[i_layer]
					temp_Frag[1][i_layer]=(temp_Frag[1][i_layer]-temp_Frag_redis[1][i_layer])/layer_V[i_layer]   //mlc/cm3
				else
					volume_removed[i_layer]=volume_added[i_layer-1]
					volume_added[i_layer]=layer_V[i_layer]-layer_V_pre[i_layer]+volume_removed[i_layer]
					temp_RH_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RH[1][i_layer+1]
					temp_ROOH1_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROOH1[1][i_layer+1]
					temp_ROOH2_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROOH2[1][i_layer+1]
					temp_ROOH3_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROOH3[1][i_layer+1]
					temp_ROH1_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROH1[1][i_layer+1]
					temp_ROH2_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROH2[1][i_layer+1]
					temp_ROH3_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROH3[1][i_layer+1]
					temp_RO2_1_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RO2_1[1][i_layer+1]
					temp_RO2_2_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RO2_2[1][i_layer+1]
					temp_RO2_3_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RO2_3[1][i_layer+1]
					temp_Frag_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_Frag[1][i_layer+1]
					temp_RH_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RH[1][i_layer]
					temp_ROOH1_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROOH1[1][i_layer]
					temp_ROOH2_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROOH2[1][i_layer]
					temp_ROOH3_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROOH3[1][i_layer]
					temp_ROH1_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROH1[1][i_layer]
					temp_ROH2_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROH2[1][i_layer]
					temp_ROH3_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROH3[1][i_layer]
					temp_RO2_1_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RO2_1[1][i_layer]
					temp_RO2_2_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RO2_2[1][i_layer]
					temp_RO2_3_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RO2_3[1][i_layer]
					temp_Frag_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_Frag[1][i_layer]
					
					temp_RH[1][i_layer]=(temp_RH[1][i_layer]+temp_RH_redis[0][i_layer]-temp_RH_redis[1][i_layer])/layer_V[i_layer] 
					temp_ROOH1[1][i_layer]=(temp_ROOH1[1][i_layer]+temp_ROOH1_redis[0][i_layer]-temp_ROOH1_redis[1][i_layer])/layer_V[i_layer]
					temp_ROOH2[1][i_layer]=(temp_ROOH2[1][i_layer]+temp_ROOH2_redis[0][i_layer]-temp_ROOH2_redis[1][i_layer])/layer_V[i_layer]
					temp_ROOH3[1][i_layer]=(temp_ROOH3[1][i_layer]+temp_ROOH3_redis[0][i_layer]-temp_ROOH3_redis[1][i_layer])/layer_V[i_layer] 
					temp_ROH1[1][i_layer]=(temp_ROH1[1][i_layer]+temp_ROH1_redis[0][i_layer]-temp_ROH1_redis[1][i_layer])/layer_V[i_layer]
					temp_ROH2[1][i_layer]=(temp_ROH2[1][i_layer]+temp_ROH2_redis[0][i_layer]-temp_ROH2_redis[1][i_layer])/layer_V[i_layer]
					temp_ROH3[1][i_layer]=(temp_ROH3[1][i_layer]+temp_ROH3_redis[0][i_layer]-temp_ROH3_redis[1][i_layer])/layer_V[i_layer] 
					temp_RO2_1[1][i_layer]=(temp_RO2_1[1][i_layer]+temp_RO2_1_redis[0][i_layer]-temp_RO2_1_redis[1][i_layer])/layer_V[i_layer]
					temp_RO2_2[1][i_layer]=(temp_RO2_2[1][i_layer]+temp_RO2_2_redis[0][i_layer]-temp_RO2_2_redis[1][i_layer])/layer_V[i_layer]
					temp_RO2_3[1][i_layer]=(temp_RO2_3[1][i_layer]+temp_RO2_3_redis[0][i_layer]-temp_RO2_3_redis[1][i_layer])/layer_V[i_layer] 
					temp_Frag[1][i_layer]=(temp_Frag[1][i_layer]+temp_Frag_redis[0][i_layer]-temp_Frag_redis[1][i_layer])/layer_V[i_layer] 
				endif
			endfor
			temp_Dp[0]=temp_Dp[1]
			temp_VFR[0]=temp_VFR[1]
		endfor
	endfor
	
	for(i_time=0;i_time<totaltimesteps;i_time+=1)
	temp_sum_mlc=mlc_RH[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][0]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_ROOH1[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][1]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_ROOH2[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][2]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_ROOH3[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][3]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_ROH1[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][4]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_ROH2[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][5]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_ROH3[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][6]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_RO2_1[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][7]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_RO2_2[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][8]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_RO2_3[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][9]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_Frag[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][10]=V_sum/(VFR_38s[i_time]*initialV)/2
	endfor
	
	make/o/d/n=(totaltimesteps,totallayers+1) Sum_RH,Sum_mlc_RH
	sum_RH=C_RH+C_ROOH1+C_ROOH2+C_ROOH3+C_ROH1+C_ROH2+C_ROH3+C_RO2_1+C_RO2_2+C_RO2_3+0.5*c_frag
	sum_mlc_RH=mlc_RH+mlc_ROOH1+mlc_ROOH2+mlc_ROOH3+mlc_ROH1+mlc_ROH2+mlc_ROH3+mlc_RO2_1+mlc_RO2_2+mlc_RO2_3+0.5*mlc_frag

	string listofCwaves=wavelist("C_*",";","")
	variable numCwaves=itemsinlist(listofCwaves)
	string listofmlcwaves=wavelist("mlc_*",";","")
	variable nummlcwaves=itemsinlist(listofmlcwaves)
	
	string theWavestr
	variable nstr
	//wave theWave
	for(nstr=0;nstr<numCwaves;nstr+=1)
		theWavestr=stringfromlist(nstr,listofCwaves)
		wave theWave=$theWavestr
		Note/k theWave "This wave stores the concentration (mlc/cm3-particle) of the compound in each layer (column) and after each time step (row)"
	endfor
	
	for(nstr=0;nstr<nummlcwaves;nstr+=1)
		theWavestr=stringfromlist(nstr,listofmlcwaves)
		wave theWave=$theWavestr
		Note/k theWave "This wave stores the number of molecules of the compound in each layer (column) and after each time step (row)"
	endfor
	
	Note/k OHexposure_38s "OH exposure (mlc cm-3 s) (calculated by a fixed OH conc*timewave)"
	Note/k VFR_38s "Volume fraction remaining of particles as a function of  time at a fixed OH conc"
	Note/k timewave "time (s)"
	Note/k Evaporation "Sum of the molecules that has been evaporated in the past time steps (accumulated)"
	Note/k NewDp "Diameter of the particles (nm) as a function of time at a fixed OH conc"
	Note/k FinalConc "A 2D matrix containing the concentration of each compound (column) after each time step (row)"
		Note FinalConc "!Please refer to textwave 'CmpIndex' for the name of the compound of each column"
	make/o/t/n=(11) CmpIndex=""
	CmpIndex[0]="RH"
	CmpIndex[1]="ROOH1"
	CmpIndex[2]="ROOH2"
	CmpIndex[3]="ROOH3"
	CmpIndex[4]="ROH1"
	CmpIndex[5]="ROH2"
	CmpIndex[6]="ROH3"
	CmpIndex[7]="RO2_1"
	CmpIndex[8]="RO2_2"
	CmpIndex[9]="RO2_3"
	CmpIndex[10]="Fragment"
	Note/k CmpIndex "Index of compounds for the columns in some 2D matrices such as 'Finalconc', 'mlcAllspecies' "
	Note/k Bulkavg_RO2 "The average concentration (mlc/cm3) of all the RO2 radicals of the bulk particles as a function of time"
	Note/k SL_RO2 "The concentration (mlc/cm3) of all the RO2 radicals in the surface layer as a function of time"
	Note/k Sum_mlc_RH "Sum of the number of molecules of all the compounds (Fragment as half) in each layer (column) as a function of time (row)"
	Note/k Sum_RH "Sum of the molecular concentration (mlc/cm3) of all the compounds (Fragment as half) in each layer (column) as a function of time (row)"
	Note/k Ratio_HO2_RO2 "Ratio of RO2 loss due to HO2+RO2 reaction to RO2+RO2 reactions in the bulk as a function of time"
	
End

////////////////////////////////////////////////////////////////////////////////////////////////////////
//This function treats ROOH(hydropeoxides) and other functionalized species (lumed as ROH) differently
//Particle growth by water is considered and the growth factor (i.e. volume fraction of liquid water in the particles) is assumed constant with aging
Function OHexposure38s_3G_H2O()

	wave kkWave
	if (waveexists(kkwave)==0)
		print "Please create rate constant wave 'kkwave' first"
		abort
	endif
	
	variable Dorg=kkWave[0]
	variable Dfrag=kkWave[1]
	variable OH_gas=kkWave[2]
	variable HO2_gas=kkWave[3]
	variable uptake_OH=kkWave[6]
	variable uptake_HO2=kkWave[7]
	variable flowtime=kkWave[8]	
	variable totaltimesteps=kkWave[9]
	variable timestep=kkWave[10]
	variable stepnum=kkWave[11]
	variable smallest_timestep=kkWave[12]
	variable Dp=kkWave[13]
	variable SL_depth=kkWave[14]
	variable totallayers=kkWave[15]
	variable layerdepth=kkWave[16]
	variable Corg_initial=kkWave[19]
	variable Corg_mlc_initial=kkWave[20]
	variable prob1=kkWave[21]
	variable prob2=kkWave[22]
	variable prob3=kkWave[23]
	variable k2=kkWave[24]
	variable k6=kkWave[25]
	variable k7=kkWave[26]
	variable k11=kkWave[27]
	variable bratio1=kkWave[28]
	variable bratio2=kkWave[29]
	variable f_water_v=kkWave[54]
	variable Cwater=kkWave[55]
	variable Cwater_mlc_initial=kkWave[56]
	variable gf=kkWave[57]
	
	variable cbar_OH=610  //m/s
	variable cbar_HO2=440 //m/s
	variable D_OH=0.21e-4 //m2/s
	variable D_HO2=0.25e-4 //m2/s
	
	variable Kn_OH=6*D_OH/cbar_OH/Dp/1e-9   //dimensionless
	variable Kn_HO2=6*D_HO2/cbar_HO2/Dp/1e-9   //dimensionless
	variable Fuchs_OH=(0.75+0.28*Kn_OH)/(Kn_OH*(1+Kn_OH))  //Maybe not Fuchs... From Shiraiwa et al. ACP 2010
	variable Fuchs_HO2=(0.75+0.28*Kn_HO2)/(Kn_HO2*(1+Kn_HO2)) 
	variable Crtf_OH=1/(1+uptake_OH*Fuchs_OH)  //Correction factor of the near surface concentration to the far away concentration
	variable Crtf_HO2=1/(1+uptake_HO2*Fuchs_HO2)
	variable OH_initial=OH_gas*Crtf_OH
	variable HO2_initial=HO2_gas*Crtf_HO2
	
	variable OH_gs=OH_initial  //mlc/cm3-air
	variable HO2_gs=HO2_initial //mlc/cm3-air
	
	//stores concentration and mlc number in each layer at each big time step
	make/o/d/n=(totaltimesteps,totallayers+1) C_RH,C_ROOH1,C_ROOH2,C_ROOH3,C_ROH1,C_ROH2,C_ROH3,C_Frag,C_RO2_1,C_RO2_2,C_RO2_3,C_H2O
	make/o/d/n=(totaltimesteps,totallayers+1) mlc_RH,mlc_ROOH1,mlc_ROOH2,mlc_ROOH3,mlc_ROH1,mlc_ROH2,mlc_ROH3,mlc_RO2_1,mlc_RO2_2,mlc_RO2_3,mlc_Frag,mlc_H2O   //surface layer index is 0
	C_RH=0  
	C_ROOH1=0
	C_ROOH2=0
	C_ROOH3=0
	C_ROH1=0
	C_ROH2=0
	C_ROH3=0
	C_Frag=0
	C_RO2_1=0
	C_RO2_2=0
	C_RO2_3=0
	C_H2O=Cwater
	mlc_RH=0  
	mlc_ROOH1=0
	mlc_ROOH2=0
	mlc_ROOH3=0
	mlc_ROH1=0
	mlc_ROH2=0
	mlc_ROH3=0
	mlc_RO2_1=0
	mlc_RO2_2=0
	mlc_RO2_3=0
	mlc_Frag=0
	mlc_H2O=0
	
	//stores concentration or mlc number of each layer for past and current time steps only
	make/o/d/n=(2,totallayers+1)/Free temp_RH,temp_ROOH1,temp_ROOH2,temp_ROOH3,temp_ROH1,temp_ROH2,temp_ROH3,temp_Frag,temp_RO2_1,temp_RO2_2,temp_RO2_3,temp_H2O
	temp_RH=kkWave[19]  //mlc/cm3-particle   don't use Corg_mlc_initial for all the layers because it is different
	temp_ROOH1=0
	temp_ROOH2=0
	temp_ROOH3=0  
	temp_ROH1=0
	temp_ROH2=0
	temp_ROH3=0
	temp_Frag=0
	temp_RO2_1=0
	temp_RO2_2=0
	temp_RO2_3=0
	temp_H2O=kkWave[55]
	
	//stores change of mlc num in each layer for current time step
	make/o/d/n=(totallayers+1)/Free temp_dRH,temp_dROOH1,temp_dROOH2,temp_dROOH3,temp_dROH1,temp_dROH2,temp_dROH3,temp_dFragment,temp_dRO2_1,temp_dRO2_2,temp_dRO2_3,temp_dH2O
	temp_dRH=0
	temp_dROOH1=0
	temp_dROOH2=0
	temp_dROOH3=0
	temp_dROH1=0
	temp_dROH2=0
	temp_dROH3=0
	temp_dFragment=0
	temp_dRO2_1=0
	temp_dRO2_2=0
	temp_dRO2_3=0
	temp_dH2O=0
	//stores rate of change of each species at the start at every big time step
	make/o/d/n=(totaltimesteps,totallayers+1)/Free dRH,dROOH1,dROOH2,dROOH3,dROH1,dROH2,dROH3,dRO2_1,dRO2_2,dRO2_3,dFragment,dH2O
	dRH=0
	dROOH1=0
	dROOH2=0
	dROOH3=0
	dROH1=0
	dROH2=0
	dROH3=0
	dRO2_1=0
	dRO2_2=0
	dRO2_3=0
	dFragment=0
	dH2O=0
	make/o/d/n=(totaltimesteps)/Free SL_dRO2HO2,SL_dRO2RO2,Bulkavg_dRO2RO2,SL_dRO2P,SL_dRO2Dif
	SL_dro2ho2=0
	SL_dro2ro2=0
	Bulkavg_dro2ro2=0
	SL_dRO2P=0
	SL_dRO2Dif=0
	make/o/d/n=(totaltimesteps)/Free SL_dFragP,SL_dFragDif
	SL_dfragP=0
	SL_dFragDif=0
	
	//stores volume, outer surface area of each layer for current time step and volume for previous time step
	make/o/d/n=(totallayers+1)/Free layer_V,layer_outer_SA,layer_V_pre
	calculateLayerVolume(Dp,totallayers,SL_depth,layer_V)   //returns in unit cm3
	calculateLayerVolume(Dp,totallayers,SL_depth,layer_V_pre)   //returns in unit cm3
	calculateLayerouterSA(Dp,totallayers,SL_depth,layer_outer_SA)     //returns in unit cm2
	
	//stores change of mlc number that happens over redistribution of particle due to evaporation for current time step
	//layer 0 is the mlc added to a layer while layer1 is mlc removed from a layer
	make/o/d/n=(totaltimesteps,totallayers+1,2)/Free RH_redis,ROOH1_redis,ROOH2_redis,ROOH3_redis,ROH1_redis,ROH2_redis,ROH3_redis,RO2_1_redis,RO2_2_redis,RO2_3_redis,Frag_redis   //mlc
	RH_redis=0
	ROOH1_redis=0
	ROOH2_redis=0
	ROOH3_redis=0
	ROH1_redis=0
	ROH2_redis=0
	ROH3_redis=0
	RO2_1_redis=0
	RO2_2_redis=0
	RO2_3_redis=0
	frag_redis=0
	
	//stores mlc added and removed for each layer at current time step only 
	make/o/d/n=(2,totallayers+1)/Free temp_RH_redis,temp_ROOH1_redis,temp_ROOH2_redis,temp_ROOH3_redis,temp_ROH1_redis,temp_ROH2_redis,temp_ROH3_redis,temp_RO2_1_redis,temp_RO2_2_redis,temp_RO2_3_redis,temp_Frag_redis
	temp_RH_redis=0
	temp_ROOH1_redis=0
	temp_ROOH2_redis=0
	temp_ROOH3_redis=0
	temp_ROH1_redis=0
	temp_ROH2_redis=0
	temp_ROH3_redis=0
	temp_RO2_1_redis=0
	temp_RO2_2_redis=0
	temp_RO2_3_redis=0
	temp_Frag_redis=0
	
	//stores volume and outer surface area for each big time step for every layer
	make/o/d/n=(totaltimesteps,totallayers+1)/Free layer_V_t,layer_outerSA_t
	layer_V_t=0
	layer_outerSA_t=0
	
	//stores detailed mlc number change due to diffusion, chemical production and chemical loss in every layer at each big time step
	make/o/d/n=(totaltimesteps,totallayers+1,2)/Free dRH_detail,dFrag_detail   //mlc
	dRH_detail=0
	dFrag_detail=0
	make/o/d/n=(totaltimesteps,totallayers+1,3)/Free dROOH1_detail,dROOH2_detail,dROOH3_detail,dROH1_detail,dROH2_detail,dROH3_detail   //mlc
	dROOH1_detail=0
	dROOH2_detail=0
	dROOH3_detail=0
	dROH1_detail=0
	dROH2_detail=0
	dROH3_detail=0
	make/o/d/n=(totaltimesteps,totallayers+1,4)/Free dRO2_1_detail,dRO2_2_detail,dRO2_3_detail     //mlc
	dRO2_1_detail=0
	dRO2_2_detail=0
	dRO2_3_detail=0
	
	make/o/d/n=(totaltimesteps)/Free SL_Frag
	SL_frag=0
	
	//stores VFR etc 
	make/o/d/n=(totaltimesteps) VFR_38s,timewave,NewDp,ratio_HO2_RO2,Evaporation,OHexposure_38s
	VFR_38s=1
	timewave=x*flowtime/(kkwave[9]-1)
	OHexposure_38s=timewave*OH_gas
	NewDp[0]=Dp
	ratio_HO2_RO2=0
	Evaporation=0
	make/o/d/n=2/Free temp_Dp,temp_VFR
	temp_Dp=Dp
	temp_VFR=1
	
	//stores bulk averaged conc of each species at each big timestep
	make/o/d/n=(totaltimesteps,11) FinalConc  // Stores averaged concentration of each species in the order of RH, ROOH1-3, ROH1-3, RO2_1-3,Frag
	make/o/d/n=(totallayers+1)/Free temp_sum_mlc
	variable initialV=Dp^3*pi/6*1e-21  //cm3  
	variable Dp_org0,Dp_org1
	
	//stores the surface layer concentration and bulk averaged concentration of RO2
	make/o/d/n=(totaltimesteps) SL_RO2, Bulkavg_RO2   //mlc/cm3
	SL_ro2=0
	bulkavg_RO2=0
	
	variable f_RH,f_ROOH1,f_ROOH2,f_ROOH3,f_ROH1,f_ROH2,f_ROH3,f_RO2_1,f_RO2_2,f_RO2_3, f_H2O
	f_RH=1-f_water_v
	f_H2O=f_water_v
	f_ROOH1=0
	f_ROOH2=0
	f_ROOH3=0
	f_ROH1=0
	f_ROH2=0
	f_ROH3=0
	f_RO2_1=0
	f_RO2_2=0
	f_RO2_3=0
	//stores fraction of every species in the surface layer at each big time step
	make/o/d/n=(totaltimesteps,12)/Free Fraction_Matrix
	fraction_matrix[][0]=1-f_water_v    //fraction of RH
	fraction_matrix[][1]=0    //fraction of ROOH1
	fraction_matrix[][2]=0    //fraction of ROOH2
	fraction_matrix[][3]=0    //fraction of ROOH3
	fraction_matrix[][4]=0    //fraction of ROH1
	fraction_matrix[][5]=0    //fraction of ROH2
	fraction_matrix[][6]=0    //fraction of ROH3
	fraction_matrix[][7]=0    //fraction of RO2_1
	fraction_matrix[][8]=0    //fraction of RO2_2
	fraction_matrix[][9]=0    //fraction of RO2_3
	fraction_matrix[][10]=0  //fraction of Frag?
	fraction_matrix[][11]=f_water_v
	
	variable i_time,i_layer,j_time
	variable layer_r,SL_sum
	variable temp_dRO2sum, temp_ratio
	make/o/d/n=(totallayers+1)/Free volume_removed,volume_added
	temp_ratio=0
	temp_dRO2sum=0
	volume_removed=0
	volume_added=0
	
	variable temp_sum_ro2,temp_sum_layerV
	temp_sum_ro2=0
	temp_sum_layerV=0
	
	for(i_time=0;i_time<totaltimesteps;i_time+=1)
		NewDp[i_time]=temp_Dp[0]   //nm
		VFR_38s[i_time]=temp_VFR[0]
		ratio_HO2_RO2[i_time]=temp_ratio
			fraction_matrix[i_time][0]=f_RH    //fraction of RH
			fraction_matrix[i_time][1]=f_ROOH1    //fraction of ROOH1
			fraction_matrix[i_time][2]=f_ROOH2    //fraction of ROOH2
			fraction_matrix[i_time][3]=f_ROOH3    //fraction of ROOH3
			fraction_matrix[i_time][4]=f_ROH1   //fraction of ROH1
			fraction_matrix[i_time][5]=f_ROH2    //fraction of ROH2
			fraction_matrix[i_time][6]=f_ROH3    //fraction of ROH3
			fraction_matrix[i_time][7]=f_RO2_1    //fraction of RO2_1
			fraction_matrix[i_time][8]=f_RO2_2    //fraction of RO2_2
			fraction_matrix[i_time][9]=f_RO2_3    //fraction of RO2_3
			fraction_matrix[i_time][10]=0  //fraction of Frag?
			fraction_matrix[i_time][11]=f_H2O
		SL_RO2[i_time]=temp_RO2_1[1][0]+temp_RO2_2[1][0]+temp_RO2_3[1][0]
		//calculate the bulk averaged RO2  concentration
		temp_sum_ro2=0
		temp_sum_layerv=0
		for(i_layer=1;i_layer<=totallayers;i_layer+=1)
			temp_sum_RO2+=(temp_RO2_1[1][i_layer]+temp_RO2_2[1][i_layer]+temp_RO2_3[1][i_layer])*layer_V[i_layer]   //mlc
			temp_sum_layerV+=layer_V[i_layer]   //cm3
		endfor
		Bulkavg_RO2[i_time]=temp_sum_RO2/temp_sum_layerV
		//Record down concentrations etc at each big time step
		for(i_layer=0;i_layer<=totallayers;i_layer+=1)
			C_RH[i_time][i_layer]=temp_RH[1][i_layer]
			C_Frag[i_time][i_layer]=temp_Frag[1][i_layer]
			C_ROOH1[i_time][i_layer]=temp_ROOH1[1][i_layer]
			C_ROOH2[i_time][i_layer]=temp_ROOH2[1][i_layer]
			C_ROOH3[i_time][i_layer]=temp_ROOH3[1][i_layer]
			C_ROH1[i_time][i_layer]=temp_ROH1[1][i_layer]
			C_ROH2[i_time][i_layer]=temp_ROH2[1][i_layer]
			C_ROH3[i_time][i_layer]=temp_ROH3[1][i_layer]
			C_RO2_1[i_time][i_layer]=temp_RO2_1[1][i_layer]
			C_RO2_2[i_time][i_layer]=temp_RO2_2[1][i_layer]
			C_RO2_3[i_time][i_layer]=temp_RO2_3[1][i_layer]
			C_H2O[i_time][i_layer]=temp_H2O[1][i_layer]
			mlc_RH[i_time][i_layer]=temp_RH[1][i_layer]*layer_V[i_layer]
			mlc_Frag[i_time][i_layer]=temp_Frag[1][i_layer]*layer_V[i_layer]
			mlc_ROOH1[i_time][i_layer]=temp_ROOH1[1][i_layer]*layer_V[i_layer]
			mlc_ROOH2[i_time][i_layer]=temp_ROOH2[1][i_layer]*layer_V[i_layer]
			mlc_ROOH3[i_time][i_layer]=temp_ROOH3[1][i_layer]*layer_V[i_layer]
			mlc_ROH1[i_time][i_layer]=temp_ROH1[1][i_layer]*layer_V[i_layer]
			mlc_ROH2[i_time][i_layer]=temp_ROH2[1][i_layer]*layer_V[i_layer]
			mlc_ROH3[i_time][i_layer]=temp_ROH3[1][i_layer]*layer_V[i_layer]
			mlc_RO2_1[i_time][i_layer]=temp_RO2_1[1][i_layer]*layer_V[i_layer]
			mlc_RO2_2[i_time][i_layer]=temp_RO2_2[1][i_layer]*layer_V[i_layer]
			mlc_RO2_3[i_time][i_layer]=temp_RO2_3[1][i_layer]*layer_V[i_layer]
			mlc_H2O[i_time][i_layer]=temp_H2O[1][i_layer]*layer_V[i_layer]
			layer_v_t[i_time][i_layer]=layer_v[i_layer]
			layer_outerSA_t[i_time][i_layer]=layer_outer_SA[i_layer]
			RH_redis[i_time][i_layer][0]=temp_RH_redis[0][i_layer]
			ROOH1_redis[i_time][i_layer][0]=temp_ROOH1_redis[0][i_layer]
			ROOH2_redis[i_time][i_layer][0]=temp_ROOH2_redis[0][i_layer]
			ROOH3_redis[i_time][i_layer][0]=temp_ROOH3_redis[0][i_layer]
			ROH1_redis[i_time][i_layer][0]=temp_ROH1_redis[0][i_layer]
			ROH2_redis[i_time][i_layer][0]=temp_ROH2_redis[0][i_layer]
			ROH3_redis[i_time][i_layer][0]=temp_ROH3_redis[0][i_layer]
			RO2_1_redis[i_time][i_layer][0]=temp_RO2_1_redis[0][i_layer]
			RO2_2_redis[i_time][i_layer][0]=temp_RO2_2_redis[0][i_layer]
			RO2_3_redis[i_time][i_layer][0]=temp_RO2_3_redis[0][i_layer]
			Frag_redis[i_time][i_layer][0]=temp_Frag_redis[0][i_layer]
			RH_redis[i_time][i_layer][1]=temp_RH_redis[1][i_layer]
			ROOH1_redis[i_time][i_layer][1]=temp_ROOH1_redis[1][i_layer]
			ROOH2_redis[i_time][i_layer][1]=temp_ROOH2_redis[1][i_layer]
			ROOH3_redis[i_time][i_layer][1]=temp_ROOH3_redis[1][i_layer]
			ROH1_redis[i_time][i_layer][1]=temp_ROH1_redis[1][i_layer]
			ROH2_redis[i_time][i_layer][1]=temp_ROH2_redis[1][i_layer]
			ROH3_redis[i_time][i_layer][1]=temp_ROH3_redis[1][i_layer]
			RO2_1_redis[i_time][i_layer][1]=temp_RO2_1_redis[1][i_layer]
			RO2_2_redis[i_time][i_layer][1]=temp_RO2_2_redis[1][i_layer]
			RO2_3_redis[i_time][i_layer][1]=temp_RO2_3_redis[1][i_layer]
			Frag_redis[i_time][i_layer][1]=temp_Frag_redis[1][i_layer]
		endfor
		
		for(j_time=1;j_time<=stepnum;j_time+=1)
			//Calculate new layer depth based on diameter change
			layerdepth=(0.5*temp_Dp[0]-SL_depth)/totallayers   //nm
			if(layerdepth<0.4)
				//print "Decay too fast"
				//abort
			endif
			CalculateLayerVolume(temp_Dp[0],totallayers,SL_depth,layer_V)   //cm3
			CalculateLayerouterSA(temp_Dp[0],totallayers,SL_depth,layer_outer_SA)  //cm2
			//Calculate new OH and HO2 concentration near surface
			Kn_OH=6*D_OH/cbar_OH/temp_Dp[0]/1e-9   //dimensionless
			Fuchs_OH=(0.75+0.28*Kn_OH)/(Kn_OH*(1+Kn_OH))  //Maybe not Fuchs... From Shiraiwa et al. ACP 2010
			Crtf_OH=1/(1+uptake_OH*Fuchs_OH)  //Correction factor of the near surface concentration to the far away concentration
			OH_gs=OH_gas*Crtf_OH  //mlc/cm3-air
			Kn_HO2=6*D_HO2/cbar_HO2/temp_Dp[0]/1e-9   //dimensionless
			Fuchs_HO2=(0.75+0.28*Kn_HO2)/(Kn_HO2*(1+Kn_HO2))  //Maybe not Fuchs... From Shiraiwa et al. ACP 2010
			Crtf_HO2=1/(1+uptake_HO2*Fuchs_HO2)  //Correction factor of the near surface concentration to the far away concentration
			HO2_gs=HO2_gas*Crtf_HO2 //mlc/cm3-air
			
			for(i_layer=0;i_layer<=totallayers;i_layer+=1)
				temp_RH[0][i_layer]=temp_RH[1][i_layer]//mlc/cm3
				temp_ROOH1[0][i_layer]=temp_ROOH1[1][i_layer]
				temp_ROOH2[0][i_layer]=temp_ROOH2[1][i_layer]
				temp_ROOH3[0][i_layer]=temp_ROOH3[1][i_layer]
				temp_ROH1[0][i_layer]=temp_ROH1[1][i_layer]
				temp_ROH2[0][i_layer]=temp_ROH2[1][i_layer]
				temp_ROH3[0][i_layer]=temp_ROH3[1][i_layer]
				temp_RO2_1[0][i_layer]=temp_RO2_1[1][i_layer]
				temp_RO2_2[0][i_layer]=temp_RO2_2[1][i_layer]
				temp_RO2_3[0][i_layer]=temp_RO2_3[1][i_layer]
				temp_Frag[0][i_layer]=temp_Frag[1][i_layer]
				temp_H2O[0][i_layer]=temp_H2O[1][i_layer]
			endfor
			temp_dRO2sum=0
			SL_sum=temp_RH[0][0]+temp_ROOH1[0][0]+temp_ROOH2[0][0]+temp_ROOH3[0][0]+temp_ROH1[0][0]+temp_ROH2[0][0]+temp_ROH3[0][0]+temp_RO2_1[0][0]+temp_RO2_2[0][0]+temp_RO2_3[0][0]+0.5*temp_frag[0][0]
			SL_sum=SL_sum/(1-f_water_v)
			if(SL_sum!=0)
				f_RH=temp_RH[0][0]/SL_sum
				f_ROOH1=temp_ROOH1[0][0]/SL_sum
				f_ROOH2=temp_ROOH2[0][0]/SL_sum
				f_ROOH3=temp_ROOH3[0][0]/SL_sum
				f_ROH1=temp_ROH1[0][0]/SL_sum
				f_ROH2=temp_ROH2[0][0]/SL_sum
				f_ROH3=temp_ROH3[0][0]/SL_sum
				f_RO2_1=temp_RO2_1[0][0]/SL_sum
				f_RO2_2=temp_RO2_2[0][0]/SL_sum
				f_RO2_3=temp_RO2_3[0][0]/SL_sum
				//f_H2O=temp_H2O[0][0]/SL_sum
			else
				f_RH=0
				f_ROOH1=0
				f_ROOH2=0
				f_ROOH3=0
				f_ROH1=0
				f_ROH2=0
				f_ROH3=0
				f_RO2_1=0
				f_RO2_2=0
				f_RO2_3=0
				f_H2O=0
			endif
			//print sl_sum,f_rh
			//This loop calculates change of concentration in term of mlc for every species in every layer at a specific time step
			for(i_layer=0;i_layer<=totallayers;i_layer+=1)
				//calculate production and loss rate in term of mlc/s for each layer
				if(i_layer==0)
					dRH_detail[i_time][0][0]=-8*Dorg*temp_RH[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_RH[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))  //mlc/s, 1e4*1e7=1e11 conversion from m2/nm to cm
					dRH_detail[i_time][0][1]=-uptake_OH*f_RH*(cbar_OH*100)*OH_gs*layer_outer_SA[0]/4    //mlc/s
					dFrag_detail[i_time][0][0]=-8*DFrag*temp_Frag[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*DFrag*temp_Frag[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dFrag_detail[i_time][0][1]=k2*4*Prob1*temp_RO2_1[0][0]^2*layer_V[0]+k7*4*Prob2*temp_RO2_2[0][0]^2*layer_V[0]+k11*4*Prob3*temp_RO2_3[0][0]^2*layer_V[0] //factor of 4 is because 2 RO2 react leads to 2 RO and if fragments, lead to 4 fragments
					dFrag_detail[i_time][0][1]+=k6*4*Prob2*temp_RO2_1[0][0]*temp_RO2_2[0][0]*layer_V[0]+k11*4*Prob3*temp_RO2_1[0][0]*temp_RO2_3[0][0]*layer_V[0]+k11*4*Prob3*temp_RO2_2[0][0]*temp_RO2_3[0][0]*layer_V[0]
					dROOH1_detail[i_time][0][0]=-8*Dorg*temp_ROOH1[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_ROOH1[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dROOH1_detail[i_time][0][1]=uptake_HO2*f_RO2_1*(cbar_HO2*100)*HO2_gs*layer_outer_SA[0]/4
					dROOH1_detail[i_time][0][2]=-uptake_OH*f_ROOH1*(cbar_OH*100)*OH_gs*layer_outer_SA[0]/4
					dROOH2_detail[i_time][0][0]=-8*Dorg*temp_ROOH2[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_ROOH2[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dROOH2_detail[i_time][0][1]=uptake_HO2*f_RO2_2*(cbar_HO2*100)*HO2_gs*layer_outer_SA[0]/4
					dROOH2_detail[i_time][0][2]=-uptake_OH*f_ROOH2*(cbar_OH*100)*OH_gs*layer_outer_SA[0]/4
					dROOH3_detail[i_time][0][0]=-8*Dorg*temp_ROOH3[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_ROOH3[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dROOH3_detail[i_time][0][1]=uptake_HO2*f_RO2_3*(cbar_HO2*100)*HO2_gs*layer_outer_SA[0]/4
					dROOH3_detail[i_time][0][2]=-uptake_OH*f_ROOH3*(cbar_OH*100)*OH_gs*layer_outer_SA[0]/4
					dROH1_detail[i_time][0][0]=-8*Dorg*temp_ROH1[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_ROH1[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dROH1_detail[i_time][0][1]=k2*2*(1-Prob1)*temp_RO2_1[0][0]^2*layer_V[0]
					dROH1_detail[i_time][0][2]=-uptake_OH*f_ROH1*(cbar_OH*100)*OH_gs*layer_outer_SA[0]/4
					dROH2_detail[i_time][0][0]=-8*Dorg*temp_ROH2[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_ROH2[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dROH2_detail[i_time][0][1]=k7*2*(1-Prob2)*temp_RO2_2[0][0]^2*layer_V[0]+k6*2*(1-Prob2)*temp_RO2_2[0][0]*temp_RO2_1[0][0]*layer_V[0]
					dROH2_detail[i_time][0][2]=-uptake_OH*f_ROH2*(cbar_OH*100)*OH_gs*layer_outer_SA[0]/4
					dROH3_detail[i_time][0][0]=-8*Dorg*temp_ROH3[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_ROH3[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dROH3_detail[i_time][0][1]=k11*2*(1-Prob3)*temp_RO2_3[0][0]^2*layer_V[0]+k11*2*(1-Prob3)*temp_RO2_1[0][0]*temp_RO2_3[0][0]*layer_V[0]+k11*2*(1-Prob3)*temp_RO2_2[0][0]*temp_RO2_3[0][0]*layer_V[0]
					dROH3_detail[i_time][0][2]=-uptake_OH*f_ROH3*(cbar_OH*100)*OH_gs*layer_outer_SA[0]/4
					dRO2_1_detail[i_time][0][0]=-8*Dorg*temp_RO2_1[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_RO2_1[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dRO2_1_detail[i_time][0][1]=(uptake_OH*f_RH*(cbar_OH*100)*OH_gs/4+uptake_OH*f_ROOH1*(cbar_OH*100)*OH_gs*bratio1/4)*layer_outer_SA[0]
					dRO2_1_detail[i_time][0][2]=-uptake_HO2*f_RO2_1*(cbar_HO2*100)*HO2_gs*layer_outer_SA[0]/4
					dRO2_1_detail[i_time][0][3]=-k2*2*temp_RO2_1[0][0]^2*layer_V[0]-k6*temp_RO2_1[0][0]*temp_RO2_2[0][0]*layer_V[0]-k11*temp_RO2_1[0][0]*temp_RO2_3[0][0]*layer_V[0]
					dRO2_2_detail[i_time][0][0]=-8*Dorg*temp_RO2_2[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_RO2_2[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dRO2_2_detail[i_time][0][1]=(uptake_OH*f_ROOH1*(cbar_OH*100)*OH_gs*(1-bratio1)/4+uptake_OH*f_ROOH2*(cbar_OH*100)*OH_gs*bratio2/4+uptake_OH*f_ROH1*(cbar_OH*100)*OH_gs/4)*layer_outer_SA[0]
					dRO2_2_detail[i_time][0][2]=-uptake_HO2*f_RO2_2*(cbar_HO2*100)*HO2_gs*layer_outer_SA[0]/4
					dRO2_2_detail[i_time][0][3]=-k7*2*temp_RO2_2[0][0]^2*layer_V[0]-k6*temp_RO2_1[0][0]*temp_RO2_2[0][0]*layer_V[0]-k11*temp_RO2_2[0][0]*temp_RO2_3[0][0]*layer_V[0]
					dRO2_3_detail[i_time][0][0]=-8*Dorg*temp_RO2_3[0][0]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))+8*Dorg*temp_RO2_3[0][1]*layer_outer_SA[1]*1e11/(pi*(SL_depth+layerdepth))
					dRO2_3_detail[i_time][0][1]=(uptake_OH*f_ROOH2*(cbar_OH*100)*OH_gs*(1-bratio2)/4+uptake_OH*f_ROOH3*(cbar_OH*100)*OH_gs/4+uptake_OH*f_ROH2*(cbar_OH*100)*OH_gs/4+uptake_OH*f_ROH3*(cbar_OH*100)*OH_gs/4)*layer_outer_SA[0]
					dRO2_3_detail[i_time][0][2]=-uptake_HO2*f_RO2_3*(cbar_HO2*100)*HO2_gs*layer_outer_SA[0]/4
					dRO2_3_detail[i_time][0][3]=-k11*2*temp_RO2_3[0][0]^2*layer_V[0]-k11*temp_RO2_1[0][0]*temp_RO2_3[0][0]*layer_V[0]-k11*temp_RO2_2[0][0]*temp_RO2_3[0][0]*layer_V[0]
				
				elseif(i_layer==1)  //the first layer near surface
					dRH_detail[i_time][i_layer][0]=8*Dorg*temp_RH[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_RH[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_RH[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RH[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRH_detail[i_time][i_layer][1]=0
					dFrag_detail[i_time][i_layer][0]=8*Dfrag*temp_Frag[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dfrag*temp_Frag[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dfrag*temp_Frag[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dfrag*temp_Frag[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dFrag_detail[i_time][i_layer][1]=k2*4*Prob1*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]+k7*4*Prob2*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]+k11*4*Prob3*temp_RO2_3[0][i_layer]^2*layer_V[i_layer] //factor of 4 is because 2 RO2 react leads to 2 RO and if fragments, lead to 4 fragments
					dFrag_detail[i_time][i_layer][1]+=k6*4*Prob2*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]+k11*4*Prob3*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]+k11*4*Prob3*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dROOH1_detail[i_time][i_layer][0]=8*Dorg*temp_ROOH1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_ROOH1[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_ROOH1[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROOH1[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROOH1_detail[i_time][i_layer][1]=0
					dROOH1_detail[i_time][i_layer][2]=0
					dROOH2_detail[i_time][i_layer][0]=8*Dorg*temp_ROOH2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_ROOH2[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_ROOH2[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROOH2[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROOH2_detail[i_time][i_layer][1]=0
					dROOH2_detail[i_time][i_layer][2]=0
					dROOH3_detail[i_time][i_layer][0]=8*Dorg*temp_ROOH3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_ROOH3[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_ROOH3[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROOH3[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROOH3_detail[i_time][i_layer][1]=0
					dROOH3_detail[i_time][i_layer][2]=0
					dROH1_detail[i_time][i_layer][0]=8*Dorg*temp_ROH1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_ROH1[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_ROH1[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROH1[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROH1_detail[i_time][i_layer][1]=k2*2*(1-Prob1)*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]
					dROH1_detail[i_time][i_layer][2]=0
					dROH2_detail[i_time][i_layer][0]=8*Dorg*temp_ROH2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_ROH2[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_ROH2[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROH2[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROH2_detail[i_time][i_layer][1]=k7*2*(1-Prob2)*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]+k6*2*(1-Prob2)*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]
					dROH2_detail[i_time][i_layer][2]=0
					dROH3_detail[i_time][i_layer][0]=8*Dorg*temp_ROH3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_ROH3[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_ROH3[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROH3[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROH3_detail[i_time][i_layer][1]=k11*2*(1-Prob3)*temp_RO2_3[0][i_layer]^2*layer_V[i_layer]+k11*2*(1-Prob3)*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]+k11*2*(1-Prob3)*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dROH3_detail[i_time][i_layer][2]=0
					dRO2_1_detail[i_time][i_layer][0]=8*Dorg*temp_RO2_1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_RO2_1[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_RO2_1[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RO2_1[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRO2_1_detail[i_time][i_layer][1]=0
					dRO2_1_detail[i_time][i_layer][2]=0
					dRO2_1_detail[i_time][i_layer][3]=-k2*2*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]-k6*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dRO2_2_detail[i_time][i_layer][0]=8*Dorg*temp_RO2_2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_RO2_2[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_RO2_2[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RO2_2[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRO2_2_detail[i_time][i_layer][1]=0
					dRO2_2_detail[i_time][i_layer][2]=0
					dRO2_2_detail[i_time][i_layer][3]=-k7*2*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]-k6*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dRO2_3_detail[i_time][i_layer][0]=8*Dorg*temp_RO2_3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-8*Dorg*temp_RO2_3[0][i_layer]*layer_outer_SA[i_layer]*1e11/(pi*(SL_depth+layerdepth))-4*Dorg*temp_RO2_3[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RO2_3[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRO2_3_detail[i_time][i_layer][1]=0
					dRO2_3_detail[i_time][i_layer][2]=0
					dRO2_3_detail[i_time][i_layer][3]=-k11*2*temp_RO2_3[0][i_layer]^2*layer_V[i_layer]-k11*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]					
				elseif(i_layer==totallayers)   //center bulk of the particle
					dRH_detail[i_time][i_layer][0]=-4*Dorg*temp_RH[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RH[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dRH_detail[i_time][i_layer][1]=0   //no loss from RH+OH
					dFrag_detail[i_time][i_layer][0]=-4*Dfrag*temp_Frag[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dfrag*temp_Frag[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dFrag_detail[i_time][i_layer][1]=k2*4*Prob1*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]+k7*4*Prob2*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]+k11*4*Prob3*temp_RO2_3[0][i_layer]^2*layer_V[i_layer] //factor of 4 is because 2 RO2 react leads to 2 RO and if fragments, lead to 4 fragments
					dFrag_detail[i_time][i_layer][1]+=k6*4*Prob2*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]+k11*4*Prob3*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]+k11*4*Prob3*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dROOH1_detail[i_time][i_layer][0]=-4*Dorg*temp_ROOH1[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROOH1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dROOH1_detail[i_time][i_layer][1]=0    //no production from RO2+HO2 which happens only at surface
					dROOH1_detail[i_time][i_layer][2]=0    //no loss due to ROOH+OH
					dROOH2_detail[i_time][i_layer][0]=-4*Dorg*temp_ROOH2[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROOH2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dROOH2_detail[i_time][i_layer][1]=0    //no production from RO2+HO2 which happens only at surface
					dROOH2_detail[i_time][i_layer][2]=0    //no loss due to ROOH+OH
					dROOH3_detail[i_time][i_layer][0]=-4*Dorg*temp_ROOH3[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROOH3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dROOH3_detail[i_time][i_layer][1]=0    //no production from RO2+HO2 which happens only at surface
					dROOH3_detail[i_time][i_layer][2]=0    //no loss due to ROOH+OH
					dROH1_detail[i_time][i_layer][0]=-4*Dorg*temp_ROH1[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROH1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dROH1_detail[i_time][i_layer][1]=k2*2*(1-Prob1)*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]
					dROH1_detail[i_time][i_layer][2]=0    //no loss due to ROH+OH
					dROH2_detail[i_time][i_layer][0]=-4*Dorg*temp_ROH2[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROH2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dROH2_detail[i_time][i_layer][1]=k7*2*(1-Prob2)*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]+k6*2*(1-Prob2)*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]
					dROH2_detail[i_time][i_layer][2]=0 
					dROH3_detail[i_time][i_layer][0]=-4*Dorg*temp_ROH3[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROH3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dROH3_detail[i_time][i_layer][1]=k11*2*(1-Prob3)*temp_RO2_3[0][i_layer]^2*layer_V[i_layer]+k11*2*(1-Prob3)*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]+k11*2*(1-Prob3)*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dROH3_detail[i_time][i_layer][2]=0 
					dRO2_1_detail[i_time][i_layer][0]=-4*Dorg*temp_RO2_1[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RO2_1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dRO2_1_detail[i_time][i_layer][1]=0    // no production from org+OH
					dRO2_1_detail[i_time][i_layer][2]=0	//no loss due to RO2+HO2
					dRO2_1_detail[i_time][i_layer][3]=-k2*2*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]-k6*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dRO2_2_detail[i_time][i_layer][0]=-4*Dorg*temp_RO2_2[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RO2_2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dRO2_2_detail[i_time][i_layer][1]=0    // no production from org+OH
					dRO2_2_detail[i_time][i_layer][2]=0	//no loss due to RO2+HO2
					dRO2_2_detail[i_time][i_layer][3]=-k7*2*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]-k6*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dRO2_3_detail[i_time][i_layer][0]=-4*Dorg*temp_RO2_3[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RO2_3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth
					dRO2_3_detail[i_time][i_layer][1]=0    // no production from org+OH
					dRO2_3_detail[i_time][i_layer][2]=0	//no loss due to RO2+HO2
					dRO2_3_detail[i_time][i_layer][3]=-k11*2*temp_RO2_3[0][i_layer]^2*layer_V[i_layer]-k11*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]			
				else  //layers that are not surface nor center
					dRH_detail[i_time][i_layer][0]=-4*Dorg*temp_RH[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RH[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_RH[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RH[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRH_detail[i_time][i_layer][1]=0
					dFrag_detail[i_time][i_layer][0]=-4*Dfrag*temp_Frag[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dfrag*temp_Frag[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dfrag*temp_Frag[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dfrag*temp_Frag[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dFrag_detail[i_time][i_layer][1]=k2*4*Prob1*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]+k7*4*Prob2*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]+k11*4*Prob3*temp_RO2_3[0][i_layer]^2*layer_V[i_layer] //factor of 4 is because 2 RO2 react leads to 2 RO and if fragments, lead to 4 fragments
					dFrag_detail[i_time][i_layer][1]+=k6*4*Prob2*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]+k11*4*Prob3*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]+k11*4*Prob3*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dROOH1_detail[i_time][i_layer][0]=-4*Dorg*temp_ROOH1[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROOH1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_ROOH1[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROOH1[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROOH1_detail[i_time][i_layer][1]=0
					dROOH1_detail[i_time][i_layer][2]=0
					dROOH2_detail[i_time][i_layer][0]=-4*Dorg*temp_ROOH2[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROOH2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_ROOH2[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROOH2[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROOH2_detail[i_time][i_layer][1]=0
					dROOH2_detail[i_time][i_layer][2]=0
					dROOH3_detail[i_time][i_layer][0]=-4*Dorg*temp_ROOH3[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROOH3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_ROOH3[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROOH3[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROOH3_detail[i_time][i_layer][1]=0
					dROOH3_detail[i_time][i_layer][2]=0
					dROH1_detail[i_time][i_layer][0]=-4*Dorg*temp_ROH1[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROH1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_ROH1[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROH1[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROH1_detail[i_time][i_layer][1]=k2*2*(1-Prob1)*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]
					dROH1_detail[i_time][i_layer][2]=0
					dROH2_detail[i_time][i_layer][0]=-4*Dorg*temp_ROH2[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROH2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_ROH2[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROH2[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROH2_detail[i_time][i_layer][1]=k7*2*(1-Prob2)*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]+k6*2*(1-Prob2)*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]
					dROH2_detail[i_time][i_layer][2]=0
					dROH3_detail[i_time][i_layer][0]=-4*Dorg*temp_ROH3[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_ROH3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_ROH3[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_ROH3[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dROH3_detail[i_time][i_layer][1]=k11*2*(1-Prob3)*temp_RO2_3[0][i_layer]^2*layer_V[i_layer]+k11*2*(1-Prob3)*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]+k11*2*(1-Prob3)*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dROH3_detail[i_time][i_layer][2]=0
					dRO2_1_detail[i_time][i_layer][0]=-4*Dorg*temp_RO2_1[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RO2_1[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_RO2_1[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RO2_1[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRO2_1_detail[i_time][i_layer][1]=0
					dRO2_1_detail[i_time][i_layer][2]=0
					dRO2_1_detail[i_time][i_layer][3]=-k2*2*temp_RO2_1[0][i_layer]^2*layer_V[i_layer]-k6*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dRO2_2_detail[i_time][i_layer][0]=-4*Dorg*temp_RO2_2[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RO2_2[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_RO2_2[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RO2_2[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRO2_2_detail[i_time][i_layer][1]=0
					dRO2_2_detail[i_time][i_layer][2]=0
					dRO2_2_detail[i_time][i_layer][3]=-k7*2*temp_RO2_2[0][i_layer]^2*layer_V[i_layer]-k6*temp_RO2_1[0][i_layer]*temp_RO2_2[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]
					dRO2_3_detail[i_time][i_layer][0]=-4*Dorg*temp_RO2_3[0][i_layer]*layer_outer_SA[i_layer]*1e11/pi/layerdepth+4*Dorg*temp_RO2_3[0][i_layer-1]*layer_outer_SA[i_layer]*1e11/pi/layerdepth-4*Dorg*temp_RO2_3[0][i_layer]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth+4*Dorg*temp_RO2_3[0][i_layer+1]*layer_outer_SA[i_layer+1]*1e11/pi/layerdepth
					dRO2_3_detail[i_time][i_layer][1]=0
					dRO2_3_detail[i_time][i_layer][2]=0
					dRO2_3_detail[i_time][i_layer][3]=-k11*2*temp_RO2_3[0][i_layer]^2*layer_V[i_layer]-k11*temp_RO2_1[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]-k11*temp_RO2_2[0][i_layer]*temp_RO2_3[0][i_layer]*layer_V[i_layer]	
				endif
					dRH_detail[i_time][i_layer][0]*=smallest_timestep   //mlc
					dRH_detail[i_time][i_layer][1]*=smallest_timestep
					dFrag_detail[i_time][i_layer][0]*=smallest_timestep
					dFrag_detail[i_time][i_layer][1]*=smallest_timestep
					dROOH1_detail[i_time][i_layer][0]*=smallest_timestep
					dROOH1_detail[i_time][i_layer][1]*=smallest_timestep
					dROOH1_detail[i_time][i_layer][2]*=smallest_timestep
					dROOH2_detail[i_time][i_layer][0]*=smallest_timestep
					dROOH2_detail[i_time][i_layer][1]*=smallest_timestep
					dROOH2_detail[i_time][i_layer][2]*=smallest_timestep
					dROOH3_detail[i_time][i_layer][0]*=smallest_timestep
					dROOH3_detail[i_time][i_layer][1]*=smallest_timestep
					dROOH3_detail[i_time][i_layer][2]*=smallest_timestep
					dROH1_detail[i_time][i_layer][0]*=smallest_timestep
					dROH1_detail[i_time][i_layer][1]*=smallest_timestep
					dROH1_detail[i_time][i_layer][2]*=smallest_timestep
					dROH2_detail[i_time][i_layer][0]*=smallest_timestep
					dROH2_detail[i_time][i_layer][1]*=smallest_timestep
					dROH2_detail[i_time][i_layer][2]*=smallest_timestep
					dROH3_detail[i_time][i_layer][0]*=smallest_timestep
					dROH3_detail[i_time][i_layer][1]*=smallest_timestep
					dROH3_detail[i_time][i_layer][2]*=smallest_timestep
					dRO2_1_detail[i_time][i_layer][0]*=smallest_timestep
					dRO2_1_detail[i_time][i_layer][1]*=smallest_timestep
					dRO2_1_detail[i_time][i_layer][2]*=smallest_timestep
					dRO2_1_detail[i_time][i_layer][3]*=smallest_timestep
					dRO2_2_detail[i_time][i_layer][0]*=smallest_timestep
					dRO2_2_detail[i_time][i_layer][1]*=smallest_timestep
					dRO2_2_detail[i_time][i_layer][2]*=smallest_timestep
					dRO2_2_detail[i_time][i_layer][3]*=smallest_timestep
					dRO2_3_detail[i_time][i_layer][0]*=smallest_timestep
					dRO2_3_detail[i_time][i_layer][1]*=smallest_timestep
					dRO2_3_detail[i_time][i_layer][2]*=smallest_timestep
					dRO2_3_detail[i_time][i_layer][3]*=smallest_timestep
					
				temp_dRH[i_layer]=dRH_detail[i_time][i_layer][0]+dRH_detail[i_time][i_layer][1]   //mlc
				temp_dFragment[i_layer]=dFrag_detail[i_time][i_layer][0]+dFrag_detail[i_time][i_layer][1]
				temp_dROOH1[i_layer]=dROOH1_detail[i_time][i_layer][0]+dROOH1_detail[i_time][i_layer][1]+dROOH1_detail[i_time][i_layer][2]
				temp_dROOH2[i_layer]=dROOH2_detail[i_time][i_layer][0]+dROOH2_detail[i_time][i_layer][1]+dROOH2_detail[i_time][i_layer][2]
				temp_dROOH3[i_layer]=dROOH3_detail[i_time][i_layer][0]+dROOH3_detail[i_time][i_layer][1]+dROOH3_detail[i_time][i_layer][2]
				temp_dROH1[i_layer]=dROH1_detail[i_time][i_layer][0]+dROH1_detail[i_time][i_layer][1]+dROH1_detail[i_time][i_layer][2]
				temp_dROH2[i_layer]=dROH2_detail[i_time][i_layer][0]+dROH2_detail[i_time][i_layer][1]+dROH2_detail[i_time][i_layer][2]
				temp_dROH3[i_layer]=dROH3_detail[i_time][i_layer][0]+dROH3_detail[i_time][i_layer][1]+dROH3_detail[i_time][i_layer][2]
				temp_dRO2_1[i_layer]=dRO2_1_detail[i_time][i_layer][0]+dRO2_1_detail[i_time][i_layer][1]+dRO2_1_detail[i_time][i_layer][2]+dRO2_1_detail[i_time][i_layer][3]
				temp_dRO2_2[i_layer]=dRO2_2_detail[i_time][i_layer][0]+dRO2_2_detail[i_time][i_layer][1]+dRO2_2_detail[i_time][i_layer][2]+dRO2_2_detail[i_time][i_layer][3]
				temp_dRO2_3[i_layer]=dRO2_3_detail[i_time][i_layer][0]+dRO2_3_detail[i_time][i_layer][1]+dRO2_3_detail[i_time][i_layer][2]+dRO2_3_detail[i_time][i_layer][3]
				
				temp_RH[1][i_layer]=temp_RH[0][i_layer]*layer_V[i_layer]+temp_dRH[i_layer]  //mlc
				temp_ROOH1[1][i_layer]=temp_ROOH1[0][i_layer]*layer_V[i_layer]+temp_dROOH1[i_layer]  //mlc
				temp_ROOH2[1][i_layer]=temp_ROOH2[0][i_layer]*layer_V[i_layer]+temp_dROOH2[i_layer]  //mlc
				temp_ROOH3[1][i_layer]=temp_ROOH3[0][i_layer]*layer_V[i_layer]+temp_dROOH3[i_layer]  //mlc
				temp_ROH1[1][i_layer]=temp_ROH1[0][i_layer]*layer_V[i_layer]+temp_dROH1[i_layer]  //mlc
				temp_ROH2[1][i_layer]=temp_ROH2[0][i_layer]*layer_V[i_layer]+temp_dROH2[i_layer]  //mlc
				temp_ROH3[1][i_layer]=temp_ROH3[0][i_layer]*layer_V[i_layer]+temp_dROH3[i_layer]  //mlc
				temp_RO2_1[1][i_layer]=temp_RO2_1[0][i_layer]*layer_V[i_layer]+temp_dRO2_1[i_layer]  //mlc
				temp_RO2_2[1][i_layer]=temp_RO2_2[0][i_layer]*layer_V[i_layer]+temp_dRO2_2[i_layer]  //mlc
				temp_RO2_3[1][i_layer]=temp_RO2_3[0][i_layer]*layer_V[i_layer]+temp_dRO2_3[i_layer]  //mlc
				temp_Frag[1][i_layer]=temp_Frag[0][i_layer]*layer_V[i_layer]+temp_dFragment[i_layer]  //mlc
				temp_dRO2sum+=dRO2_1_detail[i_time][i_layer][3]+dRO2_2_detail[i_time][i_layer][3]+dRO2_3_detail[i_time][i_layer][3]  //mlc
				if(temp_RH[1][i_layer]<0||temp_RO2_1[1][i_layer]<0||temp_RO2_2[1][i_layer]<0||temp_RO2_3[1][i_layer]<0||temp_ROOH1[1][i_layer]<0||temp_ROOH2[1][i_layer]<0||temp_ROOH3[1][i_layer]<0||temp_ROH1[1][i_layer]<0||temp_ROH2[1][i_layer]<0||temp_ROH3[1][i_layer]<0||temp_Frag[1][i_layer]<0)
					print "Report negative values at"
					print num2str(i_time*timestep+j_time*smallest_timestep)+" s"
					print "layer "+num2str(i_layer)
					abort
				endif
								
			endfor
			//stores information of change rate
			if(j_time==1)
				for(i_layer=0;i_layer<=totallayers;i_layer+=1)
					dRH[i_time][i_layer]=temp_dRH[i_layer]/smallest_timestep/layer_v[i_layer]      //mlc/cm3/s
					dROOH1[i_time][i_layer]=temp_dROOH1[i_layer]/smallest_timestep/layer_v[i_layer] 
					dROOH2[i_time][i_layer]=temp_dROOH2[i_layer]/smallest_timestep/layer_v[i_layer] 
					dROOH3[i_time][i_layer]=temp_dROOH3[i_layer]/smallest_timestep/layer_v[i_layer] 
					dROH1[i_time][i_layer]=temp_dROH1[i_layer]/smallest_timestep/layer_v[i_layer]
					dROH2[i_time][i_layer]=temp_dROH2[i_layer]/smallest_timestep/layer_v[i_layer]
					dROH3[i_time][i_layer]=temp_dROH3[i_layer]/smallest_timestep/layer_v[i_layer] 
					dRO2_1[i_time][i_layer]=temp_dRO2_1[i_layer]/smallest_timestep/layer_v[i_layer] 
					dRO2_2[i_time][i_layer]=temp_dRO2_2[i_layer]/smallest_timestep/layer_v[i_layer] 
					dRO2_3[i_time][i_layer]=temp_dRO2_3[i_layer]/smallest_timestep/layer_v[i_layer] 
					dFragment[i_time][i_layer]=temp_dfragment[i_layer]/smallest_timestep/layer_v[i_layer] 
				endfor
				SL_dRO2HO2[i_time]=(dRO2_1_detail[i_time][0][2]+dRO2_2_detail[i_time][0][2]+dRO2_3_detail[i_time][0][2])/smallest_timestep/layer_V[0]   //mlc/cm3/s
				SL_dRO2RO2[i_time]=(dRO2_1_detail[i_time][0][3]+dRO2_2_detail[i_time][0][3]+dRO2_3_detail[i_time][0][3])/smallest_timestep/layer_V[0]
				SL_dRO2P[i_time]=(dRO2_1_detail[i_time][0][1]+dRO2_2_detail[i_time][0][1]+dRO2_3_detail[i_time][0][1])/smallest_timestep/layer_V[0]
				SL_dRO2Dif[i_time]=(dRO2_1_detail[i_time][0][0]+dRO2_2_detail[i_time][0][0]+dRO2_3_detail[i_time][0][0])/smallest_timestep/layer_v[0]
				temp_sum_ro2=0
				temp_sum_layerv=0
				for(i_layer=1;i_layer<=totallayers;i_layer+=1)
					temp_sum_ro2+=dRO2_1_detail[i_time][i_layer][3]+dRO2_2_detail[i_time][i_layer][3]+dRO2_3_detail[i_time][i_layer][3]   //mlc
					temp_sum_layerv+=layer_V[i_layer]   //cm3
				endfor
				Bulkavg_dRO2RO2[i_time]=temp_sum_ro2/temp_sum_layerv/smallest_timestep   //mlc/cm3/s
				SL_frag[i_time]=0.5*temp_frag[1][0]
				SL_dFragP[i_time]=dFrag_detail[i_time][0][1]/smallest_timestep/layer_v[0]
				SL_dFragDif[i_time]=dFrag_detail[i_time][0][0]/smallest_timestep/layer_v[0]
				if(i_time<totaltimesteps-1)
					Evaporation[i_time+1]=Evaporation[i_time]
				endif
			endif
			//This is where evaporation happens
			//The following two equations are validated with the presence of water
			temp_VFR[1]=temp_VFR[0]-0.5*temp_Frag[1][0]/Corg_mlc_initial   //2 fragments=1 RO2
			temp_Dp[1]=Dp*(temp_VFR[1])^(1/3)  //Dp is the initial diameter of water-containing particle
			Dp_org0=temp_Dp[0]/1.1
			Dp_org1=temp_Dp[1]/1.1
			//volume_removed[0]=pi*(Dp_org0^3-Dp_org1^3)*1e-21/6   //cm3
			volume_removed[0]=pi*(temp_Dp[0]^3-temp_Dp[1]^3)*1e-21/6   //cm3
			if(i_time<totaltimesteps-1)
				Evaporation[i_time+1]+=0.5*temp_Frag[1][0]  //mlc-org
			endif
			temp_Frag[1][0]=0
			calculateLayerVolume(temp_Dp[0],totallayers,SL_depth,layer_V_pre)   //returns in unit cm3
			CalculateLayerVolume(temp_Dp[1],totallayers,SL_depth,layer_V)  //cm2
			temp_ratio=(dRO2_1_detail[i_time][0][3]+dRO2_2_detail[i_time][0][3]+dRO2_3_detail[i_time][0][3])/temp_dRO2sum
			
			//Redistribute mlc in the particle based on new diameter
			for(i_layer=0;i_layer<=totallayers;i_layer+=1)
				if(i_layer==0)
					volume_added[i_layer]=layer_V[i_layer]-layer_V_pre[i_layer]+volume_removed[i_layer]
					temp_RH_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RH[1][i_layer+1]   //mlc
					temp_ROOH1_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROOH1[1][i_layer+1]
					temp_ROOH2_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROOH2[1][i_layer+1]
					temp_ROOH3_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROOH3[1][i_layer+1]
					temp_ROH1_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROH1[1][i_layer+1]
					temp_ROH2_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROH2[1][i_layer+1]
					temp_ROH3_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROH3[1][i_layer+1]
					temp_RO2_1_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RO2_1[1][i_layer+1]
					temp_RO2_2_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RO2_2[1][i_layer+1]
					temp_RO2_3_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RO2_3[1][i_layer+1]
					temp_Frag_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_Frag[1][i_layer+1]
					
					temp_RH[1][i_layer]=(temp_RH[1][i_layer]+temp_RH_redis[0][i_layer])/layer_V[i_layer]   //mlc/cm3
					temp_ROOH1[1][i_layer]=(temp_ROOH1[1][i_layer]+temp_ROOH1_redis[0][i_layer])/layer_V[i_layer]  //mlc/cm3
					temp_ROOH2[1][i_layer]=(temp_ROOH2[1][i_layer]+temp_ROOH2_redis[0][i_layer])/layer_V[i_layer]
					temp_ROOH3[1][i_layer]=(temp_ROOH3[1][i_layer]+temp_ROOH3_redis[0][i_layer])/layer_V[i_layer]
					temp_ROH1[1][i_layer]=(temp_ROH1[1][i_layer]+temp_ROH1_redis[0][i_layer])/layer_V[i_layer]   //mlc/cm3
					temp_ROH2[1][i_layer]=(temp_ROH2[1][i_layer]+temp_ROH2_redis[0][i_layer])/layer_V[i_layer] 
					temp_ROH3[1][i_layer]=(temp_ROH3[1][i_layer]+temp_ROH3_redis[0][i_layer])/layer_V[i_layer] 
					temp_RO2_1[1][i_layer]=(temp_RO2_1[1][i_layer]+temp_RO2_1_redis[0][i_layer])/layer_V[i_layer]   //mlc/cm3
					temp_RO2_2[1][i_layer]=(temp_RO2_2[1][i_layer]+temp_RO2_2_redis[0][i_layer])/layer_V[i_layer]
					temp_RO2_3[1][i_layer]=(temp_RO2_3[1][i_layer]+temp_RO2_3_redis[0][i_layer])/layer_V[i_layer]
					temp_Frag[1][i_layer]=(temp_Frag[1][i_layer]+temp_Frag_redis[0][i_layer])/layer_V[i_layer]   //mlc/cm3
				elseif(i_layer==totallayers)
					volume_removed[i_layer]=volume_added[i_layer-1]
					volume_added[i_layer]=layer_V[i_layer]-layer_V_pre[i_layer]+volume_removed[i_layer]
					temp_RH_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RH[1][i_layer]  //mlc
					temp_ROOH1_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROOH1[1][i_layer]
					temp_ROOH2_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROOH2[1][i_layer]
					temp_ROOH3_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROOH3[1][i_layer]
					temp_ROH1_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROH1[1][i_layer]
					temp_ROH2_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROH2[1][i_layer]
					temp_ROH3_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROH3[1][i_layer]
					temp_RO2_1_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RO2_1[1][i_layer]
					temp_RO2_2_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RO2_2[1][i_layer]
					temp_RO2_3_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RO2_3[1][i_layer]
					temp_Frag_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_Frag[1][i_layer]
					
					temp_RH[1][i_layer]=(temp_RH[1][i_layer]-temp_RH_redis[1][i_layer])/layer_V[i_layer]   //mlc/cm3
					temp_ROOH1[1][i_layer]=(temp_ROOH1[1][i_layer]-temp_ROOH1_redis[1][i_layer])/layer_V[i_layer]  //mlc/cm3
					temp_ROOH2[1][i_layer]=(temp_ROOH2[1][i_layer]-temp_ROOH2_redis[1][i_layer])/layer_V[i_layer]
					temp_ROOH3[1][i_layer]=(temp_ROOH3[1][i_layer]-temp_ROOH3_redis[1][i_layer])/layer_V[i_layer]
					temp_ROH1[1][i_layer]=(temp_ROH1[1][i_layer]-temp_ROH1_redis[1][i_layer])/layer_V[i_layer]   //mlc/cm3
					temp_ROH2[1][i_layer]=(temp_ROH2[1][i_layer]-temp_ROH2_redis[1][i_layer])/layer_V[i_layer]
					temp_ROH3[1][i_layer]=(temp_ROH3[1][i_layer]-temp_ROH3_redis[1][i_layer])/layer_V[i_layer]
					temp_RO2_1[1][i_layer]=(temp_RO2_1[1][i_layer]-temp_RO2_1_redis[1][i_layer])/layer_V[i_layer]   //mlc/cm3
					temp_RO2_2[1][i_layer]=(temp_RO2_2[1][i_layer]-temp_RO2_2_redis[1][i_layer])/layer_V[i_layer]
					temp_RO2_3[1][i_layer]=(temp_RO2_3[1][i_layer]-temp_RO2_3_redis[1][i_layer])/layer_V[i_layer]
					temp_Frag[1][i_layer]=(temp_Frag[1][i_layer]-temp_Frag_redis[1][i_layer])/layer_V[i_layer]   //mlc/cm3
				else
					volume_removed[i_layer]=volume_added[i_layer-1]
					volume_added[i_layer]=layer_V[i_layer]-layer_V_pre[i_layer]+volume_removed[i_layer]
					temp_RH_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RH[1][i_layer+1]
					temp_ROOH1_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROOH1[1][i_layer+1]
					temp_ROOH2_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROOH2[1][i_layer+1]
					temp_ROOH3_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROOH3[1][i_layer+1]
					temp_ROH1_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROH1[1][i_layer+1]
					temp_ROH2_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROH2[1][i_layer+1]
					temp_ROH3_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_ROH3[1][i_layer+1]
					temp_RO2_1_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RO2_1[1][i_layer+1]
					temp_RO2_2_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RO2_2[1][i_layer+1]
					temp_RO2_3_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_RO2_3[1][i_layer+1]
					temp_Frag_redis[0][i_layer]=(volume_added[i_layer]/layer_V_pre[i_layer+1])*temp_Frag[1][i_layer+1]
					temp_RH_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RH[1][i_layer]
					temp_ROOH1_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROOH1[1][i_layer]
					temp_ROOH2_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROOH2[1][i_layer]
					temp_ROOH3_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROOH3[1][i_layer]
					temp_ROH1_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROH1[1][i_layer]
					temp_ROH2_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROH2[1][i_layer]
					temp_ROH3_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_ROH3[1][i_layer]
					temp_RO2_1_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RO2_1[1][i_layer]
					temp_RO2_2_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RO2_2[1][i_layer]
					temp_RO2_3_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_RO2_3[1][i_layer]
					temp_Frag_redis[1][i_layer]=(volume_removed[i_layer]/layer_V_pre[i_layer])*temp_Frag[1][i_layer]
					
					temp_RH[1][i_layer]=(temp_RH[1][i_layer]+temp_RH_redis[0][i_layer]-temp_RH_redis[1][i_layer])/layer_V[i_layer] 
					temp_ROOH1[1][i_layer]=(temp_ROOH1[1][i_layer]+temp_ROOH1_redis[0][i_layer]-temp_ROOH1_redis[1][i_layer])/layer_V[i_layer]
					temp_ROOH2[1][i_layer]=(temp_ROOH2[1][i_layer]+temp_ROOH2_redis[0][i_layer]-temp_ROOH2_redis[1][i_layer])/layer_V[i_layer]
					temp_ROOH3[1][i_layer]=(temp_ROOH3[1][i_layer]+temp_ROOH3_redis[0][i_layer]-temp_ROOH3_redis[1][i_layer])/layer_V[i_layer] 
					temp_ROH1[1][i_layer]=(temp_ROH1[1][i_layer]+temp_ROH1_redis[0][i_layer]-temp_ROH1_redis[1][i_layer])/layer_V[i_layer]
					temp_ROH2[1][i_layer]=(temp_ROH2[1][i_layer]+temp_ROH2_redis[0][i_layer]-temp_ROH2_redis[1][i_layer])/layer_V[i_layer]
					temp_ROH3[1][i_layer]=(temp_ROH3[1][i_layer]+temp_ROH3_redis[0][i_layer]-temp_ROH3_redis[1][i_layer])/layer_V[i_layer] 
					temp_RO2_1[1][i_layer]=(temp_RO2_1[1][i_layer]+temp_RO2_1_redis[0][i_layer]-temp_RO2_1_redis[1][i_layer])/layer_V[i_layer]
					temp_RO2_2[1][i_layer]=(temp_RO2_2[1][i_layer]+temp_RO2_2_redis[0][i_layer]-temp_RO2_2_redis[1][i_layer])/layer_V[i_layer]
					temp_RO2_3[1][i_layer]=(temp_RO2_3[1][i_layer]+temp_RO2_3_redis[0][i_layer]-temp_RO2_3_redis[1][i_layer])/layer_V[i_layer] 
					temp_Frag[1][i_layer]=(temp_Frag[1][i_layer]+temp_Frag_redis[0][i_layer]-temp_Frag_redis[1][i_layer])/layer_V[i_layer] 
				endif
			endfor
			temp_Dp[0]=temp_Dp[1]
			temp_VFR[0]=temp_VFR[1]
		endfor
	endfor
	
	for(i_time=0;i_time<totaltimesteps;i_time+=1)
	temp_sum_mlc=mlc_RH[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][0]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_ROOH1[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][1]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_ROOH2[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][2]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_ROOH3[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][3]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_ROH1[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][4]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_ROH2[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][5]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_ROH3[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][6]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_RO2_1[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][7]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_RO2_2[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][8]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_RO2_3[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][9]=V_sum/(VFR_38s[i_time]*initialV)
	temp_sum_mlc=mlc_Frag[i_time][p]
	wavestats/q temp_sum_mlc
	FinalConc[i_time][10]=V_sum/(VFR_38s[i_time]*initialV)/2
	endfor
	
	make/o/d/n=(totaltimesteps,totallayers+1) Sum_RH,Sum_mlc_RH
	sum_RH=C_RH+C_ROOH1+C_ROOH2+C_ROOH3+C_ROH1+C_ROH2+C_ROH3+C_RO2_1+C_RO2_2+C_RO2_3+0.5*c_frag
	sum_mlc_RH=mlc_RH+mlc_ROOH1+mlc_ROOH2+mlc_ROOH3+mlc_ROH1+mlc_ROH2+mlc_ROH3+mlc_RO2_1+mlc_RO2_2+mlc_RO2_3+0.5*mlc_frag
	
	string listofCwaves=wavelist("C_*",";","")
	variable numCwaves=itemsinlist(listofCwaves)
	string listofmlcwaves=wavelist("mlc_*",";","")
	variable nummlcwaves=itemsinlist(listofmlcwaves)
	
	string theWavestr
	variable nstr
	//wave theWave
	for(nstr=0;nstr<numCwaves;nstr+=1)
		theWavestr=stringfromlist(nstr,listofCwaves)
		wave theWave=$theWavestr
		Note/k theWave "This wave stores the concentration (mlc/cm3-particle) of the compound in each layer (column) and after each time step (row)"
	endfor
	
	for(nstr=0;nstr<nummlcwaves;nstr+=1)
		theWavestr=stringfromlist(nstr,listofmlcwaves)
		wave theWave=$theWavestr
		Note/k theWave "This wave stores the number of molecules of the compound in each layer (column) and after each time step (row)"
	endfor
	
	Note/k OHexposure_38s "OH exposure (mlc cm-3 s) (calculated by a fixed OH conc*timewave)"
	Note/k VFR_38s "Volume fraction remaining of particles as a function of  time at a fixed OH conc"
	Note/k timewave "time (s)"
	Note/k Evaporation "Sum of the molecules that has been evaporated in the past time steps (accumulated)"
	Note/k NewDp "Diameter of the particles (nm) as a function of time at a fixed OH conc"
	Note/k FinalConc "A 2D matrix containing the concentration of each compound (column) after each time step (row)"
		Note FinalConc "!Please refer to textwave 'CmpIndex' for the name of the compound of each column"
	make/o/t/n=(11) CmpIndex=""
	CmpIndex[0]="RH"
	CmpIndex[1]="ROOH1"
	CmpIndex[2]="ROOH2"
	CmpIndex[3]="ROOH3"
	CmpIndex[4]="ROH1"
	CmpIndex[5]="ROH2"
	CmpIndex[6]="ROH3"
	CmpIndex[7]="RO2_1"
	CmpIndex[8]="RO2_2"
	CmpIndex[9]="RO2_3"
	CmpIndex[10]="Fragment"
	Note/k CmpIndex "Index of compounds for the columns in some 2D matrices such as 'Finalconc', 'mlcAllspecies' "
	Note/k Bulkavg_RO2 "The average concentration (mlc/cm3) of all the RO2 radicals of the bulk particles as a function of time"
	Note/k SL_RO2 "The concentration (mlc/cm3) of all the RO2 radicals in the surface layer as a function of time"
	Note/k Sum_mlc_RH "Sum of the number of molecules of all the compounds (Fragment as half) in each layer (column) as a function of time (row)"
	Note/k Sum_RH "Sum of the molecular concentration (mlc/cm3) of all the compounds (Fragment as half) in each layer (column) as a function of time (row)"
	Note/k Ratio_HO2_RO2 "Ratio of RO2 loss due to HO2+RO2 reaction to RO2+RO2 reactions in the bulk as a function of time"
	
End

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
Function FullOHRange_lowRH()
	variable numOH=10
	prompt numOH, "number of OH conc to be considered"
	Doprompt "Set value", numOH
	
	CreatekkWave_3G_basic()
	wave kkwave
	
	variable OHstep=1.84e11/numOH
	
	variable i,j
	make/o/d/n=(numOH+1) OH_mlccm3
	for(i=1;i<numOH+1;i+=1)
		j=10^(log(0.1)+i*(log(numOH)-log(0.1))/numOH)
		oh_mlccm3[i]=OHstep*j
	endfor
	
	//abort
	make/o/d/n=(numOH+1,51) RO2_3_C,RO2_2_C,RO2_1_C,Frag_C,ROH3_C,ROH2_C,ROH1_C,ROOH3_C,ROOH2_C,ROOH1_C,RH_C
	make/o/d/n=(numOH+1,51) RO2_3_mlc,RO2_2_mlc,RO2_1_mlc,Frag_mlc,ROH3_mlc,ROH2_mlc,ROH1_mlc,ROOH3_mlc,ROOH2_mlc,ROOH1_mlc,RH_mlc
	make/o/d/n=(numOH+1) VFR, OHexposure, Parent_mlc, Parent_mlc_norm
	make/o/d/n=(numOH+1,11) ConcAllSpecies, mlcAllSpecies
	concallspecies=0
	mlcallspecies=0
	VFR[0]=1
	
	for(i=1;i<numOH+1;i+=1)
		kkwave[2]=oh_mlccm3[i]
		kkwave[3]=oh_mlccm3[i]
		kkwave[4]=oh_mlccm3[i]
		kkwave[5]=oh_mlccm3[i]
		OHexposure[i]=oh_mlccm3[i]*38
		OHexposure38s_3G_dry()
		wave C_RO2_3,C_RO2_2,C_RO2_1,C_Frag,C_ROH3,C_ROH2,C_ROH1,C_ROOH3,C_ROOH2,C_ROOH1,C_RH
		wave mlc_RO2_3,mlc_RO2_2,mlc_RO2_1,mlc_Frag,mlc_ROH3,mlc_ROH2,mlc_ROH1,mlc_ROOH3,mlc_ROOH2,mlc_ROOH1,mlc_RH
		wave VFR_38s,OHexposure_38s
		wave finalConc
		RO2_3_C[i][]=C_RO2_3[100][q]
		RO2_2_C[i][]=C_RO2_2[100][q]
		RO2_1_C[i][]=C_RO2_1[100][q]
		Frag_C[i][]=C_Frag[100][q]
		ROH3_C[i][]=C_ROH3[100][q]
		ROH2_C[i][]=C_ROH2[100][q]
		ROH1_C[i][]=C_ROH1[100][q]
		ROOH3_C[i][]=C_ROOH3[100][q]
		ROOH2_C[i][]=C_ROOH2[100][q]
		ROOH1_C[i][]=C_ROOH1[100][q]
		RH_C[i][]=C_RH[100][q]
		RO2_3_mlC[i][]=mlC_RO2_3[100][q]
		RO2_2_mlC[i][]=mlC_RO2_2[100][q]
		RO2_1_mlC[i][]=mlC_RO2_1[100][q]
		Frag_mlC[i][]=mlC_Frag[100][q]
		ROH3_mlC[i][]=mlC_ROH3[100][q]
		ROH2_mlC[i][]=mlC_ROH2[100][q]
		ROH1_mlC[i][]=mlC_ROH1[100][q]
		ROOH3_mlC[i][]=mlC_ROOH3[100][q]
		ROOH2_mlC[i][]=mlC_ROOH2[100][q]
		ROOH1_mlC[i][]=mlC_ROOH1[100][q]
		RH_mlC[i][]=mlC_RH[100][q]
		ConcAllspecies[i][]=finalconc[100][q]
		VFR[i]=VFR_38s[100]
		SumofEachRow(mlc_RH)
		wave sumofrows
		Parent_mlc[i]=sumofrows[100]
		mlcAllspecies[i][0]=sumofrows[100]
		SumofEachRow(mlc_ROOH1)
		mlcAllspecies[i][1]=sumofrows[100]
		SumofEachRow(mlc_ROOH2)
		mlcAllspecies[i][2]=sumofrows[100]
		SumofEachRow(mlc_ROOH3)
		mlcAllspecies[i][3]=sumofrows[100]
		SumofEachRow(mlc_ROH1)
		mlcAllspecies[i][4]=sumofrows[100]
		SumofEachRow(mlc_ROH2)
		mlcAllspecies[i][5]=sumofrows[100]
		SumofEachRow(mlc_ROH3)
		mlcAllspecies[i][6]=sumofrows[100]
		SumofEachRow(mlc_RO2_1)
		mlcAllspecies[i][7]=sumofrows[100]
		SumofEachRow(mlc_RO2_2)
		mlcAllspecies[i][8]=sumofrows[100]
		SumofEachRow(mlc_RO2_3)
		mlcAllspecies[i][9]=sumofrows[100]
		SumofEachRow(mlc_Frag)
		mlcAllspecies[i][10]=sumofrows[100]/2
	endfor
	
		RO2_3_C[0][]=C_RO2_3[0][q]
		RO2_2_C[0][]=C_RO2_2[0][q]
		RO2_1_C[0][]=C_RO2_1[0][q]
		Frag_C[0][]=C_Frag[0][q]
		ROH3_C[0][]=C_ROH3[0][q]
		ROH2_C[0][]=C_ROH2[0][q]
		ROH1_C[0][]=C_ROH1[0][q]
		ROOH3_C[0][]=C_ROOH3[0][q]
		ROOH2_C[0][]=C_ROOH2[0][q]
		ROOH1_C[0][]=C_ROOH1[0][q]
		RH_C[0][]=C_RH[0][q]
		RO2_3_mlC[0][]=mlC_RO2_3[0][q]
		RO2_2_mlC[0][]=mlC_RO2_2[0][q]
		RO2_1_mlC[0][]=mlC_RO2_1[0][q]
		Frag_mlC[0][]=mlC_Frag[0][q]
		ROH3_mlC[0][]=mlC_ROH3[0][q]
		ROH2_mlC[0][]=mlC_ROH2[0][q]
		ROH1_mlC[0][]=mlC_ROH1[0][q]
		ROOH3_mlC[0][]=mlC_ROOH3[0][q]
		ROOH2_mlC[0][]=mlC_ROOH2[0][q]
		ROOH1_mlC[0][]=mlC_ROOH1[0][q]
		RH_mlC[0][]=mlC_RH[0][q]
		ConcAllspecies[0][]=finalconc[0][q]
		SumofEachRow(mlc_RH)
		Parent_mlc[0]=sumofrows[0]
		mlcallspecies[0][0]=sumofrows[0]
		Parent_mlc_norm=parent_mlc[p]/parent_mlc[0]
		
	//Delete all the waves that were used to only store information for a fixed OH conc	 (as opposed to varying OH conc)
	killwaves C_RO2_3,C_RO2_2,C_RO2_1,C_Frag,C_ROH3,C_ROH2,C_ROH1,C_ROOH3,C_ROOH2,C_ROOH1,C_RH
	killwaves mlC_RO2_3,mlC_RO2_2,mlC_RO2_1,mlC_Frag,mlC_ROH3,mlC_ROH2,mlC_ROH1,mlC_ROOH3,mlC_ROOH2,mlC_ROOH1,mlC_RH
	killwaves OHexposure_38s,VFR_38s,evaporation,timewave,NewDp,ratio_HO2_RO2,sum_mlc_RH,sum_RH,Bulkavg_RO2,SL_RO2,finalconc
	
	make/o/d/n=(numOH+1,11) FractionAllSpecies
	SumofEachRow(mlcAllspecies)
	fractionallspecies=mlcallspecies[p][q]/sumofrows[p]
	
	R2foroxidizedvsnon(concallspecies)
	
	killwaves sumofrows
	
	Note/k OH_mlccm3 "OH conc (mlc/cm3)"
	Note/k OHexposure "OH exposure (mlc cm-3 s) calculated by OH_mlccm3*38s"
	Note/k VFR "volume fraction remaining of particles as a function of OH conc (* fixed time)"
	Note/k Parent_mlc "Number of molecues of parent species (RH) in the particles as a function OH conc"
	Note/k Parent_mlc_norm "Number of molecues of parent species (RH) in the particles as a function OH conc normalized to initial molecule number (at OH conc=0)"
	Note/k mlcAllspecies "A 2D matrix containing the number of molecules of each compound (column) at each OH conc (row)"
		Note mlcAllspecies "!Please refer to textwave 'CmpIndex' for the name of the compound of each column"
	Note/k ConcAllspecies "A 2D matrix containing the molecule concentration of each compound (column) at each OH conc (row)"
		Note ConcAllspecies "!Please refer to textwave 'CmpIndex' for the name of the compound of each column"
	Note/k FractionAllspecies "A 2D matrix containing the fraction of each compound (column) at each OH conc (row)"
		Note FractionAllspecies "!Please refer to textwave 'CmpIndex' for the name of the compound of each column"
	wave R2_oxi_non
	Note/k R2_oxi_non "R2 between the concentrations of all the compounds at varying OH conc vs those at OH=0"
	
	string listofCwaves=wavelist("*_C",";","")
	variable numCwaves=itemsinlist(listofCwaves)
	string listofmlcwaves=wavelist("*_mlc",";","")
	variable nummlcwaves=itemsinlist(listofmlcwaves)
	
	string theWavestr
	variable nstr
	//wave theWave
	for(nstr=0;nstr<numCwaves;nstr+=1)
		theWavestr=stringfromlist(nstr,listofCwaves)
		wave theWave=$theWavestr
		Note/k theWave "This wave stores the concentration (mlc/cm3-particle) of the compound in each layer (column) and at each OH conc (row)"
	endfor
	
	for(nstr=0;nstr<nummlcwaves;nstr+=1)
		theWavestr=stringfromlist(nstr,listofmlcwaves)
		wave theWave=$theWavestr
		Note/k theWave "This wave stores the number of molecules of the compound in each layer (column) and after each OH conc (row)"
	endfor
	

End

//////////////////////////////////////////////////////////////////////////////////////////
Function FullOHRange_highRH()
	variable numOH=10
	prompt numOH, "number of OH conc to be considered"
	Doprompt "Set value", numOH
	
	CreatekkWave_3G_basicH2O()
	wave kkwave
	
	variable OHstep=1.84e11/numOH
	
	variable i,j
	make/o/d/n=(numOH+1) OH_mlccm3
	for(i=1;i<numOH+1;i+=1)
		j=10^(log(0.1)+i*(log(numOH)-log(0.1))/numOH)
		oh_mlccm3[i]=OHstep*j
	endfor
	
	//abort
	make/o/d/n=(numOH+1,51) RO2_3_C,RO2_2_C,RO2_1_C,Frag_C,ROH3_C,ROH2_C,ROH1_C,ROOH3_C,ROOH2_C,ROOH1_C,RH_C
	make/o/d/n=(numOH+1,51) RO2_3_mlc,RO2_2_mlc,RO2_1_mlc,Frag_mlc,ROH3_mlc,ROH2_mlc,ROH1_mlc,ROOH3_mlc,ROOH2_mlc,ROOH1_mlc,RH_mlc
	make/o/d/n=(numOH+1) VFR, OHexposure, Parent_mlc, Parent_mlc_norm
	make/o/d/n=(numOH+1,11) ConcAllSpecies, mlcAllSpecies
	VFR[0]=1
	
	for(i=1;i<numOH+1;i+=1)
		kkwave[2]=oh_mlccm3[i]
		kkwave[3]=oh_mlccm3[i]
		kkwave[4]=oh_mlccm3[i]
		kkwave[5]=oh_mlccm3[i]
		OHexposure[i]=oh_mlccm3[i]*38
		OHexposure38s_3G_H2O()
		wave C_RO2_3,C_RO2_2,C_RO2_1,C_Frag,C_ROH3,C_ROH2,C_ROH1,C_ROOH3,C_ROOH2,C_ROOH1,C_RH
		wave mlc_RO2_3,mlc_RO2_2,mlc_RO2_1,mlc_Frag,mlc_ROH3,mlc_ROH2,mlc_ROH1,mlc_ROOH3,mlc_ROOH2,mlc_ROOH1,mlc_RH
		wave VFR_38s,OHexposure_38s
		wave finalConc
		RO2_3_C[i][]=C_RO2_3[100][q]
		RO2_2_C[i][]=C_RO2_2[100][q]
		RO2_1_C[i][]=C_RO2_1[100][q]
		Frag_C[i][]=C_Frag[100][q]
		ROH3_C[i][]=C_ROH3[100][q]
		ROH2_C[i][]=C_ROH2[100][q]
		ROH1_C[i][]=C_ROH1[100][q]
		ROOH3_C[i][]=C_ROOH3[100][q]
		ROOH2_C[i][]=C_ROOH2[100][q]
		ROOH1_C[i][]=C_ROOH1[100][q]
		RH_C[i][]=C_RH[100][q]
		RO2_3_mlC[i][]=mlC_RO2_3[100][q]
		RO2_2_mlC[i][]=mlC_RO2_2[100][q]
		RO2_1_mlC[i][]=mlC_RO2_1[100][q]
		Frag_mlC[i][]=mlC_Frag[100][q]
		ROH3_mlC[i][]=mlC_ROH3[100][q]
		ROH2_mlC[i][]=mlC_ROH2[100][q]
		ROH1_mlC[i][]=mlC_ROH1[100][q]
		ROOH3_mlC[i][]=mlC_ROOH3[100][q]
		ROOH2_mlC[i][]=mlC_ROOH2[100][q]
		ROOH1_mlC[i][]=mlC_ROOH1[100][q]
		RH_mlC[i][]=mlC_RH[100][q]
		ConcAllspecies[i][]=finalconc[100][q]
		VFR[i]=VFR_38s[100]
		SumofEachRow(mlc_RH)
		wave sumofrows
		Parent_mlc[i]=sumofrows[100]
		mlcAllspecies[i][0]=sumofrows[100]
		SumofEachRow(mlc_ROOH1)
		mlcAllspecies[i][1]=sumofrows[100]
		SumofEachRow(mlc_ROOH2)
		mlcAllspecies[i][2]=sumofrows[100]
		SumofEachRow(mlc_ROOH3)
		mlcAllspecies[i][3]=sumofrows[100]
		SumofEachRow(mlc_ROH1)
		mlcAllspecies[i][4]=sumofrows[100]
		SumofEachRow(mlc_ROH2)
		mlcAllspecies[i][5]=sumofrows[100]
		SumofEachRow(mlc_ROH3)
		mlcAllspecies[i][6]=sumofrows[100]
		SumofEachRow(mlc_RO2_1)
		mlcAllspecies[i][7]=sumofrows[100]
		SumofEachRow(mlc_RO2_2)
		mlcAllspecies[i][8]=sumofrows[100]
		SumofEachRow(mlc_RO2_3)
		mlcAllspecies[i][9]=sumofrows[100]
		SumofEachRow(mlc_Frag)
		mlcAllspecies[i][10]=sumofrows[100]/2
	endfor
	
		RO2_3_C[0][]=C_RO2_3[0][q]
		RO2_2_C[0][]=C_RO2_2[0][q]
		RO2_1_C[0][]=C_RO2_1[0][q]
		Frag_C[0][]=C_Frag[0][q]
		ROH3_C[0][]=C_ROH3[0][q]
		ROH2_C[0][]=C_ROH2[0][q]
		ROH1_C[0][]=C_ROH1[0][q]
		ROOH3_C[0][]=C_ROOH3[0][q]
		ROOH2_C[0][]=C_ROOH2[0][q]
		ROOH1_C[0][]=C_ROOH1[0][q]
		RH_C[0][]=C_RH[0][q]
		RO2_3_mlC[0][]=mlC_RO2_3[0][q]
		RO2_2_mlC[0][]=mlC_RO2_2[0][q]
		RO2_1_mlC[0][]=mlC_RO2_1[0][q]
		Frag_mlC[0][]=mlC_Frag[0][q]
		ROH3_mlC[0][]=mlC_ROH3[0][q]
		ROH2_mlC[0][]=mlC_ROH2[0][q]
		ROH1_mlC[0][]=mlC_ROH1[0][q]
		ROOH3_mlC[0][]=mlC_ROOH3[0][q]
		ROOH2_mlC[0][]=mlC_ROOH2[0][q]
		ROOH1_mlC[0][]=mlC_ROOH1[0][q]
		RH_mlC[0][]=mlC_RH[0][q]
		ConcAllspecies[0][]=finalconc[0][q]
		SumofEachRow(mlc_RH)
		Parent_mlc[0]=sumofrows[0]
		mlcallspecies[0][0]=sumofrows[0]
		Parent_mlc_norm=parent_mlc[p]/parent_mlc[0]
		
	//Delete all the waves that were used to only store information for a fixed OH conc	 (as opposed to varying OH conc)		
	killwaves C_RO2_3,C_RO2_2,C_RO2_1,C_Frag,C_ROH3,C_ROH2,C_ROH1,C_ROOH3,C_ROOH2,C_ROOH1,C_RH,C_H2O
	killwaves mlC_RO2_3,mlC_RO2_2,mlC_RO2_1,mlC_Frag,mlC_ROH3,mlC_ROH2,mlC_ROH1,mlC_ROOH3,mlC_ROOH2,mlC_ROOH1,mlC_RH,mlc_H2O
	killwaves OHexposure_38s,VFR_38s,evaporation,timewave,NewDp,ratio_HO2_RO2,sum_mlc_RH,sum_RH,Bulkavg_RO2,SL_RO2,finalconc
	
	make/o/d/n=(numOH+1,11) FractionAllSpecies
	SumofEachRow(mlcAllspecies)
	fractionallspecies=mlcallspecies[p][q]/sumofrows[p]
	
	R2foroxidizedvsnon(concallspecies)
	
	killwaves sumofrows
	
	Note/k OH_mlccm3 "OH conc (mlc/cm3)"
	Note/k OHexposure "OH exposure (mlc cm-3 s) calculated by OH_mlccm3*38s"
	Note/k VFR "volume fraction remaining of particles as a function of OH conc (* fixed time)"
	Note/k Parent_mlc "Number of molecues of parent species (RH) in the particles as a function OH conc"
	Note/k Parent_mlc_norm "Number of molecues of parent species (RH) in the particles as a function OH conc normalized to initial molecule number (at OH conc=0)"
	Note/k mlcAllspecies "A 2D matrix containing the number of molecules of each compound (column) at each OH conc (row)"
		Note mlcAllspecies "!Please refer to textwave 'CmpIndex' for the name of the compound of each column"
	Note/k ConcAllspecies "A 2D matrix containing the molecule concentration of each compound (column) at each OH conc (row)"
		Note ConcAllspecies "!Please refer to textwave 'CmpIndex' for the name of the compound of each column"
	Note/k FractionAllspecies "A 2D matrix containing the fraction of each compound (column) at each OH conc (row)"
		Note FractionAllspecies "!Please refer to textwave 'CmpIndex' for the name of the compound of each column"
	wave R2_oxi_non
	Note/k R2_oxi_non "R2 between the concentrations of all the compounds at varying OH conc vs those at OH=0"
	
	string listofCwaves=wavelist("*_C",";","")
	variable numCwaves=itemsinlist(listofCwaves)
	string listofmlcwaves=wavelist("*_mlc",";","")
	variable nummlcwaves=itemsinlist(listofmlcwaves)
	
	string theWavestr
	variable nstr
	//wave theWave
	for(nstr=0;nstr<numCwaves;nstr+=1)
		theWavestr=stringfromlist(nstr,listofCwaves)
		wave theWave=$theWavestr
		Note/k theWave "This wave stores the concentration (mlc/cm3-particle) of the compound in each layer (column) and at each OH conc (row)"
	endfor
	
	for(nstr=0;nstr<nummlcwaves;nstr+=1)
		theWavestr=stringfromlist(nstr,listofmlcwaves)
		wave theWave=$theWavestr
		Note/k theWave "This wave stores the number of molecules of the compound in each layer (column) and after each OH conc (row)"
	endfor
	


End

/////////////////////////////////////////////////////////////////////////////////////////////////////
//ymatrix is a matrix containing the concentration/fraction of each species in each column as a function of xwave
//This function graphs a stacked plot of all the species (1st-3rd generation) colored differently
Function GraphFraction(ymatrix,xwave)
	wave ymatrix,xwave
	variable npnts=dimsize(ymatrix,1)
	variable i
	for(i=0;i<npnts;i+=1)
		if(i==0)
			display ymatrix[][i] vs xwave
		else
			appendtograph ymatrix[][i] vs xwave
		endif
	endfor
	string wavestr=nameofwave(ymatrix)
	
	ModifyGraph mode=7,gaps=0,hbFill=2,toMode=3;DelayUpdate
	ModifyGraph rgb($wavestr)=(65535,32768,32768);DelayUpdate
	ModifyGraph rgb($(wavestr+"#1"))=(65535,54607,32768);DelayUpdate
	ModifyGraph rgb($(wavestr+"#2"))=(65535,43690,0);DelayUpdate
	ModifyGraph rgb($(wavestr+"#3"))=(65535,32764,16385);DelayUpdate
	ModifyGraph rgb($(wavestr+"#4"))=(32768,54615,65535);DelayUpdate
	ModifyGraph rgb($(wavestr+"#5"))=(0,43690,65535);DelayUpdate
	ModifyGraph rgb($(wavestr+"#6"))=(1,16019,65535);DelayUpdate
	ModifyGraph rgb($(wavestr+"#7"))=(32769,65535,32768);DelayUpdate
	ModifyGraph rgb($(wavestr+"#8"))=(0,65535,0);DelayUpdate
	ModifyGraph rgb($(wavestr+"#9"))=(2,39321,1);DelayUpdate
	ModifyGraph rgb($(wavestr+"#10"))=(65535,65535,0)

End

/////////////////////////////////////////////////////////////////////////////////////////////
function SumofEachRow(theMatrix)
	wave thematrix
	variable rownum=dimsize(thematrix,0)
	variable columnnum=dimsize(thematrix,1)
	make/d/o/n=(rownum) SumofRows 
	make/o/d/n=(columnnum)/free tempwave
	
	variable i
	for(i=0;i<rownum;i+=1)
		tempwave=thematrix[i][p]
		wavestats/q tempwave
		sumofrows[i]=V_sum
	endfor
End

/////////////////////////////////////////////////////////////////////////////////////////////
Function CalculateLayerVolume(CurrentDp,totallayers,SL_depth,Volume_wave)
	variable CurrentDp,totallayers,SL_depth  //nm
	wave Volume_wave
	
	variable layerthickness=(0.5*CurrentDp-SL_depth)/totallayers*1e-7   //cm
	
	if(numpnts(volume_wave)!=totallayers+1)
		print "Make sure that total layer number and length of volume wave match"
		abort
	endif
	
	variable i,j
	
	for(i=totallayers;i>=0;i-=1)
		j=totallayers+1-i
		if(i!=0)
			Volume_wave[i]=4/3*pi*((layerthickness*j)^3-(layerthickness*(j-1))^3)    //cm3
		else
			Volume_wave[i]=4/3*pi*((0.5*currentDp*1e-7)^3-(layerthickness*(j-1))^3)   //cm3
		endif
	endfor
	
End

//////////////////////////////////////////////////////////////////////////////////////
Function CalculateLayerSA(CurrentDp,totallayers,SL_depth,SA_wave)
	variable CurrentDp,totallayers,SL_depth
	wave SA_wave
	
	variable layerthickness=(0.5*CurrentDp-SL_depth)/totallayers*1e-7   //cm
	
	if(numpnts(SA_wave)!=totallayers+1)
		print "Make sure that total layer number and length of volume wave match"
		abort
	endif
	
	variable i,j
	
	for(i=totallayers;i>=0;i-=1)
		j=totallayers+1-i
		if(i!=0)
			SA_wave[i]=4*pi*(layerthickness*(j-1)+0.5*layerthickness)^2    //cm2
		else
			SA_wave[i]=4*pi*(layerthickness*(j-1)+SL_depth*0.5e-7)^2    //cm2
		endif
	endfor
	
End

//////////////////////////////////////////////////////////////////////////////////////
Function CalculateLayerouterSA(CurrentDp,totallayers,SL_depth,outer_SA_wave)
	variable CurrentDp,totallayers,SL_depth   //Dp, nm
	wave outer_SA_wave
	
	variable layerthickness=(0.5*CurrentDp-SL_depth)/totallayers*1e-7   //cm
	
	if(numpnts(outer_SA_wave)!=totallayers+1)
		print "Make sure that total layer number and length of volume wave match"
		abort
	endif
	
	variable i,j
	
	for(i=totallayers;i>=0;i-=1)
		j=totallayers+1-i
		if(i!=0)
			outer_SA_wave[i]=4*pi*(layerthickness*j)^2    //cm2
		else
			outer_SA_wave[i]=4*pi*(0.5*currentDp*1e-7)^2    //cm2
		endif
	endfor
	
End
