
# import the data
df <- read.csv("path/filename.csv")

df[is.na(df)] <- 0
df<-df[,-grep("rich",colnames(df))]

# re-arranges alleles within a locus smallest to largest
# Genemapper should have already done this but it pays to be paranoid
for(l in 1:8)
{
	temp <- df[,2:5 + l*4]
	for(i in 1:nrow(temp)) {
		temp[i,] <- temp[i,order(temp[i,])]
	}
	df[,colnames(temp)] <- temp
}

df <- df[,-grep("Yellow108",colnames(df))]

# Get a list of all populations
rich <- data.frame(Pop=unique(df$Pop))

for(i in unique(df$Pop)) {
	
	temp <- df[df$Pop == i,]
	
	for(l in 1:7)
	{
		locus <- temp[,2:5 + l*4]
		y <- unique(stack(locus)[,1])
		y <- y[y>0]
		y <- y[order(y)]
	
		for(j in 1:length(y)) {
			locus[locus==y[j]] <- j
		}
		rich[rich$Pop==i,2] <- max(locus)
		temp[,colnames(locus)] <- locus
	}


	# Now need to write mltet files one at a time.
	
	# First step. Bring mothers to top. This can be done by changing the 'M' in the ID column to a zero and sorting by Mom then ID
	temp <- temp[order(temp$Mom, temp$ID),]
	
	# Uncomment below to clear genotype data from all mothers
	temp[temp[,5]==0,][,6:ncol(temp)] <- 0
	
	# Next change the moms to be in sequential order
	moms <- unique(temp$Mom)
	for(m in 1:length(moms)) temp$Mom[temp$Mom == moms[m]] <- m
	
	# Next start trimming off unnecessary parts of the table
	temp <- temp[,-c(1:3)]
	
	# Add tabbing to fit MLTET format
	output <- cbind(rep("   ",nrow(temp)), temp[1], rep("   ",nrow(temp)))
	for(z in 0:6) output <- cbind(output, temp[,3:6 + z*4], rep("  ",nrow(temp)) )  
		
	# Attach MLTET Header
		output <- rbind(rep(NA,ncol(output)),rep(NA,ncol(output)),output)
		output[1,2] <- "loc1loc2loc3loc4loc5loc6loc7loc8"
		output[2,2] <- "(a4,2x,8(1x,4i1))"
		write.table(output,file=paste(i,".dat",sep=""),sep="",row.names=FALSE,col.names=FALSE,eol="\r\n",quote=FALSE,na="")
}