

#check what is in r console from last time
ls()
#remove everything
rm(list=ls())

#check what working directory is set
getwd()
#setting to required one where data is based
setwd("C:/Users/UEA/Documents/Neat data/nature heatwave")

#reading in data 
repfit10D <- read.csv("heatwavereproductivefitnessstoredsperm10day.csv", header = TRUE) # full data set 
repfit15D <- read.csv("heatwavereproductivefitnessstoredsperm15day.csv", header = TRUE) # full data set 


#### DATA CHECK, CLEAN, DESCRIPTION AND SUMMARY #########################################################################

repfit10D # produces all whole dataframe - no NAs, data to 2 or 3 d.p., no irregularities/anomalies


### checking for outliers/errors
summary(repfit10D) # produces general (unsplit) range, quantiles, median, count and mean summary stats for each variable


str(repfit10D) # checks the variable types
# 'data.frame':	117 obs. of  3 variables:
#      $ Replicate          : int  1 2 3 4 5 6 7 8 9 10 ...
# $ Offspring.count.10D: int  125 212 119 160 61 217 196 124 189 144 ...
# $ Temperature.oC     : Factor w/ 2 levels "42female","42femalesperm": 1 1 1 1 1 1 1 1 1 1 ... # heatwave treatment just female or female and sperm stored inside

# no converting necassary

is.na(repfit10D) # returns TRUE of x is missing
# nothing missing




############################# DATA EXPLORATION #######################################################################################


############# ! NAT COMMS DESCRIPTIVE STATS ###############

#### ! library(psych)
#gives you vars  n, mean, sd,  median,  trimmed, mad, min, max, range, skew, kurtosis, se
describeBy(repfit10D$Offspring.count.10D, repfit10D$Temperature.oC)

# $`42female`
#    vars  n mean sd median trimmed mad min max range  skew kurtosis  se
# X1    1 55  163 47    167     166  44   0 232   232 -0.86      1.1 6.3
# 
# $`42femalesperm`
#    vars  n mean sd median trimmed mad min max range  skew kurtosis  se
# X1    1 62  109 48    117     112  53   0 182   182 -0.59    -0.56 6.1




###################### NEAT PLOT #########################################

names(repfit10D)
str(repfit10D)
str(repfit10D$Temperature.oC)
repfit10D$Temperature.oC

library(ggplot2)

temp <- expression(paste('Temperature (',degree,'C)')) #the temperature label with degrees sign # ~ is a space



######## ! NAT COMMS PAPER ############

# notch=F,  #change to F if want to get rid of notchs
# outlier.shape= NA, #shape of the outlier (hashtag out if dont want outliers marked)
# width=0.75,
# lwd=1,
# position=position_dodge(1)

graphrepfitsperm<-ggplot(repfit10D, aes(x=Temperature.oC, y=Offspring.count.10D, fill= Temperature.oC)) +  #change fill to colour is just lines and change 'scale_fill_manual' below to scale_color_manual
     geom_boxplot(notch=F,  #change to F if want to get rid of notchs
                  outlier.shape= NA, #shape of the outlier (hashtag out if dont want outliers marked)
                  width=0.5,
                  lwd=0.5,
                  fatten=0.5,
                  color="black",
                  position=position_dodge(0.5)
                  ) + #size of the outlier (hashtag out if dont want outliers marked)
     stat_summary(fun.y="mean", geom= "point", size=4, position=position_dodge(1), color="black") + 
     scale_fill_manual(values=c("tomato", "firebrick3"), # changes the colour of the bars
                       name = temp, #adds in temperature label on the legend
                       breaks = c("42female", "42femalesperm"), #the order listed in the legend
                       label = c("Female", "Female+Sperm")) + #how things are labeled in the lgend
     geom_jitter(shape=1, size=1.5, position=position_jitter(0.2)) + #so all the data points are not ontop of each other
     labs(x= expression(bold(atop("Treatment of sperm", paste("in female")))), y="Reproductive output") +  #adding title to the x axis and y axis
     scale_x_discrete(breaks=c("42female", "42femalesperm"), #the order of the variables on the x axis
                      labels=c("Control", "Heatwave")) + # the names on the x axis
     coord_cartesian(ylim=c(-5, 255)) + #set axis limits
     scale_y_continuous(breaks=seq(0, 250, 50), #ticks from 0 to 16000 and show number every 16000
                        expand = c(0, 0)) + #cuts the axis off at 0
     theme_classic() + #the theme of the whole plot 
     theme(
           #legend.position="none", #get rid of the hashtag to get rid of legend
           panel.grid.major=element_blank(), #getting rid of majorgridlines
           panel.border=element_blank(),     #getting rid of minorgridlines  
           panel.grid.minor=element_blank(),
           axis.line.x=element_line(color="black", size = 1),
           axis.line.y=element_line(color="black", size = 1),
           axis.text.x=element_text(color="black", size=12),
           axis.text.y=element_text(color="black", size=12),
           axis.title.x=element_text(face = "bold", size=12, color="black", margin = margin(t = 10, r = 0, b = 0, l = 0)),
           axis.title.y=element_text(face = "bold", size=12, color="black", margin = margin(t = 0, r = 10, b = 0, l = 0)),
           legend.position="none",
           panel.background=element_blank(),
           plot.background=element_rect(fill="transparent", colour = NA))  

setwd("C:/Users/UEA/Desktop")
ggsave("graphrepfitsperm.png",width=2.5, height=4, dpi=300, bg = "transparent")
setwd("C:/Users/UEA/Documents/Dissertation and phd/d- data for phd/R analysis/main/10drepfit")








 
 
 
 #########################################################################################################################################PLOTTING RAW DATA DISTRIBUTION AND TESTING NORMALITY AND HOMOGENIETY OF VARIANCES OF SPERM HEAT ###############################
names(repfit10D)
levels(repfit10D$Temperature.oC)
str(repfit10D)

describeBy(repfit10D$Offspring.count.10D, repfit10D$Temperature.oC)
# $`42female`
# vars     n mean    sd median trimmed   mad min max range  skew kurtosis   se
# X1    1 55  163 46.64    167   166.4 44.48   0 232   232 -0.86     1.15 6.29
# 
# $`42femalesperm`
# vars     n   mean    sd median trimmed   mad min max range  skew kurtosis   se
# X1    1 62 108.77 48.08    117  112.42 53.37   0 182   182 -0.59    -0.56 6.11


### in base
# 42female
hist(repfit10D$Offspring.count.10D[repfit10D$Temperature.oC == "42female"], 
     main = list("42female", cex = 2), xlab = "10 day adult count", ylab ="Frequency", ylim = c(0,25),
     nclass = 10) 
# 42femalesperm
hist(repfit10D$Offspring.count.10D[repfit10D$Temperature.oC == "42femalesperm"], 
     col = "red", density = 30, angle = 180, border = "red", 
     main = list("42femalesperm", cex = 2), xlab = "10 day adult count", ylab ="Frequency", ylim = c(0,25),
     nclass = 10)  # keep nclass = 10, keep scales default

###### plotting differences
# base boxplots of data distribution grouped by temperature
boxplot(repfit10D$Offspring.count.10D ~ spermstoreheat$Temperature.oC, ylab="10D Adult Count", xlab="Temperature")

# notice plot has automatically produced a scatterplot if x is made as an integar


########### Normality - Failed in all groups, both groups -ve skew and differing kurtosis
shapiro.test (repfit10D$Offspring.count.10D[repfit10D$Temperature.oC == "42female"]) # W = 0.9, p-value = 0.02
ks.test(repfit10D$Offspring.count.10D[repfit10D$Temperature.oC == "42female"], pnorm)  # D = 1, p-value <2e-16
shapiro.test (repfit10D$Offspring.count.10D[repfit10D$Temperature.oC == "42femalesperm"]) # W = 0.9, p-value = 0.006
ks.test(repfit10D$Offspring.count.10D[repfit10D$Temperature.oC == "42femalesperm"], pnorm) # D = 1, p-value <2e-16


########### Homogeneity of Variances - passed
bartlett.test(repfit10D$Offspring.count.10D ~ repfit10D$Temperature.oC) # Bartlett's K-squared = 0.05, df = 1, p-value = 0.8
fligner.test(repfit10D$Offspring.count.10D ~ repfit10D$Temperature.oC) # Fligner-Killeen:med chi-squared = 0.2, df = 1, p-value = 0.7
#! need library(car)
leveneTest(repfit10D$Offspring.count.10D ~ repfit10D$Temperature.oC)   #Df F value Pr(>F) 1    0.11   0.74


################################################################################################################################################## OLD METHOD: USE NORMAL > TRY AND TRANSFORM TO NORMAL > NON PARAMETRIC OF SPERM HEAT ##################################### 


########## Transformation with just hist and shapiro 
# comparing plots and tests before and after
# two other methods: by(df$response, df$treatment, shapiro.test) # with(df, tapply(response, treatment, shapiro.test))
## RIGHT SKEW FIXING
par(mfrow=c(2,2)) #plotting the graphs next to get other in a 4x4 gird
#raw data not normal; -ve/left skew
hist (log10(repfit10D$Offspring.count.10D[repfit10D$Temperature.oC == "42female"]+0.01))
hist (log10(repfit10D$Offspring.count.10D[repfit10D$Temperature.oC == "42femalesperm"]+0.01))
shapiro.test (log10(repfit10D$Offspring.count.10D[repfit10D$Temperature.oC == "42female"]+0.01))
shapiro.test (log10(repfit10D$Offspring.count.10D[repfit10D$Temperature.oC == "42femalesperm"]+0.01))
#log10 makes worse
hist ((repfit10D$Offspring.count.10D[repfit10D$Temperature.oC == "42female"])^2)
hist ((repfit10D$Offspring.count.10D[repfit10D$Temperature.oC == "42femalesperm"])^2)
shapiro.test ((repfit10D$Offspring.count.10D[repfit10D$Temperature.oC == "42female"])^2)
shapiro.test ((repfit10D$Offspring.count.10D[repfit10D$Temperature.oC == "42femalesperm"])^2)
#square transformation only fixes female


#### 2 sample unpaired mann whitney U 
# As the data is not normal  but is homogenous in variance so a mann whitney U test is valid between the two groups
wilcox.test(repfit10D$Offspring.count.10D ~ repfit10D$Temperature.oC, exact = TRUE, conf.int = TRUE, paired = FALSE)
# W = 3000, p-value = 2e-08
# alternative hypothesis: true location shift is not equal to 0
# 95 percent confidence interval:
#      36 70
# sample estimates:
# difference in location 
# 53 


################################################################################################################################################# NEW METHOD: USE GLM WITH NON-GAUSSIAN ERROR STRUCTURE OF SPERM HEAT ######################################################


########## ! NAT COMMS MODEL SELECTION #############

#### USEFUL PACKAGES
library(car); library(MASS); library (lme4); library (nlme); library(MuMIn); library(multcomp); library(lmtest)

library(glmmADMB)#  glmmADMB()
names(repfit10D)


#### Poisson family error structures
# As data is very right skewed count discrete count, fitting normal distibution does not give normal and homogenity of variance in residuals 

## Poisson model 
globalmodposs <- glm(Offspring.count.10D ~ Temperature.oC, poisson(link = "log"), data=repfit10D) 
summary(globalmodposs)
par(mfrow=c(2,2)); plot(globalmodposs);par(mfrow=c(1,1))

pseudoR<-(globalmodposs$null.deviance-globalmodposs$deviance) / globalmodposs$null.deviance # (thomas et al., 2015)
pseudoR # 0.2 

AIC(globalmodposs) # 3366
AICc<-(-2*logLik(globalmodposs))+((2*1*(1+1)/(117-1-1))); AICc # qAICc<-((-2*logLik(model1)/Theta)+((2*p*(p+1)/(n-p-1))); qAICc # AIC correcting for perameters(p) and sample size (n) # 3362 # AICc smaller so model more efficient

theta<-globalmodposs$deviance/globalmodposs$df.residual; theta #dispersion perameter (thomas et al 2015) how much variation left unexplained after fitting distribution # theta =  23, massively overdispersed is >1 is overdispersion. VAR.S 2967, U   134
#!library(AER)# alternative test
var(repfit10D$Offspring.count.10D)
mean(repfit10D$Offspring.count.10D)
dispersiontest(globalmodposs) # 17

# Checking reasons: no other covariates, no pseudo rep as different males and females used for each datapoint, only 3 0s so true overdispersion, negative binomial recommended as >15 (Thomas et al., 2015)
hist(repfit10D$Offspring.count.10D) 

## Negative binomial model to fix overdispersion
globalnvebinom<-glm.nb(Offspring.count.10D ~ Temperature.oC, link = "log", data=repfit10D)
summary(globalnvebinom,cor = F)
par(mfrow=c(2,2)); plot(globalnvebinom);par(mfrow=c(1,1))

pseudoR<-(globalnvebinom$null.deviance-globalnvebinom$deviance) / globalnvebinom$null.deviance # (thomas et al., 2015)
pseudoR # 0.096 

AIC(globalnvebinom) # 1328
AICc<-(-2*logLik(globalnvebinom))+((2*1*(1+1)/(117-1-1))); AICc # qAICc<-((-2*logLik(model1)/Theta)+((2*p*(p+1)/(n-p-1))); qAICc # AIC correcting for perameters(p) and sample size (n) # 1322 # AICc smaller so model more efficient

lrtest(globalmodposs, globalnvebinom) # negative binomial better, confirming with assumptions
# Model 1: Offspring.count.10D ~ Temperature.oC
# Model 2: Offspring.count.10D ~ Temperature.oC
#    #Df LogLik Df Chisq Pr(>Chisq)    
# 1   2  -1681                        
# 2   3   -661  1  2040     <2e-16 ***

### assumption checks, recommendation of residual dev (contribution of each obs to resid dev) rather than pearson (Thomas et al., 2015)


# 1) Errors normally distributed? - NOT NECASSARY SIMILAR

# poisson
devresid<-resid(globalmodposs, type = "deviance"); hist(devresid)
shapiro.test(devresid);ks.test(devresid, pnorm)
qqnorm(devresid,cex=1.8,pch=20); qqline(devresid,lty=2,lwd=2)
par(mfrow=c(2,2)); plot(globalmodposs);par(mfrow=c(1,1))

# -vebinom
devresid<-resid(globalnvebinom, type = "deviance"); hist(devresid)
shapiro.test(devresid);ks.test(devresid, pnorm)
qqnorm(devresid,cex=1.8,pch=20); qqline(devresid,lty=2,lwd=2)
par(mfrow=c(2,2)); plot(globalnvebinom);par(mfrow=c(1,1))
#  P2 Q-Q points pull down especially on left, formal tests failed

# 2) Homogenous/homoscedasticity variance of residuals - NOT NECASSARY BUT NOT IMPROVED

# poisson
devresid<-resid(globalmodposs, type = "deviance")
plot(devresid ~ globalmodposs$fitted.values, pch = 20, cex = 1, cex.lab = 1.5)
fligner.test(devresid~repfit10D$Temperature.oC) 
par(mfrow=c(2,2)); plot(globalmodposs);par(mfrow=c(1,1))

# -vebinom
devresid<-resid(globalnvebinom, type = "deviance")
plot(devresid ~ globalnvebinom$fitted.values, pch = 20, cex = 1, cex.lab = 1.5)
fligner.test(devresid~repfit10D$Temperature.oC)
par(mfrow=c(2,2)); plot(globalnvebinom);par(mfrow=c(1,1))
#  P1,P3 -ne binomial some wedge and difference variance 

# 3) Independences of independent variables - 1 FACTOR SO YES
# Only one independent variable

# 4) No serial auto-correlation with time/space - YES
#! need library(car)
durbinWatsonTest(globalnvebinom) # test passed

# 5) No bias by unduly influential datapoints - YES IMPROVED

# poisson
par(mfrow=c(2,2)); plot(globalmodposs);par(mfrow=c(1,1))
influence<-influence.measures(globalmodposs); summary(influence) 

# -vebinom
par(mfrow=c(2,2)); plot(globalnvebinom);par(mfrow=c(1,1))
influence<-influence.measures(globalnvebinom); summary(influence) 
# 5 cases in poisson with larger cooks distance fixed with -ve binom

# 6) Independent variables measured without error - BEST OF ABILITY

## Overdispersion re-check
theta<-globalnvebinom$deviance/globalnvebinom$df.residual; theta # 1.2
AICc<-(-2*logLik(globalnvebinom))+((2*1*(1+1)/(117-1-1))); AICc # 1322
# Theta now <1.5 so overdispersion accounted for. 


###  MODEL REFINEMENT
globalnvebinom<-glm.nb(Offspring.count.10D ~ Temperature.oC, link = "log", data=repfit10D)
summary(globalnvebinom,cor = F)

## Null model
nullmod<-glm.nb(Offspring.count.10D ~ 1, link = "log", data=repfit10D) # creating null of just intercept (and random in glmms)
pseudoR<-(nullmod$null.deviance-nullmod$deviance) / nullmod$null.deviance; pseudoR # (thomas et al., 2015) # -6.1e-16
AICc<-(-2*logLik(nullmod))+((2*1*(1+1)/(117-1-1))); AICc  # 1336 



# 1) anova comparison
anova(globalnvebinom, nullmod, test = "Chi")
# Model theta Resid. df    2 x log-lik.   Test    df LR stat. Pr(Chi)
# 1              1   2.8       116           -1336                              
# 2 Temperature.oC   3.2       115           -1322 1 vs 2     1       14 0.00017


############## ! NAT COMMS MODEL SIGNIFICANCE #################

# 2) liklihood ratio test
#! library(lmtest)
lrtest(nullmod,globalnvebinom)
# Model 1: Offspring.count.10D ~ 1
# Model 2: Offspring.count.10D ~ Temperature.oC
#   #Df LogLik Df Chisq Pr(>Chisq)    
# 1   2   -668                        
# 2   3   -661  1  14.1    0.00017 ***

drop1(globalnvebinom, test = "Chi")
#                Df Deviance  AIC  LRT Pr(>Chi)    
# <none>                 142 1326                  
# Temperature.oC  1      158 1339 15.1    1e-04 ***

## Global model significantly lower LL. Therefore complex model kept (although the simplest prefered for NS difference)

globalnvebinom # shortened with basic information # redundant


########### ! NAT COMMS MODEL POST HOC ############

summary(globalnvebinom)
# Call:
#      glm.nb(formula = Offspring.count.10D ~ Temperature.oC, data = spermstoreheat, 
#             link = "log", init.theta = 3.247136199)
# 
# Deviance Residuals: 
#     Min      1Q  Median      3Q     Max  
# -5.056  -0.453   0.107   0.491   1.002  
# 
# Coefficients:
#                                    Estimate Std. Error z value Pr(>|z|)    
#      (Intercept)                   5.0938     0.0756   67.40   <2e-16 ***
#      Temperature.oC42femalesperm  -0.4045     0.1040   -3.89    1e-04 ***

# (Dispersion parameter for Negative Binomial(3.2) family taken to be 1)
# 
# Null deviance: 157.67  on 116  degrees of freedom
# Residual deviance: 142.54  on 115  degrees of freedom
# AIC: 1328
# 
# Number of Fisher Scoring iterations: 1
# 
# Theta:  3.247 
# Std. Err.:  0.468 
# 
# 2 x log-likelihood:  -1322.283 

exp(5.0938) #163
exp(5.0938-0.4045) #109





####### repfit15D stored sperm ##########
library(car); library(MASS); library (lme4); library (nlme); library(MuMIn); library(multcomp)


######### ! NAT COMMS MODEL SELECTION ############

names(repfit15D)
str(repfit15D)
globalmodposs <- glm(Offspring.count.15D ~ Temperature.oC, poisson(link = "log"), data=repfit15D) 
summary(globalmodposs)
par(mfrow=c(2,2)); plot(globalmodposs);par(mfrow=c(1,1))



theta<-globalmodposs$deviance/globalmodposs$df.residual; theta #dispersion perameter (thomas et al 2015) how much variation left unexplained after fitting distribution # theta =  39.9658, massively overdispersed is >1 is overdispersion. VAR.S 6330., U   193.3025
#!library(AER)# alternative test
var(repfit15D$Offspring.count.15D)
mean(repfit15D$Offspring.count.15D)
dispersiontest(globalmodposs) # 28.6159
table(repfit15D$Offspring.count.15D) # few 0s

# negative bionomial not iterating 
globalnvebinom<-glm.nb(Offspring.count.15D ~ Temperature.oC, link = "log", data=repfit15D, control=glm.control(maxit=25))
summary(globalnvebinom,cor = F)
par(mfrow=c(2,2)); plot(globalnvebinom);par(mfrow=c(1,1))

# use quasipoisson, looks better with outliers
globalmodquasiposs <- glm(Offspring.count.15D ~ Temperature.oC, quasipoisson(link = "log"), data=repfit15D) 
summary(globalmodquasiposs) #
#                             Estimate Std. Error t value Pr(>|t|)    
# (Intercept)                  5.40701    0.04786 112.986  < 2e-16 ***
# Temperature.oC42femalesperm -0.29483    0.07154  -4.121 7.06e-05 ***
par(mfrow=c(2,2)); plot(globalmodquasiposs);par(mfrow=c(1,1))

exp(5.40701) # 222.
exp(5.40701-0.29483) # 166.0319

######### ! NAT COMMS MODEL SIGNIFICANCE ############

drop1(globalmodquasiposs, test = "Chi")
# Model:
#      Offspring.count.15D ~ Temperature.oC
#                Df Deviance scaled dev.  Pr(>Chi)    
# <none>              4676.0                          
# Temperature.oC  1   5173.7        17.1 3.546e-05 ***

summary(globalmodquasiposs)

# Call:
#      glm(formula = Offspring.count.15D ~ Temperature.oC, family = quasipoisson(link = "log"), 
#          data = repfit15D)
# 
# Deviance Residuals: 
#      Min        1Q    Median        3Q       Max  
# -21.1171   -3.1178    0.8647    3.5283    8.1101  
# 
# Coefficients:
#      Estimate Std. Error t value Pr(>|t|)    
# (Intercept)                  5.40701    0.04786 112.986  < 2e-16 ***
#      Temperature.oC42femalesperm -0.29483    0.07154  -4.121 7.06e-05 ***
#      ---
#      Signif. codes:  0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
# 
# (Dispersion parameter for quasipoisson family taken to be 29.10556)
# 
# Null deviance: 5173.7  on 118  degrees of freedom
# Residual deviance: 4676.0  on 117  degrees of freedom
# AIC: NA
# 
# Number of Fisher Scoring iterations: 4




#### HEATWAVE STORED SPERM REPRODUCTIVE FITNESS SUMMARY ######################################################################################
#Barnard et al., 2007 and Thomas 2015 as references
#---------Hypothesis
# The relative effect of a single 5d 42oC heatwave 10D reproductive fitness (adult offspring counts) sperm in female storage

#Response variable (dependent):           10D reproductive fitness; (count +/- positive skew) 

#Global Fixed variables (independent):          
#    Categorical                          temperature (heatwave virgin female, heatwave mated female)  
#    Covariates                           NA
#    Non-linear terms                     NA
#    Interactions                         NA

#Random terms:                            NA

#---------Misc

# Simple analysis:                       2 sample t-test but not normal    
# Non-para:                              mann whitney U
# Plot:                                  Notched Box / Univariate scatter  

#------Model report Simple stats
# negative skew not fixable with transformation however homoscedasticity

# wilcox.test(spermstoreheat$Offspring.count.10D ~ spermstoreheat$Temperature.oC, exact = TRUE, conf.int = TRUE, paired = FALSE)
# # W = 3000, p-value = 2e-08

#---------GLM Model refinement

# # Overdispersion parameter:                17-23 for non-mixed poisson (log) true overdispersion

# Error family (+link function):           negative binomial (log)theta=3.2 (glmm func)

# Model refinement method(s):              AICc comparison, anova(), lmtest()

# Most plausible/final model(s):           glm.nb(Offspring.count.10D ~ Temperature.oC, link = "log", data=spermstoreheat)

# AIC(c)                                   1328 
# Model R^2/Adj R^2:                       NA for poiss, quasi-p and -ve binom
# pseudoR^2/deviance:                      10%
# Model significance:                      from analysis of deviance lrtest(nullmod,organismheatsnegbin): X^2= 14.1, df=1, 115, p<0.001


#--------Model assumptions

## 0-less count model
#Residuals normally distributed:               NOT NECASSARY SIMILAR
#    hist of stdzd resids (u=0, sd=1):         symmetrical bell shaped 
#    p1-resids(ab difs obs-mod)~fitted:        no pattern/horizontal  
#    p2-Q-Q plot w/ stdzd resids:              straight line 
#    p3-scale-location w/sqrt resid~fitted:    no pattern
#    s-w/k-s resid tests:                      NS
#  P2 Q-Q points pull down especially on left, formal tests failed

#Homogeneity of variance:                      NOT NECASSARY BUT NOT IMPROVED
#    P1-resids(ab difs obs-mod)~fitted:        no pattern/horizontal
#    sresid~ind vars:                          no pattern
#    fligner/levenes tests:                    NS
#  P1,P3 -ne binomial some wedge and difference variance 

#Independence of variables (no-collinearity):  1 FACTOR SO YES
#    pairwise scatterplots and correlations:   r<0.3
#    sresid~ind vars:                          no collinearity
#    variance inflation factors (VIFs):        values <3

#No serial auto-correlation                     YES 
#    durbinwatson test:                         NS
#    Auto-cor function (ACF):                   <threshold

#No bias by unduly influential datapoints:      YES IMPROVED
#    P4-stdzd resids~leverage:                  <cooks threshold eg. >1 or sample-size/4
#    leverage                                   <2p/n
# 5 cases in poisson with larger cooks distance fixed with -ve binom

#Independent variables measured without error:  TO BEST OF ABILITY


#-------Model report
#term                    peramter+/-se    test-stat(wald z)   d.f.      P
# (Intercept)                   5.0938     0.0756   67.40   <2e-16 ***
# Temperature.oC42femalesperm  -0.4045     0.1040   -3.89    1e-04 ***

# Hypothesis interpretation:  Heatwaves decrease the reproductive fitness of sperm in female storage

