# R script for the relative importance in multiple linear regression of IIS 
# and ecdysone signalling on the variation of TF number and ovary volume 

# Data for analyses are: 
#doubles_TF for TF number in ovaries where both IIS and ecdysone signalling were genetically manipulated
#doubles_TF for ovary volume in ovaries where both IIS and ecdysone signalling were genetically manipulated

load("doubles_TF.RData")
load("doubles_volume.RData")

#Packages required:
library(relaimpo)
require("lme4")
require("nlme")
require("deSolve")
require("MASS")
require("HH") 
require("lsmeans")

#Log(10) transformation of TF number. As TF number can be zero, we also 
# perform a sum transformation (TFs+1).
doubles.TF <- within(doubles.TF, {log.TFs=log10(TFs+1)})

#Log(10) transformation of ovary volume.
doubles.volume <- within(doubles.volume, {log.volume=log10(Volume)})

######  TF NUMBER    ######

TF.fit1<-lm(log.TFs~Timepoint+E+IIS, data= doubles.TF)
TF.fit2<-lm(log.TFs~Timepoint+E*IIS, data= doubles.TF)

calc.relimp(TF.fit1,type="lmg", rela=TRUE)
calc.relimp(TF.fit2,type="lmg", rela=TRUE)

boot1 <- boot.relimp(TF.fit1, b = 1000, type = "lmg", rank = TRUE,  diff = TRUE, rela = TRUE)
booteval.relimp(boot1) # print result
plot(booteval.relimp(boot1,sort=TRUE))

boot2 <- boot.relimp(TF.fit2, b = 1000, type = "lmg", rank = TRUE, diff = TRUE, rela = TRUE)
booteval.relimp(boot2) # print result
plot(booteval.relimp(boot2,sort=TRUE))

######  OVARY VOLUME    ######

volume.fit1<-lm(log.volume~Timepoint+E+IIS, data= doubles.volume)
volume.fit2<-lm(log.volume~Timepoint+E*IIS, data= doubles.volume)

calc.relimp(volume.fit1,type="lmg",rela=TRUE)
calc.relimp(volume.fit2,type="lmg",rela=TRUE)

boot1 <- boot.relimp(volume.fit1, b = 1000, type = "lmg", rank = TRUE, diff = TRUE, rela = TRUE)
booteval.relimp(boot1) # print result
plot(booteval.relimp(boot1,sort=TRUE))

boot2 <- boot.relimp(volume.fit2, b = 1000, type = "lmg", rank = TRUE, diff = TRUE, rela = TRUE)
booteval.relimp(boot2) # print result
plot(booteval.relimp(boot2,sort=TRUE))