# R script for a bi-segmental linear regression model to the data and tested for a 
# significant change in slope

#Data for analysis is:
#Ovariole_Diet for adult ovariole number of wild-type larvae reared in different dietary tretaments 

load("Ovariole_Diet.RData")

#Packages required: 
library(segmented)
library(reshape)
library(lattice)
library(epicalc)

#Subsetting the data
sucrose<-subset (Ovariole_Diet, Food=="Starved")

#check for the assumptions of linear regression models
mod_sucrose<-sucrose.aov<-aov(OvarioleNumber ~ Time, data=sucrose) 

par(mfrow=c(1,4))

plot(mod_sucrose)

#Perform a bi-segmental linear regression model

#Linear regression model
glm<-glm(OvarioleNumber~Time, data=sucrose)

#Test for the existence of a breakpoint
test<-davies.test(glm, seg.Z=~Time)
test$p.value 

start.psi<-test$statistic
start.psi

#bi-segmental linear regression model
seg<-segmented(glm,seg.Z=~Time,psi=start.psi)
summary(seg) 

#Slopes of each segment
slope(seg)

#Confident interval for breakpoint
confint.segmented(seg,"Time",level=0.95)
