% Function to remove gaps from incidence
function [Rtrue, rate, Iday, Lam] =  remGaps(Iday, N, offst, Rtrue, rate, Lam)


% Remove gaps of zeros from all trajectories and truncate
idStart = zeros(1, N);
for j = 1:N
    % Gaps between non-zero indicence values
    zerogaps = diff(find(Iday(j, :) ~= 0));
    % Remove startup sequence of zeros if big
    z1 = zerogaps(1); zrest = zerogaps(2:end);
    if z1 > 8
        % Update incidence and related vectors
        idStart(j) = z1+1;
        % Flag zero incidence regions after startup
        if max(zrest) > 8
            warning('Zero incidences beyond startup');
        end
    else
        % Flag any zero incidence region
        if max(zrest) > 8
            warning('Sequences of zero incidence');
        end
        % Un-truncated day set
        idStart(j) = 2;
    end
end

% Check starting beyond truncation id
if max(idStart) > offst
    error('Offset too small');
else
    % Truncate vectors to have length T
    Rtrue = Rtrue(offst+2:end); rate = rate(:, offst+2:end);
    Iday = Iday(:, offst+2:end); Lam = Lam(:, offst+2:end);
end