% Renewal log-likelihood for one R from Fraser 2011
function likGrp = getLogLikEst(R, Isum)

% Assumptions and notes
% - removed all constants
% - uses Fraser 2011 non-predictive method
% - R is MLE over this grouping (scalar)

% Non-zero log-lik contributions summed
if R ~= 0
    likGrp = Isum*log(R);
else
    likGrp = 0;
end