% Get group sizes for a given k 
function outGrp = getGrpSz(k, lenRt)

% Assumptions and notes
% - k is num of days to group
% - lenRt is total day length for R MLEs

% Number groups and group sizes
krem = rem(lenRt, k);
if krem == 0
    % Perfect group divisions
    grpSz = k*ones(1, lenRt/k);
else
    % Last group has under k events
    grpSz = [k*ones(1, floor(lenRt/k)) krem];
end
% Resulting no. groups
nGrp = length(grpSz); 

% Output structure
outGrp.nGrp = nGrp;
outGrp.grpSz = grpSz;