% Model selection over skylines for a fixed square wave
function [nGrpavg, Pdet, nGrpTrue] = sqWvFixFn(thisDir, V, nmet, pathload)

% Assumptions and notes
% - examines a single type of wave over replicates
% - square wave model selection over possible waves

%% Load main data and parse from R

% Data controlling all sims
cd(pathload);

% Trajectory, no. runs and trees
idTraj = csvread('idTraj.csv');
M = csvread('numTraj.csv');
nRuns = csvread('numRuns.csv');

% Wave types and popul range
wave = csvread('wave.csv');
Nrange = csvread('Nrange.csv');
disp(['True [Nmax Nmin] = ' num2str(Nrange')]);

% Sample data (fixed no. samps intro each segment)
sampRuns = csvread('sampRuns.csv');
tsamp = csvread('samptimes.csv'); nsegs = length(tsamp);

% Main coalescent data
tcoals = cell(1, nRuns); coalLins = tcoals;
for i = 1:nRuns
    % Coalescent times for M trees
    tcoals{i} = csvread(['coalT' num2str(i) '.csv']);
    % Corresponding lineage counts
    coalLins{i} = csvread(['coalL' num2str(i) '.csv']);
end

cd(thisDir);

% Normalised k and nGrp based on wave
nwave = size(wave, 1);
nGrpnorm = 2.^(0:nwave-1);
% Larger k as idTraj decreases
knorm = nGrpnorm(end:-1:1);
% True k for each run
idTrue = unique(idTraj);
ktrue = knorm(idTrue)*sampRuns;
nGrpTrue = nGrpnorm(idTrue);

% Space of k to choose from at each sample run
kspace = cell(1, nRuns);
for i = 1:nRuns
    %kspace{i} = 5:5:ncs(i);
    kspace{i} = sort(knorm*sampRuns(i));
end

%% Model select from coalescent events

% Performance for each run averaged over replicates
msek = zeros(nRuns, nmet); kavg = msek;
nGrpavg = msek; Pdet = msek;

for ii = 1:nRuns
    % Coalescent data for replicates
    tcoal = tcoals{ii}; lcoal = coalLins{ii};
    % Local kspace at this run
    k = kspace{ii}; k0 = ktrue(ii);
    
    % No. coalescences in each segment
    cshift = zeros(M, nsegs);
    % Samples introduced each segment (fixed)
    sampIntro = sampRuns(ii)*ones(1, nsegs)';
    
     % Model selection criteria
    criteria = cell(1, M); nGrp = criteria;
    kbest = zeros(M, nmet); nGrpbest = kbest;
    for i = 1:M
        % Main function for selection models
        [criteria{i}, kbest(i, :), nGrpbest(i, :), nGrp{i}, cshift(i, :), ~] = ...
            sqWaveFn(tcoal(:, i), lcoal(:, i), k, nwave, sampIntro, V, tsamp);
    end
    
    % Square (normalised) error to ktrue
    kerr2 = (kbest/k0 - 1).^2;
    msek(ii, :) = mean(kerr2);
    % Avg chosen k and nGrp for each metric
    kavg(ii, :) = mean(kbest);
    nGrpavg(ii, :) = mean(nGrpbest);
    
    % Convert nGrps to an idTraj value
    idEst =  log2(nGrpbest) + 1;
    % Prob of correct detection 
    detID = idEst == idTraj;
    Pdet(ii, :) = sum(detID)/M;
end
