% Plot under and over-fitting
clearvars; clc;
close all;

% Assumptions and notes
% - data available in current dircectory

% Aditional plotting/partition package
addpath(genpath('/Users/kp10/Documents/MATLAB'));

% Set figure defaults
set(groot, 'defaultAxesTickLabelInterpreter', 'latex');
set(groot, 'defaultLegendInterpreter', 'latex');
set(0, 'defaultTextInterpreter', 'latex');
set(0, 'defaultAxesFontSize', 16);
grey1 = 0.8*ones(1, 3); grey2 = 0.5*ones(1, 3);

% Possible trajectories to select
type = [7 8]; traj = cell(1, 2);
trajNames = {'logis', 'exp', 'steep', 'unif_low', 'unif_high', 'boom', 'cyc', 'bottle', 'mesa', 'binary'};
for i = 1:2
    traj{i} = trajNames{type(i)};
end
% Max time of plot
tmax = 100;

% Under and over-fitting plots
figure;
load([traj{1} '.mat']);
subplot(2, 2, 1);
plot(t, logNt, 'k', 'linewidth', 2);
hold on;
stairs(tEnd0{end}, logNavg0{end}, 'c', 'linewidth', 2);
hold off; grid off; box off;
ylabel('$\log(\hat{N})_{k = 1}$');
xlim([0 tmax]);
subplot(2, 2, 2);
plot(t, logNt, 'k', 'linewidth', 2);
hold on;
stairs(tEnd0{1}, logNavg0{1}, 'c', 'linewidth', 2);
hold off; grid off; box off;
ylabel('$\log(\hat{N})_{k = 800}$');
xlim([0 tmax]);

load([traj{2} '.mat']);
subplot(2, 2, 3);
plot(t, logNt, 'k', 'linewidth', 2);
hold on;
stairs(tEnd0{end}, logNavg0{end}, 'c', 'linewidth', 2);
hold off; grid off; box off;
ylabel('$\log(\hat{N})_{k = 1}$');
xlabel('$t$ (units)');
xlim([0 tmax]);

subplot(2, 2, 4);
plot(t, logNt, 'k', 'linewidth', 2);
hold on;
stairs(tEnd0{1}, logNavg0{1}, 'c', 'linewidth', 2);
hold off; grid off; box off;
ylabel('$\log(\hat{N})_{k = 800}$');
xlabel('$t$ (units)');
xlim([0 tmax]);