% Plot the group sizes for cyclic and bottleneck
clearvars; clc; close all;

% Aditional plotting/partition package
addpath(genpath('/Users/kp10/Documents/MATLAB'));

% Set figure defaults
set(groot, 'defaultAxesTickLabelInterpreter', 'latex');
set(groot, 'defaultLegendInterpreter', 'latex');
set(0, 'defaultTextInterpreter', 'latex');
set(0, 'defaultAxesFontSize', 16);
grey1 = 0.8*ones(1, 3); grey2 = 0.5*ones(1, 3);


% Best group choices
figure;
load('grpCyc.mat');
ax(1) = subplot(2, 1, 1);
plot(ns-1, nGrpbest, '.-', 'linewidth', 2, 'MarkerSize', 30);
box off; grid off;
legend(metrics, 'location', 'best');
ylabel('$p^*$');

load('grpBot.mat')
ax(2) = subplot(2, 1, 2);
plot(ns-1, nGrpbest, '.-', 'linewidth', 2, 'MarkerSize', 30);
box off; grid off;
legend(metrics, 'location', 'best');
xlabel('$m$');
ylabel('$p^*$');