% Log-likelihood of MLE skyline with model selection
function [lik, likSeg, fia, bic, qian, aic] = getLogNModSel2(nc,...
    nGrp, idGrp, logNmax, compCoal, icoal)

% Assumptions and notes
% - penalised log-likelihoods (no constants)
% - also outputs the segment likelihoods
% - assumes a fixed tree with component sums

% Segment log-lik contributions
likSeg = zeros(1, nGrp);
likAIC = likSeg; likBIC = likSeg;
likFIA = likSeg; likQian = likSeg;
% Segment coalescent count = FI
FI = zeros(1, nGrp);

% Get segment contribution to likelihood
for i = 1:nGrp
    % Group ids
    ids = idGrp{i};
    % Scaled coalescent times for this segment
    wj = sum(compCoal(ids));
    % Num coalescent events in segment
    mj = sum(icoal(ids)); FI(i) = mj;
    
    % Segment log-likelihood
    likSeg(i) = mj*log(mj/wj);
    % AIC penalised likelihood
    likAIC(i) = -likSeg(i) + 1;
    % FIA penalised likelihood
    likFIA(i) = -likSeg(i) + 0.5*log((logNmax^2)*mj/(2*pi));
    % BIC penalised likelihood
    likBIC(i) = -likSeg(i) + 0.5*log(nc);
    % Qian MDL penalised likelihood
    likQian(i) = -likSeg(i) + 0.5*log(mj) + log(log(wj/mj) + nc^(-0.25));
end

% Fisher information check
if ~all(FI)
    warning('Issues with FI at this grouping');
    assignin('base', 'FIErr', FI);
end

% Log-likelihood and selection criteria across skyline
lik = sum(likSeg); fia = sum(likFIA); bic = sum(likBIC); 
qian = sum(likQian); aic = sum(likAIC); 
