% Negative log-likelihood of MLE skyline with model selection
function [nlik, nlikSeg, fia, bic] = getLogNModSel(nc, nGrp, idGrp, logNmax, compCoal, icoal)

% Assumptions and notes
% - penalised log-likelihoods (no constants)
% - also outputs the segment likelihoods
% - assumes a fixed tree with component sums

% Segment log-lik contributions
nlikSeg = zeros(1, nGrp);
likFIA = nlikSeg; likBIC = nlikSeg;

% Get segment contribution to likelihood
for i = 1:nGrp
    % Group ids
    ids = idGrp{i};
    % Scaled coalescent times for this segment
    wj = sum(compCoal(ids));
    % Num coalescent events in segment
    mj = sum(icoal(ids)); 
    % Segment negative log-likelihood
    nlikSeg(i) = mj*log(wj/mj);
    % FIA penalised likelihood
    likFIA(i) = nlikSeg(i) + 0.5*log((logNmax^2)*mj/(2*pi));
    % BIC penalised likelihood
    likBIC(i) = nlikSeg(i) + 0.5*log(nc);
end

% Negative log-likelihood and selection criteria
nlik = sum(nlikSeg); fia = sum(likFIA); bic = sum(likBIC);
