% Calculate log-likelihood of preferential skyline for given beta
function [logLik, likSeg] = getLogLikBeta2(Navg, beta, nGrp, idGrp, alpha, icoal, isamp, dtLin)

% Assumptions and notes
% - also outputs the segment likelihoods
% - Navg is the preferential skyline MLE for a given beta
% - assumes a fixed tree with component sums

% Segment log-lik contributions
likSeg = zeros(1, nGrp);

% Get segment contribution to likelihood
for i = 1:nGrp
    % Population and group indices
    N = Navg(i); ids = idGrp{i};
    
    % Log-likelihood for preferential skyline intervals
    likComp = isamp(ids).*log(beta*N) + icoal(ids).*log(alpha(ids)/N) - ...
        dtLin(ids).*(beta*N + alpha(ids)/N);
    % Sum across intervals in segment
    likSeg(i) = sum(likComp);
end

% Skyline log-likelihood
logLik = sum(likSeg);
