% Calculate log-likelihood of MLE skyline
function [logLik, likSeg] = getLogLik(Navg, nGrp, idGrp, alpha, icoal, dtLin)

% Assumptions and notes
% - also outputs the segment likelihoods
% - assumes a fixed tree with component sums

% Segment log-lik contributions
likSeg = zeros(1, nGrp);

% Get segment contribution to likelihood
for i = 1:nGrp
    % Population and group indices
    N = Navg(i); ids = idGrp{i};
    
    % Log-likelihood for preferential skyline intervals
    likComp = icoal(ids).*log(alpha(ids)/N) - dtLin(ids).*(alpha(ids)/N);
    % Sum across intervals in segment
    likSeg(i) = sum(likComp);
end

% Skyline log-likelihood
logLik = sum(likSeg);
