% Computes grouped skyline for a given k
function [logNavg, c, nGrp, tEnd, idGrp] = getGrpSkyLog(k, compCoal, nc, icoal, icoalSum, dtLin, tLin)

% Assumptions and notes
% - works directly in log(N) space
% - gives grouped skyline conditioned on k (coalescences only)
% - does not count sampled intervals as part of k

% Use nc - 1 as last event is at end of final interval
nc = nc - 1;

% Coalescent group sizes and divisions
krem = rem(nc, k);
if krem == 0
    % Perfect group divisions
    c = k*ones(1, nc/k);
else
    % Last group has under k events
    c = [k*ones(1, floor(nc/k)) krem];
end
% No. groups with roughly equal coalescences
nGrp = length(c); 
% Cumulative coalescent events
csum = cumsum(c);

% Indices of groups
idGrp = cell(1, nGrp);
% Length, del, and sum(alpha*del) over each group
A = zeros(1, nGrp); del = A;
% Times at end of each group
tEnd = zeros(1, nGrp);
% Main grouped, sampled skyline
logNavg = zeros(1, nGrp);
% Check of events
ccheck = zeros(size(c));

% Get grouped coalescent skyline components
jstart = 1; 
for i = 1:nGrp
    % Number of completed coalescents in group
    jstop = find(icoalSum == csum(i), 1, 'first');
    % Indices of intervals involved
    ids = jstart:jstop;
    idGrp{i} = ids;
    
    % Component sums: A (coalescent) 
    A(i) = sum(compCoal(ids));
    % Event types in group
    ccheck(i) = sum(icoal(ids));
    
    % Group length in time
    del(i) = sum(dtLin(ids));
    % Update end indices
    jstart = jstop + 1;
    
    % End-time of group
    tEnd(i) = tLin(jstop+1);
    
    % Skyline (coalescent)
    logNavg(i) = log(A(i)/c(i));
end

% Check all population sizes valid
if any(isnan(logNavg)) || any(isinf(logNavg))
    assignin('base','logNavgErr', logNavg);
    error('Some log(N) values are inadmissible');
end
% Check coalescences used
if any(ccheck ~= c)
    assignin('base', 'c', c);
    assignin('base', 'ccheck', ccheck);
    error('Division of coalescences into group incorrect');
end


