% Compute coalescent statistics for a given tree
function [icoal, icoalSum, nc, compCoal, tLin, dtLin] = computeCoal(tcoal, tsamp, coalLin, sampIntro)

% Combine coalescent and sample times
tLin = sort([tcoal' tsamp']);
len = length(tLin);

% Define num of samples and coalescents
nc = length(tcoal); ns = length(tsamp);

% Get whether a coalescent or sample time (complementary sets)
isamp = ismember(tLin, tsamp);
icoal = ismember(tLin, tcoal);

% Construct LTT, must start with sample
nLin = zeros(size(tLin));
nLin(1) = sampIntro(1);
% Check started with at least 2 samples
if nLin(1) < 2
    error('Started with under 2 samples');
end

% Counters for samples and coalescents
c_coal = 0; c_samp = 1;
for j = 2:len
    if isamp(j)
        % Sample event has occurred
        c_samp = c_samp + 1;
        nLin(j) = nLin(j-1) + sampIntro(c_samp);
    else
        % Coalescent event has occurred
        c_coal = c_coal + 1;
        nLin(j) = nLin(j-1) - 1;
    end
end
% Lineages that drive stated events (nLin is after events originally)
nLinPre = nLin;
nLinPre(icoal) = nLinPre(icoal) + 1;
nLinPre(isamp) = nLinPre(isamp) - sampIntro';

% Check have lineage pre-post relationship right
if ~ all(nLinPre(2:end) == nLin(1:end-1))
    error('The nLin and nLinPre relationship is wrong');
end
% Check that all events are used and that lineages match
if c_samp ~= ns || c_coal ~= nc || ~all(coalLin' == nLinPre(icoal))
    error('Computed LTT incorrectly');
end

% Number of intervals and lengths (times)
dtLin = diff(tLin); numInt = length(dtLin);
% The lineage count over dtLin(i) is nLinPre(i)
lendt = length(dtLin); cumInt = cumsum(dtLin);
% Cumulative sum of coalescents
icoalSum = cumsum(icoal);

% Compute components for grouped skyline on each interval
alpha = 0.5*nLin(1:lendt).*(nLin(1:lendt) - 1);
compCoal = alpha.*dtLin;