% ROC examination for skylines in batch
clearvars; clc;
close all; tic;

% Assumptions and notes
% - single shift binary hypothesis problem
% - select over skyline segment number using robust criteria
% - test with several criteria: MDL, BIC, likelihood

% Aditional plotting/partition package
addpath(genpath('/Users/kp10/Documents/MATLAB'));

% Set figure defaults
set(groot, 'defaultAxesTickLabelInterpreter', 'latex');
set(groot, 'defaultLegendInterpreter', 'latex');
set(0, 'defaultTextInterpreter', 'latex');
set(0, 'defaultAxesFontSize', 16);
grey1 = 0.8*ones(1, 3); grey2 = 0.5*ones(1, 3);

% Home and folder to save/load
savetrue = 0;
folload = 'shift_batch';
folsave = 'rocData';

% Metrics to be evaluated
metrics = {'$-\log L$', 'BIC', 'FIA', 'QK', 'AIC'};
nmet = length(metrics);

% Get number of files (equal to trajectories)
thisDir = cd;
cd(['using phylodyn/' folload '/']);
files = dir([folload '*']); 
cd(thisDir);
M = length(files);

%% Load each file and perform model selection

% Store frac of change, best models and criteria
frac = zeros(1, M); criteria = cell(1, M);
k = criteria; nGrp = criteria;
kbest = zeros(M, nmet); nGrpbest = kbest;

for i = 1:M
    % Main function for selection models
    [frac(i), criteria{i}, kbest(i, :), nGrpbest(i, :), k{i}, nGrp{i}]= rocSkyFn(i, folload);
    disp(['Completed ' num2str(i) ' of ' num2str(M)]);
end

% Null model indices and true nGrp
modTrueID = ones(size(frac));
modTrueID(frac == 1) = 0;
nGrpTrue = modTrueID + 1;

% Boolean for if metric selected the correct model
boolMet = nGrpbest' == nGrpTrue;
Psucc = sum(boolMet, 2)/M;


% Log time
tsim = toc/60;
disp(['Execution time: ' num2str(tsim) ' mins']);