############################################################################################################################################### META-ANALYSIS UNCONTROLLED ###################################
data<-read.table("Data.txt", header=T, sep="\t")
data<-subset(data, data$Tropic==1)

## Plants
Data<-subset(data, data$Plants==1)
Data<-Data[,c(3,5,6,7,8,9,11,14,27)]
Data<-na.omit(Data)
# Outlyers
outlyers<-boxplot(Data$RR)
sort(outlyers$out)
Plants<-subset(Data, Data$RR<1.371181 & Data$RR>-2.061423)

## Invertebrates
Data<-subset(data, data$Invertebrates==1)
Data<-Data[,c(3,5,6,7,8,9,12,15,27)]
Data<-na.omit(Data)
# Outlyers
outlyers<-boxplot(Data$RR)
sort(outlyers$out)
Invertebrates<-subset(Data, Data$RR<1.029619 & Data$RR>-1.386294)

## Birds
Data<-subset(data, data$Birds==1)
Data<-Data[,c(3,5,6,7,8,9,12,15,27)]
Data<-na.omit(Data)
# Outlyers
outlyers<-boxplot(Data$RR)
sort(outlyers$out)
Birds<-subset(Data, Data$RR<0.8418 & Data$RR>-0.9084)

## Mammals
Data<-subset(data, data$Mammals==1)
Data<-Data[,c(3,5,6,7,8,9,12,15,27)]
Data<-na.omit(Data)
# Outlyers
outlyers<-boxplot(Data$RR)
sort(outlyers$out)
Mammals<-subset(Data, Data$RR<1.3138 & Data$RR>-1.6094)

## Herpeto
Data<-subset(data, data$Herpeto==1)
Data<-Data[,c(3,5,6,7,8,9,12,15,27)]
Data<-na.omit(Data)
# Outlyers
outlyers<-boxplot(Data$RR)
sort(outlyers$out)
Herpeto<-subset(Data, Data$RR<1.133704 & Data$RR>-1.609438)

## Cover
Data<-subset(data, data$Cover==1)
Data<-Data[,c(3,5,6,7,8,9,12,15,27)]
Data<-na.omit(Data)
# Outlyers
outlyers<-boxplot(Data$RR)
sort(outlyers$out)
Cover<-subset(Data, Data$RR<1.560817 & Data$RR>-1.9911)

## Density
Data<-subset(data, data$Density==1)
Data<-Data[,c(3,5,6,7,8,9,12,15,27)]
Data<-na.omit(Data)
# Outlyers
outlyers<-boxplot(Data$RR)
sort(outlyers$out)
Density<-subset(Data, Data$RR<1.258461 & Data$RR>-1.553749)

## Biomass
Data<-subset(data, data$Biomass==1)
Data<-Data[,c(3,5,6,7,8,9,12,15,27)]
Data<-na.omit(Data)
# Outlyers
outlyers<-boxplot(Data$RR)
sort(outlyers$out)
Biomass<-subset(Data, Data$RR>-2.8984)

## Height
Data<-subset(data, data$Height==1)
Data<-Data[,c(3,5,6,7,8,9,12,15,27)]
Data<-na.omit(Data)
# Outlyers
outlyers<-boxplot(Data$RR)
sort(outlyers$out)
Height<-subset(Data, Data$RR>-1.570598)

## Litter
Data<-subset(data, data$Litter==1)
Data<-Data[,c(3,5,6,7,8,9,10,13,27)]
Data<-na.omit(Data)
# Outlyers
outlyers<-boxplot(Data$RR)
sort(outlyers$out)
Litter<-subset(Data, Data$RR<1.3125)

######################################################################################################
################################# BOOTSTRAP FOR META-ANALYSIS ########################################

## 1 sample per study landscape
library("plyr")
randomRows = function(df,n){
  return(df[sample(nrow(df),n),])
}

######################################################################################################
## Plants
length(which(Plants$Restoration_activity=="passive"))
length(which(Plants$Restoration_activity=="active"))
site.passive<-subset(Plants, Plants$Restoration_activity=="passive")
site.active<-subset(Plants, Plants$Restoration_activity=="active")
N.site.passive<-ddply(site.passive,.(Site),randomRows,1)
N.site.active<-ddply(site.active,.(Site),randomRows,1)

b.Plants_passive <- c()
b.Plants_active <- c()
for (i in 1:1000){
  bsample <- ddply(Plants,.(Site),randomRows,1)

Plants_passive<-subset(bsample, bsample$Restoration_activity=="passive")
bestimate_passive <- mean(Plants_passive$RR)
b.Plants_passive <- c(b.Plants_passive,bestimate_passive)

Plants_active<-subset(bsample, bsample$Restoration_activity=="active")
bestimate_active <- mean(Plants_active$RR)
b.Plants_active <- c(b.Plants_active,bestimate_active)}

######################################################################################################
## Invertebrates
length(which(Invertebrates$Restoration_activity=="passive"))
length(which(Invertebrates$Restoration_activity=="active"))
site.passive<-subset(Invertebrates, Invertebrates$Restoration_activity=="passive")
site.active<-subset(Invertebrates, Invertebrates$Restoration_activity=="active")
N.site.passive<-ddply(site.passive,.(Site),randomRows,1)
N.site.active<-ddply(site.active,.(Site),randomRows,1)

b.Invertebrates_passive <- c()
b.Invertebrates_active <- c()
for (i in 1:1000){
    bsample <- ddply(Invertebrates,.(Site),randomRows,1)
    
  Invertebrates_passive<-subset(bsample, bsample$Restoration_activity=="passive")
  bestimate_passive <- mean(Invertebrates_passive$RR)
  b.Invertebrates_passive <- c(b.Invertebrates_passive,bestimate_passive)
  
  Invertebrates_active<-subset(bsample, bsample$Restoration_activity=="active")
  bestimate_active <- mean(Invertebrates_active$RR)
  b.Invertebrates_active <- c(b.Invertebrates_active,bestimate_active)}

######################################################################################################
## Birds
length(which(Birds$Restoration_activity=="passive"))
length(which(Birds$Restoration_activity=="active"))
site.passive<-subset(Birds, Birds$Restoration_activity=="passive")
site.active<-subset(Birds, Birds$Restoration_activity=="active")
N.site.passive<-ddply(site.passive,.(Site),randomRows,1)
N.site.active<-ddply(site.active,.(Site),randomRows,1)

b.Birds_passive <- c()
b.Birds_active <- c()
for (i in 1:1000){
    bsample <- ddply(Birds,.(Site),randomRows,1)
  
  Birds_passive<-subset(bsample, bsample$Restoration_activity=="passive")
  bestimate_passive <- mean(Birds_passive$RR)
  b.Birds_passive <- c(b.Birds_passive,bestimate_passive)
  
  Birds_active<-subset(bsample, bsample$Restoration_activity=="active")
  bestimate_active <- mean(Birds_active$RR)
  b.Birds_active <- c(b.Birds_active,bestimate_active)}

######################################################################################################
## Mammals
length(which(Mammals$Restoration_activity=="passive"))
length(which(Mammals$Restoration_activity=="active"))
site.passive<-subset(Mammals, Mammals$Restoration_activity=="passive")
site.active<-subset(Mammals, Mammals$Restoration_activity=="active")
N.site.passive<-ddply(site.passive,.(Site),randomRows,1)
N.site.active<-ddply(site.active,.(Site),randomRows,1)

b.Mammals_passive <- c()
b.Mammals_active <- c()
for (i in 1:1000){
    bsample <- ddply(Mammals,.(Site),randomRows,1)
  
  Mammals_passive<-subset(bsample, bsample$Restoration_activity=="passive")
  bestimate_passive <- mean(Mammals_passive$RR)
  b.Mammals_passive <- c(b.Mammals_passive,bestimate_passive)
  
  Mammals_active<-subset(bsample, bsample$Restoration_activity=="active")
  bestimate_active <- mean(Mammals_active$RR)
  b.Mammals_active <- c(b.Mammals_active,bestimate_active)}

######################################################################################################## Herpeto
length(which(Herpeto$Restoration_activity=="passive"))
length(which(Herpeto$Restoration_activity=="active"))
site.passive<-subset(Herpeto, Herpeto$Restoration_activity=="passive")
site.active<-subset(Herpeto, Herpeto$Restoration_activity=="active")
N.site.passive<-ddply(site.passive,.(Site),randomRows,1)
N.site.active<-ddply(site.active,.(Site),randomRows,1)

b.Herpeto_passive <- c()
b.Herpeto_active <- c()
for (i in 1:1000){
    bsample <- ddply(Herpeto,.(Site),randomRows,1)
  
  Herpeto_passive<-subset(bsample, bsample$Restoration_activity=="passive")
  bestimate_passive <- mean(Herpeto_passive$RR)
  b.Herpeto_passive <- c(b.Herpeto_passive,bestimate_passive)
  
  Herpeto_active<-subset(bsample, bsample$Restoration_activity=="active")
  bestimate_active <- mean(Herpeto_active$RR)
  b.Herpeto_active <- c(b.Herpeto_active,bestimate_active)}

######################################################################################################## Cover
length(which(Cover$Restoration_activity=="passive"))
length(which(Cover$Restoration_activity=="active"))
site.passive<-subset(Cover, Cover$Restoration_activity=="passive")
site.active<-subset(Cover, Cover$Restoration_activity=="active")
N.site.passive<-ddply(site.passive,.(Site),randomRows,1)
N.site.active<-ddply(site.active,.(Site),randomRows,1)

b.Cover_passive <- c()
b.Cover_active <- c()
for (i in 1:10000){
    bsample <- ddply(Cover,.(Site),randomRows,1)
  
  Cover_passive<-subset(bsample, bsample$Restoration_activity=="passive")
  bestimate_passive <- mean(Cover_passive$RR)
  b.Cover_passive <- c(b.Cover_passive,bestimate_passive)
  
  Cover_active<-subset(bsample, bsample$Restoration_activity=="active")
  bestimate_active <- mean(Cover_active$RR)
  b.Cover_active <- c(b.Cover_active,bestimate_active)}

######################################################################################################## Density
length(which(Density$Restoration_activity=="passive"))
length(which(Density$Restoration_activity=="active"))
site.passive<-subset(Density, Density$Restoration_activity=="passive")
site.active<-subset(Density, Density$Restoration_activity=="active")
N.site.passive<-ddply(site.passive,.(Site),randomRows,1)
N.site.active<-ddply(site.active,.(Site),randomRows,1)

b.Density_passive <- c()
b.Density_active <- c()
for (i in 1:1000){
    bsample <- ddply(Density,.(Site),randomRows,1)
  
  Density_passive<-subset(bsample, bsample$Restoration_activity=="passive")
  bestimate_passive <- mean(Density_passive$RR)
  b.Density_passive <- c(b.Density_passive,bestimate_passive)
  
  Density_active<-subset(bsample, bsample$Restoration_activity=="active")
  bestimate_active <- mean(Density_active$RR)
  b.Density_active <- c(b.Density_active,bestimate_active)}

######################################################################################################## Biomass
length(which(Biomass$Restoration_activity=="passive"))
length(which(Biomass$Restoration_activity=="active"))
site.passive<-subset(Biomass, Biomass$Restoration_activity=="passive")
site.active<-subset(Biomass, Biomass$Restoration_activity=="active")
N.site.passive<-ddply(site.passive,.(Site),randomRows,1)
N.site.active<-ddply(site.active,.(Site),randomRows,1)

b.Biomass_passive <- c()
b.Biomass_active <- c()
for (i in 1:1000){
    bsample <- ddply(Biomass,.(Site),randomRows,1)
  
  Biomass_passive<-subset(bsample, bsample$Restoration_activity=="passive")
  bestimate_passive <- mean(Biomass_passive$RR)
  b.Biomass_passive <- c(b.Biomass_passive,bestimate_passive)
  
  Biomass_active<-subset(bsample, bsample$Restoration_activity=="active")
  bestimate_active <- mean(Biomass_active$RR)
  b.Biomass_active <- c(b.Biomass_active,bestimate_active)}

######################################################################################################## Height
length(which(Height$Restoration_activity=="passive"))
length(which(Height$Restoration_activity=="active"))
site.passive<-subset(Height, Height$Restoration_activity=="passive")
site.active<-subset(Height, Height$Restoration_activity=="active")
N.site.passive<-ddply(site.passive,.(Site),randomRows,1)
N.site.active<-ddply(site.active,.(Site),randomRows,1)

b.Height_passive <- c()
b.Height_active <- c()
for (i in 1:1000){
    bsample <- ddply(Height,.(Site),randomRows,1)
   
  Height_passive<-subset(bsample, bsample$Restoration_activity=="passive")
  bestimate_passive <- mean(Height_passive$RR)
  b.Height_passive <- c(b.Height_passive,bestimate_passive)
  
  Height_active<-subset(bsample, bsample$Restoration_activity=="active")
  bestimate_active <- mean(Height_active$RR)
  b.Height_active <- c(b.Height_active,bestimate_active)}

######################################################################################################## Litter
length(which(Litter$Restoration_activity=="passive"))
length(which(Litter$Restoration_activity=="active"))
site.passive<-subset(Litter, Litter$Restoration_activity=="passive")
site.active<-subset(Litter, Litter$Restoration_activity=="active")
N.site.passive<-ddply(site.passive,.(Site),randomRows,1)
N.site.active<-ddply(site.active,.(Site),randomRows,1)

b.Litter_passive <- c()
b.Litter_active <- c()
for (i in 1:1000){
    bsample <- ddply(Litter,.(Site),randomRows,1)
    
  Litter_passive<-subset(bsample, bsample$Restoration_activity=="passive")
  bestimate_passive <- mean(Litter_passive$RR)
  b.Litter_passive <- c(b.Litter_passive,bestimate_passive)
  
  Litter_active<-subset(bsample, bsample$Restoration_activity=="active")
  bestimate_active <- mean(Litter_active$RR)
  b.Litter_active <- c(b.Litter_active,bestimate_active)}

######################################################################################################## Join results
meanRR<-matrix(c(b.Plants_passive,b.Plants_active, b.Invertebrates_passive, b.Invertebrates_active, b.Birds_passive,b.Birds_active, b.Mammals_passive, b.Mammals_active,b.Herpeto_passive,b.Herpeto_active, b.Cover_passive,b.Cover_active, b.Density_passive, b.Density_active, b.Biomass_passive,b.Biomass_active, b.Height_passive, b.Height_active,b.Litter_passive, b.Litter_active),1000,20)

write.table(meanRR, "Meta_Analysis_passive_active_results_uncontrolled.txt", quote=F, sep="\t")

######################################################################################################
####################### FIGURE OVERALL META-ANALYSIS #################################################

#par(mfrow=c(5,2))
overall<-read.table("Meta_Analysis_passive_active_results_uncontrolled.txt", header=T, sep="\t")

## Green is passive restoration and red is active restoration
######################################################################################################## Plants
par(mar = c(3, 3, 3, 3)+ 0.1, lwd=1, tck=0.03, bty="7")
boxplot(overall[,1],overall[,2],boxwex = 0.8, at = 1:2 - 0, col =(c("darkolivegreen4", "orangered3")) , notch=T, ylim=c(-1.5,0.5), xlim=c(0.5,2.5),outline=F,cex.axis=2, horizontal=T, las=1, range= 0.0001, boxlwd = 1)
abline(v=0, lty=2, col="black", lwd=2)
title(main="Plants", font.main = 1, cex.main=1.7,adj=0)
# save pdf size 12 x 9 inc.
median(overall[,1])
median(overall[,2])

######################################################################################################## Invertebrates
par(mar = c(3, 3, 3, 3)+ 0.1, lwd=1, tck=0.03, bty="7")
boxplot(overall[,3],overall[,4],boxwex = 0.8, at = 1:2 - 0, col =(c("darkolivegreen4", "orangered3")) , notch=T, ylim=c(-1.5,0.5), xlim=c(0.5,2.5),outline=F,cex.axis=2, horizontal=T, las=1, range= 0.0001, boxlwd = 1)
abline(v=0, lty=2, col="black", lwd=2)
title(main="Invertebrates", font.main = 1, cex.main=1.7,adj=0)
# save pdf size 9 x 12 inc.
median(overall[,3])
median(overall[,4])

######################################################################################################## Birds
par(mar = c(3, 3, 3, 3)+ 0.1, lwd=1, tck=0.03, bty="7")
boxplot(overall[,5],overall[,6],boxwex = 0.8, at = 1:2 - 0, col =(c("darkolivegreen4", "orangered3")) , notch=T, ylim=c(-1.5,0.5), xlim=c(0.5,2.5),outline=F,cex.axis=2, horizontal=T, las=1, range= 0.0001, boxlwd = 1)
abline(v=0, lty=2, col="black", lwd=2)
title(main="Birds", font.main = 1, cex.main=1.7,adj=0)
# save pdf size 9 x 12 inc.
median(overall[,5])
median(overall[,6])

######################################################################################################## Mammals
par(mar = c(3, 3, 3, 3)+ 0.1, lwd=1, tck=0.03, bty="7")
boxplot(overall[,7],overall[,8],boxwex = 0.8, at = 1:2 - 0, col =(c("darkolivegreen4", "orangered3")) , notch=T, ylim=c(-1.5,0.5), xlim=c(0.5,2.5),outline=F,cex.axis=2, horizontal=T, las=1, range= 0.0001, boxlwd = 1)
abline(v=0, lty=2, col="black", lwd=2)
title(main="Mammals", font.main = 1, cex.main=1.7,adj=0)
#save pdf size 9 x 12 inc.
median(overall[,7])
test<-na.omit(overall[,8])
median(test)

######################################################################################################## Herpeto
par(mar = c(3, 3, 3, 3)+ 0.1, lwd=1, tck=0.03, bty="7")
boxplot(overall[,9],overall[,10],boxwex = 0.8, at = 1:2 - 0, col =(c("darkolivegreen4", "orangered3")) , notch=T, ylim=c(-1.5,0.5), xlim=c(0.5,2.5),outline=F,cex.axis=2, horizontal=T, las=1, range= 0.0001, boxlwd = 1)
abline(v=0, lty=2, col="black", lwd=2)
title(main="Herpeto", font.main = 1, cex.main=1.7,adj=0)
# save pdf size 9 x 12 inc.
median(overall[,9])
test<-na.omit(overall[,10])
median(test)

######################################################################################################## Cover
par(mar = c(3, 3, 3, 3)+ 0.1, lwd=1, tck=0.03, bty="7")
boxplot(overall[,11],overall[,12],boxwex = 0.8, at = 1:2 - 0, col =(c("darkolivegreen4", "orangered3")) , notch=T, ylim=c(-0.35,0), xlim=c(0.5,2.5),outline=F,cex.axis=2, horizontal=T, las=1, range= 0.0001, boxlwd = 1)
abline(v=0, lty=2, col="black", lwd=2)
title(main="Cover", font.main = 1, cex.main=1.7,adj=0)
# save pdf size 9 x 12 inc.
median(overall[,11])
median(overall[,12])

######################################################################################################## Density
par(mar = c(3, 3, 3, 3)+ 0.1, lwd=1, tck=0.03, bty="7")
boxplot(overall[,13],overall[,14],boxwex = 0.8, at = 1:2 - 0, col =(c("darkolivegreen4", "orangered3")) , notch=T, ylim=c(-0.35,0), xlim=c(0.5,2.5),outline=F,cex.axis=2, horizontal=T, las=1, range= 0.0001, boxlwd = 1)
abline(v=0, lty=2, col="black", lwd=2)
title(main="Density", font.main = 1, cex.main=1.7,adj=0)
# save pdf size 9 x 12 inc.
median(overall[,13])
median(overall[,14])

######################################################################################################## Biomass
par(mar = c(3, 3, 3, 3)+ 0.1, lwd=1, tck=0.03, bty="7")
boxplot(overall[,15],overall[,16],boxwex = 0.8, at = 1:2 - 0, col =(c("darkolivegreen4", "orangered3")) , notch=T, ylim=c(-0.35,0), xlim=c(0.5,2.5),outline=F,cex.axis=2, horizontal=T, las=1, range= 0.0001, boxlwd = 1)
abline(v=0, lty=2, col="black", lwd=2)
title(main="Biomass", font.main = 1, cex.main=1.7,adj=0)
# save pdf size 9 x 12 inc.
median(overall[,15])
median(overall[,16])

######################################################################################################## Height
par(mar = c(3, 3, 3, 3)+ 0.1, lwd=1, tck=0.03, bty="7")
boxplot(overall[,17],overall[,18],boxwex = 0.8, at = 1:2 - 0, col =(c("darkolivegreen4", "orangered3")) , notch=T, ylim=c(-0.35,0), xlim=c(0.5,2.5),outline=F,cex.axis=2, horizontal=T, las=1, range= 0.0001, boxlwd = 1)
abline(v=0, lty=2, col="black", lwd=2)
title(main="Height", font.main = 1, cex.main=1.7,adj=0)
# save pdf size 9 x 12 inc.
median(overall[,17])
median(overall[,18])

######################################################################################################## Litter
par(mar = c(3, 3, 3, 3)+ 0.1, lwd=1, tck=0.03, bty="7")
boxplot(overall[,19],overall[,20],boxwex = 0.8, at = 1:2 - 0, col =(c("darkolivegreen4", "orangered3")) , notch=T, ylim=c(-0.35,0), xlim=c(0.5,2.5),outline=F,cex.axis=2, horizontal=T, las=1, range= 0.0001, boxlwd = 1)
abline(v=0, lty=2, col="black", lwd=2)
title(main="Litter", font.main = 1, cex.main=1.7,adj=0)
# save pdf size 9 x 12 inc.
median(overall[,19])
median(overall[,20])
