###########################################################################
### R CODE FOR ANALYSIS OF RELATIONSHIPS BETWEEN FACIAL ATTRACTIVENESS  ###
### AND WORLD-CUP PERFORMANCE IN MALE AND FEMALE BIATHLETES             ###
###                                                                     ###
### by TIM W. FAWCETT, JACK EWANS, ALICE LAWRENCE AND ANDREW N. RADFORD ###
###########################################################################

# PRELIMINARIES
rm(list=ls()) # clear previous sessions
biathlon.data<-read.table(file.choose(),header=T) # open data file
str(biathlon.data) # check variables

##################
### BOTH SEXES ###
##################

# CHECK REPEATABILITY OF ATTRACTIVENESS RATINGS
model0<-aov(zAttractiveness~targetID,data=biathlon.data) # compute within-target and between-target variances
summary(model0)
MS=summary(model0)[[1]]$'Mean Sq' # extract mean squares
(MS[[1]]-MS[[2]])/(MS[[1]]+MS[[2]]) # calculate repeatability

library(lmerTest) # call lmerTest library, to allow use of lmer function
library(car) # call car library, for Q-Q plots
library(lattice) # call lattice library for multilevel plots
library(latticeExtra) # call latticeExtra library for combining multilevel plots

# BUILD RANDOM EFFECTS MODEL
summary(model1<-lmer(zAttractiveness~(1|raterID)+(1|targetID),data=biathlon.data)) # fit random intercepts model
summary(model2<-update(model1,~.-(1|raterID))) # drop random effect of rater
anova(model1,model2) # test significance
summary(model3<-update(model1,~.-(1|targetID))) # drop random effect of target
anova(model1,model3) # test significance

# ADD FIXED EFFECTS
summary(model4<-lmer(zAttractiveness~sex*zWCptsPB+zAge+zHeight+zBMI+sqzAge+sqzHeight+sqzBMI+(1|raterID)+(1|targetID),data=biathlon.data))

# CHECK FOR RANDOM SLOPES
summary(model5<-lmer(zAttractiveness~sex*zWCptsPB+zAge+zHeight+zBMI+sqzAge+sqzHeight+sqzBMI+(zWCptsPB|raterID)+(1|targetID),data=biathlon.data))
anova(model4,model5)

# REMOVE NS QUADRATIC TERMS AND NS INTERACTION TERMS
summary(model6<-lmer(zAttractiveness~sex*zWCptsPB+zAge+zHeight+zBMI+(1|raterID)+(1|targetID),data=biathlon.data))

# CHECK FOR RANDOM SLOPES
summary(model7<-lmer(zAttractiveness~sex*zWCptsPB+zAge+zHeight+zBMI+(zWCptsPB|raterID)+(1|targetID),data=biathlon.data))
anova(model6,model7)
qqPlot(resid(model7)) # check normality of residuals
plot(model7) # resids versus fitted values

##################
### WOMEN ONLY ###
##################

F.biathlon.data<-subset(biathlon.data,sex=="female") # select female athletes

# FIT MODEL
summary(modelF1<-lmer(zAttractiveness~zWCptsPB+zAge+zHeight+zBMI+(1|raterID)+(1|targetID),data=F.biathlon.data)) # model containing main effects

# CHECK FOR RANDOM SLOPES
summary(modelF2<-lmer(zAttractiveness~zWCptsPB+zAge+zHeight+zBMI+(zAge|raterID)+(1|targetID),data=F.biathlon.data)) # model containing main effects
anova(modelF1,modelF2)
qqPlot(resid(modelF2)) # check normality of residuals
plot(modelF2) # resids versus fitted values

# GENERATE PLOT
athletepoints<-xyplot(meanAthlAttr~zWCptsPB,groups=raterID,pch=21,fill="grey",col="black",cex=1.5,auto.key=F,type="p",ylim=c(-1.6,1.6),xlab=list(label="performance (highest World Cup total score)",cex=1.5),ylab=list(label="mean attractiveness rating",cex=1.5),scales=list(cex=1.3),data=F.biathlon.data)
raterlines<-xyplot(predict(modelF2)~zWCptsPB,groups=raterID,col="grey",auto.key=F,type="r",ylim=c(-1.6,1.6),xlab=list(label="performance (highest World Cup total score)",cex=1.5),ylab=list(label="mean attractiveness rating",cex=1.5),scales=list(cex=1.3),data=F.biathlon.data)
raterlines+as.layer(athletepoints)
panel.text(230,70,labels="(a) women",cex=1.5)

# CONTROLLING FOR MOUTH CURVATURE AND fWHR
summary(modelF3<-lmer(zAttractiveness~zWCptsPB+zAge+zHeight+zBMI+zMouthCurv+zfWHR+(zAge|raterID)+(1|targetID),data=F.biathlon.data))

################
### MEN ONLY ###
################

M.biathlon.data<-subset(biathlon.data,sex=="male") # select male athletes

# FIT MODEL
summary(modelM1<-lmer(zAttractiveness~zWCptsPB+zAge+zHeight+zBMI+(1|raterID)+(1|targetID),data=M.biathlon.data)) # model containing main effects

# CHECK FOR RANDOM SLOPES
summary(modelM2<-lmer(zAttractiveness~zWCptsPB+zAge+zHeight+zBMI+(zWCptsPB|raterID)+(1|targetID),data=M.biathlon.data)) # model containing main effects
anova(modelM1,modelM2)
qqPlot(resid(modelM2)) # check normality of residuals
plot(modelM2) # resids versus fitted values

# GENERATE PLOT
athletepoints<-xyplot(meanAthlAttr~zWCptsPB,groups=raterID,pch=21,fill="grey",col="black",cex=1.5,auto.key=F,type="p",ylim=c(-1.6,1.6),xlab=list(label="performance (highest World Cup total score)",cex=1.5),ylab=list(label="mean attractiveness rating",cex=1.5),scales=list(cex=1.3),data=M.biathlon.data)
meaneffect<-xyplot(predict(modelM2)~zWCptsPB,col="black",auto.key=F,type="r",lwd=4,ylim=c(-1.6,1.6),xlab=list(label="performance (highest World Cup total score)",cex=1.5),ylab=list(label="mean attractiveness rating",cex=1.5),scales=list(cex=1.3),data=M.biathlon.data)
raterlines<-xyplot(predict(modelM2)~zWCptsPB,groups=raterID,col="grey",auto.key=F,type="r",ylim=c(-1.6,1.6),xlab=list(label="performance (highest World Cup total score)",cex=1.5),ylab=list(label="mean attractiveness rating",cex=1.5),scales=list(cex=1.3),data=M.biathlon.data)
raterlines+as.layer(athletepoints)+as.layer(meaneffect)
panel.text(230,70,labels="(b) men",cex=1.5)

# CONTROLLING FOR MOUTH CURVATURE AND fWHR
summary(modelM3<-lmer(zAttractiveness~zWCptsPB+zAge+zHeight+zBMI+zMouthCurv+zfWHR+(zWCptsPB|raterID)+(1|targetID),data=M.biathlon.data))