library(spatstat)
library(dbscan)
library(dplyr)

base=Espacial_Industria_AV

XYdata = select(base, XABS, YABS)

XYmatrix = data.matrix(XYdata, rownames.force = TRUE)

sector = dbscan(XYmatrix, eps = .5, minPts = 30)
XYdata$cluster = sector$cluster
plot(XYdata$XABS, XYdata$YABS, col = XYdata$cluster + 1L, pch=20)
table(XYdata$cluster)
base$LEVEL = XYdata$cluster
base$LEVEL[base$LEVEL==1]="A"
base$LEVEL[base$LEVEL!="A"]="B"

saveRDS(base, file = "Data\\AV_2clusters.rds")
