library(spatstat)

## Distribución general
lithics = ppp(Espacial_Industria_AV$XABS, Espacial_Industria_AV$YABS, window = Excavation_area)
plot(lithics, pch=20)


intensity.ppp(lithics)
area(Excavation_area)

## Distribución de elementos termoalterados
termoalterados = ppp(Espacial_Industria_AV$XABS[Espacial_Industria_AV$BURNT==TRUE], Espacial_Industria_AV$YABS[Espacial_Industria_AV$BURNT==TRUE], window = Excavation_area)
plot(termoalterados, pch=19)

## Distribución de microdebris (Dim max < 1 cm, CUTOFF = FALSE)
microdebris = ppp(Espacial_Industria_AV$XABS[Espacial_Industria_AV$CUTOFF==FALSE], Espacial_Industria_AV$YABS[Espacial_Industria_AV$CUTOFF==FALSE], window = Excavation_area)
plot(microdebris, pch=19)

# Prueba distribución lascas con córtex
ctx = ppp(Espacial_Industria_AV$XABS[Espacial_Industria_AV$CATEGORY=="FLAKE"&Espacial_Industria_AV$CTX_PCTG>=0.5], Espacial_Industria_AV$YABS[Espacial_Industria_AV$CATEGORY=="FLAKE"&Espacial_Industria_AV$CTX_PCTG>=0.5], window = exc_area)
densctx = density.ppp(ctx, sigma = 0.56, diggle = TRUE)
plot(densctx)

#Prueba microdebris quemado
microquemado = ppp(Espacial_Industria_AV$XABS[Espacial_Industria_AV$CUTOFF==FALSE&Espacial_Industria_AV$BURNT==TRUE], Espacial_Industria_AV$YABS[Espacial_Industria_AV$CUTOFF==FALSE&Espacial_Industria_AV$BURNT==TRUE], window = exc_area)
microquemdens = density.ppp(microquemado,sigma = 0.56, diggle = TRUE)
plot(microquemdens)




#Quadrat test of intensity to test the CSR of the ppp based on quadrat counts. Quadrats adjusted for 0.5 m2, the resolution of the excavation
#MonteCarlo method because chisquare requires a minimum count of 5 in each quadrat. The rejection of the H0 does not mean clustered pattern, it just means not random
QuadrTestDisp = quadrat.test.ppp(lithics, alternative = "clustered", method = "MonteCarlo", nsim = 99, xbreaks = c(2,2.5,3,3.5,4,4.5,5,5.5,6,6.5,7,7.5,8,8.5,9,9.5,10,10.5,11,11.5,12,12.5,13,13.5), ybreaks = c(0,.5,1,1.5,2,2.5,3,3.5,4,4.5,5,5.5,6,6.5,7,7.5,8,8.5,9,9.5,10))
print(QuadrTestDisp)
plot(QuadrTestDisp)

QuadrTestDisp1m = quadrat.test.ppp(lithics, alternative = "clustered", method = "MonteCarlo", nsim = 99, xbreaks = c(2,3,4,5,6,7,8,9,10,11,12,13,14), ybreaks = c(0,1,2,3,4,5,6,7,8,9,10))
print(QuadrTestDisp1m)
plot(QuadrTestDisp1m, main= "Prueba de dispersión basada en conteos por cuadrantes")

QuadrTestDisprndm = quadrat.test.ppp(lithics, method = "Chisq")
print(QuadrTestDisprndm)
plot(QuadrTestDisprndm, main= "Prueba de dispersión basada en conteos por cuadrantes")


## Clark-Evans
clarkevans.test(lithics, correction = "cdf", alternative = "regular")


#Hopkins-Skellam
hopskel.test(lithics, alternative = "clustered")



# Linhom
Linhomogeous = envelope(lithics, Linhom, correction = "isotropic", nsim = 999)
plot(Linhomogeous)
plot(Linhomogeous, xlim =c(0,1.2))



# Kernel Density Map general
KDEgeneral = density.ppp(lithics, sigma = 0.28, diggle = TRUE)
    #KDEgeneral = density.ppp(lithics, sigma = bw.diggle(lithics), adjust = 2, diggle = TRUE)
plot(KDEgeneral)
contour(KDEgeneral, add = TRUE)

# KDM termoalterados
KDEtermo = density.ppp(termoalterados, sigma = 0.28, diggle = TRUE)
plot(KDEtermo)
contour(KDEtermo, add=TRUE)

#KDM microdebris
KDEmicro = density.ppp(microdebris, sigma = 0.28, diggle = TRUE)
plot(KDEmicro)
contour(KDEmicro, add = TRUE)

# Densidad de los de >3cm
mayores = ppp(Espacial_Industria_TAM$XABS[Espacial_Industria_TAM$`>= 30`==TRUE],Espacial_Industria_TAM$YABS[Espacial_Industria_TAM$`>= 30`==TRUE], window = Excavation_area)
mayoresdens = density.ppp(mayores, sigma = .28, diggle = TRUE)
plot(mayoresdens)
contour(mayoresdens, add=TRUE)

# Función L-cruzada para estructuras y lítica
plot(envelope(estr_litb, Lcross, i="ESTRUCTURA", j="LITICA", correction = "isotropic", nsim = 99))
plot(envelope(estr_lit, Lcross, i="ESTRUCTURA", j="LITICA", correction = "isotropic", nsim = 99))
