#####################################################################################################################################################################
######## Plot for each chromosome the linkage map raw data, the loess smoothed distribution and the actual distribution with the best interference parameter ########
#####################################################################################################################################################################
rm(list=ls())
# ------------------------------------------------------------------------------------------------------------------
# (0) inputs -----------------------------------------------------------------------------------------------------------
# ------------------------------------------------------------------------------------------------------------------
# define path to files here
path = "C:\\Users\\Data\\"
outfile <- "LM_InterferenceBestParameter.txt"
# n simulations (*2, since there is a female and a male meiosis simulated and later summed up)
nSims <- 5000

# ---
options(warn=2)
# files
map <- read.table(paste(path,"data_ZF324.SIM100kb.map.txt",sep=""), sep="\t", header=TRUE)
splitAt <- function(x, pos) unname(split(x, cumsum(seq_along(x) %in% pos)))
tgus <- read.table(paste(path, "data_ZF324.chromosomes.txt", sep=""), sep="\t", header=TRUE)
tgus <- subset(tgus,Tgu %in% c("chr1","chr10","chr11","chr12","chr13","chr14","chr15","chr17","chr18","chr19","chr1A","chr2","chr20","chr23","chr3","chr4","chr4A","chr5","chr6","chr7","chr8","chr9","chr1.1"))
markers <- read.table(paste(path, "data_ZF324.SNPinfoRANDOM_8_13.txt", sep=""), sep="\t", header=TRUE)
markers <- subset(markers,chromosome!="chrZ")
# remove marker on Tgu4A that screws up the whole linkage map
markers <- subset(markers, SNP!="A25817" & SNP!="A03165" & SNP!="A01215")


# ------------------------------------------------------------------------------------------------------------------
# (1) create recombination probabilities for each chromosomes from linkage map -----------------------------------------
# ------------------------------------------------------------------------------------------------------------------
prob <- data.frame(matrix(,ncol=5))
colnames(prob) <- c("Pos.Genet.Start","Pos.Genet.End","Pos.Phys.Start","Pos.Phys.End","Rec.Prob")
prob <- prob[-1,]
for(j in 1:length(unique(map$Chromosome))) {
	chr <- subset(map, Chromosome==unique(map$Chromosome)[j])
	m1 <- chr$Marker[-nrow(chr)]
	m2 <- chr$Marker[-1]
	chr <- matrix(c(chr$Pos.Genet[-nrow(chr)],chr$Pos.Genet[-1],chr$Pos.Phys[-nrow(chr)],chr$Pos.Phys[-1]),ncol=4)
	dstnc <- chr[,2]-chr[,1]
	chr <- data.frame(chr)
	chr$Prob <- ((exp(4*((dstnc)/100))-1)/(exp(4*((dstnc)/100))+1))
	chr <- cbind(unique(map$Chromosome)[j],m1,m2,chr)
	colnames(chr) <- c("Chromosome","Marker1","Marker2","Pos.Genet.Start","Pos.Genet.End","Pos.Phys.Start","Pos.Phys.End","Rec.Prob")
	chr$Pos.Phys.End <- chr$Pos.Phys.End-1
	prob <- rbind(prob,chr)
}
	
	
for(mm in 1:nrow(tgus)) {
	chromo <- as.character(tgus[mm,"Tgu"])
	marker <- subset(markers, chromosome==chromo)
	interf.range <- subset(tgus,Tgu==chromo)
	interf.range <- interf.range$inter_range

	# ------------------------------------------------------------------------------------------------------------------
	# (2) simulation of recombinations -------------------------------------------------------------------------------------
	# ------------------------------------------------------------------------------------------------------------------
	xxMID <- rep(0,nrow(subset(prob, Chromosome==chromo)))
	xxFID <- rep(0,nrow(subset(prob, Chromosome==chromo)))
	for(nn in 1:nSims) {
		# select specified chromosome
		chr.map <- subset(map, Chromosome==chromo)
		chr.prob <- subset(prob, Chromosome==chromo)
		# get at least one crossover per chromosome
		xFID.1 <- 0
		xMID.1 <- 0
		# find the position where the crossover occurs in both female and male
		while(sum(xFID.1)==0) {
			xFID.1 <- rbinom(n=nrow(chr.prob), 1, p=chr.prob$Rec.Prob)
		}
		while(sum(xMID.1)==0) {
			xMID.1 <- rbinom(n=nrow(chr.prob), 1, p=chr.prob$Rec.Prob)
		}
		# introduce crossover interference if required
		if(interf.range>0) {
			# introduce interference - FID
			inter.F <- which(xFID.1==1)
			l <- 1
			while(l <= length(inter.F)) {
				sct <- xFID.1[max(inter.F[l]-interf.range/prob$Pos.Phys.End[1],1):min(inter.F[l]+interf.range/prob$Pos.Phys.End[1],length(xFID.1))]
				while(sum(sct)>1) {
					sct[sample(c(which(sct==1)),1,prob=c(1-chr.prob$Rec.Prob[which(sct==1)]))] <- 0
				}
			xFID.1[max(inter.F[l]-interf.range/prob$Pos.Phys.End[1],1):min(inter.F[l]+interf.range/prob$Pos.Phys.End[1],length(xFID.1))] <- sct
			inter.F <- which(xFID.1==1)
			l <- l+1
			}
			# introduce interference - MID
			inter.M <- which(xMID.1==1)
			l <- 1
			while(l <= length(inter.M)) {
				sct <- xMID.1[max(inter.M[l]-interf.range/prob$Pos.Phys.End[1],1):min(inter.M[l]+interf.range/prob$Pos.Phys.End[1],length(xMID.1))]
				while(sum(sct)>1) {
					sct[sample(c(which(sct==1)),1,prob=c(1-chr.prob$Rec.Prob[which(sct==1)]))] <- 0
				}
			xMID.1[max(inter.M[l]-interf.range/prob$Pos.Phys.End[1],1):min(inter.M[l]+interf.range/prob$Pos.Phys.End[1],length(xMID.1))] <- sct
			inter.M <- which(xMID.1==1)
			l <- l+1
			}
		}
		# create the second chromatid in both females and males (after interference is introduced because interference is acting for both sisterchromatids (by splitting up the recombination events on both chromatids)
		xFID.2 <- ifelse((sample(c(0,1),length(xFID.1),replace=TRUE)==1),xFID.1,0)
		xFID.1[which(xFID.2==1)] <- 0
		xMID.2 <- ifelse((sample(c(0,1),length(xMID.1),replace=TRUE)==1),xMID.1,0)
		xMID.1[which(xMID.2==1)] <- 0		
		# save the number of recombination events in one of the haplotypes each
		xxFID <- xxFID + xFID.1
		xxMID <- xxMID + xMID.1
	}
	# check linkage map vs simulation
	# get all recombination events from mother and father
	xx <- xxMID+xxFID
	# get the chromosome that is simulated and get the genetic position between each window
	chr <- subset(map, Chromosome==chromo)
	chr <- matrix(c(chr$Pos.Genet[-nrow(chr)],chr$Pos.Genet[-1],chr$Pos.Phys[-nrow(chr)],chr$Pos.Phys[-1]),ncol=4)
	chr <- data.frame(chr)
	for(i in 1:nrow(chr)) {
		chr$dstnc[i] <- (chr[i,2]+chr[i,1])/2
	}
	# scale the recombination events from the simulation to the average recombination events per meiosis
	xy <- (cumsum(xx)/max(cumsum(xx)))*sum(xx)/(nSims)*50
	xy <- cbind(xy,chr$dstnc,chr$X3)
	xy <- data.frame(xy)
	xy$chromo <- rep(chromo,nrow(xy))
	colnames(xy) <- c("SIM","LM","POS","Chromosome")
	xy$POS <- xy$POS/1000000
	if(mm==1) {
		write.table(xy,paste(path, outfile, sep=""), append=FALSE, row.names=FALSE, col.names=TRUE, sep="\t", quote=FALSE, eol="\n")
	} else {
		write.table(xy,paste(path, outfile, sep=""), append=TRUE, row.names=FALSE, col.names=FALSE, sep="\t", quote=FALSE, eol="\n")
	}
	print(mm)
}



# ------------------------------------------------------------------------------------------------------------------
# (3) create the plot --------------------------------------------------------------------------------------------------
# ------------------------------------------------------------------------------------------------------------------
rm(list=ls())
# define path to files here
path = "C:\\Users\\Data\\"
outfile <- paste("LM_Interference.svg",sep="")
size <- 1
tgus <- read.table(paste(path, "data_ZF324.chromosomes.txt", sep=""), sep="\t", header=TRUE)
tgus <- subset(tgus,Tgu %in% c("chr1","chr10","chr11","chr12","chr13","chr14","chr15","chr17","chr18","chr19","chr1A","chr2","chr20","chr23","chr3","chr4","chr4A","chr5","chr6","chr7","chr8","chr9","chr1.1"))
marker <- read.table(paste(path, "data_ZF324.SNPinfoRANDOM_8_13.txt", sep=""), sep="\t", header=TRUE)
marker <- subset(marker,chromosome!="chrZ")
# remove marker on Tgu4A that screws up the whole linkage map
marker <- subset(marker, SNP!="A25817" & SNP!="A03165" & SNP!="A01215")
LMSIM <- read.table(paste(path, "LM_InterferenceBestParameter.txt", sep=""), sep="\t", header=TRUE)
splitAt <- function(x, pos) unname(split(x, cumsum(seq_along(x) %in% pos)))

svg(filename=paste(path,outfile,sep=""), height=265/25.4, width=170/25.4, family="Arial", pointsize=9)
par(mfrow=c(6,4),oma = c(1.2, 1.2, 0, 0), cex=1)
par(mar=c(2, 2, 1.2, 0.5))
par(mgp=c(1.5,0.4,0))

for(mm in 1:nrow(tgus)) {
	chromo <- as.character(tgus[mm,"Tgu"])
	markers <- subset(marker, chromosome==chromo)
	LMSIM.chromo <- subset(LMSIM, Chromosome==chromo)
	main <- paste("Tgu",strsplit(chromo,"chr",fixed=TRUE)[[1]][2],sep="")
	if(main!="Tgu1.1") {
		if(markers$position[1]/1000000>markers$position[nrow(markers)]/1000000) {
			markers$position/1000000 <- abs(markers$position-max(markers$position/1000000))
		}
	markers$cM <- markers$cM + LMSIM.chromo$LM[which(abs(LMSIM.chromo$POS-markers$position[1]/1000000)==min(abs(LMSIM.chromo$POS-markers$position[1]/1000000)))]
	}
	if(main=="Tgu1.1") {main <- "Artifical Tgu"}
	plot(markers$position/1000000,markers$cM, col='gray65', pch=21, main=substitute(bolditalic(main), list(main = as.character(main))), xlab="", ylab="", ylim=c(0,max(LMSIM.chromo$LM,LMSIM.chromo$SIM,markers$cM)), xlim=c(0,max(markers$start_MB,LMSIM.chromo$POS)), cex.main=size, tcl=-0.4)
	points(LMSIM.chromo$POS, LMSIM.chromo$LM, col="orangered", lwd=2, type="l")
	points(LMSIM.chromo$POS, LMSIM.chromo$SIM, col="#006F99", lwd=2, type="l")
	}
mtext(expression(bold("Physical position (Mb)")), cex=1, outer = TRUE, side=1)
mtext(expression(bold("Genetic position (cM)")), srt = 90, cex=1, outer = TRUE, side=2)
plot(1, type = "n", axes=FALSE, xlab="", ylab="")
par(xpd=TRUE)
legend(x = "topleft",inset = c(-0.11,0), legend = c("Simulation","Linkage map","SNPs"), col=c("#006F99","orangered","gray65"), lwd=c(2,2,NA), cex=size, bty="n", pch=c(NA,NA,21))
par(xpd=FALSE)
dev.off()


