# User Guide Index

## `classifier`

 - [`EnsembleVoteClassifier`](user_guide/classifier/EnsembleVoteClassifier.md)
 - [`StackingClassifier`](user_guide/classifier/StackingClassifier.md) (new in 0.3.1dev)
 - [`Perceptron`](user_guide/classifier/Perceptron.md)
 - [`Adaline`](user_guide/classifier/Adaline.md)
 - [`LogisticRegression`](user_guide/classifier/LogisticRegression.md)
 - [`NeuralNetMLP`](user_guide/classifier/NeuralNetMLP.md)
 - [`SoftmaxRegression`](user_guide/classifier/SoftmaxRegression.md) (new in 0.3.1dev)

## `tf_classifier` (TensorFlow Classifier)
 - [`TfSoftmaxRegression`](user_guide/tf_classifier/TfSoftmaxRegression.md) (new in 0.3.1dev)
 - [`TfMultiLayerPerceptron`](user_guide/tf_classifier/TfMultiLayerPerceptron.md) (new in 0.3.1dev)

## `regressor`

- [`LinearRegression`](user_guide/regressor/LinearRegression.md)
- [`StackingRegressor`](user_guide/regressor/StackingRegressor.md) (new in 0.3.1dev)

## `regression_utils`
- [`plot_linear_regression`](user_guide/regression_utils/plot_linear_regression.md)

## `feature_selection`
- [`SequentialFeatureSelector`](user_guide/feature_selection/SequentialFeatureSelector.md)

## `feature_extraction`
- [`PrincipalComponentAnalysis`](user_guide/feature_extraction/PrincipalComponentAnalysis.md) (new in 0.3.1dev)
- [`LinearDiscriminantAnalysis`](user_guide/feature_extraction/LinearDiscriminantAnalysis.md) (new in 0.3.1dev)

## `evaluate`
- [`confusion_matrix`](user_guide/evaluate/confusion_matrix.md)
- [`plot_decision_regions`](user_guide/evaluate/plot_decision_regions.md)
- [`plot_learning_curves`](user_guide/evaluate/plot_learning_curves.md)
- [`scoring`](user_guide/evaluate/scoring.md)

## `preprocessing`
- [`DenseTransformer`](user_guide/preprocessing/DenseTransformer.md)
- [`MeanCenterer`](user_guide/preprocessing/MeanCenterer.md)
- [`minmax_scaling`](user_guide/preprocessing/minmax_scaling.md)
- [`shuffle_arrays_unison`](user_guide/preprocessing/shuffle_arrays_unison.md)
- [`standardize`](user_guide/preprocessing/standardize.md)
- [`one-hot_encoding`](user_guide/preprocessing/one-hot_encoding.md) (new in 0.3.1dev)

## `data`
- [`autompg_data`](user_guide/data/autompg_data.md)
- [`boston_housing_data`](user_guide/data/boston_housing_data.md)
- [`iris_data`](user_guide/data/iris_data.md)
- [`mnist_data`](user_guide/data/mnist_data.md)
- [`load_mnist`](user_guide/data/load_mnist.md)
- [`wine_data`](user_guide/data/wine_data.md)

## `file_io`
- [`find_filegroups`](user_guide/file_io/find_filegroups.md)
- [`find_files`](user_guide/file_io/find_files.md)

## `general plotting`
- [`category_scatter`](user_guide/general_plotting/category_scatter.md)
- [`enrichment_plot`](user_guide/general_plotting/enrichment_plot.md)
- [`stacked_barplot`](user_guide/general_plotting/stacked_barplot.md)

## `math`
- [`num_combinations`](user_guide/math/num_combinations.md)
- [`num_permutations`](user_guide/math/num_permutations.md)

## `text`
- [`generalize_names`](user_guide/text/generalize_names.md)
- [`generalize_names_duplcheck`](user_guide/text/generalize_names_duplcheck.md)
- [`tokenizer.`](user_guide/text/tokenizer.md)

## `utils`
- [`Counter`](user_guide/utils/Counter.md)

## `general concepts`
- [`activation-functions`](user_guide/general_concepts/activation-functions.md)
- [`gradient-optimization`](user_guide/general_concepts/gradient-optimization.md)
- [`linear-gradient-derivative`](user_guide/general_concepts/linear-gradient-derivative.md)
- [`regularization-linear`](user_guide/general_concepts/regularization-linear.md)
