#include "object.hpp"

namespace xios
{
  /// ////////////////////// Définitions ////////////////////// ///

  CObject::CObject(void)
    : id(), idDefined(false), idAutoGenerated(false)
  { /* Ne rien faire de plus */ }

  CObject::CObject(const StdString& id, bool idAutoGenerated /*= false*/)
    : id(id)
    , idDefined(true)
    , idAutoGenerated(idAutoGenerated)
  { /* Ne rien faire de plus */ }

  CObject::CObject(const CObject& object)
    : id(object.id)
    , idDefined(object.idDefined)
    , idAutoGenerated(object.idAutoGenerated)
  { /* Ne rien faire de plus */ }

  CObject::~CObject(void)
  { /* Ne rien faire de plus */ }

  const StdString& CObject::getId(void) const
  {
    return this->id;
  }

  const StdString& CObject::getIdServer() const
  {
    return this->id;
  }

  bool CObject::hasId(void) const
  {
    return this->idDefined;
  }

  bool CObject::hasAutoGeneratedId(void) const
  {
    return this->idAutoGenerated;
  }

  void CObject::resetId(void)
  {
    this->idDefined = false;
  }

  void CObject::setId(const StdString& id, bool idAutoGenerated /*= false*/)
  {
    this->id = id;
    this->idDefined = true;
    this->idAutoGenerated = idAutoGenerated;
  }

  /*
  bool CObject::operator==(const CObject& other) const
  {
    if(!this->hasId() || !other.hasId())
    return false;
    return this->id.compare(other.id) == 0;
  }

  bool CObject::operator!=(const CObject& other) const
  {
    return !(*this == other);
  }
  */

  StdOStream& operator<<(StdOStream& os, const CObject& object)
  {
    os << object.toString();
    return os;
  }
} // namespace xios
