/* ************************************************************************** *
 *      Copyright © IPSL/LSCE, xios, Avril 2010 - Octobre 2011         *
 * ************************************************************************** */

#include <boost/multi_array.hpp>
#include <boost/shared_ptr.hpp>

#include "xios.hpp"

#include "object_template.hpp"
#include "group_template.hpp"
#include "attribute_template.hpp"

#include "icutil.hpp"
#include "timer.hpp"
#include "interpolate_domain.hpp"
#include "interpolate_axis.hpp"

extern "C"
{
// /////////////////////////////// Définitions ////////////////////////////// //

   // ----------------------- Redéfinition de types ----------------------------

   typedef xios::CInterpolateDomain    * XInterpolateDomainPtr;
   typedef xios::CInterpolateAxis      * XInterpolateAxisPtr;

   // ------------------------ Création des handle -----------------------------
   void cxios_interpolate_domain_handle_create(XInterpolateDomainPtr * _ret, const char * _id, int _id_len)
   {
      std::string id;
      if (!cstr2string(_id, _id_len, id)) return;
      CTimer::get("XIOS").resume() ;
      *_ret = xios::CInterpolateDomain::get(id);
      CTimer::get("XIOS").suspend() ;
   }

   // -------------------- Vérification des identifiants -----------------------
   void cxios_interpolate_domain_valid_id(bool * _ret, const char * _id, int _id_len)
   {
      std::string id;
      if (!cstr2string(_id, _id_len, id)) return;

      CTimer::get("XIOS").resume() ;
      *_ret = xios::CInterpolateDomain::has(id);
      CTimer::get("XIOS").suspend() ;
   }

    // ------------------------ Création des handle -----------------------------
   void cxios_interpolate_axis_handle_create(XInterpolateAxisPtr * _ret, const char * _id, int _id_len)
   {
      std::string id;
      if (!cstr2string(_id, _id_len, id)) return;
      CTimer::get("XIOS").resume() ;
      *_ret = xios::CInterpolateAxis::get(id);
      CTimer::get("XIOS").suspend() ;
   }

   // -------------------- Vérification des identifiants -----------------------
   void cxios_interpolate_axis_valid_id(bool * _ret, const char * _id, int _id_len)
   {
      std::string id;
      if (!cstr2string(_id, _id_len, id)) return;

      CTimer::get("XIOS").resume() ;
      *_ret = xios::CInterpolateAxis::has(id);
      CTimer::get("XIOS").suspend() ;
   }
} // extern "C"
