% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_retweets_of_userv2.R
\name{get_retweets_of_user}
\alias{get_retweets_of_user}
\title{Get retweets of user}
\usage{
get_retweets_of_user(
  users,
  start_tweets,
  end_tweets,
  bearer_token,
  n = 100,
  file = NULL,
  data_path = NULL,
  bind_tweets = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{users}{character vector, user handles from which to collect data}

\item{start_tweets}{string, starting date}

\item{end_tweets}{string, ending date}

\item{bearer_token}{string, bearer token}

\item{n}{integer, amount of tweets to be fetched}

\item{file}{string, name of the resulting RDS file}

\item{data_path}{string, if supplied, fetched data can be saved to the designated path as jsons}

\item{bind_tweets}{If \code{TRUE}, tweets captured are bound into a data.frame for assignment}

\item{verbose}{If \code{FALSE}, query progress messages are suppressed}

\item{...}{arguments will be passed to \code{build_query()} function. See \code{?build_query()} for further information.}
}
\value{
a data frame
}
\description{
This function collects retweets of tweets by a user or set of users between specified date ranges.
Tweet-level data is stored in a data/ path as a series of JSONs beginning "data_"; User-level data is stored as
a series of JSONs beginning "users_". If a filename is supplied, this function will save the result as a RDS file,
otherwise it will return the results as a dataframe.
}
\examples{
\dontrun{
bearer_token <- "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
users <- c("cbarrie", "justin_ct_ho")
get_retweets_of_user(users, "2020-01-01T00:00:00Z", "2020-04-05T00:00:00Z", 
                     bearer_token, data_path = "data/")
}
}
