% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_all_tweetsv2.R
\name{get_all_tweets}
\alias{get_all_tweets}
\title{Get tweets from full archive search}
\usage{
get_all_tweets(
  query = NULL,
  start_tweets,
  end_tweets,
  bearer_token,
  n = 100,
  file = NULL,
  data_path = NULL,
  export_query = TRUE,
  bind_tweets = TRUE,
  page_n = 500,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{query}{string or character vector, search query or queries}

\item{start_tweets}{string, starting date}

\item{end_tweets}{string, ending date}

\item{bearer_token}{string, bearer token}

\item{n}{integer, amount of tweets to be fetched}

\item{file}{string, name of the resulting RDS file}

\item{data_path}{string, if supplied, fetched data can be saved to the designated path as jsons}

\item{export_query}{If \code{TRUE}, queries are exported to data_path}

\item{bind_tweets}{If \code{TRUE}, tweets captured are bound into a data.frame for assignment}

\item{page_n}{integer, amount of tweets to be returned by per page}

\item{verbose}{If \code{FALSE}, query progress messages are suppressed}

\item{...}{arguments will be passed to \code{build_query()} function. See \code{?build_query()} for further information.}
}
\value{
a data.frame
}
\description{
This function collects tweets containing strings or hashtags
between specified date ranges. Tweet-level data is stored in a data/ path as a series of JSONs beginning "data_";
User-level data is stored as a series of JSONs beginning "users_". If a filename is supplied, this function will
save the result as a RDS file, otherwise it will return the results as a dataframe.
}
\examples{
\dontrun{
bearer_token <- "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"

get_all_tweets(query = "BLM", 
               start_tweets = "2020-01-01T00:00:00Z", 
               end_tweets = "2020-01-05T00:00:00Z", 
               bearer_token = bearer_token, 
               data_path = "data")
               
get_all_tweets(start_tweets = "2021-01-01T00:00:00Z", 
               end_tweets = "2021-06-01T00:00:00Z",
               bearer_token = bearer_token, 
               n = 200, 
               conversation_id = "1392887366507970561")
}
}
