**What the pull request does**   

Explain in a few words what the pull request does.

**Type of change**   

Please indicate the relevant option(s)

- [ ] :bug: Bug fix (non-breaking change which fixes an issue)
- [ ] :sparkle: New feature (non-breaking change which adds functionality)
- [ ] :boom: Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] :book: This change requires a documentation update

**Checklist**

- [ ] The changes are documented
  - [ ] The docstrings of the different functions describe the arguments, purpose, and behavior 
  - [ ] There are examples in the documentation website
- [ ] The changes are tested
- [ ] The changes **do not** modify the behavior of the previously existing functions
  - If they **do**, please explain why and how in the introduction paragraph
- [ ] For **new contributors** - my name and information are added to `.zenodo.json`
- [ ] The `Project.toml` field `version` has been updated
  - Change the *last* number for a `v0.0.x` series release, a bug fix, or a performance improvement
  - Change the *middle* number for additional features that *do not* break the current test suite (unless you fix a bug in the test suite)
  - Change the *first* number for changes that break the current test suite
