! 1) check the setup and give warning information
! 2) check model blowup

subroutine config_remind_warning_info
  ! Check configuration and options and provide reminding or warning.
  !
  ! Coded by Qiang Wang
  ! Reviewed by ??
  !--------------------------------------------------------------
  
  use o_param
  use o_array          
  use o_solver
  use g_config
  use g_parfe
  use g_clock
  use g_forcing_param
  use g_forcing_index
  use g_forcing_arrays
  implicit none

  if(mype/=0) return

#ifdef use_opbnd_restoring
  write(*,*) '---------------------------------------------------'
  write(*,*) 'Reminding:'
  write(*,*) 'It is configured to restore velocity at open boundarie.'
  write(*,*) 'Routine init_restoring_vel should be specifically prepared.'
  write(*,*) '---------------------------------------------------'
#endif

  if(buffer_zone) then
     write(*,*) '---------------------------------------------------'
     write(*,*) 'Reminding:'
     write(*,*) 'It is configured to restore tracers at open boundaries.'
     write(*,*) 'Routine init_restoring_bufferzone should be specifically'
     write(*,*) 'prepared.'
     write(*,*) '---------------------------------------------------'
  end if

#if defined(use_opbnd_tide) || defined(use_opbnd_restoring)
  if(.not.buffer_zone) then
     write(*,*) '---------------------------------------------------'
     write(*,*) 'Warning:'
     write(*,*) 'It is recommended to restore tracers in a buffer zone near o.b.'
     write(*,*) '---------------------------------------------------'
  end if
#endif

#ifdef use_opbnd_tide
#ifndef use_semiimplicit_scheme
  write(*,*) '---------------------------------------------------'
  write(*,*) 'Warning:'
  write(*,*) 'It is recommended to use the semi-implicit scheme when'
  write(*,*) 'simulating tides. To change, set it in the Makefile.'
  write(*,*) '---------------------------------------------------'
#endif
#endif

#ifdef use_ice
  if(restore_s_surf>0.0) then
     write(*,*) '---------------------------------------------------'
     write(*,*) 'Reminding:'
     write(*,*) 'It is specified to restore SSS. Check which climatology is'
     write(*,*) 'to be used (yearly or monthly, which source) and modify the'
     write(*,*) 'code in file gen_forcing_couple.F90 for your purpose.'
     write(*,*) 'Also check how restoring under ice is done in the code;'
     write(*,*) 'you might need to change the code for your application.'
     write(*,*) '---------------------------------------------------'
  end if
#endif

  if(balance_salt_water) then
     write(*,*) '---------------------------------------------------'
     write(*,*) 'Reminding:'
     write(*,*) 'You specified to balance salt and freshwater fluxes.'
     write(*,*) 'The default is to do correction for every time step.'
     write(*,*) 'You might need your own correction strategy. Check'
     write(*,*) 'the code to be sure it does what you want.'
     write(*,*) '---------------------------------------------------'
   end if  

#ifndef use_ice
  write(*,*) '---------------------------------------------------'
  write(*,*) 'Warning:'
  write(*,*) 'You are running the ocean-alone model. The surface forcing routine'
  write(*,*) 'should be adjusted/checked to properly apply your particular surface'
  write(*,*) 'forcing to the ocean.'
  write(*,*) '---------------------------------------------------'
#endif

#ifdef use_cavity
  write(*,*) '---------------------------------------------------'
  write(*,*) 'Reminding:'
  write(*,*) 'Your have ice shelf in your mesh.'
  write(*,*) 'You need to specify your own way to initialize T/S under the cavity.'
  write(*,*) 'Example routines are in file oce_cavity.'
  write(*,*) '---------------------------------------------------'
#endif


  if(wind_data_source=='NCEP' .and. ncar_bulk_formulae) then
      write(*,*) '---------------------------------------------------'
      write(*,*) 'Warning:'
      write(*,*) 'you are using NCEP 2m air temperature and humidity. The current'
      write(*,*) 'formulae for calculating drag and heat exchange coefficients'
      write(*,*) 'only support 10m data. If you plan to use these formulae, a small'
      write(*,*) 'update is required, though the inconsistence might be small.'
      write(*,*) '---------------------------------------------------'
  end if

  if(mix_scheme=='MY2p5') then
     write(*,*) '---------------------------------------------------'
     write(*,*) 'Reminding:'
     write(*,*) 'MY2.5 mixing scheme is to be used. Its variables will'
     write(*,*) 'be saved at the end of the run for the next restart job.'
     write(*,*) 'This file will be replaced in each restart run. So it'
     write(*,*) 'is not possible to restart from intermediate snapshots,'
     write(*,*) 'or from previous runs if the file is not backed up'
     write(*,*) 'manually. To get rid of this limit, code need update.'
     write(*,*) '---------------------------------------------------'
  end if

  if(use_passive_tracer) then
     if(ptr_start_year>yearnew) then
        write(*,*) '---------------------------------------------------'
        write(*,*) 'Warning:'
        write(*,*) 'You specify to use passive tracers not at the beginning of'
        write(*,*) 'this job. This is not supported. The model will start to'
        write(*,*) 'include the passive tracers from the beginning of this job.'
        write(*,*) 'If you do not want this, cancel this job, turn off'
        write(*,*) 'use_passive_tracer, run the model until the moment when'
        write(*,*) 'you want to have the passive tracers, and then re-start the'
        write(*,*) 'simulation with passive tracers used.'
        write(*,*) '---------------------------------------------------'
     end if
  end if

  if(use_age_tracer) then
     if(age_tracer_start_year>yearnew) then
        write(*,*) '---------------------------------------------------'
        write(*,*) 'Warning:'
        write(*,*) 'You specify to use age tracers not at the beginning of'
        write(*,*) 'this job. This is not supported. The model will start to'
        write(*,*) 'include the age tracers from the beginning of this job.'
        write(*,*) 'If you do not want this, cancel this job, turn off'
        write(*,*) 'use_age_tracer, run the model until the moment when'
        write(*,*) 'you want to have the age tracers, and then re-start the'
        write(*,*) 'simulation with age tracers used.'
        write(*,*) '---------------------------------------------------'
     end if
  end if
end subroutine config_remind_warning_info
!
!--------------------------------------------------------------------------
!
subroutine check_blowup
  ! Check if the model blows up and cancel the job if it is the case.
  ! Salinity is used as an indicator.
  ! ALLREDUCE is used, so it slows down the code somehow. 
  ! A better way is requried!
  ! One can turn on/off this function in namelist.diag
  !
  ! Coded by Qiang Wang
  ! Reviewed by ??
  !--------------------------------------------------------------
  
  use o_array          
  use g_config
  use g_parfe
  implicit none

  integer     :: flag, g_flag

  flag=0
  !any(abs(uf(1:mydim_nod3d))>10.0) .or. & 
     
  if(any(tracer(:,2)<0.0)             .or. &
     any(tracer(:,2)>65.0)) then
     flag=1
     write(*,*)
     write(*,*) '____gen_warning.F90 > check_blowup_____________________________'
     write(*,*) '-->  mype: ',mype
     write(*,*) '--> istep: ',istep
     write(*,*)
     write(*,*) 'mype: ', mype, 'step: ', istep, ' any(salt<0.0)  -->', any(tracer(:,2)<0.0)  !, ' min(salt)=' , minval(tracer(:,2))
     write(*,*) 'mype: ', mype, 'step: ', istep, ' any(salt>60.0) -->', any(tracer(:,2)>60.0) !, ' max(salt)=' , maxval(tracer(:,2))
     write(*,*) 'mype: ', mype, 'step: ', istep, ' any(salt==nan) -->', any(tracer(:,2)/=tracer(:,2))
     write(*,*) 'mype: ', mype, 'step: ', istep, ' any(uv>10.0)   -->', any(abs(uf(1:mydim_nod3d))>10.0)
     write(*,*)
     write(*,*) 'Step: ', istep
  end if
  g_flag=0
  call MPI_AllREDUCE(flag, g_flag, 1, MPI_INTEGER, MPI_SUM, &
       MPI_COMM_WORLD, MPIerr)
  
  if(g_flag>0) then
     if(mype==0) then
        write(*,*) 'Velocity too large or salinity goes below zero.'
        write(*,*) 'The model will blow up!'
        write(*,*) 'The program is forced to stop here.'

	if(mype==0) then
		open(unit=50, file='goodfile')
		write(50,*)'blow up'
		close(50)
	end if
     end if
     
     call par_ex
     stop
  end if
end subroutine check_blowup
