# Open Science Project Repository
## Overview
This repo contains the data and code used for the study presented in the following paper:

[*Rainfall, temperature, and Classic Maya conflict: A comparison of hypotheses using Bayesian time-series analysis*]()

## Abstract
Studies published over the last decade have reached contrasting conclusions regarding the impact of climate change on conflict among the Classic Maya (ca. 250-900 CE). Some researchers have argued that rainfall declines exacerbated conflict in this civilisation. However, other researchers have found that the relevant climate variable was increasing summer temperatures and not decreasing rainfall. The goal of the study reported here was to test between these two hypotheses. To do so, we collated annually-resolved conflict and climate data, and then subjected them to a recently developed Bayesian method for analysing count-based times-series. The results indicated that increasing summer temperature exacerbated conflict while annual rainfall variation had no effect. This finding not only has important implications for our understanding of conflict in the Maya region during the Classic Period. It also contributes to the ongoing discussion about the likely impact of contemporary climate change on conflict levels. Specifically, when our finding is placed alongside the results of other studies that have examined temperature and conflict over the long term, it is clear that the impact of climate change on conflict is context dependent.  

[Corresponding Author: Prof. Mark Collard](https://www.sfu.ca/archaeology/faculty/collard.html)

## Software
The R scripts contained in this repository are intended for replication efforts and to improve the transparency of research. They are, of course, provided without warranty or technical support. That said, questions about the code can be directed to me, Chris Carleton, at ccarleton@protonmail.com.

### R
This analysis described in the associated manuscript was performed in R. Thus, you may need to download the latest version of [R](https://www.r-project.org/) in order to make use of the scripts contained in this repo. The core analysis can be replicated by running "nimblePois.R", which requires the [nimble](r.nimble.org) R package.

## Contact

[ORCID](https://orcid.org/0000-0001-7463-8638) |
[Google Scholar](https://scholar.google.com/citations?hl=en&user=0ZG-6CsAAAAJ) |
[Website](https://wccarleton.me)

## License

Shield: [![CC BY 4.0][cc-by-shield]][cc-by]

This work is licensed under a
[Creative Commons Attribution 4.0 International License][cc-by].

[![CC BY 4.0][cc-by-image]][cc-by]

[cc-by]: http://creativecommons.org/licenses/by/4.0/
[cc-by-image]: https://i.creativecommons.org/l/by/4.0/88x31.png
[cc-by-shield]: https://img.shields.io/badge/License-CC%20BY%204.0-lightgrey.svg
