## How to perform this step?

### Prepare your files

Prepare your repository for use with the `BinderHub`:

- The online repository (e.g., on GitHub or BitBucket) containing the notebook is public
- The repository does not require any personal or sensitive information (such as passwords)
- The repository has configuration files that specify its environment (e.g. environment.yml, requirements.txt)

Let's consider a simple model housed in the [following repository](https://github.com/mosoriob/simpleModel-1).

If we inspect the contents of this repository, we see the following
files:

```bash
./
├── environment.yml
├── simpleModel.ipynb
└── README.md
```

In this case, we have two important files:

-   **A content (Notebook) file**: `simpleModel.ipynb` is a simple example using line fitting. In this case, we are trying to predict `y` (the output), given the input data `x` and input parameters `a,b,c` according to the following equation: `y=ax+b+c`. The input data `x` is contained in a `.csv` file and the model outputs `y` in a `.csv` file.
-   **An environment configuration file**: `environment.yml` is a
    standard file that specifies an Anaconda environment. The environment contains information about the packages needed to execute the notebook. To learn how to create `environment.yml` file from Anaconda, follow [this guide](https://conda.io/projects/conda/en/latest/user-guide/tasks/manage-environments.html#sharing-an-environment).

!!! importart
    You may notice that `environment.yml` is not Binder-specific. This is
    intentional! Binder tries to use environment configuration files that
    are already standards in the data science community. For a list of all
    configuration files available, see the  [Binder](https://mybinder.readthedocs.io/en/latest/using/config_files.html#config-files) page.


### Build your repository


Next, let's **build your Binder repository**. Head to <https://mybinder.org>.
You'll see a form that asks you to specify a repository for mybinder.org to
build. In the first field, paste the URL of your forked repository. It'll look
something like this:

```
https://github.com/<your-username>/simpleModel-1
```

Finally, click the **launch** button. This will ask mybinder.org to
build the environment needed to run the repository. You can click on the
"Build logs" button to see the logs generated by the build process.

While your Binder repository is building, note the URL that points to your unique Binder.
You can share this URL with a friend, allowing them to access an interactive
version of your repository.

See below for a quick layout of the BinderHub user interface.

![The myinder.org UI](_static/images/mybinder-ui-start.png)

If your Binder repository has already been built once, then subsequent clicks on
the Binder link will not re-trigger the build process. However, if you
push any changes to the repository, then it will be re-built the next time
somebody clicks a link.

If your environment files and content files are not housed in the same branch of the same repository, see [this documentation](https://mybinder.readthedocs.io/en/latest/howto/external_binder_setup.html) on how to generate a URL.

Now that you're acquainted with Binder, see [this page](https://mybinder.readthedocs.io/en/latest/introduction.html)
for more information about what you can do with it.
