package de.rss.fachstudie.MiSim.entities.networking;

import de.rss.fachstudie.MiSim.entities.generator.Generator;
import de.rss.fachstudie.MiSim.entities.microservice.Operation;
import de.rss.fachstudie.MiSim.export.MultiDataPointReporter;
import desmoj.core.simulator.Model;

/**
 * A {@code Request} that represents a request that is created by a user from outside the simulated system.
 * <p>
 * These type of requests are generated by the {@code Generator}s and do not have a parent request.
 * They are usually the root request of a trace.
 *
 * @author Lion Wagner
 * @see Generator
 */
public class UserRequest extends Request {

    private static final MultiDataPointReporter reporter = new MultiDataPointReporter("R");

    public UserRequest(Model model, String name, boolean showInTrace, Operation operation) {
        super(model, name, showInTrace, null, operation, null);//TODO: insert generator as requester here
    }


    @Override
    protected void onReceive() {
        super.onReceive();
        reporter.addDatapoint(String.format("[%s]_ResponseTimes", operation.getName()), presentTime(), getResponseTime());
    }


}
