C Pass the head to daycent and receive the recharge 
      MODULE ModToDaycent
        include 'mpif.h'
        real, dimension(:,:), allocatable:: hbuf,SY,hrech,hrf
	integer ierr, world_rank, istat(MPI_STATUS_SIZE),nsize
	integer comm_world,S,color,key,comm_worker,nline


      CONTAINS 

C Initilize MPI, seperate processor into two groups and send the size of head aray
      SUBROUTINE MPI_COLOR()
	      call MPI_INIT ( ierr )
	      call MPI_Comm_rank(MPI_COMM_WORLD,world_rank,ierr)
	      if (world_rank>0) then
	      		color=1
	      else 
			    color=0
	      end if 
	      key=0
	      call MPI_COMM_SPLIT(MPI_COMM_WORLD,color,key,comm_worker,
     &	      ierr)

      END SUBROUTINE 

C Pass the model basic information to Daycent: nrow, ncol, SY, SurfElev
c and the initial head 
      SUBROUTINE PassBasic(head_init)
      	USE GLOBAL,	ONLY: NCOL,NROW, BOTM, DELR, DELC
	USE GWFUPWMODULE, ONLY: SC2UPW
	real(8) :: head_init(:,:)
	integer i, j
	      S=NCOL*NROW
	      ALLOCATE(SY(NROW,NCOL))	
	      call MPI_Send(NROW, 1, MPI_INT, 1, 0, MPI_COMM_WORLD,
     &	      ierr)
	      call MPI_Send(NCOL, 1, MPI_INT, 1, 1, MPI_COMM_WORLD,
     &	      ierr)
	      call MPI_Send(BOTM(:,:,0), S, MPI_INT, 1, 2, MPI_COMM_WORLD,
     &	      ierr)
	      DO i=1,NROW
	     	 DO  j=1,NCOL
	     		 SY(i,j)=SC2UPW(j,i,1)/DELC(i)/DELR(j)
	      	 END DO
	      END DO 
c		print*, SY 
	      call MPI_Send(SY, S, MPI_INT, 1, 3, MPI_COMM_WORLD,
     &	      ierr)
	      ALLOCATE(hbuf(NROW,NCOL))	
		hbuf=head_init
		call MPI_Send(hbuf, S, MPI_INT, 1, 0, MPI_COMM_WORLD,
     &	      ierr)
c recieve number of soil cells 
	    IF (world_rank==0) THEN
		CALL  MPI_Recv(nline,1, MPI_INT, 1, 0, MPI_COMM_WORLD,istat,
     &	      ierr)
		print*,nline*3
		ALLOCATE(hrech(nline,3))
		ALLOCATE(hrf(nline,3))
	    end if 
      END SUBROUTINE 

C Send the head to Daycent 
      SUBROUTINE PassHead(head_o,head_n)
		real :: head_o(:,:)
		real(8) :: head_n(:,:)
c		print*, sum(head_n-head_o)
		IF (world_rank==0) THEN
			hbuf=head_o
			call MPI_Send(hbuf, S, MPI_INT, 1, 0, MPI_COMM_WORLD,
     &	      ierr)
			hbuf=head_n

			call MPI_Send(hbuf, S, MPI_INT, 1, 1, MPI_COMM_WORLD,
     &	      ierr)

	   	END IF
      END SUBROUTINE 	


C Receive the recharge from Daycent
      SUBROUTINE ReceiveRech()
	    IF (world_rank==0) THEN
		nsize=nline*3
		CALL  MPI_Recv(hrech,nsize, MPI_INT, 1, 1, MPI_COMM_WORLD,istat,
     &	      ierr)
		CALL  MPI_Recv(hrf,nsize, MPI_INT, 1, 2, MPI_COMM_WORLD,istat,
     &	      ierr)
c		      print *, "Recharge Received by MODFLOW",(hrech(:,3))
c		      print *, "Runoff Received by MODFLOW",sum(hrf(:,3))
	    END IF 
      END SUBROUTINE 	
      
C Change the recharge in MODFLOW 
      SUBROUTINE ChangeRech(irech)
		USE GLOBAL,	ONLY:DELR,DELC,NROW,NCOL
		USE GWFRCHMODULE,ONLY:RECH
		integer m,R,C,step
		real :: irech(:,:)
		DO m=1, nline
			R=hrech(m,1)
			C=hrech(m,2)
C			print*,"UNCHANGED RECHARGE in period is ", irech(C,R)
C			print*,"OLD RECHARGE IS ", RECH(C,R)
			RECH(C,R)=hrech(m,3)*DELR(C)*DELC(R)/30.4
     & 					-hrf(m,3)*DELR(C)*DELC(R)/30.4
C			print*,"NEW RECHARGE IS ", RECH(C,R)

		END DO 

      END SUBROUTINE 
      END MODULE ModToDaycent	



   
