![](http://i.imgur.com/EOowdSD.png)

[![PyPI version](https://badge.fury.io/py/lifelines.svg)](https://badge.fury.io/py/lifelines)
[![Anaconda-Server Badge](https://anaconda.org/conda-forge/lifelines/badges/installer/conda.svg)](https://conda.anaconda.org/conda-forge)
[![Build Status](https://travis-ci.org/CamDavidsonPilon/lifelines.svg?branch=master)](https://travis-ci.org/CamDavidsonPilon/lifelines)
[![Coverage Status](https://coveralls.io/repos/github/CamDavidsonPilon/lifelines/badge.svg?branch=master)](https://coveralls.io/github/CamDavidsonPilon/lifelines?branch=master)
[![DOI](https://zenodo.org/badge/12420595.svg)](https://zenodo.org/badge/latestdoi/12420595)


[What is survival analysis and why should I learn it?](http://lifelines.readthedocs.org/en/latest/Survival%20Analysis%20intro.html)
 Survival analysis was originally developed and applied heavily by the actuarial and medical community. Its purpose was to answer *why do events occur now versus later* under uncertainty (where *events* might refer to deaths, disease remission, etc.). This is great for researchers who are interested in measuring lifetimes: they can answer questions like *what factors might influence deaths?*

But outside of medicine and actuarial science, there are many other interesting and exciting applications of survival analysis. For example:
- SaaS providers are interested in measuring subscriber lifetimes, or time to some first action
- inventory stock out is a censoring event for true "demand" of a good.
- sociologists are interested in measuring political parties' lifetimes, or relationships, or marriages
- A/B tests to determine how long it takes different groups to perform an action.

*lifelines* is a pure Python implementation of the best parts of survival analysis.


## Documentation and intro to survival analysis

If you are new to survival analysis, wondering why it is useful, or are interested in *lifelines* examples, API, and syntax, please read the [Documentation and Tutorials page](http://lifelines.readthedocs.org/en/latest/index.html)

## Contact
 - Start a conversation in our [Discussions room](https://github.com/CamDavidsonPilon/lifelines/discussions).
 - Some users have posted common questions at [stats.stackexchange.com](https://stats.stackexchange.com/search?tab=votes&q=%22lifelines%22%20is%3aquestion)
 - creating an issue in the [Github repository](https://github.com/camdavidsonpilon/lifelines).

## Roadmap
You can find the roadmap for lifelines [here](https://www.notion.so/camdp/6e2965207f564eb2a3e48b5937873c14?v=47edda47ab774ca2ac7532bb0c750559).

## Development

See our [Contributing](https://github.com/CamDavidsonPilon/lifelines/blob/master/.github/CONTRIBUTING.md) guidelines.

## Citing lifelines

You can use this badge below to generate a DOI and reference text for the latest related version of lifelines:

 [![DOI](https://zenodo.org/badge/12420595.svg)](https://zenodo.org/badge/latestdoi/12420595)
