function assert_validity(object, type)
% Ensures the object is of a correct type and is not empty.

% SyneRBI Synergistic Image Reconstruction Framework (SIRF).
% Copyright 2015 - 2017 Rutherford Appleton Laboratory STFC.
% 
% This is software developed for the Collaborative Computational
% Project in Synergistic Reconstruction for Biomedical Imaging (formerly CCP PETMR)
% (http://www.ccpsynerbi.ac.uk/).
% 
% Licensed under the Apache License, Version 2.0 (the "License");
% you may not use this file except in compliance with the License.
% You may obtain a copy of the License at
% http://www.apache.org/licenses/LICENSE-2.0
% Unless required by applicable law or agreed to in writing, software
% distributed under the License is distributed on an "AS IS" BASIS,
% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
% See the License for the specific language governing permissions and
% limitations under the License.

errID = 'SIRF:assert_validity';
if ~ismethod(object, 'class_name')
    error(errID, 'expected %s, got %s\n', type, class(object))
end

if ~strcmp(object.class_name(), type)
    error(errID, 'expected %s, got %s\n', type, object.class_name())
end

assert(~isempty(object.handle_), errID, 'empty object')