function image = my_osmaposl...
    (init_image, obj_fun, prior, filter, num_subsets, num_subiterations)
% Function implementing OSMAPOSL, an Ordered Subsets (OS) version of the One 
% Step Late algorithm (OSL) from Green et al for Maximum a Posteriori (MAP) 
% maximisation. 

% SyneRBI Synergistic Image Reconstruction Framework (SIRF).
% Copyright 2015 - 2018 Rutherford Appleton Laboratory STFC.
% Copyright 2015 - 2017 University College London.
% 
% This is software developed for the Collaborative Computational
% Project in Synergistic Reconstruction for Biomedical Imaging (formerly CCP PETMR)
% (http://www.ccpsynerbi.ac.uk/).
% 
% Licensed under the Apache License, Version 2.0 (the "License");
% you may not use this file except in compliance with the License.
% You may obtain a copy of the License at
% http://www.apache.org/licenses/LICENSE-2.0
% Unless required by applicable law or agreed to in writing, software
% distributed under the License is distributed on an "AS IS" BASIS,
% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
% See the License for the specific language governing permissions and
% limitations under the License.

if nargin < 1 % for run_all.m to ignore this function
    image = [];
    return
end

image = init_image;
for iter = 1 : num_subiterations
    fprintf('\n------------- Subiteration %d\n', iter) 

    % select subset
    subset = iter - 1;

    % get sensitivity as ImageData
    sens_image = obj_fun.get_subset_sensitivity(subset);

    % get backprojection of the ratio of measured to estimated
    % acquisition data
    grad_image = obj_fun.get_backprojection_of_acquisition_ratio...
                 (image, subset);

    % get gradient of prior as ImageData
    prior_grad_image = prior.get_gradient(image);

    % update image data
    denom = sens_image + prior_grad_image/num_subsets;
    update = grad_image./denom;
    image = image.*update;

    % apply filter
    filter.apply(image);

end
end
