# Synergistic Image Reconstruction Framework

[![gh-action-badge]][gh-action-link]
<!--
[![coveralls-badge]][coveralls] [![codecov-badge]][codecov] -->
[![style-badge]][style-link]
[![zenodo-badge]][zenodo-link]

This software is the main output of [SyneRBI](https://www.ccpsynerbi.ac.uk), the Collaborative Computational 
Platform for Synergistic Reconstruction for Biomedical Imaging (formerly CCP PETMR).

Please start with our latest [User's Guide](doc/UserGuide.md).
See [our Wiki page for installation instructions](https://github.com/SyneRBI/SIRF/wiki/Installation-instructions).

You can also [download a VM](https://doi.org/10.5281/zenodo.2707911) with SIRF and related software preinstalled.

# Where is everything installed?

SIRF largely follows the usual directory structure with some minor tweaks. When using
the default options when building SIRF, you will get (most of the) following, depending
what was found/built:
```
<install-dir>/
    bin/            # executables
    lib/            # libraries
    python/         # Python files
    matlab/         # MATLAB files
    share/SIRF-V.v/ # versioned location (e.g. SIRF-3.0)
       doc/         # doxumentation
          doxygen/  # C++ documentation files generated by doxygen
          examples/ # example scripts
       data/        # data used in example scripts
```

[coveralls-badge]: https://coveralls.io/repos/github/CCPPETMR/SIRF/badge.svg?branch=master
[coveralls]: https://coveralls.io/github/CCPPETMR/SIRF?branch=master
[codecov-badge]: https://codecov.io/gh/SyneRBI/SIRF/branch/master/graph/badge.svg
[codecov]: https://codecov.io/gh/SyneRBI/SIRF
[gh-action-badge]: https://github.com/SyneRBI/SIRF/actions/workflows/build-test.yml/badge.svg
[gh-action-link]: https://github.com/SyneRBI/SIRF/actions/workflows/build-test.yml
[travis-badge]: https://travis-ci.org/SyneRBI/SIRF.svg?branch=master
[travis]: https://travis-ci.org/SyneRBI/SIRF
[style-badge]: https://api.codacy.com/project/badge/Grade/392861b4085f4f438d12c41029f86b47
[style-link]: https://www.codacy.com/gh/SyneRBI/SIRF?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=SyneRBI/SIRF&amp;utm_campaign=Badge_Grade
[zenodo-badge]: https://zenodo.org/badge/DOI/10.5281/zenodo.3885368.svg
[zenodo-link]: https://doi.org/10.5281/zenodo.3885368
