function  Ovl = ctSent_readOvl
parm = load('parms');
filepath = load('ovlpath');
slcpath = filepath.slcpath;
ndate = length(slcpath);
masterIndex = 0;
for i = 1:ndate
    datestr = slcpath(i).date;
    if strcmp(datestr,parm.masterdate)
        masterIndex = i;
    end
end
fprintf('    Extracting overlapping region... \n');
info_mas = load(slcpath(masterIndex).infopath);
info_mas = info_mas.infosave;
nSubswath = length(info_mas.IW);
for k = 1:nSubswath
    novl = size(info_mas.IW(k).BurstUse,2)-1;
for i = 1:novl
    [Rect_up,Rect_lo] = getOverlappedRectangles(i,info_mas.IW(k).subSwath);
    Ovl.IW(k).overlap(i).upslcstack = zeros(Rect_up(4),Rect_up(3),ndate,'single');
    Ovl.IW(k).overlap(i).loslcstack = zeros(Rect_up(4),Rect_up(3),ndate,'single');
    fprintf(['    Extracting ',info_mas.IW(k).Swathname,' No. %d overlapping region... \n'],i);
    for j = 1:ndate
        fprintf('------------ %d of %d days ------------ \n',j,ndate);
        Burst_up = readcpx(slcpath(j).ovlpath{k,i,1},Rect_up(3),Rect_up(4));
        Ovl.IW(k).overlap(i).upslcstack(:,:,j) = Burst_up;
        Burst_lo = readcpx(slcpath(j).ovlpath{k,i,2},Rect_lo(3),Rect_lo(4));
        Ovl.IW(k).overlap(i).loslcstack(:,:,j) = Burst_lo;
        fprintf('    Reading finished ... \n');
        fclose('all');
    end
end
end
end
function [Rectangle1,Rectangle2]=getOverlappedRectangles(overlapIndex,subSwath)
firstValidPixelOfBurstOne = getBurstFirstValidPixel(overlapIndex,subSwath);
lastValidPixelOfBurstOne = getBurstLastValidPixel(overlapIndex,subSwath);
firstValidPixelOfBurstTwo = getBurstFirstValidPixel(overlapIndex + 1,subSwath);
lastValidPixelOfBurstTwo = getBurstLastValidPixel(overlapIndex + 1,subSwath);
firstValidPixel = max(firstValidPixelOfBurstOne, firstValidPixelOfBurstTwo);
lastValidPixel = min(lastValidPixelOfBurstOne, lastValidPixelOfBurstTwo);
x0 = firstValidPixel;
w = lastValidPixel - firstValidPixel + 1;
numOfInvalidLinesInBurstOne = subSwath.linesPerBurst -...
                subSwath.lastValidLine(overlapIndex) - 1;
numOfInvalidLinesInBurstTwo = subSwath.firstValidLine(overlapIndex + 1);
numOverlappedLines = computeBurstOverlapSize(overlapIndex,subSwath);
h = numOverlappedLines - numOfInvalidLinesInBurstOne - numOfInvalidLinesInBurstTwo;
% y0BurstOne =subSwath.linesPerBurst * (overlapIndex) - numOfInvalidLinesInBurstOne - h;
y0BurstOne =subSwath.linesPerBurst - numOfInvalidLinesInBurstOne - h;
y0BurstTwo =  numOfInvalidLinesInBurstTwo;
Rectangle1=[x0, y0BurstOne, w, h];
Rectangle2=[x0, y0BurstTwo, w, h];
end
function index=getBurstFirstValidPixel(burstIndex,subSwath)
[~,n]=size(subSwath.firstValidSample);
        for lineIdx = 1:n
            if (subSwath.firstValidSample(burstIndex,lineIdx) ~= -1) 
                index=subSwath.firstValidSample(burstIndex,lineIdx);
                break;
            end
        end
end
function index=getBurstLastValidPixel(burstIndex,subSwath)
[~,n]=size(subSwath.lastValidSample);
        for lineIdx = 1:n
            if (subSwath.lastValidSample(burstIndex,lineIdx) ~= -1) 
                index=subSwath.lastValidSample(burstIndex,lineIdx);
                break;
            end
        end
end
function numOverlappedLines = computeBurstOverlapSize(overlapIndex,subSwath)
endTime = subSwath.burstLastLineTime(overlapIndex);
startTime = subSwath.burstFirstLineTime(overlapIndex + 1);
numOverlappedLines =floor((endTime - startTime) / subSwath.azimuthTimeInterval);
end

