function [slcstack,lat,lon,inc,hgt,bperp_mat,ac_date] = ctSent_readDeb(window)
slcpath = load('debSlc.mat');
dateslc = load('slcpath.mat');
debSlc = slcpath.slcsavepath;
dates = dateslc.slcpath;
if nargin<1
    window =[1 slcpath.Lines 1 slcpath.Pixels];
    % row_start,row_end,column_start,column_end
end
for i = 1:length(dates)
    ac_date(i,1) = str2double(dates(i).date);
end
slcstack = zeros(window(2)-window(1)+1,window(4)-window(3)+1,length(debSlc),'single');
for i=1:length(debSlc)
    [data, ~] = freadbk(debSlc(i).savepath,slcpath.Lines,'mph',window(1),window(2),window(3),window(4));
    %data = data(window(1):window(2),window(3):window(4));
    slcstack(:,:,i) = single(data);
    fprintf('Reading SLC %d / %d \n',i,length(debSlc));
end
[lat,lon,inc,hgt,bperp_mat] = ctSent_readAuxiliary(window);
end
function [lat,lon,inc,hgt,bperp_mat] = ctSent_readAuxiliary(window)
basepath = load('baseline.mat');
geopath = load('debGeo.mat');
debSlc = basepath.basesavepath;
debGeo = geopath.debGeo;
if nargin<1
    window =[1 basepath.Lines 1 basepath.Pixels];
    % row_start,row_end,column_start,column_end
end
fprintf('Reading Latitude \n');
data = freadCt(debGeo.lat,basepath.Lines,basepath.Pixels);
lat = data(window(1):window(2),window(3):window(4));
fprintf('Reading Longitude \n');
data = freadCt(debGeo.lon,basepath.Lines,basepath.Pixels);
lon = data(window(1):window(2),window(3):window(4));
fprintf('Reading Elevation \n');
data = freadCt(debGeo.hgt,basepath.Lines,basepath.Pixels);
hgt = data(window(1):window(2),window(3):window(4));
fprintf('Reading Incidence \n');
data = freadCt(debGeo.inc,basepath.Lines,basepath.Pixels);
inc = data(window(1):window(2),window(3):window(4));
bperp_mat = zeros(window(2)-window(1)+1,window(4)-window(3)+1,length(debSlc),'single');
for i=1:length(debSlc)
    data = freadCt(debSlc(i).savepath,basepath.Lines,basepath.Pixels);
    data = data(window(1):window(2),window(3):window(4));
    bperp_mat(:,:,i) = single(data);
    fprintf('Reading Baseline %d / %d \n',i,length(debSlc));
end
end
