function ctSent_parms_default()
%ctSent_PARMS_DEFAULT set parms to default value if not already set
%
%   Zhangfeng Ma, Hohai University 
%   July 2019
%
%   ======================================================================


parmfile='parms.mat';
parms=struct('Created',date);

if ~isfield(parms,'workDir')
    parms.workDir = 'J:\Geothermal';%
end

if ~isfield(parms,'rectangle')
%     parms.rectangle = [28.5 28.6 103.6 103.8];
%       parms.rectangle = [28.24 28.26 103.5 103.7];
   parms.rectangle = [39.4 39.7 -118.65 -118.35];
end

if ~isfield(parms,'esd_coh_threshold')
    parms.esd_coh_threshold = 0.6;
end

if ~isfield(parms,'orbit_degree')
    parms.orbit_degree = 3;
end

if ~isfield(parms,'coh_estimator')
    parms.coh_estimator = '2k';
end

if ~isfield(parms,'network_method')
    parms.network_method = 'mst';
end
if ~isfield(parms,'polarization')
    parms.polarization = 'VV'; 
end
if ~isfield(parms,'SLCPATH')
%     parms.SLCPATH = 'F:\SLC' ;
    parms.SLCPATH = 'D:\geothermal' ;
end
if ~isfield(parms,'ORBITPATH')
    parms.ORBITPATH = 'E:\Sentinel-Orbit\orbit' ;
end
if ~isfield(parms,'masterdate')
    parms.masterdate = [] ;
    %No input required here
end
if ~isfield(parms,'DEMPATH')
%     parms.DEMPATH = 'F:\SLCDEM\srtm_57_07.tif' ;
    parms.DEMPATH = 'E:\Sentinel-Orbit\DEM\california.tif';
end
if ~isfield(parms,'NetworkNum')
    parms.NetworkNum = 2 ;
    
end
if ~isfield(parms,'InterfeSuffix')
    parms.InterfeSuffix= 'esd' ;
end
save(parmfile,'-struct','parms')
end
