function ctSent_geocoregSLC
%GEOCOREGSLC Summary of this function goes here
%   Detailed explanation goes here
fprintf('#######################CtSent v1.0####################### \n');
fprintf('######################################################### \n');
fprintf('###########     Geometrical Co-registration      ######## \n');
fprintf('######################################################### \n');
fprintf('########     Zhang-Feng Ma, Hohai University      ####### \n');
fprintf('########        Mi Jiang  , Hohai University      ####### \n');
fprintf('########         Yi Zhao  , Hohai University      ####### \n');
fprintf('###################   9,July,2019    #################### \n');
parm = load('parms');
filepath = load('slcpath');
slcpath = filepath.slcpath;
ndate = length(slcpath);
masterIndex = 0;
for i = 1:ndate
    datestr = slcpath(i).date;
    if strcmp(datestr,parm.masterdate)
        masterIndex = i;
    end
end
if masterIndex == 0 
    fprintf('Master date cannot be detected and set the first acquisition as the Master reference... \n');
    masterIndex = 1;
end
info_mas = load(slcpath(masterIndex).infopath);
info_mas = info_mas.infosave;
nsubswath = length(info_mas.IW);
dem_read = readtiff(parm.DEMPATH);
for i = 1:ndate
    info_sla = load(slcpath(i).infopath);
    info_sla = info_sla.infosave;
    for j = 1:nsubswath
        nburst = info_mas.IW(j).subSwath.numOfBursts;
        novl = nburst - 1;
     if novl == 0
       fprintf('Only one burst, Enhanced Spectral Diversity skipped...\n');
     end
    for k = 1:nburst
        existfile = strcat(slcpath(i).savepath{j,k},'.geo');
        if i == masterIndex
            continue;
        elseif exist(existfile,'file')
        slcpath(i).savepath{j,k} = strcat(slcpath(i).savepath{j,k},'.geo');
        slcpath(i).derampdemodpath{j,k} = strcat(slcpath(i).savepath{j,k},'.rampmod');   
            continue;
        end
        masterBurstIndex = k;
        slaveBurstIndex = info_mas.IW(j).BurstUse(i,k);
        if slaveBurstIndex
        fprintf(['    Resample ',info_mas.IW(j).Swathname,' No. %d burst ... \n'],k);  
        samples = info_sla.IW(j).subSwath.samplesPerBurst;
        slavecplx = readcpx(slcpath(i).savepath{j,k},samples);
        tic;
        fprintf(['------------' info_sla.date '------------ \n']);
        fprintf('    Geometrical co-registration... \n');
        [resample_slavecplx,resample_slavedeRampphase] = ctSent_geoCoreg(info_mas.IW(j),info_sla.IW(j),...
            slavecplx,masterBurstIndex,slaveBurstIndex,dem_read);
        t = toc;
        fprintf('    Resampling completed in %d s ... \n',floor(t));
        slcpath(i).savepath{j,k} = strcat(slcpath(i).savepath{j,k},'.geo');
        slcpath(i).derampdemodpath{j,k} = strcat(slcpath(i).savepath{j,k},'.rampmod');  
        writecpx(slcpath(i).savepath{j,k},resample_slavecplx);
        fileID = fopen(slcpath(i).derampdemodpath{j,k},'w');
        fwrite(fileID,resample_slavedeRampphase,'float');
        fclose(fileID);
        end
    end
    fclose('all');
    end
end
save 'coregpath.mat' slcpath;
end
function [ dem ] = readtiff( path )
[elevation,R] = geotiffread(path);
info = geotiffinfo(path);
 height = info.Height; % Integer indicating the height of the image in pixels
 width = info.Width;
 %height1 = info.Height; % Integer indicating the height of the image in pixels
% width1 = info.Width;
 [rows,cols] = meshgrid(1:width,1:height);%[rows1,cols1] = meshgrid(1:height1,1:width1);
 % Getting the latitude and longitude of the points
 [lon,lat] = pix2map(info.RefMatrix, cols, rows);
 %[lon1,lat1] = pix2map(info.RefMatrix, rows1, cols1);
 %[lat,lon] = projinv(info, y,x);
%lon1=lon1';
%z=elevation;
dem.lat=flipud(lat);dem.lon=lon;
%Vq = geointerp(double(elevation),R,lat,lon);
dem.z = flipud(elevation);dem.R=R;
end