function  ctSent_Interferometry(flag)
%CTSENT_INTERFEROMETRY Summary of this function goes here
%   Detailed explanation goes here
fprintf('#######################CtSent v1.0####################### \n');
fprintf('######################################################### \n');
fprintf('#################     Interferometry    ################# \n');
fprintf('######################################################### \n');
fprintf('########     Zhang-Feng Ma, Hohai University      ####### \n');
fprintf('########        Mi Jiang  , Hohai University      ####### \n');
fprintf('########         Yi Zhao  , Hohai University      ####### \n');
fprintf('###################  30,July,2019    #################### \n');
if nargin < 1
    flag = 1;
end
parm = load('parms');
if strcmp(parm.InterfeSuffix,'esd')
    filepath = load('esdpath');
else
    filepath = load('coregpath');
end
filepath = load('esdpath');
% filepath = load('coregpath');
slcpath = filepath.slcpath;
ndate = length(slcpath);
masterIndex = 0;
for j = 1:ndate
    datestr = slcpath(j).date;
    if strcmp(datestr,parm.masterdate)
        masterIndex = j;
    end
end
if masterIndex == 0 
    fprintf('Master date cannot be detected and set the first acquisition as the Master reference... \n');
    masterIndex = 1;
end
info_mas = load(slcpath(masterIndex).infopath);
info_mas = info_mas.infosave;
nsubswath = length(info_mas.IW);
dem_read = readtiff(parm.DEMPATH);
if flag == 1
    for j = 1:nsubswath
        nburst = info_mas.IW(j).subSwath.numOfBursts;
    for k = 1:nburst
fprintf('    -----------------Radarcoding------------------\n');
fprintf(['    Generating lat lon hgt of ',info_mas.IW(j).Swathname,' Burst %d \n'],k);
tic;
[Lat,Lon,Elevation,Incidence] = ctSent_radarcode(info_mas.IW(j),k,dem_read);
t = toc;
fprintf('    Generated in %d s \n',floor(t));
fileDir  = [parm.workDir,'\GEO\',info_mas.IW(j).Swathname];
       if ~exist(fileDir,'dir')
         mkdir(fileDir);
       end
geopath.Lat{j,k} = [fileDir,'\lat.','burst',num2str(k)];
geopath.Lon{j,k} = [fileDir,'\lon.','burst',num2str(k)];
geopath.Hgt{j,k} = [fileDir,'\hgt.','burst',num2str(k)];
geopath.Inc{j,k} = [fileDir,'\inc.','burst',num2str(k)];
fprintf(['    Writing lat lon hgt of ',info_mas.IW(j).Swathname,' Burst %d... \n'],k);
fwriteCt(geopath.Lat{j,k},Lat);
fwriteCt(geopath.Lon{j,k},Lon);
fwriteCt(geopath.Hgt{j,k},Elevation);
fwriteCt(geopath.Inc{j,k},Incidence);
fprintf('    Compeleted... \n');
    end
    end
save 'geopath.mat' geopath;
end
for i = 1:ndate
    info_s = load(slcpath(i).infopath);
    info_s = info_s.infosave;
    for j = 1:nsubswath
        nburst = info_mas.IW(j).subSwath.numOfBursts;
    for k = 1:nburst
        if i == masterIndex
            fileDir  = [parm.workDir,'\SLC\',info_s.date,'\',info_mas.IW(j).Swathname];
            if ~exist(fileDir,'dir')
             mkdir(fileDir);
            end
            intfpath(i).savepath{j,k} = [fileDir,'\burst',num2str(k),'.slc'];
            intfpath(i).basepath{j,k} = [fileDir,'\burst',num2str(k),'.base'];
            mas = readcpx(slcpath(i).savepath{j,k},info_mas.IW(j).sensor_para.samplesPerBurst);
            intfpath(i).date = info_mas.date;
            writecpx(intfpath(i).savepath{j,k},mas);
            fwriteCt(intfpath(i).basepath{j,k},zeros(size(mas),'single'));
            continue;
        end
        masterBurstIndex = k;
        slaveBurstIndex = info_mas.IW(j).BurstUse(i,k);
        if slaveBurstIndex
    fileDir  = [parm.workDir,'\SLC\',info_s.date,'\',info_mas.IW(j).Swathname];
       if ~exist(fileDir,'dir')
         mkdir(fileDir);
       end
    fprintf(['    _______________',info_s.date,'_______________\n']);
    tic;
    fprintf(['    Generating Bperp Flatearth & Topo phase of ',info_mas.IW(j).Swathname,' Burst %d... \n'],k);
    [Bperpmat,refPhasemat] = ctSent_computeBnormal(info_mas.IW(j),info_s.IW(j),masterBurstIndex,dem_read);
    t = toc;
    fprintf('    Generated in %d s... \n',floor(t));
    sla = readcpx(slcpath(i).savepath{j,k},info_mas.IW(j).sensor_para.samplesPerBurst);
    flat_topo = complex(cos(refPhasemat),sin(refPhasemat));
    int = sla.*(flat_topo);
    intfpath(i).savepath{j,k} = [fileDir,'\burst',num2str(k),'.slc'];
    intfpath(i).basepath{j,k} = [fileDir,'\burst',num2str(k),'.base'];
    intfpath(i).date = info_s.date;
    fprintf(['    Writing Bperp Flatearth & Topo phase of ',info_mas.IW(j).Swathname,' Burst %d... \n'],k);
    writecpx(intfpath(i).savepath{j,k},int);
    fwriteCt(intfpath(i).basepath{j,k},Bperpmat);
    fprintf('    Completed... \n');
        end
    end
    end
end
save 'intfpath.mat' intfpath;
end
function fwriteCt(savepath,savedata)
fileID = fopen(savepath,'w');
fwrite(fileID,savedata,'float');
fclose(fileID);
end
