﻿using Core.Interfaces;
using Microsoft.Xna.Framework;
using Newtonsoft.Json;
using System;
using System.Linq;

namespace Core.Symmetry
{
    [Serializable]
    [JsonObject(MemberSerialization.OptIn)]
    public class IcosahedralSymmetryBuilder : SymmetryBuilder
    {
        public static string Architecture {  get { return "I"; } }
        public static string[] Units { get { return new string[] { "C5", "C3", "C2" }; } }
        public static int[] Multiplicities { get { return new int[] { 5, 3, 2 }; } }

        [JsonConstructor]
        public IcosahedralSymmetryBuilder()
        {
            Vector3[][] pentamers = new Vector3[][]
            {
                new Vector3[] { new Vector3(+0.85065080835204f,+0.52573111211914f,-0.00000000000000f), new Vector3(-0.42532540417602f,+0.68819096023558f,+0.58778525229248f), new Vector3(0,0,0)},       // xyz BP00_0
                new Vector3[] { new Vector3(+0.85065080835204f,+0.52573111211914f,-0.00000000000000f), new Vector3(+0.16245984811646f,-0.26286555605957f,+0.95105651629515f), new Vector3(0,0,0)},       // xyz BP00_1 
                new Vector3[] { new Vector3(+0.85065080835204f,+0.52573111211914f,-0.00000000000000f), new Vector3(+0.16245984811645f,-0.26286555605956f,-0.95105651629516f), new Vector3(0,0,0)},       // xyz BP00_2 
                new Vector3[] { new Vector3(+0.85065080835204f,+0.52573111211914f,-0.00000000000000f), new Vector3(-0.42532540417603f,+0.68819096023559f,-0.58778525229246f), new Vector3(0,0,0)},       // xyz BP00_3 
                new Vector3[] { new Vector3(+0.85065080835204f,+0.52573111211914f,-0.00000000000000f), new Vector3(+0.52573111211914f,-0.85065080835204f,-0.00000000000001f), new Vector3(0,0,0)},       // xyz BP00_4 
                new Vector3[] { new Vector3(-0.00000000000000f,+0.85065080835204f,+0.52573111211914f), new Vector3(+0.95105651629515f,+0.16245984811646f,-0.26286555605957f), new Vector3(0,0,0)},       // xyz BP01_0 
                new Vector3[] { new Vector3(-0.00000000000000f,+0.85065080835204f,+0.52573111211914f), new Vector3(+0.58778525229248f,-0.42532540417602f,+0.68819096023558f), new Vector3(0,0,0)},       // xyz BP01_1 
                new Vector3[] { new Vector3(-0.00000000000000f,+0.85065080835204f,+0.52573111211914f), new Vector3(-0.95105651629516f,+0.16245984811645f,-0.26286555605956f), new Vector3(0,0,0)},       // xyz BP01_2 
                new Vector3[] { new Vector3(-0.00000000000000f,+0.85065080835204f,+0.52573111211914f), new Vector3(-0.58778525229246f,-0.42532540417603f,+0.68819096023559f), new Vector3(0,0,0)},       // xyz BP01_3 
                new Vector3[] { new Vector3(-0.00000000000000f,+0.85065080835204f,+0.52573111211914f), new Vector3(-0.00000000000001f,+0.52573111211914f,-0.85065080835204f), new Vector3(0,0,0)},       // xyz BP01_4 
                new Vector3[] { new Vector3(+0.52573111211914f,-0.00000000000000f,+0.85065080835204f), new Vector3(-0.26286555605957f,+0.95105651629515f,+0.16245984811646f), new Vector3(0,0,0)},       // xyz BP02_0 
                new Vector3[] { new Vector3(+0.52573111211914f,-0.00000000000000f,+0.85065080835204f), new Vector3(+0.68819096023558f,+0.58778525229248f,-0.42532540417602f), new Vector3(0,0,0)},       // xyz BP02_1 
                new Vector3[] { new Vector3(+0.52573111211914f,-0.00000000000000f,+0.85065080835204f), new Vector3(-0.26286555605956f,-0.95105651629516f,+0.16245984811645f), new Vector3(0,0,0)},       // xyz BP02_2 
                new Vector3[] { new Vector3(+0.52573111211914f,-0.00000000000000f,+0.85065080835204f), new Vector3(-0.85065080835204f,-0.00000000000001f,+0.52573111211914f), new Vector3(0,0,0)},       // xyz BP02_3 
                new Vector3[] { new Vector3(+0.52573111211914f,-0.00000000000000f,+0.85065080835204f), new Vector3(+0.68819096023559f,-0.58778525229246f,-0.42532540417603f), new Vector3(0,0,0)},       // xyz BP02_4 
                new Vector3[] { new Vector3(+0.52573111211913f,+0.00000000000001f,-0.85065080835204f), new Vector3(+0.68819096023559f,+0.58778525229248f,+0.42532540417602f), new Vector3(0,0,0)},       // xyz BP03_0 
                new Vector3[] { new Vector3(+0.52573111211913f,+0.00000000000001f,-0.85065080835204f), new Vector3(-0.26286555605958f,+0.95105651629515f,-0.16245984811644f), new Vector3(0,0,0)},       // xyz BP03_1 
                new Vector3[] { new Vector3(+0.52573111211913f,+0.00000000000001f,-0.85065080835204f), new Vector3(+0.68819096023560f,-0.58778525229247f,+0.42532540417601f), new Vector3(0,0,0)},       // xyz BP03_2 
                new Vector3[] { new Vector3(+0.52573111211913f,+0.00000000000001f,-0.85065080835204f), new Vector3(-0.26286555605956f,-0.95105651629515f,-0.16245984811646f), new Vector3(0,0,0)},       // xyz BP03_3 
                new Vector3[] { new Vector3(+0.52573111211913f,+0.00000000000001f,-0.85065080835204f), new Vector3(-0.85065080835204f,-0.00000000000000f,-0.52573111211913f), new Vector3(0,0,0)},       // xyz BP03_4 
                new Vector3[] { new Vector3(-0.00000000000001f,+0.85065080835204f,-0.52573111211913f), new Vector3(+0.00000000000000f,+0.52573111211913f,+0.85065080835204f), new Vector3(0,0,0)},       // xyz BP07_0 
                new Vector3[] { new Vector3(-0.00000000000001f,+0.85065080835204f,-0.52573111211913f), new Vector3(+0.95105651629515f,+0.16245984811646f,+0.26286555605956f), new Vector3(0,0,0)},       // xyz BP07_1 
                new Vector3[] { new Vector3(-0.00000000000001f,+0.85065080835204f,-0.52573111211913f), new Vector3(+0.58778525229247f,-0.42532540417601f,-0.68819096023560f), new Vector3(0,0,0)},       // xyz BP07_2 
                new Vector3[] { new Vector3(-0.00000000000001f,+0.85065080835204f,-0.52573111211913f), new Vector3(-0.95105651629515f,+0.16245984811644f,+0.26286555605958f), new Vector3(0,0,0)},       // xyz BP07_3 
                new Vector3[] { new Vector3(-0.00000000000001f,+0.85065080835204f,-0.52573111211913f), new Vector3(-0.58778525229248f,-0.42532540417602f,-0.68819096023559f), new Vector3(0,0,0)},       // xyz BP07_4 
                new Vector3[] { new Vector3(+0.85065080835204f,-0.52573111211913f,-0.00000000000001f), new Vector3(+0.52573111211913f,+0.85065080835204f,+0.00000000000000f), new Vector3(0,0,0)},       // xyz BP08_0 
                new Vector3[] { new Vector3(+0.85065080835204f,-0.52573111211913f,-0.00000000000001f), new Vector3(+0.16245984811646f,+0.26286555605956f,+0.95105651629515f), new Vector3(0,0,0)},       // xyz BP08_1 
                new Vector3[] { new Vector3(+0.85065080835204f,-0.52573111211913f,-0.00000000000001f), new Vector3(+0.16245984811644f,+0.26286555605958f,-0.95105651629515f), new Vector3(0,0,0)},       // xyz BP08_2 
                new Vector3[] { new Vector3(+0.85065080835204f,-0.52573111211913f,-0.00000000000001f), new Vector3(-0.42532540417601f,-0.68819096023560f,+0.58778525229247f), new Vector3(0,0,0)},       // xyz BP08_3 
                new Vector3[] { new Vector3(+0.85065080835204f,-0.52573111211913f,-0.00000000000001f), new Vector3(-0.42532540417602f,-0.68819096023559f,-0.58778525229248f), new Vector3(0,0,0)},       // xyz BP08_4 
                               // Flipped copies - hopefully that's correct:
                new Vector3[] { new Vector3(-0.85065080835204f,-0.52573111211914f,+0.00000000000000f), new Vector3(+0.42532540417602f,-0.68819096023558f,-0.58778525229248f), new Vector3(0,0,0)},       // xyz BP00_0
                new Vector3[] { new Vector3(-0.85065080835204f,-0.52573111211914f,+0.00000000000000f), new Vector3(-0.16245984811646f,+0.26286555605957f,-0.95105651629515f), new Vector3(0,0,0)},       // xyz BP00_1 
                new Vector3[] { new Vector3(-0.85065080835204f,-0.52573111211914f,+0.00000000000000f), new Vector3(-0.16245984811645f,+0.26286555605956f,+0.95105651629516f), new Vector3(0,0,0)},       // xyz BP00_2 
                new Vector3[] { new Vector3(-0.85065080835204f,-0.52573111211914f,+0.00000000000000f), new Vector3(+0.42532540417603f,-0.68819096023559f,+0.58778525229246f), new Vector3(0,0,0)},       // xyz BP00_3 
                new Vector3[] { new Vector3(-0.85065080835204f,-0.52573111211914f,+0.00000000000000f), new Vector3(-0.52573111211914f,+0.85065080835204f,+0.00000000000001f), new Vector3(0,0,0)},       // xyz BP00_4 
                new Vector3[] { new Vector3(+0.00000000000000f,-0.85065080835204f,-0.52573111211914f), new Vector3(-0.95105651629515f,-0.16245984811646f,+0.26286555605957f), new Vector3(0,0,0)},       // xyz BP01_0 
                new Vector3[] { new Vector3(+0.00000000000000f,-0.85065080835204f,-0.52573111211914f), new Vector3(-0.58778525229248f,+0.42532540417602f,-0.68819096023558f), new Vector3(0,0,0)},       // xyz BP01_1 
                new Vector3[] { new Vector3(+0.00000000000000f,-0.85065080835204f,-0.52573111211914f), new Vector3(+0.95105651629516f,-0.16245984811645f,+0.26286555605956f), new Vector3(0,0,0)},       // xyz BP01_2 
                new Vector3[] { new Vector3(+0.00000000000000f,-0.85065080835204f,-0.52573111211914f), new Vector3(+0.58778525229246f,+0.42532540417603f,-0.68819096023559f), new Vector3(0,0,0)},       // xyz BP01_3 
                new Vector3[] { new Vector3(+0.00000000000000f,-0.85065080835204f,-0.52573111211914f), new Vector3(+0.00000000000001f,-0.52573111211914f,+0.85065080835204f), new Vector3(0,0,0)},       // xyz BP01_4 
                new Vector3[] { new Vector3(-0.52573111211914f,+0.00000000000000f,-0.85065080835204f), new Vector3(+0.26286555605957f,-0.95105651629515f,-0.16245984811646f), new Vector3(0,0,0)},       // xyz BP02_0 
                new Vector3[] { new Vector3(-0.52573111211914f,+0.00000000000000f,-0.85065080835204f), new Vector3(-0.68819096023558f,-0.58778525229248f,+0.42532540417602f), new Vector3(0,0,0)},       // xyz BP02_1 
                new Vector3[] { new Vector3(-0.52573111211914f,+0.00000000000000f,-0.85065080835204f), new Vector3(+0.26286555605956f,+0.95105651629516f,-0.16245984811645f), new Vector3(0,0,0)},       // xyz BP02_2 
                new Vector3[] { new Vector3(-0.52573111211914f,+0.00000000000000f,-0.85065080835204f), new Vector3(+0.85065080835204f,+0.00000000000001f,-0.52573111211914f), new Vector3(0,0,0)},       // xyz BP02_3 
                new Vector3[] { new Vector3(-0.52573111211914f,+0.00000000000000f,-0.85065080835204f), new Vector3(-0.68819096023559f,+0.58778525229246f,+0.42532540417603f), new Vector3(0,0,0)},       // xyz BP02_4 
                new Vector3[] { new Vector3(-0.52573111211913f,-0.00000000000001f,+0.85065080835204f), new Vector3(-0.68819096023559f,-0.58778525229248f,-0.42532540417602f), new Vector3(0,0,0)},       // xyz BP03_0 
                new Vector3[] { new Vector3(-0.52573111211913f,-0.00000000000001f,+0.85065080835204f), new Vector3(+0.26286555605958f,-0.95105651629515f,+0.16245984811644f), new Vector3(0,0,0)},       // xyz BP03_1 
                new Vector3[] { new Vector3(-0.52573111211913f,-0.00000000000001f,+0.85065080835204f), new Vector3(-0.68819096023560f,+0.58778525229247f,-0.42532540417601f), new Vector3(0,0,0)},       // xyz BP03_2 
                new Vector3[] { new Vector3(-0.52573111211913f,-0.00000000000001f,+0.85065080835204f), new Vector3(+0.26286555605956f,+0.95105651629515f,+0.16245984811646f), new Vector3(0,0,0)},       // xyz BP03_3 
                new Vector3[] { new Vector3(-0.52573111211913f,-0.00000000000001f,+0.85065080835204f), new Vector3(+0.85065080835204f,+0.00000000000000f,+0.52573111211913f), new Vector3(0,0,0)},       // xyz BP03_4 
                new Vector3[] { new Vector3(+0.00000000000001f,-0.85065080835204f,+0.52573111211913f), new Vector3(-0.00000000000000f,-0.52573111211913f,-0.85065080835204f), new Vector3(0,0,0)},       // xyz BP07_0 
                new Vector3[] { new Vector3(+0.00000000000001f,-0.85065080835204f,+0.52573111211913f), new Vector3(-0.95105651629515f,-0.16245984811646f,-0.26286555605956f), new Vector3(0,0,0)},       // xyz BP07_1 
                new Vector3[] { new Vector3(+0.00000000000001f,-0.85065080835204f,+0.52573111211913f), new Vector3(-0.58778525229247f,+0.42532540417601f,+0.68819096023560f), new Vector3(0,0,0)},       // xyz BP07_2 
                new Vector3[] { new Vector3(+0.00000000000001f,-0.85065080835204f,+0.52573111211913f), new Vector3(+0.95105651629515f,-0.16245984811644f,-0.26286555605958f), new Vector3(0,0,0)},       // xyz BP07_3 
                new Vector3[] { new Vector3(+0.00000000000001f,-0.85065080835204f,+0.52573111211913f), new Vector3(+0.58778525229248f,+0.42532540417602f,+0.68819096023559f), new Vector3(0,0,0)},       // xyz BP07_4 
                new Vector3[] { new Vector3(-0.85065080835204f,+0.52573111211913f,+0.00000000000001f), new Vector3(-0.52573111211913f,-0.85065080835204f,-0.00000000000000f), new Vector3(0,0,0)},       // xyz BP08_0 
                new Vector3[] { new Vector3(-0.85065080835204f,+0.52573111211913f,+0.00000000000001f), new Vector3(-0.16245984811646f,-0.26286555605956f,-0.95105651629515f), new Vector3(0,0,0)},       // xyz BP08_1 
                new Vector3[] { new Vector3(-0.85065080835204f,+0.52573111211913f,+0.00000000000001f), new Vector3(-0.16245984811644f,-0.26286555605958f,+0.95105651629515f), new Vector3(0,0,0)},       // xyz BP08_2 
                new Vector3[] { new Vector3(-0.85065080835204f,+0.52573111211913f,+0.00000000000001f), new Vector3(+0.42532540417601f,+0.68819096023560f,-0.58778525229247f), new Vector3(0,0,0)},       // xyz BP08_3 
                new Vector3[] { new Vector3(-0.85065080835204f,+0.52573111211913f,+0.00000000000001f), new Vector3(+0.42532540417602f,+0.68819096023559f,+0.58778525229248f), new Vector3(0,0,0)},       // xyz BP08_4 
            };

            Vector3[][] trimers = new Vector3[][]
            {
                new Vector3[] { new Vector3(+0.93417235896272f,+0.00000000000000f,+0.35682208977309f), new Vector3(-0.17841104488654f,+0.86602540378444f,+0.46708617948136f), new Vector3(0,0,0) },      // xyz BT00_0      
                new Vector3[] { new Vector3(+0.93417235896272f,+0.00000000000000f,+0.35682208977309f), new Vector3(-0.17841104488654f,-0.86602540378444f,+0.46708617948136f), new Vector3(0,0,0) },      // xyz BT00_1      
                new Vector3[] { new Vector3(+0.93417235896272f,+0.00000000000000f,+0.35682208977309f), new Vector3(+0.35682208977309f,+0.00000000000000f,-0.93417235896272f), new Vector3(0,0,0) },      // xyz BT00_2      
                new Vector3[] { new Vector3(+0.57735026918963f,+0.57735026918963f,-0.57735026918963f), new Vector3(-0.64549722436790f,-0.11026408970827f,-0.75576131407617f), new Vector3(0,0,0) },      // xyz BT01_0      
                new Vector3[] { new Vector3(+0.57735026918963f,+0.57735026918963f,-0.57735026918963f), new Vector3(-0.11026408970827f,+0.75576131407617f,+0.64549722436790f), new Vector3(0,0,0) },      // xyz BT01_1      
                new Vector3[] { new Vector3(+0.57735026918963f,+0.57735026918963f,-0.57735026918963f), new Vector3(+0.75576131407617f,-0.64549722436790f,+0.11026408970827f), new Vector3(0,0,0) },      // xyz BT01_2      
                new Vector3[] { new Vector3(+0.57735026918963f,-0.57735026918963f,+0.57735026918963f), new Vector3(-0.11026408970827f,-0.75576131407617f,-0.64549722436790f), new Vector3(0,0,0) },      // xyz BT02_0      
                new Vector3[] { new Vector3(+0.57735026918963f,-0.57735026918963f,+0.57735026918963f), new Vector3(+0.75576131407617f,+0.64549722436790f,-0.11026408970827f), new Vector3(0,0,0) },      // xyz BT02_1      
                new Vector3[] { new Vector3(+0.57735026918963f,-0.57735026918963f,+0.57735026918963f), new Vector3(-0.64549722436790f,+0.11026408970827f,+0.75576131407617f), new Vector3(0,0,0) },      // xyz BT02_2      
                new Vector3[] { new Vector3(+0.57735026918963f,-0.57735026918963f,-0.57735026918963f), new Vector3(-0.11026408970827f,-0.75576131407617f,+0.64549722436790f), new Vector3(0,0,0) },      // xyz BT03_0      
                new Vector3[] { new Vector3(+0.57735026918963f,-0.57735026918963f,-0.57735026918963f), new Vector3(-0.64549722436790f,+0.11026408970827f,-0.75576131407617f), new Vector3(0,0,0) },      // xyz BT03_1      
                new Vector3[] { new Vector3(+0.57735026918963f,-0.57735026918963f,-0.57735026918963f), new Vector3(+0.75576131407617f,+0.64549722436790f,+0.11026408970827f), new Vector3(0,0,0) },      // xyz BT03_2      
                new Vector3[] { new Vector3(-0.57735026918963f,+0.57735026918963f,+0.57735026918963f), new Vector3(-0.75576131407617f,-0.64549722436790f,-0.11026408970827f), new Vector3(0,0,0) },      // xyz BT04_0     
                new Vector3[] { new Vector3(-0.57735026918963f,+0.57735026918963f,+0.57735026918963f), new Vector3(+0.64549722436790f,-0.11026408970827f,+0.75576131407617f), new Vector3(0,0,0) },      // xyz BT04_1     
                new Vector3[] { new Vector3(-0.57735026918963f,+0.57735026918963f,+0.57735026918963f), new Vector3(+0.11026408970827f,+0.75576131407617f,-0.64549722436790f), new Vector3(0,0,0) },      // xyz BT04_2     
                new Vector3[] { new Vector3(-0.57735026918963f,+0.57735026918963f,-0.57735026918963f), new Vector3(+0.64549722436790f,-0.11026408970827f,-0.75576131407617f), new Vector3(0,0,0) },      // xyz BT05_0     
                new Vector3[] { new Vector3(-0.57735026918963f,+0.57735026918963f,-0.57735026918963f), new Vector3(-0.75576131407617f,-0.64549722436790f,+0.11026408970827f), new Vector3(0,0,0) },      // xyz BT05_1     
                new Vector3[] { new Vector3(-0.57735026918963f,+0.57735026918963f,-0.57735026918963f), new Vector3(+0.11026408970827f,+0.75576131407617f,+0.64549722436790f), new Vector3(0,0,0) },      // xyz BT05_2     
                new Vector3[] { new Vector3(-0.57735026918963f,-0.57735026918963f,+0.57735026918963f), new Vector3(-0.75576131407617f,+0.64549722436790f,-0.11026408970827f), new Vector3(0,0,0) },      // xyz BT06_0     
                new Vector3[] { new Vector3(-0.57735026918963f,-0.57735026918963f,+0.57735026918963f), new Vector3(+0.11026408970827f,-0.75576131407617f,-0.64549722436790f), new Vector3(0,0,0) },      // xyz BT06_1     
                new Vector3[] { new Vector3(-0.57735026918963f,-0.57735026918963f,+0.57735026918963f), new Vector3(+0.64549722436790f,+0.11026408970827f,+0.75576131407617f), new Vector3(0,0,0) },      // xyz BT06_2     
                new Vector3[] { new Vector3(-0.57735026918963f,-0.57735026918963f,-0.57735026918963f), new Vector3(+0.64549722436790f,+0.11026408970827f,-0.75576131407617f), new Vector3(0,0,0) },      // xyz BT07_0     
                new Vector3[] { new Vector3(-0.57735026918963f,-0.57735026918963f,-0.57735026918963f), new Vector3(+0.11026408970827f,-0.75576131407617f,+0.64549722436790f), new Vector3(0,0,0) },      // xyz BT07_1     
                new Vector3[] { new Vector3(-0.57735026918963f,-0.57735026918963f,-0.57735026918963f), new Vector3(-0.75576131407617f,+0.64549722436790f,+0.11026408970827f), new Vector3(0,0,0) },      // xyz BT07_2     
                new Vector3[] { new Vector3(+0.00000000000000f,+0.35682208977309f,-0.93417235896272f), new Vector3(+0.86602540378444f,+0.46708617948136f,+0.17841104488655f), new Vector3(0,0,0) },      // xyz BT08_0     
                new Vector3[] { new Vector3(+0.00000000000000f,+0.35682208977309f,-0.93417235896272f), new Vector3(-0.86602540378444f,+0.46708617948136f,+0.17841104488655f), new Vector3(0,0,0) },      // xyz BT08_1     
                new Vector3[] { new Vector3(+0.00000000000000f,+0.35682208977309f,-0.93417235896272f), new Vector3(+0.00000000000000f,-0.93417235896272f,-0.35682208977309f), new Vector3(0,0,0) },      // xyz BT08_2     
                new Vector3[] { new Vector3(+0.35682208977309f,-0.93417235896272f,+0.00000000000000f), new Vector3(+0.46708617948136f,+0.17841104488654f,+0.86602540378444f), new Vector3(0,0,0) },      // xyz BT09_0      
                new Vector3[] { new Vector3(+0.35682208977309f,-0.93417235896272f,+0.00000000000000f), new Vector3(+0.46708617948136f,+0.17841104488654f,-0.86602540378444f), new Vector3(0,0,0) },      // xyz BT09_1      
                new Vector3[] { new Vector3(+0.35682208977309f,-0.93417235896272f,+0.00000000000000f), new Vector3(-0.93417235896272f,-0.35682208977309f,+0.00000000000000f), new Vector3(0,0,0) },      // xyz BT09_2      
                new Vector3[] { new Vector3(-0.93417235896272f,+0.00000000000000f,+0.35682208977309f), new Vector3(+0.17841104488654f,+0.86602540378444f,+0.46708617948136f), new Vector3(0,0,0) },      // xyz BT10_0     
                new Vector3[] { new Vector3(-0.93417235896272f,+0.00000000000000f,+0.35682208977309f), new Vector3(+0.17841104488654f,-0.86602540378444f,+0.46708617948136f), new Vector3(0,0,0) },      // xyz BT10_1     
                new Vector3[] { new Vector3(-0.93417235896272f,+0.00000000000000f,+0.35682208977309f), new Vector3(-0.35682208977309f,+0.00000000000000f,-0.93417235896272f), new Vector3(0,0,0) },      // xyz BT10_2     
                new Vector3[] { new Vector3(+0.00000000000000f,+0.35682208977309f,+0.93417235896272f), new Vector3(+0.86602540378444f,+0.46708617948136f,-0.17841104488655f), new Vector3(0,0,0) },      // xyz BT11_0      
                new Vector3[] { new Vector3(+0.00000000000000f,+0.35682208977309f,+0.93417235896272f), new Vector3(-0.86602540378444f,+0.46708617948136f,-0.17841104488655f), new Vector3(0,0,0) },      // xyz BT11_1      
                new Vector3[] { new Vector3(+0.00000000000000f,+0.35682208977309f,+0.93417235896272f), new Vector3(+0.00000000000000f,-0.93417235896272f,+0.35682208977309f), new Vector3(0,0,0) },      // xyz BT11_2      
                new Vector3[] { new Vector3(+0.35682208977309f,+0.93417235896272f,+0.00000000000000f), new Vector3(+0.46708617948136f,-0.17841104488654f,+0.86602540378444f), new Vector3(0,0,0) },      // xyz BT12_0      
                new Vector3[] { new Vector3(+0.35682208977309f,+0.93417235896272f,+0.00000000000000f), new Vector3(+0.46708617948136f,-0.17841104488654f,-0.86602540378444f), new Vector3(0,0,0) },      // xyz BT12_1      
                new Vector3[] { new Vector3(+0.35682208977309f,+0.93417235896272f,+0.00000000000000f), new Vector3(-0.93417235896272f,+0.35682208977309f,+0.00000000000000f), new Vector3(0,0,0) },      // xyz BT12_2      
                new Vector3[] { new Vector3(+0.57735026918963f,+0.57735026918963f,+0.57735026918963f), new Vector3(-0.64549722436790f,-0.11026408970827f,+0.75576131407617f), new Vector3(0,0,0) },      // xyz BT13_0      
                new Vector3[] { new Vector3(+0.57735026918963f,+0.57735026918963f,+0.57735026918963f), new Vector3(-0.11026408970827f,+0.75576131407617f,-0.64549722436790f), new Vector3(0,0,0) },      // xyz BT13_1      
                new Vector3[] { new Vector3(+0.57735026918963f,+0.57735026918963f,+0.57735026918963f), new Vector3(+0.75576131407617f,-0.64549722436790f,-0.11026408970827f), new Vector3(0,0,0) },      // xyz BT13_2      
                new Vector3[] { new Vector3(+0.00000000000000f,-0.35682208977309f,-0.93417235896272f), new Vector3(+0.86602540378444f,-0.46708617948136f,+0.17841104488655f), new Vector3(0,0,0) },      // xyz BT14_0     
                new Vector3[] { new Vector3(+0.00000000000000f,-0.35682208977309f,-0.93417235896272f), new Vector3(-0.86602540378444f,-0.46708617948136f,+0.17841104488655f), new Vector3(0,0,0) },      // xyz BT14_1     
                new Vector3[] { new Vector3(+0.00000000000000f,-0.35682208977309f,-0.93417235896272f), new Vector3(+0.00000000000000f,+0.93417235896272f,-0.35682208977309f), new Vector3(0,0,0) },      // xyz BT14_2     
                new Vector3[] { new Vector3(-0.35682208977309f,-0.93417235896272f,+0.00000000000000f), new Vector3(-0.46708617948136f,+0.17841104488654f,+0.86602540378444f), new Vector3(0,0,0) },      // xyz BT15_0     
                new Vector3[] { new Vector3(-0.35682208977309f,-0.93417235896272f,+0.00000000000000f), new Vector3(-0.46708617948136f,+0.17841104488654f,-0.86602540378444f), new Vector3(0,0,0) },      // xyz BT15_1     
                new Vector3[] { new Vector3(-0.35682208977309f,-0.93417235896272f,+0.00000000000000f), new Vector3(+0.93417235896272f,-0.35682208977309f,+0.00000000000000f), new Vector3(0,0,0) },      // xyz BT15_2     
                new Vector3[] { new Vector3(-0.93417235896272f,+0.00000000000000f,-0.35682208977309f), new Vector3(+0.17841104488654f,+0.86602540378444f,-0.46708617948136f), new Vector3(0,0,0) },      // xyz BT16_0     
                new Vector3[] { new Vector3(-0.93417235896272f,+0.00000000000000f,-0.35682208977309f), new Vector3(+0.17841104488654f,-0.86602540378444f,-0.46708617948136f), new Vector3(0,0,0) },      // xyz BT16_1     
                new Vector3[] { new Vector3(-0.93417235896272f,+0.00000000000000f,-0.35682208977309f), new Vector3(-0.35682208977309f,+0.00000000000000f,+0.93417235896272f), new Vector3(0,0,0) },      // xyz BT16_2     
                new Vector3[] { new Vector3(+0.00000000000000f,-0.35682208977309f,+0.93417235896272f), new Vector3(+0.86602540378444f,-0.46708617948136f,-0.17841104488655f), new Vector3(0,0,0) },      // xyz BT17_0      
                new Vector3[] { new Vector3(+0.00000000000000f,-0.35682208977309f,+0.93417235896272f), new Vector3(-0.86602540378444f,-0.46708617948136f,-0.17841104488655f), new Vector3(0,0,0) },      // xyz BT17_1      
                new Vector3[] { new Vector3(+0.00000000000000f,-0.35682208977309f,+0.93417235896272f), new Vector3(+0.00000000000000f,+0.93417235896272f,+0.35682208977309f), new Vector3(0,0,0) },      // xyz BT17_2      
                new Vector3[] { new Vector3(-0.35682208977309f,+0.93417235896272f,+0.00000000000000f), new Vector3(-0.46708617948136f,-0.17841104488654f,+0.86602540378444f), new Vector3(0,0,0) },      // xyz BT18_0     
                new Vector3[] { new Vector3(-0.35682208977309f,+0.93417235896272f,+0.00000000000000f), new Vector3(-0.46708617948136f,-0.17841104488654f,-0.86602540378444f), new Vector3(0,0,0) },      // xyz BT18_1     
                new Vector3[] { new Vector3(-0.35682208977309f,+0.93417235896272f,+0.00000000000000f), new Vector3(+0.93417235896272f,+0.35682208977309f,+0.00000000000000f), new Vector3(0,0,0) },      // xyz BT18_2     
                new Vector3[] { new Vector3(+0.93417235896272f,+0.00000000000000f,-0.35682208977309f), new Vector3(-0.17841104488654f,+0.86602540378444f,-0.46708617948136f), new Vector3(0,0,0) },      // xyz BT19_0      
                new Vector3[] { new Vector3(+0.93417235896272f,+0.00000000000000f,-0.35682208977309f), new Vector3(-0.17841104488654f,-0.86602540378444f,-0.46708617948136f), new Vector3(0,0,0) },      // xyz BT19_1      
                new Vector3[] { new Vector3(+0.93417235896272f,+0.00000000000000f,-0.35682208977309f), new Vector3(+0.35682208977309f,+0.00000000000000f,+0.93417235896272f), new Vector3(0,0,0) },      // xyz BT19_2  
            };

            Vector3[][] dimers = new Vector3[][]
            {
                new Vector3[] { new Vector3(+1.00000000000000f,+0.00000000000000f,+0.00000000000000f), new Vector3(+0.00000000000000f,+0.00000000000000f,+1.00000000000000f), new Vector3(0,0,0) },       // DIMER	xyz BD00_0 
                new Vector3[] { new Vector3(+1.00000000000000f,+0.00000000000000f,+0.00000000000000f), new Vector3(+0.00000000000000f,+0.00000000000000f,-1.00000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD00_1 
                new Vector3[] { new Vector3(-1.00000000000000f,+0.00000000000000f,+0.00000000000000f), new Vector3(+0.00000000000000f,+0.00000000000000f,+1.00000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD01_0 
                new Vector3[] { new Vector3(-1.00000000000000f,+0.00000000000000f,+0.00000000000000f), new Vector3(+0.00000000000000f,+0.00000000000000f,-1.00000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD01_1 
                new Vector3[] { new Vector3(+0.00000000000000f,+1.00000000000000f,+0.00000000000000f), new Vector3(+1.00000000000000f,+0.00000000000000f,+0.00000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD02_0 
                new Vector3[] { new Vector3(+0.00000000000000f,+1.00000000000000f,+0.00000000000000f), new Vector3(-1.00000000000000f,+0.00000000000000f,+0.00000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD02_1 
                new Vector3[] { new Vector3(+0.00000000000000f,-1.00000000000000f,+0.00000000000000f), new Vector3(+1.00000000000000f,+0.00000000000000f,+0.00000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD03_0 
                new Vector3[] { new Vector3(+0.00000000000000f,-1.00000000000000f,+0.00000000000000f), new Vector3(-1.00000000000000f,+0.00000000000000f,+0.00000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD03_1 
                new Vector3[] { new Vector3(+0.00000000000000f,+0.00000000000000f,+1.00000000000000f), new Vector3(+0.00000000000000f,+1.00000000000000f,+0.00000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD04_0 
                new Vector3[] { new Vector3(+0.00000000000000f,+0.00000000000000f,+1.00000000000000f), new Vector3(+0.00000000000000f,-1.00000000000000f,+0.00000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD04_1 
                new Vector3[] { new Vector3(+0.00000000000000f,+0.00000000000000f,-1.00000000000000f), new Vector3(+0.00000000000000f,+1.00000000000000f,+0.00000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD05_0 
                new Vector3[] { new Vector3(+0.00000000000000f,+0.00000000000000f,-1.00000000000000f), new Vector3(+0.00000000000000f,-1.00000000000000f,+0.00000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD05_1 
                new Vector3[] { new Vector3(+0.30901699437495f,+0.50000000000000f,+0.80901699437495f), new Vector3(+0.80901699437495f,+0.30901699437495f,-0.50000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD06_0 
                new Vector3[] { new Vector3(+0.30901699437495f,+0.50000000000000f,+0.80901699437495f), new Vector3(-0.80901699437495f,-0.30901699437495f,+0.50000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD06_1 
                new Vector3[] { new Vector3(+0.50000000000000f,+0.80901699437495f,+0.30901699437495f), new Vector3(+0.30901699437495f,-0.50000000000000f,+0.80901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD07_0 
                new Vector3[] { new Vector3(+0.50000000000000f,+0.80901699437495f,+0.30901699437495f), new Vector3(-0.30901699437495f,+0.50000000000000f,-0.80901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD07_1 
                new Vector3[] { new Vector3(+0.80901699437495f,+0.30901699437495f,+0.50000000000000f), new Vector3(-0.50000000000000f,+0.80901699437495f,+0.30901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD08_0 
                new Vector3[] { new Vector3(+0.80901699437495f,+0.30901699437495f,+0.50000000000000f), new Vector3(+0.50000000000000f,-0.80901699437495f,-0.30901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD08_1 
                new Vector3[] { new Vector3(+0.30901699437495f,+0.50000000000000f,-0.80901699437495f), new Vector3(+0.80901699437495f,+0.30901699437495f,+0.50000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD09_0 
                new Vector3[] { new Vector3(+0.30901699437495f,+0.50000000000000f,-0.80901699437495f), new Vector3(-0.80901699437495f,-0.30901699437495f,-0.50000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD09_1 
                new Vector3[] { new Vector3(+0.50000000000000f,+0.80901699437495f,-0.30901699437495f), new Vector3(+0.30901699437495f,-0.50000000000000f,-0.80901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD10_0 
                new Vector3[] { new Vector3(+0.50000000000000f,+0.80901699437495f,-0.30901699437495f), new Vector3(-0.30901699437495f,+0.50000000000000f,+0.80901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD10_1 
                new Vector3[] { new Vector3(+0.80901699437495f,+0.30901699437495f,-0.50000000000000f), new Vector3(-0.50000000000000f,+0.80901699437495f,-0.30901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD11_0 
                new Vector3[] { new Vector3(+0.80901699437495f,+0.30901699437495f,-0.50000000000000f), new Vector3(+0.50000000000000f,-0.80901699437495f,+0.30901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD11_1 
                new Vector3[] { new Vector3(+0.30901699437495f,-0.50000000000000f,+0.80901699437495f), new Vector3(+0.80901699437495f,-0.30901699437495f,-0.50000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD12_0 
                new Vector3[] { new Vector3(+0.30901699437495f,-0.50000000000000f,+0.80901699437495f), new Vector3(-0.80901699437495f,+0.30901699437495f,+0.50000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD12_1 
                new Vector3[] { new Vector3(+0.50000000000000f,-0.80901699437495f,+0.30901699437495f), new Vector3(+0.30901699437495f,+0.50000000000000f,+0.80901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD13_0 
                new Vector3[] { new Vector3(+0.50000000000000f,-0.80901699437495f,+0.30901699437495f), new Vector3(-0.30901699437495f,-0.50000000000000f,-0.80901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD13_1 
                new Vector3[] { new Vector3(+0.80901699437495f,-0.30901699437495f,+0.50000000000000f), new Vector3(-0.50000000000000f,-0.80901699437495f,+0.30901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD14_0 
                new Vector3[] { new Vector3(+0.80901699437495f,-0.30901699437495f,+0.50000000000000f), new Vector3(+0.50000000000000f,+0.80901699437495f,-0.30901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD14_1 
                new Vector3[] { new Vector3(+0.30901699437495f,-0.50000000000000f,-0.80901699437495f), new Vector3(+0.80901699437495f,-0.30901699437495f,+0.50000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD15_0 
                new Vector3[] { new Vector3(+0.30901699437495f,-0.50000000000000f,-0.80901699437495f), new Vector3(-0.80901699437495f,+0.30901699437495f,-0.50000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD15_1 
                new Vector3[] { new Vector3(+0.50000000000000f,-0.80901699437495f,-0.30901699437495f), new Vector3(+0.30901699437495f,+0.50000000000000f,-0.80901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD16_0 
                new Vector3[] { new Vector3(+0.50000000000000f,-0.80901699437495f,-0.30901699437495f), new Vector3(-0.30901699437495f,-0.50000000000000f,+0.80901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD16_1 
                new Vector3[] { new Vector3(+0.80901699437495f,-0.30901699437495f,-0.50000000000000f), new Vector3(-0.50000000000000f,-0.80901699437495f,-0.30901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD17_0 
                new Vector3[] { new Vector3(+0.80901699437495f,-0.30901699437495f,-0.50000000000000f), new Vector3(+0.50000000000000f,+0.80901699437495f,+0.30901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD17_1 
                new Vector3[] { new Vector3(-0.30901699437495f,+0.50000000000000f,+0.80901699437495f), new Vector3(-0.80901699437495f,+0.30901699437495f,-0.50000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD18_0 
                new Vector3[] { new Vector3(-0.30901699437495f,+0.50000000000000f,+0.80901699437495f), new Vector3(+0.80901699437495f,-0.30901699437495f,+0.50000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD18_1 
                new Vector3[] { new Vector3(-0.50000000000000f,+0.80901699437495f,+0.30901699437495f), new Vector3(-0.30901699437495f,-0.50000000000000f,+0.80901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD19_0 
                new Vector3[] { new Vector3(-0.50000000000000f,+0.80901699437495f,+0.30901699437495f), new Vector3(+0.30901699437495f,+0.50000000000000f,-0.80901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD19_1 
                new Vector3[] { new Vector3(-0.80901699437495f,+0.30901699437495f,+0.50000000000000f), new Vector3(+0.50000000000000f,+0.80901699437495f,+0.30901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD20_0 
                new Vector3[] { new Vector3(-0.80901699437495f,+0.30901699437495f,+0.50000000000000f), new Vector3(-0.50000000000000f,-0.80901699437495f,-0.30901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD20_1 
                new Vector3[] { new Vector3(-0.30901699437495f,+0.50000000000000f,-0.80901699437495f), new Vector3(-0.80901699437495f,+0.30901699437495f,+0.50000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD21_0 
                new Vector3[] { new Vector3(-0.30901699437495f,+0.50000000000000f,-0.80901699437495f), new Vector3(+0.80901699437495f,-0.30901699437495f,-0.50000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD21_1 
                new Vector3[] { new Vector3(-0.50000000000000f,+0.80901699437495f,-0.30901699437495f), new Vector3(-0.30901699437495f,-0.50000000000000f,-0.80901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD22_0 
                new Vector3[] { new Vector3(-0.50000000000000f,+0.80901699437495f,-0.30901699437495f), new Vector3(+0.30901699437495f,+0.50000000000000f,+0.80901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD22_1 
                new Vector3[] { new Vector3(-0.80901699437495f,+0.30901699437495f,-0.50000000000000f), new Vector3(+0.50000000000000f,+0.80901699437495f,-0.30901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD23_0 
                new Vector3[] { new Vector3(-0.80901699437495f,+0.30901699437495f,-0.50000000000000f), new Vector3(-0.50000000000000f,-0.80901699437495f,+0.30901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD23_1 
                new Vector3[] { new Vector3(-0.30901699437495f,-0.50000000000000f,+0.80901699437495f), new Vector3(-0.80901699437495f,-0.30901699437495f,-0.50000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD24_0 
                new Vector3[] { new Vector3(-0.30901699437495f,-0.50000000000000f,+0.80901699437495f), new Vector3(+0.80901699437495f,+0.30901699437495f,+0.50000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD24_1 
                new Vector3[] { new Vector3(-0.50000000000000f,-0.80901699437495f,+0.30901699437495f), new Vector3(-0.30901699437495f,+0.50000000000000f,+0.80901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD25_0 
                new Vector3[] { new Vector3(-0.50000000000000f,-0.80901699437495f,+0.30901699437495f), new Vector3(+0.30901699437495f,-0.50000000000000f,-0.80901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD25_1 
                new Vector3[] { new Vector3(-0.80901699437495f,-0.30901699437495f,+0.50000000000000f), new Vector3(+0.50000000000000f,-0.80901699437495f,+0.30901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD26_0 
                new Vector3[] { new Vector3(-0.80901699437495f,-0.30901699437495f,+0.50000000000000f), new Vector3(-0.50000000000000f,+0.80901699437495f,-0.30901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD26_1 
                new Vector3[] { new Vector3(-0.30901699437495f,-0.50000000000000f,-0.80901699437495f), new Vector3(-0.80901699437495f,-0.30901699437495f,+0.50000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD27_0 
                new Vector3[] { new Vector3(-0.30901699437495f,-0.50000000000000f,-0.80901699437495f), new Vector3(+0.80901699437495f,+0.30901699437495f,-0.50000000000000f), new Vector3(0,0,0) },       // DIMER xyz BD27_1 
                new Vector3[] { new Vector3(-0.50000000000000f,-0.80901699437495f,-0.30901699437495f), new Vector3(-0.30901699437495f,+0.50000000000000f,-0.80901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD28_0 
                new Vector3[] { new Vector3(-0.50000000000000f,-0.80901699437495f,-0.30901699437495f), new Vector3(+0.30901699437495f,-0.50000000000000f,+0.80901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD28_1 
                new Vector3[] { new Vector3(-0.80901699437495f,-0.30901699437495f,-0.50000000000000f), new Vector3(+0.50000000000000f,-0.80901699437495f,-0.30901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD29_0 
                new Vector3[] { new Vector3(-0.80901699437495f,-0.30901699437495f,-0.50000000000000f), new Vector3(-0.50000000000000f,+0.80901699437495f,+0.30901699437495f), new Vector3(0,0,0) },       // DIMER xyz BD29_1 
            };

            string[] pentamerSubunitNames = new string[]
            {
                    "5.1.1",  "5.1.2",  "5.1.3",  "5.1.4",  "5.1.5",
                    "5.2.1",  "5.2.2",  "5.2.3",  "5.2.4",  "5.2.5",
                    "5.3.1",  "5.3.2",  "5.3.3",  "5.3.4",  "5.3.5",
                    "5.4.1",  "5.4.2",  "5.4.3",  "5.4.4",  "5.4.5",
                    "5.5.1",  "5.5.2",  "5.5.3",  "5.5.4",  "5.5.5",
                    "5.6.1",  "5.6.2",  "5.6.3",  "5.6.4",  "5.6.5",
                    "5.7.1",  "5.7.2",  "5.7.3",  "5.7.4",  "5.7.5",
                    "5.8.1",  "5.8.2",  "5.8.3",  "5.8.4",  "5.8.5",
                    "5.9.1",  "5.9.2",  "5.9.3",  "5.9.4",  "5.9.5",
                    "5.10.1", "5.10.2", "5.10.3", "5.10.4", "5.10.5",
                    "5.11.1", "5.11.2", "5.11.3", "5.11.4", "5.11.5",
                    "5.12.1", "5.12.2", "5.12.3", "5.12.4", "5.12.5",
            };

            string[] trimerSubunitNames = new string[]
            {
                    "3.1.1",  "3.1.2",  "3.1.3",
                    "3.2.1",  "3.2.2",  "3.2.3",
                    "3.3.1",  "3.3.2",  "3.3.3",
                    "3.4.1",  "3.4.2",  "3.4.3",
                    "3.5.1",  "3.5.2",  "3.5.3",
                    "3.6.1",  "3.6.2",  "3.6.3",
                    "3.7.1",  "3.7.2",  "3.7.3",
                    "3.8.1",  "3.8.2",  "3.8.3",
                    "3.9.1",  "3.9.2",  "3.9.3",
                    "3.10.1", "3.10.2", "3.10.3",
                    "3.11.1", "3.11.2", "3.11.3",
                    "3.12.1", "3.12.2", "3.12.3",
                    "3.13.1", "3.13.2", "3.13.3",
                    "3.14.1", "3.14.2", "3.14.3",
                    "3.15.1", "3.15.2", "3.15.3",
                    "3.16.1", "3.16.2", "3.16.3",
                    "3.17.1", "3.17.2", "3.17.3",
                    "3.18.1", "3.18.2", "3.18.3",
                    "3.19.1", "3.19.2", "3.19.3",
                    "3.20.1", "3.20.2", "3.20.3",
            };

            string[] dimerSubunitNames = new string[]
            {
                    "2.1.1",  "2.1.2",
                    "2.2.1",  "2.2.2",
                    "2.3.1",  "2.3.2",
                    "2.4.1",  "2.4.2",
                    "2.5.1",  "2.5.2",
                    "2.6.1",  "2.6.2",
                    "2.7.1",  "2.7.2",
                    "2.8.1",  "2.8.2",
                    "2.9.1",  "2.9.2",
                    "2.10.1", "2.10.2",
                    "2.11.1", "2.11.2",
                    "2.12.1", "2.12.2",
                    "2.13.1", "2.13.2",
                    "2.14.1", "2.14.2",
                    "2.15.1", "2.15.2",
                    "2.16.1", "2.16.2",
                    "2.17.1", "2.17.2",
                    "2.18.1", "2.18.2",
                    "2.19.1", "2.19.2",
                    "2.20.1", "2.20.2",
                    "2.21.1", "2.21.2",
                    "2.22.1", "2.22.2",
                    "2.23.1", "2.23.2",
                    "2.24.1", "2.24.2",
                    "2.25.1", "2.25.2",
                    "2.26.1", "2.26.2",
                    "2.27.1", "2.27.2",
                    "2.28.1", "2.28.2",
                    "2.29.1", "2.29.2",
                    "2.30.1", "2.30.2",
            };

            base.Setup("C5", 60);
            int subunitIndex = 0;
            pentamers.ToList().ForEach(xy => base.AddSymdefStyleCoordinateSystem("C5", pentamerSubunitNames[subunitIndex++], xy[0], xy[1], xy[2]));

            base.Setup("C3", 60);
            subunitIndex = 0;
            trimers.ToList().ForEach(xy => base.AddSymdefStyleCoordinateSystem("C3", trimerSubunitNames[subunitIndex++], xy[0], xy[1], xy[2]));

            base.Setup("C2", 60);
            subunitIndex = 0;
            dimers.ToList().ForEach(xy => base.AddSymdefStyleCoordinateSystem("C2", dimerSubunitNames[subunitIndex++], xy[0], xy[1], xy[2]));
        }

        public override object DeepCopyFindOrCreate(IDeepCloneObjectGraph graph)
        {
            if (graph.TryGetClone(this, out object clone))
                return clone;

            IcosahedralSymmetryBuilder builder = new IcosahedralSymmetryBuilder();
            graph.Add(this, builder);
            DeepCopyPopulateFields(graph, builder);
            return builder;
        }
    }
}
