# Audio-based Containers Manipulation (Setup 2)

*Authors*:
- Santiago Donaher
- Alessio Xompero
- Andrea Cavallaro

Created date: 2021/03/15

Modified date: 2021/03/31

Version: 0.1

Resource type: Dataset, Audio

## Description
Audio-based Containers Manipulation Setup 2 (ACM-S2) is a dataset for the validation of audio-based models for the task of filling type and filling level classification. This dataset contains 21 recordings adquired in a different setup than the [CORSMAL Containers Manupulation dataset](http://corsmal.eecs.qmul.ac.uk/containers_manip.html), recorded with a different microphone, room and containers, providing a new scenario with diffetent acoustics. The recordings are in *.wav* format, and correspond to 19 pouring and 2 shaking actions, performed manually by a human.

The microphone used is a *Blue Yeti Studio microphone*, placed on a table, facing the container at 12 cm for the pouring action, and 20 cm for the shaking action. The used containers are a medium glass (300 ml), tall glass (450 ml), small plastic cup (200 ml), and muesli box (300 ml). The filling types (materials) are: pasta penne (Gallo plumas nº6), white rice (Arroz SOS), and tap water, and the filling levels (%) are 0 (empty), 50, and 90.

## Data organization

 ACM-S2 contains:
 - Folder *acm_s2_audio* with all the audio files of the dataset
 - Folder *acm_s2_containers_imgs* with images of the containers
 - Annotations file, *acm_s2_annotations.json*
 - Samples information, *acm_s2_samples_info.csv*. This file can be generated from the annotations json file
 - *README.md* with the dataset's documentation and license

### Data format
ACM-S2's annotations are stored using [JSON](https://www.json.org/json-en.html), in a similar format to [COCO](https://cocodataset.org/#format-data) dataset, but for acoustic data.

For each audio, the annotations file provides information about the filling level and filling type, container and scenario, and also audio properties, such as number of channels, samples width (bytes), sampling frequency (Hz) and number of frames. These properties are acquired with Python's module [Wave](https://docs.python.org/3/library/wave.html).

```
{
    'id' : int,
    'scenario' : 1,
    'containerID' : int,
    'filling_type' : 0, 1, 2, or 3,
    'filling_level' : 0, 1, or 2,
},
{
    'audio_id' : int,
    'filename' : str,
    'channels' : file.getnchannels(),
    'sample_width' : file.getsampwidth(),
    'sampling_freq' : file.getframerate(),
    'num_frames' : file.getnframes(),
    'license' : 4,
}
```

ACM-S2 also provides additional entries that self-document the fields and their values of the audio annotations.


```
containers = [
	{
		'id' : 16,
		'name' : 'medium glass',
		'material' : 'glass',
	},
	{
		'id' : 17,
		'name' : 'tall glass',
		'material' : 'glass',
	},
	{
		'id' : 18,
		'name' : 'small plastic cup',
		'material' : 'plastic',
	},
	{
		'id' : 19,
		'name' : 'muesli box',
		'material' : 'plastic',
	},
],
filling_type = [
	{
		'id' : 0,
		'name' : 'empty',
	},
	{
		'id' : 1,
		'name' : 'pasta',
	},
	{
		'id' : 2,
		'name' : 'rice',
	},
	{
		'id' : 3,
		'name' : 'water',
	}
],
filling_level = [
	{
		'id' : 0,
		'name' : 'empty',
		'percentage' : '0%',
	},
	{
		'id' : 1,
		'name' : 'half-full',
		'percentage' : '50%',
	},
	{
		'id' : 2,
		'name' : 'full',
		'percentage' : '90%',
	}
],
scenarios = [
	{
		'id' : 1,
		'name' : 'subject sitting, container visible on the table',
	},
```

The annotation file provides additional information about the dataset, including general metadata of the dataset and licenses.
```
info_dataset = {
	'description' : 'Audio-based Containers Manipulation Setup 2 (ACM-S2)',
	'url' : '',
	'version' : '0.1',
	'year' : 2021,
	'contributor' : 'CORSMAL Consortium',
	'date_created' : '31 Mar 2021',
}
license = {
	'url' : 'http://creativecommons.org/licenses/by/4.0/',
	'id'	: 4,
	'name' : 'Creative Commons Attribution 4.0',
}
```

---
## Licence

This work is licensed under the Creative Commons Attribution 4.0 International License. To view a copy of this license, visit http://creativecommons.org/licenses/by/4.0/ or send a letter to Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.
